/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars.util;

import com.useful.ucars.util.USchLocks;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.metadata.MetadataValue;

public class UMeta {
    private static volatile ConcurrentHashMap<WeakKey, Map<String, List<MetadataValue>>> metadata = new ConcurrentHashMap(100, 0.75f, 3);

    public static void removeAllMeta(Object key) {
        WeakKey weakKey = new WeakKey(key);
        metadata.remove(weakKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<MetadataValue>> getAllMeta(Object key) {
        if (key == null) {
            return new ConcurrentHashMap<String, List<MetadataValue>>(10, 0.75f, 2);
        }
        WeakKey weakKey = new WeakKey(key);
        Map<String, List<MetadataValue>> res = metadata.get(weakKey);
        if (res == null) {
            ConcurrentHashMap<WeakKey, Map<String, List<MetadataValue>>> concurrentHashMap = metadata;
            synchronized (concurrentHashMap) {
                res = metadata.get(weakKey);
                if (res == null) {
                    res = new ConcurrentHashMap<String, List<MetadataValue>>(10, 0.75f, 2);
                    metadata.put(weakKey, res);
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MetadataValue> getMeta(Object key, String metaKey) {
        Map<String, List<MetadataValue>> meta = UMeta.getAllMeta(key);
        List<MetadataValue> list = meta.get(metaKey);
        if (list == null) {
            Object object = USchLocks.getMonitor(key);
            synchronized (object) {
                list = meta.get(metaKey);
                if (list == null) {
                    list = new ArrayList<MetadataValue>();
                    meta.put(metaKey, list);
                }
            }
        }
        return list;
    }

    public static void removeMeta(Object key, String metaKey) {
        Map<String, List<MetadataValue>> meta = UMeta.getAllMeta(key);
        meta.remove(metaKey);
    }

    public static void gc() {
        UMeta.clean();
    }

    public static void clean() {
        for (Map.Entry<WeakKey, Map<String, List<MetadataValue>>> entry : metadata.entrySet()) {
            WeakKey ref = entry.getKey();
            try {
                if (ref.get() != null && ref != null) continue;
                metadata.remove(ref);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static int getTotalMetaSize() {
        UMeta.clean();
        return metadata.size();
    }

    private static class WeakKey
    extends WeakReference {
        private int hash = -1;

        public WeakKey(Object arg0) {
            super(arg0);
            this.hash = arg0.hashCode();
        }

        public int hashCode() {
            Object self = this.get();
            if (self != null) {
                this.hash = self.hashCode();
            }
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WeakKey)) {
                return false;
            }
            Object self = this.get();
            Object other = ((WeakKey)o).get();
            if (self == null || other == null) {
                return super.equals(o);
            }
            return self.equals(other);
        }
    }
}

