/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.utils;

import net.stormdev.ucars.trade.AIVehicles.DynamicLagReducer;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.ToggleLatch;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Scheduler {
    public static void runBlockingSyncTask(final Runnable run) throws Exception {
        int timeout;
        final ToggleLatch latch = new ToggleLatch().lock();
        Bukkit.getScheduler().runTask((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    run.run();
                }
                finally {
                    latch.unlock();
                }
            }
        });
        for (timeout = 50; latch.isLocked() && timeout > 0; --timeout) {
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (timeout < 1) {
            DynamicLagReducer.failedSyncTask();
        }
    }

    public static void runBlockingSyncTask(final Runnable run, int timeOut) throws Exception {
        int timeout;
        final ToggleLatch latch = new ToggleLatch().lock();
        Bukkit.getScheduler().runTask((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    run.run();
                }
                finally {
                    latch.unlock();
                }
            }
        });
        for (timeout = timeOut * 4; latch.isLocked() && timeout > 0; --timeout) {
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (timeout < 1) {
            DynamicLagReducer.failedSyncTask();
        }
    }

    public static void runBlockingSyncTaskNoTimeout(final Runnable run) throws Exception {
        final ToggleLatch latch = new ToggleLatch().lock();
        Bukkit.getScheduler().runTask((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                try {
                    run.run();
                }
                finally {
                    latch.unlock();
                }
            }
        });
        while (latch.isLocked()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

