/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles.spawning.nodes;

import com.useful.ucars.util.UEntityMeta;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.spawning.AbstractAISpawnManager;
import net.stormdev.ucars.trade.AIVehicles.spawning.nodes.Node;
import net.stormdev.ucars.trade.AIVehicles.spawning.nodes.NodesStore;
import net.stormdev.ucars.trade.main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AINodesSpawnManager
extends AbstractAISpawnManager {
    private static NodesStore nodes = null;
    private BukkitTask task = null;
    private BukkitTask task2 = null;
    private long spawnRate = 35L;
    public static int minDistance = 30;
    private int maxDistance = 70;
    public static Map<String, List<Entity>> entitiesInWorld = new HashMap<String, List<Entity>>();

    public AINodesSpawnManager(main plugin, boolean enabled, File nodesSaveFile) {
        super(plugin, enabled);
        nodes = new NodesStore(nodesSaveFile);
        if (!main.config.contains("general.ai.maxSpawnDistanceFromPlayers")) {
            main.config.set("general.ai.maxSpawnDistanceFromPlayers", (Object)70);
        }
        this.maxDistance = main.config.getInt("general.ai.maxSpawnDistanceFromPlayers");
        this.maxDistance = Math.min(this.maxDistance, Bukkit.getServer().getViewDistance() * 16 - 10);
        if (!main.config.contains("general.ai.minSpawnDistanceFromPlayers")) {
            main.config.set("general.ai.minSpawnDistanceFromPlayers", (Object)30);
        }
        if (this.maxDistance - (minDistance = main.config.getInt("general.ai.minSpawnDistanceFromPlayers")) < 10) {
            minDistance = this.maxDistance - 10;
        }
        AIRouter.PLAYER_RADIUS = this.maxDistance;
        plugin.saveConfig();
    }

    public static NodesStore getNodesStore() {
        return nodes;
    }

    @Override
    public void shutdown() {
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.task2 != null) {
            this.task2.cancel();
            entitiesInWorld.clear();
        }
    }

    private boolean randomDoSpawn() {
        if (this.getSpawnedAICount() < 1) {
            return true;
        }
        return main.random.nextInt(5) < 1;
    }

    private int randomMinCarSpacingSquared() {
        return main.random.nextInt(96) + 4;
    }

    @Override
    public void initSpawnTask() {
        final double minDistanceSquared = Math.pow(minDistance, 2.0);
        final double maxDistanceSquared = Math.pow(this.maxDistance, 2.0);
        this.task2 = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (World w : Bukkit.getWorlds()) {
                    entitiesInWorld.put(w.getName(), new ArrayList(w.getEntities()));
                }
            }
        }, 20L, 20L);
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!AINodesSpawnManager.this.enabled) {
                    return;
                }
                if (!AINodesSpawnManager.this.isNPCCarsSpawningNow()) {
                    return;
                }
                if (AINodesSpawnManager.this.getSpawnedAICount() >= AINodesSpawnManager.this.getCurrentAICap()) {
                    return;
                }
                for (Player player : new ArrayList(Bukkit.getOnlinePlayers())) {
                    ArrayList<Entity> ents;
                    int minSpacing;
                    boolean closeCar;
                    Location randomNodeLoc;
                    Node randomNode;
                    block10: {
                        List<Node> activeNodes;
                        if (!AINodesSpawnManager.this.randomDoSpawn() || (activeNodes = AINodesSpawnManager.getNodesStore().getActiveNodes((Entity)player, (float)minDistance, (float)AINodesSpawnManager.this.maxDistance)).size() < 1) continue;
                        int chance = 20;
                        if ((chance = (int)((double)chance - (double)activeNodes.size() * 0.5)) < 0) {
                            chance = 0;
                        }
                        if (chance != 0 && main.random.nextInt(chance) >= 1) continue;
                        randomNode = activeNodes.get(main.random.nextInt(activeNodes.size()));
                        randomNodeLoc = randomNode.getLocation();
                        int nearCount = 0;
                        boolean cancel = false;
                        for (Player pl : new ArrayList(Bukkit.getOnlinePlayers())) {
                            if (pl.equals(player)) continue;
                            if (pl.getLocation().distanceSquared(randomNodeLoc) < minDistanceSquared) {
                                cancel = true;
                                break;
                            }
                            if (!(pl.getLocation().distanceSquared(randomNodeLoc) < maxDistanceSquared)) continue;
                            ++nearCount;
                        }
                        if (cancel || (chance = nearCount) != 0 && main.random.nextInt(50) <= chance) continue;
                        closeCar = false;
                        minSpacing = AINodesSpawnManager.this.randomMinCarSpacingSquared();
                        ents = new ArrayList<Entity>();
                        try {
                            List<Entity> inWorld = entitiesInWorld.get(randomNodeLoc.getWorld().getName());
                            if (inWorld == null) break block10;
                            ents.addAll(inWorld);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            continue;
                        }
                    }
                    for (Entity e : ents) {
                        Location l;
                        if (!UEntityMeta.hasMetadata((Entity)e, (String)"trade.npc") || !((l = e.getLocation()).toVector().clone().subtract(randomNodeLoc.toVector()).lengthSquared() < (double)minSpacing)) continue;
                        closeCar = true;
                        break;
                    }
                    if (closeCar) continue;
                    randomNode.spawnAICarIfLogicalToDoSo();
                }
            }
        }, this.spawnRate, this.spawnRate);
    }
}

