/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles.spawning.nodes;

import java.io.Serializable;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.AITrackFollow;
import net.stormdev.ucars.trade.AIVehicles.spawning.nodes.AINodesSpawnManager;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.SerializableLocation;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;

public class Node
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SerializableLocation trackerBlockSloc = null;
    private BlockFace direction;
    private volatile transient long lastSpawnTime = -1L;
    private transient Location loc;
    private transient boolean carSafeToSpawn = false;

    public Node(Location location, BlockFace direction) {
        this.loc = location;
        this.trackerBlockSloc = new SerializableLocation(location);
        this.direction = direction;
        this.getCarriagewayDirection();
    }

    public void setLocation(Location loc) {
        this.loc = loc;
        this.trackerBlockSloc = new SerializableLocation(loc);
    }

    public Location getLocation() {
        if (this.loc == null) {
            this.loc = this.trackerBlockSloc.getLocation(Bukkit.getServer());
        }
        return this.loc;
    }

    public Chunk getChunk() {
        return this.getLocation().getChunk();
    }

    public boolean isValid() {
        Block block = this.getLocation().getBlock();
        if (!AIRouter.isTrackBlock(block.getType())) {
            return false;
        }
        if (AITrackFollow.carriagewayDirection(block) == null) {
            return false;
        }
        return this.isRoomForCarToSpawn();
    }

    public BlockFace getCarriagewayDirection() {
        if (this.direction == null) {
            this.direction = AITrackFollow.carriagewayDirection(this.getLocation().getBlock()).getDirection();
            AINodesSpawnManager.getNodesStore().asyncSave();
        }
        return this.direction;
    }

    public boolean isRoomForCarToSpawn() {
        if (!main.plugin.checkSpawnSafety || this.carSafeToSpawn) {
            return true;
        }
        Block block = this.getLocation().getBlock();
        for (int i = 1; i <= 3; ++i) {
            Block relative = block.getRelative(BlockFace.UP, i);
            if (!relative.isEmpty() && !relative.isLiquid()) continue;
            this.carSafeToSpawn = true;
            return true;
        }
        return false;
    }

    public void spawnAICarIfLogicalToDoSo() {
        if (System.currentTimeMillis() - this.lastSpawnTime < 5000L) {
            return;
        }
        final Location spawnLoc = this.getLocation().clone().add(0.0, 2.0, 0.0);
        if (!this.isRoomForCarToSpawn()) {
            return;
        }
        final BlockFace carriagewayDir = this.getCarriagewayDirection();
        if (carriagewayDir != null) {
            this.lastSpawnTime = System.currentTimeMillis();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

                @Override
                public void run() {
                    main.plugin.aiSpawns.spawnNPCCar(spawnLoc, carriagewayDir);
                }
            });
        }
    }

    public boolean isEqualTo(Node other) {
        Location self = this.getLocation();
        Location otherLoc = other.getLocation();
        return self.getX() == otherLoc.getX() && self.getY() == otherLoc.getY() && self.getZ() == otherLoc.getZ();
    }
}

