/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade;

import com.useful.uCarsAPI.uCarCrashEvent;
import com.useful.uCarsAPI.uCarRespawnEvent;
import com.useful.uCarsAPI.uCarsAPI;
import com.useful.ucars.CarHealthData;
import com.useful.ucars.ClosestFace;
import com.useful.ucars.PlaceManager;
import com.useful.ucars.ucarDeathEvent;
import com.useful.ucars.ucars;
import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.milkbowl.vault.economy.EconomyResponse;
import net.stormdev.ucars.entity.CarMinecraftEntity;
import net.stormdev.ucars.stats.StatType;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.CarStealEvent;
import net.stormdev.ucars.trade.CarPlaceAPI;
import net.stormdev.ucars.trade.Lang;
import net.stormdev.ucars.trade.guis.IconMenu;
import net.stormdev.ucars.trade.guis.InputMenu;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.CarForSale;
import net.stormdev.ucars.utils.CarGenerator;
import net.stormdev.ucars.utils.CarValueCalculator;
import net.stormdev.ucars.utils.InputMenuClickEvent;
import net.stormdev.ucars.utils.TradeBoothClickEvent;
import net.stormdev.ucars.utils.TradeBoothMenuType;
import net.stormdev.ucars.utils.UpgradeForSale;
import net.stormdev.ucarstrade.ItemCarValidation;
import net.stormdev.ucarstrade.cars.CarPresets;
import net.stormdev.ucarstrade.cars.DrivenCar;
import net.stormdev.ucarstrade.displays.DisplayType;
import net.stormdev.ucarstrade.displays.Displays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class UTradeListener
implements Listener {
    main plugin = null;
    private double hovercarHeightLimit = 256.0;
    private boolean safeExit = false;
    private boolean stealNPC;

    public UTradeListener(main plugin) {
        this.plugin = plugin;
        this.hovercarHeightLimit = main.config.getDouble("general.hoverCar.heightLimit");
        this.stealNPC = main.config.getBoolean("general.ai.canSteal");
        this.safeExit = main.config.getBoolean("general.car.safeExit");
    }

    void npcCarSteal(final Entity vehicle, final Player player, final DrivenCar c, final boolean setPassenger) {
        if (!UEntityMeta.hasMetadata((Entity)vehicle, (String)"trade.npc") || !c.isNPC()) {
            return;
        }
        if (!this.stealNPC) {
            if (player.getVehicle() != null) {
                final Location loc = player.getVehicle().getLocation();
                player.getVehicle().eject();
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        player.teleport(loc.add(0.0, 0.5, 0.0));
                    }
                }, 2L);
            }
            return;
        }
        Entity e = vehicle.getPassenger();
        if (e != null) {
            vehicle.eject();
            e.remove();
            AIRouter.clearNPCMeta(vehicle);
        }
        if (setPassenger && player.getVehicle() != null) {
            player.getVehicle().eject();
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                c.setNPC(false);
                UEntityMeta.removeMetadata((Entity)vehicle, (String)"trade.npc");
                final CarStealEvent evt = new CarStealEvent(vehicle, player, c);
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.plugin.getServer().getPluginManager().callEvent((Event)evt);
                    }
                });
                UTradeListener.this.plugin.carSaver.carNowInUse(vehicle, c);
                if (setPassenger) {
                    vehicle.setPassenger((Entity)player);
                }
                if (vehicle instanceof CarMinecraftEntity) {
                    ((CarMinecraftEntity)vehicle).setHitBoxX(c.getHitboxX());
                    ((CarMinecraftEntity)vehicle).setHitBoxZ(c.getHitboxZ());
                }
                player.sendMessage(main.colors.getInfo() + Lang.get("general.steal.taken"));
            }
        }, 3L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void aiCarDie(VehicleDestroyEvent event) {
        if (!event.isCancelled() && event.getVehicle() instanceof Vehicle) {
            main.plugin.carSaver.carNoLongerInUse(event.getVehicle().getUniqueId());
            UEntityMeta.removeMetadata((Entity)event.getVehicle(), (String)"car.drivenCarMeta");
        }
        if (!UEntityMeta.hasMetadata((Entity)event.getVehicle(), (String)"trade.npc") || event.isCancelled() || event.getVehicle().hasMetadata("car.destroyed") || UEntityMeta.hasMetadata((Entity)event.getVehicle(), (String)"car.destroyed")) {
            return;
        }
        Vehicle veh = event.getVehicle();
        Location loc = veh.getLocation();
        for (Entity passenger = veh.getPassenger(); passenger != null; passenger = passenger.getPassenger()) {
            final Entity pass = passenger;
            Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                @Override
                public void run() {
                    pass.remove();
                }
            }, 2L);
        }
        List near = veh.getNearbyEntities(5.0, 5.0, 5.0);
        AIRouter.clearNPCMeta((Entity)veh);
        veh.remove();
        event.setCancelled(true);
        for (Entity e : near) {
            if (UEntityMeta.hasMetadata((Entity)e, (String)"trade.npcvillager") || e.getType().equals((Object)EntityType.DROPPED_ITEM)) {
                e.remove();
                continue;
            }
            if (uCarsAPI.getAPI().checkIfCar(e).booleanValue() || !(e instanceof Damageable)) continue;
            ((Damageable)e).damage(5.0);
        }
        loc.getWorld().playEffect(loc, Effect.EXPLOSION_HUGE, 20);
        loc.getWorld().playSound(loc, Sound.ENTITY_GENERIC_EXPLODE, 5.0f, 1.0f);
    }

    @EventHandler
    void respawn(uCarRespawnEvent event) {
        UUID old = event.getOldEntityId();
        UUID newId = event.getNewEntityId();
        DrivenCar d = this.plugin.carSaver.getCarInUseWithEntityID(old);
        if (d == null) {
            return;
        }
        d.setId(newId);
        this.plugin.carSaver.carNoLongerInUse(old);
        this.plugin.carSaver.carNowInUse(event.getNewCar(), d);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void vehicleEntry(PlayerInteractEntityEvent event) {
        if (!this.stealNPC) {
            return;
        }
        final Player player = event.getPlayer();
        Entity i = event.getRightClicked();
        Entity cart = i;
        if (!(cart instanceof Vehicle)) {
            cart = this.isEntityInCar(cart);
        }
        if (cart == null || !(cart instanceof Vehicle)) {
            return;
        }
        if (UEntityMeta.hasMetadata((Entity)cart, (String)"trade.npc")) {
            final DrivenCar c = this.plugin.carSaver.getCarInUse(cart);
            if (c == null) {
                return;
            }
            event.setCancelled(true);
            final Entity m = cart;
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    UTradeListener.this.npcCarSteal(m, player, c, true);
                }
            }, 4L);
        }
    }

    @EventHandler
    void NpcController(VehicleUpdateEvent event) {
        try {
            Vehicle v = event.getVehicle();
            if (!(v instanceof Vehicle)) {
                return;
            }
            Vehicle m = v;
            DrivenCar c = this.plugin.carSaver.getCarInUse((Entity)m);
            if (c == null || !c.isNPC()) {
                return;
            }
            Entity driver = ucars.listener.getDrivingPassengerOfCar(m);
            if (driver == null || !UEntityMeta.hasMetadata((Entity)driver, (String)"trade.npcvillager")) {
                if (c.isNPC() && m.isValid() && !m.isDead()) {
                    UEntityMeta.removeMetadata((Entity)m, (String)"trade.npc");
                    c.setNPC(false);
                    this.plugin.carSaver.carNowInUse((Entity)m, c);
                }
                return;
            }
            this.plugin.aiController.route((Entity)m, c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    void vehicleExit(VehicleExitEvent event) {
        if (!this.safeExit) {
            return;
        }
        Vehicle veh = event.getVehicle();
        if (veh.hasMetadata("safeExit.ignore") || UEntityMeta.hasMetadata((Entity)veh, (String)"safeExit.ignore")) {
            return;
        }
        Location loc = veh.getLocation();
        Block b = loc.getBlock();
        LivingEntity exited = event.getExited();
        if (!(exited instanceof Player)) {
            return;
        }
        if (!uCarsAPI.getAPI().checkIfCar((Entity)veh).booleanValue()) {
            return;
        }
        Player player = (Player)exited;
        if (exited.isDead() || player.getHealth() < 1.0) {
            return;
        }
        loc.setYaw(player.getLocation().getYaw());
        loc.setPitch(player.getLocation().getPitch());
        main.plugin.getServer().getScheduler().runTaskLater((Plugin)main.plugin, new Runnable((Entity)exited, loc){
            final /* synthetic */ Entity val$exited;
            final /* synthetic */ Location val$loc;
            {
                this.val$exited = entity;
                this.val$loc = location;
            }

            @Override
            public void run() {
                this.val$exited.teleport(this.val$loc.add(0.0, 0.5, 0.0));
            }
        }, 2L);
    }

    @EventHandler
    void displayUpgrades(VehicleUpdateEvent event) {
        Vehicle veh = event.getVehicle();
        if (!(veh instanceof Vehicle)) {
            return;
        }
        Vehicle car = veh;
        Location loc = car.getLocation();
        Entity passenger = car.getPassenger();
        if (passenger == null) {
            return;
        }
        if (passenger instanceof Boat) {
            Block toGo;
            BlockFace f;
            Block b = loc.getBlock();
            Vector vel = car.getVelocity();
            Boolean inWater = false;
            if (b.isLiquid()) {
                inWater = true;
                if (vel.getY() < 0.5) {
                    vel.setY(0.5);
                }
            } else if (b.getRelative(BlockFace.DOWN).isLiquid()) {
                inWater = true;
                vel.setY(0);
            }
            if (inWater.booleanValue() && (f = ClosestFace.getClosestFace((float)loc.getYaw())) != BlockFace.UP && f != BlockFace.DOWN && !(toGo = b.getRelative(f)).isLiquid() && !toGo.isEmpty()) {
                vel.setY(0.1);
            }
            car.setVelocity(vel);
            return;
        }
        if (passenger instanceof Bat && UEntityMeta.hasMetadata((Entity)car, (String)"trade.hover")) {
            if (passenger.getPassenger() == null) {
                return;
            }
            Block b = loc.getBlock();
            Vector vel = car.getVelocity();
            Block under = b.getRelative(BlockFace.DOWN);
            Block under2 = b.getRelative(BlockFace.DOWN, 2);
            Boolean descending = UEntityMeta.hasMetadata((Entity)car, (String)"car.braking");
            Boolean ascending = UEntityMeta.hasMetadata((Entity)car, (String)"car.action");
            int count = 0;
            if (!b.isEmpty()) {
                ++count;
            }
            if (!under.isEmpty()) {
                ++count;
            }
            if (!under2.isEmpty()) {
                ++count;
            }
            switch (count) {
                case 0: {
                    vel.setY(-0.3);
                    under.getWorld().playEffect(under.getLocation(), Effect.SMOKE, 1);
                    break;
                }
                case 1: {
                    vel.setY(2);
                    break;
                }
                case 2: {
                    vel.setY(1);
                    break;
                }
                case 3: {
                    vel.setY(0.1);
                    under.getWorld().playEffect(under.getLocation(), Effect.SMOKE, 1);
                }
            }
            if (descending.booleanValue() && ascending.booleanValue()) {
                vel.setY(0);
            } else if (descending.booleanValue()) {
                vel.setY(-0.6);
            } else if (ascending.booleanValue()) {
                vel.setY(0.6);
            }
            if (loc.getY() < this.hovercarHeightLimit || descending.booleanValue()) {
                car.setVelocity(vel);
            } else {
                Entity p;
                for (p = car.getPassenger(); p != null && !(p instanceof Player) && p.getPassenger() != null; p = p.getPassenger()) {
                }
                if (p != null && p instanceof Player) {
                    String msg = Lang.get("general.hovercar.heightLimit");
                    ((Player)p).sendMessage(main.colors.getInfo() + msg);
                }
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void itemCraft(CraftItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack recipe = event.getCurrentItem();
        if (recipe.getType() != Material.MINECART) {
            return;
        }
        if (!ChatColor.stripColor((String)recipe.getItemMeta().getDisplayName()).equalsIgnoreCase("car")) {
            return;
        }
        DrivenCar car = CarGenerator.gen();
        event.setCurrentItem(car.toItemStack());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void carUpgradeAnvil(final InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.CLONE_STACK) {
            ItemStack cloned = event.getCursor();
            if (uCarsAPI.getAPI().runCarChecks(cloned).booleanValue()) {
                event.setCancelled(true);
                return;
            }
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        InventoryView view = event.getView();
        if (event.isShiftClick() && (view.getBottomInventory() instanceof AnvilInventory || view.getTopInventory() instanceof AnvilInventory)) {
            event.setCancelled(true);
            return;
        }
        final Inventory i = event.getInventory();
        if (!(i instanceof AnvilInventory)) {
            return;
        }
        int slotNumber = event.getRawSlot();
        if (slotNumber != view.convertSlot(slotNumber)) {
            return;
        }
        Boolean update = true;
        Boolean save = false;
        Boolean pickup = false;
        if (event.getAction() == InventoryAction.PICKUP_ALL || event.getAction() == InventoryAction.PICKUP_HALF || event.getAction() == InventoryAction.PICKUP_ONE || event.getAction() == InventoryAction.PICKUP_SOME) {
            update = false;
            pickup = true;
            if (slotNumber == 2) {
                save = true;
            }
        }
        ItemStack carItem = null;
        try {
            carItem = i.getItem(0);
        }
        catch (Exception e) {
            return;
        }
        if (carItem == null) {
            if (!pickup.booleanValue() && i.getItem(1) != null) {
                ItemStack held = event.getCursor();
                DrivenCar car = ItemCarValidation.getCar(held);
                if (car == null) {
                    return;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (i.getItem(0) != null) {
                            UTradeListener.this.carUpgradeAnvil(event);
                        }
                    }
                }, 1L);
            }
            return;
        }
        if (carItem.getItemMeta().getLore().size() < 2) {
            return;
        }
        DrivenCar car = ItemCarValidation.getCar(carItem);
        if (car == null) {
            return;
        }
        if (save.booleanValue() && slotNumber == 2) {
            ItemStack result = event.getCurrentItem();
            if (!CarPresets.isCarPresetsUsed || CarPresets.isCarAllowedRename) {
                String name = ChatColor.stripColor((String)result.getItemMeta().getDisplayName());
                car.setName(name);
                player.sendMessage(main.colors.getSuccess() + "+" + main.colors.getInfo() + " Renamed car to: '" + name + "'");
                return;
            }
            event.setCancelled(true);
            return;
        }
        InventoryAction a = event.getAction();
        ItemStack upgrade = null;
        Boolean set = false;
        final ItemStack up = upgrade;
        final Boolean updat = update;
        final Boolean sav = save;
        final DrivenCar ca = car;
        if (slotNumber == 1 && (a == InventoryAction.PLACE_ALL || a == InventoryAction.PLACE_ONE || a == InventoryAction.PLACE_SOME) && event.getCursor().getType() != Material.AIR) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ItemStack upgrade = up;
                    try {
                        upgrade = i.getItem(1);
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (upgrade == null) {
                        return;
                    }
                    UTradeListener.this.applyUpgrades(upgrade, ca, updat, sav, player, i);
                }
            }, 1L);
            set = true;
            return;
        }
        if (!set.booleanValue()) {
            try {
                upgrade = i.getItem(1);
            }
            catch (Exception e) {
                return;
            }
        }
        if (upgrade == null) {
            return;
        }
        if (pickup.booleanValue() && slotNumber == 1) {
            return;
        }
        if (pickup.booleanValue() && slotNumber == 0 && upgrade != null && !upgrade.getType().equals((Object)Material.AIR)) {
            return;
        }
        this.applyUpgrades(upgrade, car, update, save, player, i);
    }

    public void applyUpgrades(ItemStack upgrade, DrivenCar car, Boolean update, Boolean save, Player player, Inventory i) {
        String upgradeMsg = Lang.get("general.upgrade.msg");
        if (upgrade.getType() == Material.IRON_BLOCK) {
            double health = car.getHealth();
            double maxHealth = ucars.config.getDouble("general.cars.health.max");
            double bonus = 9 * upgrade.getAmount();
            if ((health += bonus) > maxHealth) {
                health = maxHealth;
            }
            upgradeMsg = ucars.colorise((String)upgradeMsg);
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%amount%"), bonus + "");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%stat%"), "health");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%value%"), health + " (Max: " + maxHealth + ")");
            player.sendMessage(upgradeMsg);
            upgrade.setAmount(0);
            car.setHealth(health);
        } else if (upgrade.getType() == Material.IRON_INGOT) {
            double health = car.getHealth();
            double maxHealth = ucars.config.getDouble("general.cars.health.max");
            double bonus = 1 * upgrade.getAmount();
            if ((health += bonus) > maxHealth) {
                health = maxHealth;
            }
            upgradeMsg = ucars.colorise((String)upgradeMsg);
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%amount%"), bonus + "");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%stat%"), "health");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%value%"), health + " (Max: " + maxHealth + ")");
            player.sendMessage(upgradeMsg);
            upgrade.setAmount(0);
            car.setHealth(health);
        } else if (upgrade.getType() == Material.LEVER) {
            if (car.isHandlingDamaged()) {
                car.setHandlingDamaged(false);
            }
            upgradeMsg = ucars.colorise((String)upgradeMsg);
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%amount%"), "Fixed");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%stat%"), "all damage to the car");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%value%"), "Undamaged");
            player.sendMessage(upgradeMsg);
            upgrade.setAmount(0);
        } else if (upgrade.getType() == Material.REDSTONE) {
            double speed = car.getSpeed();
            speed += 0.05 * (double)upgrade.getAmount();
            speed *= 1000.0;
            speed = Math.round(speed);
            if ((speed /= 1000.0) > 4.0) {
                speed = 4.0;
            }
            upgradeMsg = ucars.colorise((String)upgradeMsg);
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%amount%"), 0.05 * (double)upgrade.getAmount() + "x");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%stat%"), "speed");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%value%"), speed + "x (Max: " + 4 + "x)");
            player.sendMessage(upgradeMsg);
            upgrade.setAmount(0);
            car.setSpeed(speed);
        } else if (upgrade.getType() == Material.REDSTONE_BLOCK) {
            double speed = car.getSpeed();
            speed += 0.45 * (double)upgrade.getAmount();
            speed *= 1000.0;
            speed = Math.round(speed);
            if ((speed /= 1000.0) > 4.0) {
                speed = 4.0;
            }
            upgradeMsg = ucars.colorise((String)upgradeMsg);
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%amount%"), 0.05 * (double)upgrade.getAmount() + "x");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%stat%"), "speed");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%value%"), speed + "x (Max: " + 4 + "x)");
            player.sendMessage(upgradeMsg);
            upgrade.setAmount(0);
            car.setSpeed(speed);
        } else {
            DisplayType type = Displays.canAdd(upgrade);
            if (type == null) {
                return;
            }
            if (car.getModifiers().size() > 0) {
                return;
            }
            List<String> modifys = car.getModifiers();
            modifys.add(type.getName());
            car.setModifiers(modifys);
            upgradeMsg = ucars.colorise((String)upgradeMsg);
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%amount%"), "1");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%stat%"), "Modifier");
            upgradeMsg = upgradeMsg.replaceAll(Pattern.quote("%value%"), type.getName());
            player.sendMessage(upgradeMsg);
            upgrade.setAmount(0);
        }
        i.clear(1);
        if (update.booleanValue()) {
            i.setItem(0, car.toItemStack());
            player.updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    void carDisplayDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        Entity e = event.getEntity();
        Vehicle v = this.isEntityInCar(e);
        if (v == null) {
            return;
        }
        if ((UEntityMeta.hasMetadata((Entity)v, (String)"trade.npc") || v.hasMetadata("mta.copentity") || UEntityMeta.hasMetadata((Entity)v, (String)"mta.copentity")) && (event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL) || event.getCause().equals((Object)EntityDamageEvent.DamageCause.SUFFOCATION))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    void carDisplayDeaths(EntityDeathEvent event) {
        try {
            if (event.getEntity() instanceof Player) {
                return;
            }
            LivingEntity e = event.getEntity();
            Vehicle v = this.isEntityInCar((Entity)e);
            if (v == null) {
                return;
            }
            event.setDroppedExp(0);
            event.getDrops().clear();
            if (UEntityMeta.hasMetadata((Entity)e, (String)"trade.npcvillager") && UEntityMeta.hasMetadata((Entity)v, (String)"trade.npc")) {
                Projectile p;
                final DrivenCar c = this.plugin.carSaver.getCarInUse((Entity)v);
                if (c == null || !(v instanceof Vehicle)) {
                    return;
                }
                final Vehicle m = v;
                if (!(e.getLastDamageCause() instanceof EntityDamageByEntityEvent)) {
                    c.setNPC(false);
                    UEntityMeta.removeMetadata((Entity)m, (String)"trade.npc");
                    this.plugin.carSaver.carNowInUse((Entity)m, c);
                    return;
                }
                EntityDamageByEntityEvent ev = (EntityDamageByEntityEvent)e.getLastDamageCause();
                Entity damager = ev.getDamager();
                if (damager instanceof Projectile && (p = (Projectile)damager).getShooter() instanceof Player) {
                    damager = (Entity)p.getShooter();
                }
                if (!(damager instanceof Player)) {
                    c.setNPC(false);
                    UEntityMeta.removeMetadata((Entity)m, (String)"trade.npc");
                    this.plugin.carSaver.carNowInUse((Entity)m, c);
                    return;
                }
                final Player player = (Player)damager;
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.npcCarSteal((Entity)m, player, c, false);
                    }
                }, 4L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    void carDestroy(VehicleDestroyEvent event) {
        if (uCarsAPI.getAPI().checkIfCar((Entity)event.getVehicle()).booleanValue()) {
            return;
        }
        Vehicle car = this.isEntityInCar((Entity)event.getVehicle());
        if (car == null || !uCarsAPI.getAPI().checkIfCar((Entity)car).booleanValue()) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    void boatDestroy(EntityDamageByBlockEvent event) {
        Vehicle car = this.isEntityInCar(event.getEntity());
        if (car == null || !uCarsAPI.getAPI().checkIfCar((Entity)car).booleanValue()) {
            return;
        }
        event.setDamage(0.0);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    void carDestroy(VehicleDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (uCarsAPI.getAPI().checkIfCar((Entity)event.getVehicle()).booleanValue()) {
            return;
        }
        Vehicle car = this.isEntityInCar((Entity)event.getVehicle());
        if (car == null || !uCarsAPI.getAPI().checkIfCar((Entity)car).booleanValue()) {
            return;
        }
        event.setDamage(0.0);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW)
    void carDestroy(EntityDamageByEntityEvent event) {
        if (uCarsAPI.getAPI().checkIfCar(event.getEntity()).booleanValue()) {
            return;
        }
        if (event.isCancelled() || event.getDamage() <= 0.0) {
            return;
        }
        Player player = event.getDamager() instanceof Player ? (Player)event.getDamager() : null;
        Vehicle car = this.isEntityInCar(event.getEntity());
        if (car == null || !uCarsAPI.getAPI().checkIfCar((Entity)car).booleanValue()) {
            return;
        }
        if (car.getPassenger() != null && car.getPassenger().getType().equals((Object)EntityType.PLAYER) || UEntityMeta.hasMetadata((Entity)car, (String)"trade.npc") && UEntityMeta.hasMetadata((Entity)event.getEntity(), (String)"trade.npcvillager") || car.getPassenger() != null && (UEntityMeta.hasMetadata((Entity)car.getPassenger(), (String)"mta.copentity") || car.getPassenger().hasMetadata("mta.copentity"))) {
            return;
        }
        CarHealthData health = ucars.listener.getCarHealthHandler((Entity)car);
        if (health == null) {
            return;
        }
        double damage = event.getDamage();
        if (player != null && (player.getItemInHand() == null | player.getItemInHand().getType().equals((Object)Material.AIR) || damage < ucars.config.getDouble("general.cars.health.punchDamage"))) {
            damage = ucars.config.getDouble("general.cars.health.punchDamage");
        }
        event.setDamage(-70.0);
        event.setCancelled(true);
        if (damage > 0.0) {
            double max = ucars.config.getDouble("general.cars.health.default");
            double left = health.getHealth() - damage;
            ChatColor color = ChatColor.YELLOW;
            if (left > max * 0.66) {
                color = ChatColor.GREEN;
            }
            if (left < max * 0.33) {
                color = ChatColor.RED;
            }
            if (left < 0.0) {
                left = 0.0;
            }
            if (player != null) {
                player.sendMessage(ChatColor.RED + "-" + damage + ChatColor.YELLOW + "[" + player.getName() + "]" + color + " (" + left + ")");
            }
            if (player != null) {
                health.damage(damage, (Entity)car, player);
            } else {
                health.damage(damage, (Entity)car);
            }
            ucars.listener.updateCarHealthHandler((Entity)car, health);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    void carPlace(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        ItemStack inHand = event.getPlayer().getItemInHand().clone();
        if (inHand == null || inHand.getItemMeta() == null || inHand.getItemMeta().getLore() == null || inHand.getItemMeta().getLore().size() < 2 || !uCarsAPI.getAPI().runCarChecks(inHand).booleanValue()) {
            return;
        }
        if (!PlaceManager.placeableOn((String)block.getType().name(), (byte)block.getData()).booleanValue()) {
            return;
        }
        if (!ucars.config.getBoolean("general.cars.enable")) {
            return;
        }
        if (ucars.config.getBoolean("general.cars.placePerm.enable")) {
            String perm = ucars.config.getString("general.cars.placePerm.perm");
            if (!event.getPlayer().hasPermission(perm)) {
                String noPerm = com.useful.ucars.Lang.get((String)"lang.messages.noPlacePerm");
                noPerm = noPerm.replaceAll("%perm%", perm);
                event.getPlayer().sendMessage(ucars.colors.getError() + noPerm);
                return;
            }
        }
        if (event.isCancelled()) {
            event.getPlayer().sendMessage(ucars.colors.getError() + com.useful.ucars.Lang.get((String)"lang.messages.noPlaceHere"));
            return;
        }
        DrivenCar c = ItemCarValidation.getCar(inHand);
        if (c == null) {
            return;
        }
        Location loc = block.getLocation().add(0.0, 1.5, 0.0);
        if (loc.getY() >= (double)loc.getWorld().getMaxHeight()) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(ucars.colors.getError() + com.useful.ucars.Lang.get((String)"lang.messages.noPlaceHere"));
            return;
        }
        Vector v = loc.toVector().clone().setY(event.getPlayer().getLocation().getY()).subtract(event.getPlayer().getLocation().toVector());
        v = v.normalize();
        boolean loop = this.safeExit;
        Location current = event.getPlayer().getLocation().clone();
        double prevDist = Double.MAX_VALUE;
        while (loop) {
            double dist = current.distanceSquared(loc);
            if (dist > prevDist || dist < 1.5) {
                loop = false;
            }
            prevDist = dist;
            Block b = current.getBlock();
            if (!b.isEmpty() && !b.isLiquid()) {
                event.getPlayer().sendMessage(ChatColor.RED + "You need a clear path between you and the vehicle to be placed!");
                event.setCancelled(true);
                return;
            }
            current = current.add(v);
        }
        loc.setYaw(event.getPlayer().getLocation().getYaw());
        Block in = loc.getBlock();
        if (!in.isEmpty() && !in.isLiquid()) {
            return;
        }
        Entity car = CarPlaceAPI.placeCar(c, loc.clone().subtract(0.0, 1.5, 0.0), event.getPlayer(), event.getPlayer().getLocation().getYaw());
        ItemStack placed = event.getPlayer().getItemInHand();
        placed.setAmount(0);
        event.getPlayer().getInventory().setItemInHand(placed);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void carCrash(uCarCrashEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity cart = event.getCar();
        if (UEntityMeta.hasMetadata((Entity)cart, (String)"car.destroyed") || cart.hasMetadata("car.destroyed")) {
            return;
        }
        UUID id = cart.getUniqueId();
        DrivenCar car = this.plugin.carSaver.getCarInUse(cart);
        if (car == null) {
            cart.remove();
            return;
        }
        if (main.random.nextInt(10) < 1) {
            car.setHandlingDamaged(true);
            this.plugin.carSaver.asyncSave();
            Entity passenger = cart.getPassenger();
            while (!passenger.getType().equals((Object)EntityType.PLAYER) && passenger.getPassenger() != null) {
                passenger = passenger.getPassenger();
            }
            if (passenger instanceof Player) {
                ((Player)passenger).sendMessage(ChatColor.RED + "*The car's handling broke* If you want to repair it, you will need to use an anvil and a lever!");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void carRemoval(ucarDeathEvent event) {
        event.setCancelled(true);
        Entity cart = event.getCar();
        if (UEntityMeta.hasMetadata((Entity)cart, (String)"car.destroyed") || cart.hasMetadata("car.destroyed")) {
            return;
        }
        UUID id = cart.getUniqueId();
        DrivenCar car = this.plugin.carSaver.getCarInUse(cart);
        if (car == null) {
            cart.remove();
            return;
        }
        UEntityMeta.setMetadata((Entity)cart, (String)"car.destroyed", (MetadataValue)new StatValue((Object)true, (Plugin)ucars.plugin));
        event.setCancelled(true);
        if (UEntityMeta.hasMetadata((Entity)cart, (String)"trade.npc")) {
            main.plugin.aiSpawns.decrementSpawnedAICount();
            if (event.didPlayerKill()) {
                Player player = event.getPlayerWhoKilled();
                this.npcCarSteal(cart, player, car, false);
            }
        }
        this.plugin.carSaver.carNoLongerInUse(car);
        Location loc = cart.getLocation();
        Entity top = cart;
        while (top.getPassenger() != null && !(top.getPassenger() instanceof Player)) {
            top = top.getPassenger();
        }
        if (top.getPassenger() instanceof Player) {
            final Player pl = (Player)top.getPassenger();
            top.eject();
            if (this.safeExit) {
                final Location exitLoc = loc.clone().add(0.0, 0.5, 0.0);
                Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        pl.teleport(exitLoc);
                    }
                }, 1L);
            }
        }
        while (top.getVehicle() != null) {
            Entity veh = top.getVehicle();
            top.remove();
            top = veh;
        }
        cart.eject();
        cart.remove();
        loc.getWorld().dropItemNaturally(loc, new ItemStack(car.toItemStack()));
    }

    @EventHandler
    public void signWriter(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[Trade]")) {
            lines[0] = ChatColor.GREEN + "[Trade]";
            lines[1] = ChatColor.RED + ChatColor.stripColor((String)lines[1]);
            lines[2] = "Place chest";
            lines[3] = "above";
        }
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[Shop]")) {
            lines[0] = ChatColor.GREEN + "[Shop]";
            lines[1] = ChatColor.RED + ChatColor.stripColor((String)lines[1]);
            lines[2] = "Place chest";
            lines[3] = "above";
        }
    }

    @EventHandler
    public void tradeBooth(InventoryOpenEvent event) {
        Boolean installed;
        if (!main.config.getBoolean("general.carTrading.enable")) {
            return;
        }
        if (main.economy == null && !(installed = Boolean.valueOf(this.plugin.setupEconomy())).booleanValue()) {
            main.config.set("general.carTrading.enable", (Object)false);
            main.logger.info(main.colors.getError() + "[Important] Unable to find an economy plugin: trade booths have been closed.");
            return;
        }
        Inventory inv = event.getInventory();
        if (!(inv.getHolder() instanceof Chest) && !(inv.getHolder() instanceof DoubleChest)) {
            return;
        }
        Block block = null;
        block = inv.getHolder() instanceof Chest ? ((Chest)inv.getHolder()).getBlock() : ((DoubleChest)inv.getHolder()).getLocation().getBlock();
        Block underBlock = block.getRelative(BlockFace.DOWN);
        if (!(underBlock.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)underBlock.getState();
        if (!ChatColor.stripColor((String)sign.getLines()[0]).equalsIgnoreCase("[Trade]") || !ChatColor.stripColor((String)sign.getLines()[1]).equalsIgnoreCase("cars")) {
            if (ChatColor.stripColor((String)sign.getLines()[0]).equalsIgnoreCase("[Shop]") && ChatColor.stripColor((String)sign.getLines()[1]).equalsIgnoreCase("cars")) {
                event.getView().close();
                event.setCancelled(true);
                this.plugin.carShop.open((Player)event.getPlayer());
            }
            return;
        }
        Player player = (Player)event.getPlayer();
        event.getView().close();
        event.setCancelled(true);
        this.plugin.tradeMenu.open(player);
    }

    @EventHandler
    public void tradeMenuSelect(final TradeBoothClickEvent event) {
        IconMenu.OptionClickEvent clickEvent = event.getClickEvent();
        final Player player = clickEvent.getPlayer();
        int position = clickEvent.getPosition();
        Runnable doAfter = null;
        if (event.getMenuType() == TradeBoothMenuType.MENU) {
            if (position == 0) {
                player.sendMessage(main.colors.getTitle() + "Tutorial coming soon!");
                return;
            }
            if (position == 1) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.getCarsForSaleMenu(1).open(player);
                    }
                };
            } else if (position == 2) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.getSellCarsInputMenu().open(player);
                    }
                };
            } else if (position == 3) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.getUpgradesForSaleMenu(1).open(player);
                    }
                };
            } else if (position == 4) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.getSellUpgradesInputMenu().open(player);
                    }
                };
            }
        } else if (event.getMenuType() == TradeBoothMenuType.BUY_CARS) {
            if (position == 0) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.plugin.tradeMenu.open(player);
                    }
                };
            } else if (position == 53) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.getCarsForSaleMenu(event.getPage() + 1).open(player);
                    }
                };
            } else if (position == 52) {
                int page = event.getPage();
                if (page > 1) {
                    --page;
                }
                final int p = page;
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.getCarsForSaleMenu(p).open(player);
                    }
                };
            } else {
                int page = event.getPage();
                int slot = clickEvent.getPosition() - 1;
                int mapPos = (page - 1) * 51 + slot;
                HashMap cars = null;
                try {
                    cars = (HashMap)event.getArgs()[0];
                }
                catch (Exception e) {
                    player.sendMessage(main.colors.getError() + "An error occured. Please try again.");
                    return;
                }
                CarForSale car = null;
                try {
                    car = (CarForSale)cars.get(cars.keySet().toArray()[mapPos]);
                }
                catch (Exception e) {
                    player.sendMessage(main.colors.getError() + "An error occured. Please try again.");
                    return;
                }
                if (!this.plugin.salesManager.carsForSale.containsKey(car.getUUID())) {
                    return;
                }
                if (main.economy == null && !this.plugin.setupEconomy()) {
                    player.sendMessage(main.colors.getError() + "An error occured. Please try again later.");
                    return;
                }
                double price = car.getPrice();
                double balance = main.economy.getBalance(player.getName());
                if (balance < price) {
                    String msg = Lang.get("general.buy.notEnoughMoney");
                    msg = msg.replaceAll(Pattern.quote("%balance%"), Matcher.quoteReplacement(main.config.getString("general.carTrading.currencySign") + balance));
                    player.sendMessage(main.colors.getError() + msg);
                    return;
                }
                this.plugin.salesManager.carsForSale.remove(car.getUUID());
                EconomyResponse er = main.economy.withdrawPlayer(player.getName(), price);
                balance = er.balance;
                if (!er.transactionSuccess()) {
                    player.sendMessage(main.colors.getError() + "An error occured. Please try again later.");
                    return;
                }
                double profit = car.getProfit();
                EconomyResponse er2 = main.economy.depositPlayer(car.getSeller(), profit);
                if (this.plugin.getServer().getPlayer(car.getSeller()) != null && this.plugin.getServer().getPlayer(car.getSeller()).isOnline()) {
                    Player pl = this.plugin.getServer().getPlayer(car.getSeller());
                    pl.sendMessage(main.colors.getSuccess() + "+" + main.config.getString("general.carTrading.currencySign") + profit + main.colors.getInfo() + " For car sale!");
                } else {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("[dd/MM/yyyy@HH:mm]");
                    String time = dateFormat.format(new Date());
                    String msg = main.colors.getInfo() + time + " " + ChatColor.RESET + main.colors.getSuccess() + "+" + main.config.getString("general.carTrading.currencySign") + profit + main.colors.getInfo() + " For car sale!";
                    this.plugin.alerts.put(car.getSeller(), msg);
                }
                if (!er2.transactionSuccess()) {
                    main.logger.info(main.colors.getError() + "Failed to give seller money for seller: " + car.getSeller() + "!");
                }
                String msg = Lang.get("general.buy.success");
                msg = msg.replaceAll(Pattern.quote("%balance%"), Matcher.quoteReplacement(main.config.getString("general.carTrading.currencySign") + balance));
                msg = msg.replaceAll(Pattern.quote("%item%"), "1 car");
                msg = msg.replaceAll(Pattern.quote("%price%"), Matcher.quoteReplacement(main.config.getString("general.carTrading.currencySign") + price));
                DrivenCar c = car.getCar();
                this.plugin.salesManager.saveCars();
                player.getInventory().addItem(new ItemStack[]{c.toItemStack()});
                player.sendMessage(main.colors.getSuccess() + msg);
            }
        } else if (event.getMenuType() == TradeBoothMenuType.BUY_UPGRADES) {
            if (position == 0) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.plugin.tradeMenu.open(player);
                    }
                };
            } else if (position == 53) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.getUpgradesForSaleMenu(event.getPage() + 1).open(player);
                    }
                };
            } else if (position == 52) {
                int page = event.getPage();
                if (page > 1) {
                    --page;
                }
                final int p = page;
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.getUpgradesForSaleMenu(p).open(player);
                    }
                };
            } else {
                int page = event.getPage();
                int slot = clickEvent.getPosition() - 1;
                int mapPos = (page - 1) * 51 + slot;
                HashMap cars = null;
                try {
                    cars = (HashMap)event.getArgs()[0];
                }
                catch (Exception e) {
                    player.sendMessage(main.colors.getError() + "An error occured. Please try again.");
                    return;
                }
                UpgradeForSale car = null;
                try {
                    car = (UpgradeForSale)cars.get(cars.keySet().toArray()[mapPos]);
                }
                catch (Exception e) {
                    player.sendMessage(main.colors.getError() + "An error occured. Please try again.");
                    return;
                }
                if (!this.plugin.salesManager.upgradeForSale.containsKey(car.getSaleId())) {
                    return;
                }
                if (main.economy == null && !this.plugin.setupEconomy()) {
                    player.sendMessage(main.colors.getError() + "An error occured. Please try again later.");
                    return;
                }
                double price = car.getPrice();
                double balance = main.economy.getBalance(player.getName());
                if (balance < price) {
                    String msg = Lang.get("general.buy.notEnoughMoney");
                    msg = msg.replaceAll(Pattern.quote("%balance%"), Matcher.quoteReplacement(main.config.getString("general.carTrading.currencySign") + balance));
                    player.sendMessage(main.colors.getError() + msg);
                    return;
                }
                this.plugin.salesManager.upgradeForSale.remove(car.getSaleId());
                EconomyResponse er = main.economy.withdrawPlayer(player.getName(), price);
                balance = er.balance;
                if (!er.transactionSuccess()) {
                    player.sendMessage(main.colors.getError() + "An error occured. Please try again later.");
                    return;
                }
                double profit = car.getProfit();
                EconomyResponse er2 = main.economy.depositPlayer(car.getSeller(), profit);
                if (this.plugin.getServer().getPlayer(car.getSeller()) != null && this.plugin.getServer().getPlayer(car.getSeller()).isOnline()) {
                    Player pl = this.plugin.getServer().getPlayer(car.getSeller());
                    pl.sendMessage(main.colors.getSuccess() + "+" + main.config.getString("general.carTrading.currencySign") + profit + main.colors.getInfo() + " For upgrade sale!");
                } else {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("[dd/MM/yyyy@HH:mm]");
                    String time = dateFormat.format(new Date());
                    String msg = main.colors.getInfo() + time + " " + ChatColor.RESET + main.colors.getSuccess() + "+" + main.config.getString("general.carTrading.currencySign") + profit + main.colors.getInfo() + " For upgrade sale!";
                    this.plugin.alerts.put(car.getSeller(), msg);
                }
                if (!er2.transactionSuccess()) {
                    main.logger.info(main.colors.getError() + "Failed to give seller money for seller: " + car.getSeller() + "!");
                }
                String msg = Lang.get("general.buy.success");
                msg = msg.replaceAll(Pattern.quote("%balance%"), Matcher.quoteReplacement(main.config.getString("general.carTrading.currencySign") + balance));
                msg = msg.replaceAll(Pattern.quote("%item%"), "upgrades");
                msg = msg.replaceAll(Pattern.quote("%price%"), Matcher.quoteReplacement(main.config.getString("general.carTrading.currencySign") + price));
                this.plugin.salesManager.saveUpgrades();
                ItemStack item = new ItemStack(Material.IRON_INGOT);
                ItemMeta im = item.getItemMeta();
                ArrayList<String> lore = new ArrayList<String>();
                StatType type = car.getUpgradeType();
                if (type == StatType.HANDLING_DAMAGED) {
                    item = new ItemStack(Material.LEVER);
                    im = item.getItemMeta();
                    im.setDisplayName("Repair Upgrade");
                    lore.add(main.colors.getInfo() + "Repairs all car damage");
                    im.setLore(lore);
                    item.setItemMeta(im);
                } else if (type == StatType.HEALTH) {
                    item = new ItemStack(Material.IRON_INGOT);
                    im = item.getItemMeta();
                    im.setDisplayName("Health Upgrade");
                    lore.add(main.colors.getInfo() + "Adds 1 health to your car");
                    im.setLore(lore);
                    item.setItemMeta(im);
                } else if (type == StatType.SPEED) {
                    item = new ItemStack(Material.REDSTONE);
                    im = item.getItemMeta();
                    im.setDisplayName("Speed Upgrade");
                    lore.add(main.colors.getInfo() + "Adds 0.05x speed to your car");
                    im.setLore(lore);
                    item.setItemMeta(im);
                }
                item.setAmount(car.getQuantity());
                player.getInventory().addItem(new ItemStack[]{item});
                player.sendMessage(main.colors.getSuccess() + msg);
            }
        }
        if (doAfter != null) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, doAfter, 2L);
        }
    }

    @EventHandler
    void sellStuff(InputMenuClickEvent event) {
        InputMenu.OptionClickEvent clickEvent = event.getClickEvent();
        final Player player = clickEvent.getPlayer();
        int position = clickEvent.getPosition();
        Runnable doAfter = null;
        if (event.getMenuType() == TradeBoothMenuType.SELL_CARS) {
            if (position == 0) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.plugin.tradeMenu.open(player);
                    }
                };
            } else if (position == 8) {
                Inventory i = clickEvent.getInventory();
                if (i.getItem(4) == null || i.getItem(4).getType() == Material.AIR) {
                    player.sendMessage(main.colors.getError() + "Invalid item to sell!");
                    return;
                }
                ItemStack carItem = i.getItem(4);
                if (carItem.getItemMeta() == null || carItem.getItemMeta().getLore() == null || carItem.getItemMeta().getLore().size() < 2) {
                    player.sendMessage(main.colors.getError() + "Invalid item to sell!");
                    return;
                }
                DrivenCar c = ItemCarValidation.getCar(carItem);
                if (c == null) {
                    player.sendMessage(main.colors.getInfo() + "Invalid item to sell!");
                    return;
                }
                double price = CarValueCalculator.getCarValueForSale(c);
                if (main.economy == null) {
                    return;
                }
                String msg = Lang.get("general.sell.msg");
                msg = msg.replaceAll(Pattern.quote("%item%"), "a car");
                String units = main.config.getString("general.carTrading.currencySign") + price;
                msg = msg.replaceAll(Pattern.quote("%price%"), Matcher.quoteReplacement(units));
                double purchase = CarValueCalculator.getCarValueForPurchase(c);
                CarForSale saleItem = new CarForSale(c, player.getName(), purchase, price, null);
                this.plugin.salesManager.carsForSale.put(saleItem.getUUID(), saleItem);
                this.plugin.salesManager.saveCars();
                player.sendMessage(main.colors.getInfo() + msg);
                event.getClickEvent().setWillClose(true);
                event.getClickEvent().setWillDestroy(true);
            } else if (position == 4) {
                final Inventory inv = clickEvent.getInventory();
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Inventory i = inv;
                        if (i.getItem(4) == null || i.getItem(4).getType() == Material.AIR) {
                            player.sendMessage(main.colors.getError() + "Invalid item to sell!");
                            return;
                        }
                        ItemStack carItem = i.getItem(4);
                        if (carItem.getItemMeta() == null || carItem.getItemMeta().getLore() == null || carItem.getItemMeta().getLore().size() < 2) {
                            player.sendMessage(main.colors.getError() + "Invalid item to sell!");
                            return;
                        }
                        DrivenCar c = ItemCarValidation.getCar(carItem);
                        if (c == null) {
                            player.sendMessage(main.colors.getInfo() + "Invalid item to sell!");
                            return;
                        }
                        double price = CarValueCalculator.getCarValueForSale(c);
                        if (main.economy == null) {
                            return;
                        }
                        ItemStack sellItem = new ItemStack(Material.EMERALD);
                        ItemMeta im = sellItem.getItemMeta();
                        im.setDisplayName(main.colors.getTitle() + "Sell");
                        ArrayList<String> lre = new ArrayList<String>();
                        lre.add(main.colors.getInfo() + "For: " + main.config.getString("general.carTrading.currencySign") + price);
                        im.setLore(lre);
                        sellItem.setItemMeta(im);
                        inv.setItem(8, sellItem);
                    }
                }, 1L);
            }
        } else if (event.getMenuType() == TradeBoothMenuType.SELL_UPGRADES) {
            if (position == 0) {
                doAfter = new Runnable(){

                    @Override
                    public void run() {
                        UTradeListener.this.plugin.tradeMenu.open(player);
                    }
                };
            } else if (position == 8) {
                Inventory i = clickEvent.getInventory();
                if (i.getItem(4) == null || i.getItem(4).getType() == Material.AIR) {
                    player.sendMessage(main.colors.getError() + "Invalid item to sell!");
                    return;
                }
                ItemStack upgradeItem = i.getItem(4).clone();
                i.clear(4);
                Material type = upgradeItem.getType();
                StatType upgradeType = StatType.SPEED;
                if (type == Material.IRON_INGOT) {
                    upgradeType = StatType.HEALTH;
                } else if (type == Material.REDSTONE) {
                    upgradeType = StatType.SPEED;
                } else if (type == Material.LEVER) {
                    upgradeType = StatType.HANDLING_DAMAGED;
                } else {
                    player.sendMessage(main.colors.getError() + "Invalid item to sell!");
                    return;
                }
                double price = main.config.getDouble("general.carTrading.upgradeValue") * (double)upgradeItem.getAmount();
                double sellFor = price + main.config.getDouble("general.carTrading.VATPercent") * price / 100.0;
                sellFor = Math.round(sellFor * 100.0);
                UUID saleId = UUID.randomUUID();
                UpgradeForSale saleItem = new UpgradeForSale(saleId, player.getName(), sellFor /= 100.0, upgradeType, upgradeItem.getAmount(), price);
                String msg = Lang.get("general.sell.msg");
                msg = msg.replaceAll(Pattern.quote("%item%"), "upgrades");
                String units = main.config.getString("general.carTrading.currencySign") + price;
                msg = msg.replaceAll(Pattern.quote("%price%"), Matcher.quoteReplacement(units));
                if (!this.plugin.salesManager.upgradeForSale.containsKey(saleId)) {
                    this.plugin.salesManager.upgradeForSale.put(saleId, saleItem);
                    this.plugin.salesManager.saveUpgrades();
                    player.sendMessage(main.colors.getInfo() + msg);
                }
                event.getClickEvent().setWillClose(true);
                event.getClickEvent().setWillDestroy(true);
                clickEvent.getMenu().destroy();
            } else if (position == 4) {
                final Inventory inv = clickEvent.getInventory();
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Inventory i = inv;
                        if (i.getItem(4) == null || i.getItem(4).getType() == Material.AIR) {
                            player.sendMessage(main.colors.getError() + "Invalid item to sell!");
                            return;
                        }
                        Material type = i.getItem(4).getType();
                        if (type != Material.IRON_INGOT && type != Material.REDSTONE && type != Material.LEVER) {
                            player.sendMessage(main.colors.getError() + "Invalid item to sell!");
                            return;
                        }
                        ItemStack sellItem = new ItemStack(Material.EMERALD);
                        ItemMeta im = sellItem.getItemMeta();
                        im.setDisplayName(main.colors.getTitle() + "Sell");
                        ArrayList<String> lre = new ArrayList<String>();
                        double price = main.config.getDouble("general.carTrading.upgradeValue") * (double)i.getItem(4).getAmount();
                        lre.add(main.colors.getInfo() + "For: " + main.config.getString("general.carTrading.currencySign") + price);
                        im.setLore(lre);
                        sellItem.setItemMeta(im);
                        inv.setItem(8, sellItem);
                    }
                }, 1L);
            }
        }
        if (doAfter != null) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, doAfter, 2L);
        }
    }

    IconMenu getCarsForSaleMenu(final int page) {
        String title = main.colors.getTitle() + Lang.get("title.trade.buyCars") + " Page: " + page;
        if (title.length() > 32) {
            title = main.colors.getError() + "Buy Cars (ERROR:Too Long)";
        }
        final HashMap cars = (HashMap)this.plugin.salesManager.carsForSale.clone();
        IconMenu menu = new IconMenu(title, 54, new IconMenu.OptionClickEventHandler(){

            @Override
            public void onOptionClick(IconMenu.OptionClickEvent event) {
                TradeBoothClickEvent evt = new TradeBoothClickEvent(event, TradeBoothMenuType.BUY_CARS, page, new Object[]{cars});
                UTradeListener.this.plugin.getServer().getPluginManager().callEvent((Event)evt);
                event.setWillClose(true);
                event.setWillDestroy(true);
            }
        }, (Plugin)this.plugin, true);
        menu.setOption(0, new ItemStack(Material.BOOK), main.colors.getTitle() + "Back to menu", main.colors.getInfo() + "Return back to the selection menu");
        menu.setOption(52, new ItemStack(Material.PAPER), main.colors.getTitle() + "Previous Page", main.colors.getInfo() + "Go to previous page");
        menu.setOption(53, new ItemStack(Material.PAPER), main.colors.getTitle() + "Next Page", main.colors.getInfo() + "Go to next page");
        int pos = 1;
        int start = (page - 1) * 51;
        Object[] keys = cars.keySet().toArray();
        for (int i = start; i < keys.length; ++i) {
            CarForSale car = (CarForSale)cars.get(keys[i]);
            double price = car.getPrice();
            String seller = car.getSeller();
            ItemStack item = new ItemStack(Material.AIR);
            String name = "Car";
            ArrayList<String> lore = new ArrayList<String>();
            DrivenCar c = car.getCar();
            name = c.getName();
            item = c.toItemStack();
            ItemMeta im = item.getItemMeta();
            lore.add(main.colors.getInfo() + main.config.getString("general.carTrading.currencySign") + price);
            lore.add(main.colors.getInfo() + "Seller: " + seller);
            List iml = im.getLore();
            iml.remove(0);
            lore.addAll(2, iml);
            im.setLore(lore);
            item.setItemMeta(im);
            if (pos >= 52) continue;
            menu.setOption(pos, item, main.colors.getTitle() + name, lore);
            ++pos;
        }
        return menu;
    }

    IconMenu getUpgradesForSaleMenu(final int page) {
        String title = main.colors.getTitle() + Lang.get("title.trade.buyUpgrades") + " Page: " + page;
        if (title.length() > 32) {
            title = main.colors.getError() + "Buy Upgrades (ERROR:Too Long)";
        }
        final HashMap ups = (HashMap)this.plugin.salesManager.upgradeForSale.clone();
        IconMenu menu = new IconMenu(title, 54, new IconMenu.OptionClickEventHandler(){

            @Override
            public void onOptionClick(IconMenu.OptionClickEvent event) {
                TradeBoothClickEvent evt = new TradeBoothClickEvent(event, TradeBoothMenuType.BUY_UPGRADES, page, new Object[]{ups});
                UTradeListener.this.plugin.getServer().getPluginManager().callEvent((Event)evt);
                event.setWillClose(true);
                event.setWillDestroy(true);
            }
        }, (Plugin)this.plugin, true);
        menu.setOption(0, new ItemStack(Material.BOOK), main.colors.getTitle() + "Back to menu", main.colors.getInfo() + "Return back to the selection menu");
        menu.setOption(52, new ItemStack(Material.PAPER), main.colors.getTitle() + "Previous Page", main.colors.getInfo() + "Go to previous page");
        menu.setOption(53, new ItemStack(Material.PAPER), main.colors.getTitle() + "Next Page", main.colors.getInfo() + "Go to next page");
        int pos = 1;
        int start = (page - 1) * 51;
        Object[] keys = ups.keySet().toArray();
        for (int i = start; i < keys.length; ++i) {
            UpgradeForSale car = (UpgradeForSale)ups.get(keys[i]);
            double price = car.getPrice();
            String seller = car.getSeller();
            ItemStack item = new ItemStack(Material.AIR);
            ItemMeta im = item.getItemMeta();
            String name = "Upgrade";
            ArrayList<String> lore = new ArrayList<String>();
            item = new ItemStack(Material.IRON_INGOT);
            StatType type = car.getUpgradeType();
            if (type == StatType.HANDLING_DAMAGED) {
                item = new ItemStack(Material.LEVER);
                im = item.getItemMeta();
                name = "Repair Upgrade";
                lore.add(main.colors.getInfo() + "Repairs all car damage");
                im.setLore(lore);
                item.setItemMeta(im);
            } else if (type == StatType.HEALTH) {
                item = new ItemStack(Material.IRON_INGOT);
                im = item.getItemMeta();
                name = "Health Upgrade";
                lore.add(main.colors.getInfo() + "Adds 1 health to your car");
                im.setLore(lore);
                item.setItemMeta(im);
            } else if (type == StatType.SPEED) {
                item = new ItemStack(Material.REDSTONE);
                im = item.getItemMeta();
                name = "Speed Upgrade";
                lore.add(main.colors.getInfo() + "Adds 0.05x speed to your car");
                im.setLore(lore);
                item.setItemMeta(im);
            }
            lore = new ArrayList();
            lore.add(main.colors.getInfo() + main.config.getString("general.carTrading.currencySign") + price);
            lore.add(main.colors.getInfo() + "Seller: " + seller);
            lore.addAll(2, im.getLore());
            im.setLore(lore);
            item.setItemMeta(im);
            item.setAmount(car.getQuantity());
            if (pos >= 52) continue;
            menu.setOption(pos, item, main.colors.getTitle() + name, lore);
            ++pos;
        }
        return menu;
    }

    InputMenu getSellCarsInputMenu() {
        String title = main.colors.getTitle() + Lang.get("title.trade.sellCars");
        if (title.length() > 32) {
            title = main.colors.getError() + "Sell a car";
        }
        InputMenu menu = new InputMenu(title, 9, new InputMenu.OptionClickEventHandler(){

            @Override
            public void onOptionClick(InputMenu.OptionClickEvent event) {
                if (event.getPosition() == 0 || event.getPosition() == 8) {
                    event.setWillClose(true);
                }
                InputMenuClickEvent evt = new InputMenuClickEvent(event, TradeBoothMenuType.SELL_CARS);
                UTradeListener.this.plugin.getServer().getPluginManager().callEvent((Event)evt);
            }

            @Override
            public void onClose(Player player, Inventory inv) {
            }
        }, (Plugin)this.plugin, true);
        menu.setOption(0, new ItemStack(Material.BOOK), main.colors.getTitle() + "Back to menu", main.colors.getInfo() + "Return back to the selection menu");
        menu.setOption(8, new ItemStack(Material.EMERALD), main.colors.getTitle() + "Sell", main.colors.getError() + "Unavailable");
        menu.setOption(1, new ItemStack(Material.PAPER), main.colors.getTitle() + ">", main.colors.getInfo() + ">");
        menu.setOption(2, new ItemStack(Material.PAPER), main.colors.getTitle() + ">", main.colors.getInfo() + ">");
        menu.setOption(3, new ItemStack(Material.PAPER), main.colors.getTitle() + ">", main.colors.getInfo() + ">");
        menu.setOption(5, new ItemStack(Material.PAPER), main.colors.getTitle() + "<", main.colors.getInfo() + "<");
        menu.setOption(6, new ItemStack(Material.PAPER), main.colors.getTitle() + "<", main.colors.getInfo() + "<");
        menu.setOption(7, new ItemStack(Material.PAPER), main.colors.getTitle() + "<", main.colors.getInfo() + "<");
        return menu;
    }

    InputMenu getSellUpgradesInputMenu() {
        String title = main.colors.getTitle() + Lang.get("title.trade.sellUpgrades");
        if (title.length() > 32) {
            title = main.colors.getError() + "Sell upgrades";
        }
        InputMenu menu = new InputMenu(title, 9, new InputMenu.OptionClickEventHandler(){

            @Override
            public void onOptionClick(InputMenu.OptionClickEvent event) {
                if (event.getPosition() == 0 || event.getPosition() == 8) {
                    event.setWillClose(true);
                }
                InputMenuClickEvent evt = new InputMenuClickEvent(event, TradeBoothMenuType.SELL_UPGRADES);
                UTradeListener.this.plugin.getServer().getPluginManager().callEvent((Event)evt);
            }

            @Override
            public void onClose(Player player, Inventory inv) {
            }
        }, (Plugin)this.plugin, true);
        menu.setOption(0, new ItemStack(Material.BOOK), main.colors.getTitle() + "Back to menu", main.colors.getInfo() + "Return back to the selection menu");
        menu.setOption(8, new ItemStack(Material.EMERALD), main.colors.getTitle() + "Sell", main.colors.getError() + "Unavailable");
        menu.setOption(1, new ItemStack(Material.PAPER), main.colors.getTitle() + ">", main.colors.getInfo() + ">");
        menu.setOption(2, new ItemStack(Material.PAPER), main.colors.getTitle() + ">", main.colors.getInfo() + ">");
        menu.setOption(3, new ItemStack(Material.PAPER), main.colors.getTitle() + ">", main.colors.getInfo() + ">");
        menu.setOption(5, new ItemStack(Material.PAPER), main.colors.getTitle() + "<", main.colors.getInfo() + "<");
        menu.setOption(6, new ItemStack(Material.PAPER), main.colors.getTitle() + "<", main.colors.getInfo() + "<");
        menu.setOption(7, new ItemStack(Material.PAPER), main.colors.getTitle() + "<", main.colors.getInfo() + "<");
        return menu;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void alerts(PlayerJoinEvent event) {
        String name = event.getPlayer().getName();
        if (!this.plugin.alerts.containsKey(name)) {
            return;
        }
        event.getPlayer().sendMessage(this.plugin.alerts.get(name));
        this.plugin.alerts.remove(name);
    }

    public Vehicle isEntityInCar(Entity e) {
        Entity v;
        if (e.getVehicle() == null) {
            return null;
        }
        for (v = e.getVehicle(); v != null && v.getVehicle() != null && !(v instanceof Vehicle); v = v.getVehicle()) {
        }
        if (v == null || !uCarsAPI.getAPI().runCarChecks(v).booleanValue() || !(v instanceof Vehicle)) {
            return null;
        }
        return (Vehicle)v;
    }
}

