/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles.spawning.nodes;

import java.io.Serializable;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;

public class ChunkCoord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID worldUUID;
    private int x;
    private int z;

    public ChunkCoord(Chunk chunk) {
        this(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public ChunkCoord(World world, int x, int z) {
        this(world.getUID(), x, z);
    }

    public ChunkCoord(UUID worldUUID, int x, int z) {
        this.worldUUID = worldUUID;
        this.x = x;
        this.z = z;
    }

    public boolean isValid() {
        return this.getWorld() != null && this.getChunk() != null;
    }

    public Chunk getChunk() {
        World w = this.getWorld();
        if (w == null) {
            return null;
        }
        return w.getChunkAt(this.getX(), this.getZ());
    }

    public World getWorld() {
        return Bukkit.getWorld((UUID)this.worldUUID);
    }

    public void setWorld(World world) {
        this.worldUUID = world.getUID();
    }

    public UUID getWorldUUID() {
        return this.worldUUID;
    }

    public void setWorldUUID(UUID worldUUID) {
        this.worldUUID = worldUUID;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public boolean isEqualTo(ChunkCoord coord) {
        return this.worldUUID.equals(coord.worldUUID) && this.x == coord.x && this.z == coord.z;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = hashCode * 397 ^ this.worldUUID.hashCode();
        hashCode = hashCode * 397 ^ this.x;
        hashCode = hashCode * 397 ^ this.z;
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkCoord)) {
            return false;
        }
        return this.isEqualTo((ChunkCoord)obj);
    }
}

