/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.md_5.bungee.api.ChatColor;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.AITrackFollow;
import net.stormdev.ucars.trade.AIVehicles.DynamicLagReducer;
import net.stormdev.ucars.trade.AIVehicles.routing.BlockRouteData;
import net.stormdev.ucars.trade.AIVehicles.routing.RouteBlockType;
import net.stormdev.ucars.trade.AIVehicles.routing.RouteDecoder;
import net.stormdev.ucars.trade.AIVehicles.routing.RouteMethod;
import net.stormdev.ucars.trade.main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class NetworkConversionScan {
    private static int SCAN_BRANCH_LIMIT = 1500;
    private Logger logger = null;
    private Location origin = null;
    private Stage stage = Stage.SCAN_ROAD_NETWORK_BLOCKS;
    private volatile List<Vector> allBlocks = new ArrayList<Vector>();
    private volatile List<BlockRouteData> roadNetwork = new ArrayList<BlockRouteData>();
    private volatile long REST_TIME = 50L;
    private volatile BukkitTask restTimeChecker = null;
    private volatile boolean finishedScan = false;
    private volatile List<Block> queuedBranches = new ArrayList<Block>();
    private volatile long lastStartTime = 0L;
    private volatile int scansRunning = 1;
    private volatile int roughSize = 0;

    public NetworkConversionScan(Player player) {
        if (Bukkit.isPrimaryThread()) {
            throw new RuntimeException("Don't use in main thread");
        }
        this.logger = new Logger(player);
        this.logger.log("Detecting road network...");
        final Location playerLoc = player.getLocation();
        Location startTrackerBlock = null;
        Future trackerBlockFind = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<Location>(){

            @Override
            public Location call() throws Exception {
                for (int i = 0; i < 5; ++i) {
                    Block under = playerLoc.getBlock().getRelative(BlockFace.DOWN, i);
                    if (!AIRouter.isTrackBlock(under.getType())) continue;
                    return under.getLocation();
                }
                return null;
            }
        });
        try {
            startTrackerBlock = (Location)trackerBlockFind.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (startTrackerBlock == null) {
            this.logger.log("Unable to detect road network! Scan cancelled! Please make sure you're standing on it!");
            return;
        }
        this.origin = startTrackerBlock;
        this.logger.log("Successfully found road network's entry point!");
        this.restTimeChecker = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                double tps = DynamicLagReducer.getTPS();
                if (tps > 18.0) {
                    if (NetworkConversionScan.this.REST_TIME > 10L) {
                        NetworkConversionScan.this.REST_TIME -= 10L;
                    }
                    if (NetworkConversionScan.this.REST_TIME < 0L) {
                        NetworkConversionScan.this.REST_TIME = 0L;
                    }
                } else if (tps > 14.0) {
                    if (NetworkConversionScan.this.REST_TIME > 10L) {
                        NetworkConversionScan.this.REST_TIME -= 5L;
                    }
                    if (NetworkConversionScan.this.REST_TIME < 2L) {
                        NetworkConversionScan.this.REST_TIME = 2L;
                    }
                } else {
                    NetworkConversionScan.this.REST_TIME += 20L;
                    if (NetworkConversionScan.this.REST_TIME > 200L) {
                        NetworkConversionScan.this.REST_TIME = 200L;
                    }
                }
            }
        }, 20L, 20L);
        this.startStage();
    }

    private void nextStage() {
        this.stage = this.stage.getNext();
        if (this.stage == null) {
            this.finish();
        } else {
            this.startStage();
        }
    }

    private void replaceRoadNetwork() {
        if (this.roadNetwork == null) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                int size = NetworkConversionScan.this.allBlocks.size();
                for (int i = 0; i < size; ++i) {
                    Vector vec = (Vector)NetworkConversionScan.this.allBlocks.get(i);
                    Block bl = NetworkConversionScan.this.getBlock(vec);
                    BlockRouteData brd = (BlockRouteData)NetworkConversionScan.this.roadNetwork.get(i);
                    int data = RouteDecoder.getDataFromDir(brd.getType(), brd.getDirection());
                    bl.setType(Material.STAINED_GLASS);
                    bl.setData((byte)data);
                    NetworkConversionScan.this.logger.log("Replacing control blocks " + (i + 1) + "/" + size + "!");
                }
                NetworkConversionScan.this.logger.log("Block replacing complete!");
                NetworkConversionScan.this.nextStage();
            }
        });
    }

    public void finish() {
        main.plugin.aiRouteMethod = RouteMethod.ENCODED;
        main.config.set("general.ai.routing", (Object)RouteMethod.ENCODED.name());
        main.plugin.saveConfig();
        this.origin.getWorld().save();
        this.origin = null;
        this.roadNetwork.clear();
        this.roadNetwork = null;
        this.restTimeChecker.cancel();
        this.logger.log("Network scanning terminated!");
        this.logger = null;
    }

    private void startStage() {
        switch (this.stage) {
            case REPLACE_ROAD_NETWORK_BLOCKS: {
                this.replaceRoadNetwork();
                break;
            }
            case SCAN_ROAD_NETWORK_BLOCKS: {
                this.scanRoadNetwork();
                this.nextStage();
                break;
            }
        }
    }

    private void sleep() {
        Thread.yield();
        if (this.REST_TIME > 0L) {
            try {
                Thread.sleep(this.REST_TIME);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void scanRoadNetwork() {
        if (this.roadNetwork == null) {
            this.roadNetwork = new ArrayList<BlockRouteData>();
        }
        this.roadNetwork.clear();
        this.logger.log("Starting indexing of the road network... (This could take a long time)");
        this.blockScan(this.origin.getBlock());
        this.roadScanOutput();
        this.logger.log("Road network indexed!");
        this.finishedScan = true;
    }

    private void roadScanOutput() {
        while (this.countScanBranches() > 0 && System.currentTimeMillis() - this.lastStartTime < 120000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.logger.log("Currently active scan branches: " + this.scansRunning + " Queued extra branches: " + this.queuedBranches.size() + " Current network size: " + this.roughSize);
        }
        int count = 0;
        while ((this.countScanBranches() <= 0 || System.currentTimeMillis() - this.lastStartTime > 120000L) && count < 5) {
            ++count;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (count < 5) {
            this.roadScanOutput();
            return;
        }
    }

    private Block getBlock(final Vector v) {
        if (Bukkit.isPrimaryThread()) {
            return new Location(this.origin.getWorld(), v.getX(), v.getY(), v.getZ()).getBlock();
        }
        try {
            return (Block)Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<Block>(){

                @Override
                public Block call() throws Exception {
                    return new Location(NetworkConversionScan.this.origin.getWorld(), v.getX(), v.getY(), v.getZ()).getBlock();
                }
            }).get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private int countScanBranches() {
        if (this.queuedBranches.size() > 0 && this.scansRunning < SCAN_BRANCH_LIMIT) {
            int toStart = SCAN_BRANCH_LIMIT - this.scansRunning;
            if (toStart > this.queuedBranches.size()) {
                toStart = this.queuedBranches.size();
            }
            for (int i = 0; i < toStart && this.scansRunning < SCAN_BRANCH_LIMIT; ++i) {
                final Block b = this.queuedBranches.get(0);
                this.queuedBranches.remove(0);
                this.incrementScansRunning();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        NetworkConversionScan.this.blockScan(b);
                    }
                });
                Thread.yield();
                try {
                    Thread.sleep(this.REST_TIME);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        int sr = this.scansRunning;
        if (this.queuedBranches.size() > 0 && sr < 1) {
            return 1;
        }
        return sr;
    }

    private String getKey(Vector v) {
        return v.getX() + "" + v.getY() + "" + v.getZ();
    }

    private synchronized void incrementScansRunning() {
        ++this.scansRunning;
    }

    private synchronized void decrementScansRunning() {
        --this.scansRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockScan(final Block block) {
        if (this.finishedScan) {
            this.decrementScansRunning();
            return;
        }
        this.lastStartTime = System.currentTimeMillis();
        if (block == null) {
            this.decrementScansRunning();
            return;
        }
        Vector vec = block.getLocation().toVector().clone();
        String key = this.getKey(vec);
        if (this.allBlocks.contains(vec)) {
            this.decrementScansRunning();
            return;
        }
        if (this.scansRunning > SCAN_BRANCH_LIMIT) {
            this.queuedBranches.add(block);
            this.decrementScansRunning();
            return;
        }
        try {
            BlockRouteData brd;
            this.sleep();
            try {
                brd = (BlockRouteData)Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<BlockRouteData>(){

                    @Override
                    public BlockRouteData call() throws Exception {
                        return AITrackFollow.carriagewayDirection(block);
                    }
                }).get();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                brd = new BlockRouteData(RouteBlockType.CONTINUE, null);
            }
            if (brd.getType() == null) {
                brd.setType(RouteBlockType.CONTINUE);
                brd.setDirection(null);
            }
            ++this.roughSize;
            NetworkConversionScan e1 = this;
            synchronized (e1) {
                this.roadNetwork.add(brd);
                this.allBlocks.add(vec);
            }
            Future moreStarted = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean startedMore = false;
                    for (int modY = -1; modY <= 1; ++modY) {
                        for (int modX = -1; modX <= 1; ++modX) {
                            for (int modZ = -1; modZ <= 1; ++modZ) {
                                try {
                                    final Block newBlock = new Location(block.getWorld(), (double)(block.getX() + modX), (double)(block.getY() + modY), (double)(block.getZ() + modZ)).getBlock();
                                    if (!AIRouter.isTrackBlock(newBlock.getType())) continue;
                                    final boolean originalScan = !startedMore;
                                    startedMore = true;
                                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)main.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!originalScan) {
                                                NetworkConversionScan.this.incrementScansRunning();
                                            }
                                            NetworkConversionScan.this.blockScan(newBlock);
                                        }
                                    }, 1L);
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    return startedMore;
                }
            });
            if (!((Boolean)moreStarted.get()).booleanValue()) {
                this.decrementScansRunning();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Stage {
        SCAN_ROAD_NETWORK_BLOCKS(1),
        REPLACE_ROAD_NETWORK_BLOCKS(2);

        private int pos;

        private Stage(int pos) {
            this.pos = pos;
        }

        public Stage getNext() {
            int nextPos = this.pos + 1;
            return Stage.getStage(nextPos);
        }

        private static Stage getStage(int pos) {
            for (Stage s : Stage.values()) {
                if (s.pos != pos) continue;
                return s;
            }
            return null;
        }
    }

    public static class Logger {
        private UUID startPlayerUUID;

        public Logger(Player starter) {
            this.startPlayerUUID = starter.getUniqueId();
        }

        public void log(String message) {
            main.plugin.getLogger().info(message);
            Player player = Bukkit.getPlayer((UUID)this.startPlayerUUID);
            if (player != null) {
                player.sendMessage(ChatColor.RED + "[RoadNetworkScan]:" + ChatColor.RESET + message);
            }
        }
    }
}

