/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucarstrade.cars;

import com.useful.ucars.ucars;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.ItemRename;
import net.stormdev.ucarstrade.cars.CarPresets;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class DrivenCar
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID id;
    private String name = "Car";
    private double speed;
    private double health;
    private boolean isHandlingDamaged;
    private List<String> modifiers = new ArrayList<String>();
    private boolean isNPC = false;
    private double accelMod = 1.0;
    private double turnAmountPerTick = 5.0;
    private int maxPassengers = -1;
    private double[] boatsOrientationOffsetDeg = new double[0];
    private float hitboxX = -1.0f;
    private float hitboxZ = -1.0f;
    private transient CarPresets.CarPreset preset;

    public DrivenCar(CarPresets.CarPreset cp) {
        this(cp.getName(), cp.getSpeed(), cp.getHealth(), cp.getAcceleration(), cp.getTurnAmountPerTick(), false, cp.getModifications());
    }

    public DrivenCar(String name, double speed, double health, double acceleration, double turnAmountPerTick, boolean isHandlingDamaged, List<String> modifiers) {
        this.setName(name);
        this.setSpeed(speed);
        this.setHealth(health);
        this.setHandlingDamaged(isHandlingDamaged);
        this.setModifiers(modifiers);
        this.setAccelMod(acceleration);
        this.setTurnAmountPerTick(turnAmountPerTick);
    }

    public int getMaxPassengers() {
        if (this.maxPassengers < 0 && this.getPreset() != null) {
            return this.getPreset().getMaxPassengers();
        }
        return this.maxPassengers < 0 ? 1 : this.maxPassengers;
    }

    public void setMaxPassengers(int maxPassengers) {
        this.maxPassengers = maxPassengers;
    }

    public double[] getBoatOrientationOffsetDeg() {
        if (this.maxPassengers < 0 && this.getPreset() != null) {
            return this.getPreset().getBoatOrientationOffsetDeg();
        }
        return this.boatsOrientationOffsetDeg;
    }

    public void setBoatOrientationOffsetDeg(double[] boatOrientationOffsetDeg) {
        this.boatsOrientationOffsetDeg = boatOrientationOffsetDeg;
    }

    public MaterialData getBaseDisplayBlock() {
        if (!this.name.toLowerCase().contains("cop")) {
            return null;
        }
        return new ItemStack(Material.EMERALD_ORE).getData();
    }

    public DrivenCar(DrivenCar other) {
        this(other.getName(), other.getSpeed(), other.getHealth(), other.getAccelMod(), other.getTurnAmountPerTick(), other.isHandlingDamaged(), other.getModifiers());
        this.id = other.getId();
    }

    private static String getHandleString(boolean isDamaged) {
        if (isDamaged) {
            return "damaged";
        }
        return "undamaged";
    }

    public ItemStack toItemStack() {
        ItemStack stack;
        MaterialData md;
        MaterialData materialData = md = this.hasPreset() ? this.getPreset().getDisplayBlock() : null;
        if (main.config.getBoolean("general.car.displayInInvAsDisplayBlockWhenExist") && md != null) {
            stack = new ItemStack(md.getItemType());
            stack.setData(md);
        } else {
            stack = new ItemStack(Material.MINECART);
        }
        ArrayList<String> lore = new ArrayList<String>();
        ItemMeta meta = stack.getItemMeta();
        lore.add(ChatColor.GRAY + "car");
        lore.add(main.colors.getTitle() + "[Speed:] " + main.colors.getInfo() + this.speed + "x");
        double max = ucars.config.getDouble("general.cars.health.max");
        lore.add(main.colors.getTitle() + "[Health:] " + main.colors.getInfo() + this.health + "/" + max);
        lore.add(main.colors.getTitle() + "[Handling:] " + main.colors.getInfo() + 10.0 * this.getTurnAmountPerTick());
        lore.add(main.colors.getTitle() + "[Acceleration:] " + main.colors.getInfo() + this.getAccelMod() * 10.0);
        lore.add(main.colors.getTitle() + "[Damage:] " + main.colors.getInfo() + DrivenCar.getHandleString(this.isHandlingDamaged));
        for (String x : this.modifiers) {
            lore.add(main.colors.getTitle() + "-Modifier: " + main.colors.getInfo() + x);
        }
        meta.setLore(lore);
        stack.setItemMeta(meta);
        stack = ItemRename.rename(stack, this.name);
        return stack;
    }

    public boolean hasPreset() {
        return this.getPreset() != null;
    }

    public CarPresets.CarPreset getPreset() {
        if (!CarPresets.isCarPresetsUsed()) {
            return null;
        }
        if (this.preset != null) {
            return this.preset;
        }
        List<CarPresets.CarPreset> cp = CarPresets.getPresets();
        for (CarPresets.CarPreset c : new ArrayList<CarPresets.CarPreset>(cp)) {
            if (!ChatColor.translateAlternateColorCodes((char)'&', (String)c.getName()).equals(this.name)) continue;
            this.preset = c;
            return c;
        }
        return null;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getHealth() {
        return this.health;
    }

    public void setHealth(double health) {
        this.health = health;
    }

    public boolean isHandlingDamaged() {
        return this.isHandlingDamaged;
    }

    public void setHandlingDamaged(boolean isHandlingDamaged) {
        this.isHandlingDamaged = isHandlingDamaged;
    }

    public List<String> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<String> modifiers) {
        this.modifiers = modifiers;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    public DrivenCar setNPC(boolean isNPC) {
        if (this.isNPC && !isNPC) {
            main.plugin.aiSpawns.decrementSpawnedAICount();
        }
        this.isNPC = isNPC;
        return this;
    }

    public double getTurnAmountPerTick() {
        if (this.turnAmountPerTick <= 0.0) {
            this.turnAmountPerTick = 5.0;
        }
        return this.turnAmountPerTick;
    }

    public void setTurnAmountPerTick(double turnAmountPerTick) {
        this.turnAmountPerTick = turnAmountPerTick;
    }

    public double getAccelMod() {
        if (this.accelMod <= 0.0) {
            this.accelMod = 1.0;
        }
        return this.accelMod;
    }

    public void setAccelMod(double accelMod) {
        this.accelMod = accelMod;
    }

    public float getHitboxX() {
        if (this.hitboxX < 0.0f && this.getPreset() != null) {
            return this.getPreset().getHitboxX();
        }
        return this.hitboxX;
    }

    public void setHitboxX(float hitboxX) {
        this.hitboxX = hitboxX;
    }

    public float getHitboxZ() {
        if (this.hitboxZ < 0.0f && this.getPreset() != null) {
            return this.getPreset().getHitboxZ();
        }
        return this.hitboxZ;
    }

    public void setHitboxZ(float hitboxZ) {
        this.hitboxZ = hitboxZ;
    }
}

