/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.shops;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.stormdev.ucars.trade.Lang;
import net.stormdev.ucars.trade.guis.IconMenu;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.CarGenerator;
import net.stormdev.ucars.utils.CarValueCalculator;
import net.stormdev.ucarstrade.cars.CarPresets;
import net.stormdev.ucarstrade.cars.DrivenCar;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;

public class CarShop {
    private double value;
    private IconMenu menu = null;
    private main plugin;
    private Map<Integer, IconMenu> menus = new HashMap<Integer, IconMenu>();

    public CarShop(main plugin) {
        this.plugin = plugin;
        this.value = main.config.getDouble("general.carTrading.averageCarValue") * 1.25;
        int v = (int)this.value * 100;
        this.value = (double)v / 100.0;
        this.setupMenu(plugin);
    }

    public void destroy() {
        this.menu.destroy();
    }

    public IconMenu getShopWindow() {
        if (this.menu == null) {
            this.setupMenu(this.plugin);
        }
        return this.menu;
    }

    public void onClick(IconMenu.OptionClickEvent event) {
        event.setWillClose(false);
        event.setWillDestroy(false);
        int slot = event.getPosition();
        if (!CarPresets.isCarPresetsUsed()) {
            if (slot == 4) {
                event.setWillClose(true);
                this.buyCar(event.getPlayer(), CarGenerator.gen());
            }
        } else {
            int page;
            String title = ChatColor.stripColor((String)event.getInventory().getTitle());
            title = title.replaceFirst("Car Shop Page ", "");
            try {
                page = Integer.parseInt(title);
            }
            catch (NumberFormatException e) {
                return;
            }
            int pos = event.getPosition();
            if (pos == 52) {
                int prevPage = page - 1;
                if (!this.pageExists(prevPage)) {
                    event.getPlayer().sendMessage(ChatColor.RED + "That page doesn't exist!");
                    return;
                }
                final IconMenu nextPage = this.getPage(prevPage);
                final Player pl = event.getPlayer();
                event.setWillClose(true);
                Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        nextPage.open(pl);
                    }
                }, 2L);
                return;
            }
            if (pos == 53) {
                int nextPage = page + 1;
                if (!this.pageExists(nextPage)) {
                    event.getPlayer().sendMessage(ChatColor.RED + "That page doesn't exist!");
                    return;
                }
                final IconMenu ppage = this.getPage(nextPage);
                final Player pl = event.getPlayer();
                event.setWillClose(true);
                Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        ppage.open(pl);
                    }
                }, 2L);
                return;
            }
            int startPos = (page - 1) * 52;
            int arrayPos = startPos + pos;
            List<CarPresets.CarPreset> cars = CarPresets.getPresets();
            if (arrayPos >= cars.size()) {
                return;
            }
            CarPresets.CarPreset cp = cars.get(arrayPos);
            event.setWillClose(true);
            DrivenCar dc = new DrivenCar(cp.getName(), cp.getSpeed(), cp.getHealth(), cp.getAcceleration(), cp.getTurnAmountPerTick(), false, cp.getModifications());
            this.buyCar(event.getPlayer(), dc);
            return;
        }
    }

    public void open(Player player) {
        if (this.menu == null) {
            player.sendMessage(ChatColor.RED + "No cars for sale!");
            return;
        }
        this.getShopWindow().open(player);
    }

    public void buyCar(Player player, DrivenCar dc) {
        double cost;
        if (main.economy == null) {
            main.plugin.setupEconomy();
            if (main.economy == null) {
                player.sendMessage(main.colors.getError() + "No economy plugin found! Error!");
                return;
            }
        }
        double bal = main.economy.getBalance(player.getName());
        double d = cost = CarPresets.isCarPresetsUsed() ? CarValueCalculator.getCarValueForPurchase(dc) : this.value;
        if (cost < 1.0) {
            return;
        }
        double rem = bal - cost;
        if (rem < 0.0) {
            String msg = Lang.get("general.buy.notEnoughMoney");
            msg = msg.replaceAll(Pattern.quote("%balance%"), Matcher.quoteReplacement(bal + ""));
            player.sendMessage(main.colors.getError() + msg);
            return;
        }
        main.economy.withdrawPlayer(player.getName(), cost);
        String currency = main.config.getString("general.carTrading.currencySign");
        String msg = Lang.get("general.buy.success");
        msg = msg.replaceAll(Pattern.quote("%item%"), "a car");
        msg = msg.replaceAll(Pattern.quote("%price%"), Matcher.quoteReplacement(currency + cost));
        msg = msg.replaceAll(Pattern.quote("%balance%"), Matcher.quoteReplacement(currency + rem));
        player.sendMessage(main.colors.getSuccess() + msg);
        ItemStack i = dc.toItemStack();
        player.getInventory().addItem(new ItemStack[]{i});
    }

    private boolean pageExists(int page) {
        return this.menus.containsKey(page);
    }

    public IconMenu getPage(int page) {
        return this.menus.get(page);
    }

    public void setupMenu(main plugin) {
        String currency = main.config.getString("general.carTrading.currencySign");
        if (!CarPresets.isCarPresetsUsed()) {
            this.menu = new IconMenu("Car Shop", 9, new IconMenu.OptionClickEventHandler(){

                @Override
                public void onOptionClick(IconMenu.OptionClickEvent event) {
                    CarShop.this.onClick(event);
                }
            }, (Plugin)plugin);
            ArrayList<String> info = new ArrayList<String>();
            info.add(main.colors.getTitle() + "[Price:] " + main.colors.getInfo() + currency + this.value);
            this.menu.setOption(4, new ItemStack(Material.MINECART), main.colors.getTitle() + "Buy Random Car", info);
        } else {
            List<CarPresets.CarPreset> cars = CarPresets.getPresets();
            int pagesNeeded = (int)Math.ceil((double)cars.size() / 52.0);
            main.logger.info("Pages of cars: " + pagesNeeded + ", cars: " + cars.size());
            for (int i = 0; i < pagesNeeded; ++i) {
                int startPos = i * 52;
                IconMenu page = new IconMenu("Car Shop Page " + (i + 1), 54, new IconMenu.OptionClickEventHandler(){

                    @Override
                    public void onOptionClick(IconMenu.OptionClickEvent event) {
                        CarShop.this.onClick(event);
                    }
                }, (Plugin)plugin);
                for (int pos = 0; pos < 52; ++pos) {
                    if (startPos + pos >= cars.size()) continue;
                    int arrayPos = startPos + pos;
                    CarPresets.CarPreset cp = cars.get(arrayPos);
                    ArrayList<String> lore = new ArrayList<String>();
                    lore.add(ChatColor.YELLOW + "Speed: " + cp.getSpeed() + "x");
                    lore.add(ChatColor.YELLOW + "Health: " + cp.getHealth());
                    lore.add(ChatColor.YELLOW + "Acceleration: " + cp.getAcceleration() * 10.0);
                    lore.add(ChatColor.YELLOW + "Handling: " + cp.getTurnAmountPerTick() * 10.0);
                    if (cp.getModifications().size() > 0) {
                        lore.add(ChatColor.YELLOW + "Modifications:");
                        for (String n : cp.getModifications()) {
                            lore.add(ChatColor.YELLOW + " -" + n);
                        }
                    }
                    lore.add(ChatColor.WHITE + "Price: " + currency + CarValueCalculator.getCarValueForPurchase(new DrivenCar(cp.getName(), cp.getSpeed(), cp.getHealth(), cp.getAcceleration(), cp.getTurnAmountPerTick(), false, cp.getModifications())));
                    MaterialData md = cp.toItemStack().getData();
                    ItemStack is = new ItemStack(md.getItemType());
                    is.setData(md);
                    page.setOption(pos, is, ChatColor.BLUE + cp.getName(), lore);
                }
                page.setOption(52, new ItemStack(Material.PAPER), main.colors.getTitle() + "Previous Page", main.colors.getInfo() + "Go to previous page");
                page.setOption(53, new ItemStack(Material.PAPER), main.colors.getTitle() + "Next Page", main.colors.getInfo() + "Go to next page");
                if (i == 0) {
                    this.menu = page;
                }
                this.menus.put(i + 1, page);
            }
        }
    }
}

