/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucarstrade.displays;

import java.io.Serializable;
import java.util.List;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.CarFiller;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DisplayType
implements Serializable {
    private static final long serialVersionUID = 4323952036275549097L;
    private String name;
    private CarFiller filler;
    private Boolean restrictedJumping;
    private double carValueRatingBonus;
    private Material displayItem;
    private Material upgradeNeeded;
    private int amount;
    private List<String> lore;

    public static void putEntityInCar(Entity car, Entity entity) {
        car.setPassenger(entity);
    }

    public static void putEntityInCar(Entity car, EntityType type) {
        Chunk c = car.getLocation().getChunk();
        if (!c.isLoaded()) {
            c.load(true);
        }
        Entity e = car.getWorld().spawnEntity(car.getLocation(), type);
        DisplayType.putEntityInCar(car, e);
    }

    public static Entity spawnEntityAtCar(Entity car, EntityType type) {
        Chunk c = car.getLocation().getChunk();
        if (!c.isLoaded()) {
            c.load(true);
        }
        Entity e = car.getWorld().spawnEntity(car.getLocation(), type);
        return e;
    }

    protected DisplayType(String name, CarFiller filler, Boolean restrictedJumping, double carValueRatingBonus, Material displayItem, Material upgradeNeeded, int amount, List<String> lore) {
        this.name = name;
        this.filler = filler;
        this.restrictedJumping = restrictedJumping;
        this.carValueRatingBonus = carValueRatingBonus;
        this.displayItem = displayItem;
        this.amount = amount;
        this.upgradeNeeded = upgradeNeeded;
        this.lore = lore;
    }

    public ItemStack getDisplayItemForShop() {
        ItemStack i = new ItemStack(this.displayItem);
        ItemMeta im = i.getItemMeta();
        im.setDisplayName(main.colors.getTitle() + this.getName());
        im.setLore(this.lore);
        i.setItemMeta(im);
        return i;
    }

    public ItemStack getUpgradeItemStack() {
        ItemStack i = new ItemStack(this.upgradeNeeded);
        i.setAmount(this.amount);
        return i;
    }

    public Boolean isJumpingRestriced() {
        return this.restrictedJumping;
    }

    public double getCarValueRatingBonus() {
        return this.carValueRatingBonus;
    }

    public String getName() {
        return this.name;
    }

    public CarFiller getFiller() {
        return this.filler;
    }

    public void fill(Entity car, Player owner) {
        this.getFiller().putInCar(car, owner);
    }
}

