/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles;

import com.useful.uCarsAPI.uCarsAPI;
import com.useful.ucars.CartOrientationUtil;
import com.useful.ucars.ClosestFace;
import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.stormdev.ucars.trade.AIVehicles.AITrackFollow;
import net.stormdev.ucars.trade.AIVehicles.TrackingData;
import net.stormdev.ucars.trade.AIVehicles.VelocityData;
import net.stormdev.ucars.trade.AIVehicles.routing.BlockRouteData;
import net.stormdev.ucars.trade.AIVehicles.routing.RouteMethod;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.NoMobAI;
import net.stormdev.ucarstrade.cars.DrivenCar;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class AIRouter {
    public static int PLAYER_RADIUS = 70;
    public static double PLAYER_RADIUS_SQ = Math.pow(PLAYER_RADIUS, 2.0);
    private static boolean enabled;
    private static Map<String, Material> trackBlocks;
    private String trackPattern = "a,b,c";
    public static String[] pattern;
    private Material roadEdge;
    public static Material junction;
    private uCarsAPI api;

    public static boolean isEncodedRouting() {
        return main.plugin.aiRouteMethod.equals((Object)RouteMethod.ENCODED);
    }

    public static boolean isTrackBlock(Material mat) {
        if (AIRouter.isEncodedRouting()) {
            return mat.equals((Object)Material.STAINED_GLASS);
        }
        for (Material mate : trackBlocks.values()) {
            if (!mat.name().contains(mate.name())) continue;
            return true;
        }
        return mat.equals((Object)junction);
    }

    public static String getTrackBlockType(Material mat) {
        for (String name : trackBlocks.keySet()) {
            if (!mat.name().contains(trackBlocks.get(name).name())) continue;
            return name;
        }
        return null;
    }

    public static int getTrackBlockIndexByType(String type) {
        for (int i = 0; i < pattern.length; ++i) {
            if (!pattern[i].equals(type)) continue;
            return i;
        }
        return -1;
    }

    public AIRouter(boolean enabled) {
        AIRouter.enabled = enabled;
        String edgeRaw = main.config.getString("general.ai.roadEdgeBlock");
        String junRaw = main.config.getString("general.ai.junctionBlock");
        this.roadEdge = Material.getMaterial((String)edgeRaw);
        junction = Material.getMaterial((String)junRaw);
        ConfigurationSection sect = main.config.getConfigurationSection("general.ai.trackerBlock");
        for (String patternName : sect.getKeys(false)) {
            if (patternName == null || patternName.length() <= 0 || patternName.equals("pattern")) continue;
            trackBlocks.put(patternName, Material.getMaterial((String)sect.getString(patternName)));
            main.plugin.getLogger().info("Found AI tracker block: " + sect.getString(patternName));
        }
        this.trackPattern = main.config.getString("general.ai.trackerBlock.pattern");
        pattern = this.trackPattern.split(Pattern.quote(","));
        if (this.roadEdge == null || junction == null) {
            main.logger.info("Didn't enable AIs routing as configuration is invalid!");
            enabled = false;
        }
        this.api = uCarsAPI.getAPI();
    }

    public static boolean isAIEnabled() {
        return enabled && main.plugin.aiSpawns.isNPCCarsSpawningNow();
    }

    public VelocityData getVelocityData(Vehicle car) {
        VelocityData data = new VelocityData(null, null, car.getLocation());
        if (UEntityMeta.hasMetadata((Entity)car, (String)"trade.npc")) {
            List ms = UEntityMeta.getMetadata((Entity)car, (String)"trade.npc");
            try {
                data = (VelocityData)((MetadataValue)ms.get(0)).value();
            }
            catch (Exception e) {
                UEntityMeta.removeMetadata((Entity)car, (String)"trade.npc");
            }
        }
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void route(final Entity car, final DrivenCar c) throws Exception {
        int p;
        Block next;
        boolean keepVel;
        long stationaryRemoveTime;
        if (!enabled) {
            return;
        }
        double speed = 2.0;
        BlockFace direction = BlockFace.NORTH;
        Vector vel = car.getVelocity();
        final Location loc = car.getLocation();
        Block under = loc.clone().add(0.0, -2.0, 0.0).getBlock();
        double cx = loc.getX();
        double cy = loc.getY();
        double cz = loc.getZ();
        if (!c.isNPC()) {
            return;
        }
        VelocityData data = new VelocityData(null, null, car.getLocation());
        try {
            data = (VelocityData)((MetadataValue)UEntityMeta.getMetadata((Entity)car, (String)"trade.npc").get(0)).value();
            if (data.getDir() != null) {
                direction = data.getDir();
            }
        }
        catch (Exception e1) {
            UEntityMeta.removeMetadata((Entity)car, (String)"trade.npc");
            UEntityMeta.setMetadata((Entity)car, (String)"trade.npc", (MetadataValue)new StatValue((Object)data, (Plugin)main.plugin));
        }
        data.updateLocation(car.getLocation());
        boolean supposedToBeStopped = data.isStoppedForOtherCar() || car.hasMetadata("car.frozen") || UEntityMeta.hasMetadata((Entity)car, (String)"car.frozen") || this.api.atTrafficLight(car) != false;
        long l = stationaryRemoveTime = supposedToBeStopped ? 2000L : 200L;
        if ((long)data.getStationaryCount() > stationaryRemoveTime) {
            AIRouter.despawnNPCCar(car, c);
            return;
        }
        final VelocityData vd = data;
        final List es = car.getWorld().getEntities();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                if (main.random.nextInt(5) < 1) {
                    ArrayList pls = new ArrayList(Bukkit.getOnlinePlayers());
                    double radiusSq = Math.pow(PLAYER_RADIUS, 2.0);
                    if (car.getTicksLived() > 2400) {
                        radiusSq = 1225.0;
                    }
                    for (Player pl : pls) {
                        double d = pl.getLocation().clone().toVector().subtract(loc.clone().toVector()).lengthSquared();
                        if (!(d < radiusSq)) continue;
                        return;
                    }
                    AIRouter.despawnNPCCar(car, c);
                    return;
                }
                Vector carLoc = car.getLocation().toVector();
                boolean nearbyCars = false;
                for (Entity e : es) {
                    VelocityData otherCar;
                    Vector diff;
                    if (e.equals(car) || !UEntityMeta.hasMetadata((Entity)e, (String)"trade.npc") || !(Math.abs((diff = e.getLocation().toVector().clone().subtract(carLoc.clone())).lengthSquared()) < 12.0) || (otherCar = AIRouter.this.getVelocityData((Vehicle)e)).getDir() == null || vd.getDir() == null || !otherCar.getDir().equals((Object)vd.getDir())) continue;
                    BlockFace dir = otherCar.getDir();
                    double cx = dir.getModX();
                    double cz = dir.getModZ();
                    if (cx == 0.0 && Math.abs(diff.getX()) >= 1.0 || cz == 0.0 && Math.abs(diff.getZ()) >= 1.0 || cx > 0.0 && diff.getX() < 0.0 || cx < 0.0 && diff.getX() > 0.0 || cz > 0.0 && diff.getZ() < 0.0 || cz < 0.0 && diff.getZ() > 0.0 || cx > 0.0 && cz > 0.0 && (diff.getX() < 0.0 || diff.getZ() < 0.0) || cx < 0.0 && cz < 0.0 && (diff.getX() > 0.0 || diff.getZ() > 0.0)) continue;
                    nearbyCars = true;
                    break;
                }
                vd.setStoppedForOtherCar(nearbyCars);
            }
        });
        if (supposedToBeStopped) {
            vd.notStationary();
            UEntityMeta.setMetadata((Entity)car, (String)"currentlyStopped", (MetadataValue)new StatValue((Object)true, (Plugin)main.plugin));
            car.setVelocity(new Vector(0, 0, 0));
            return;
        }
        UEntityMeta.removeMetadata((Entity)car, (String)"currentlyStopped");
        BlockRouteData brm = AITrackFollow.carriagewayDirection(under);
        if (brm.getType() == null && (brm = AITrackFollow.carriagewayDirection(under = under.getRelative(BlockFace.DOWN))).getType() == null && (brm = AITrackFollow.carriagewayDirection(under = under.getRelative(BlockFace.UP, 2))).getType() == null) {
            this.findRoad(car, c, speed, under.getRelative(BlockFace.DOWN), loc, false, data);
            return;
        }
        boolean bl = keepVel = !brm.isJunction() && !vd.isInProgressOfTurningAtJunction() && !UEntityMeta.hasMetadata((Entity)car, (String)"relocatingRoad");
        if (!UEntityMeta.hasMetadata((Entity)car, (String)"trade.npc")) {
            if (brm.isJunction()) {
                this.findRoad(car, c, speed, car.getLocation().getBlock().getRelative(BlockFace.DOWN, 2), loc, brm.isJunction(), data);
                return;
            }
            BlockFace face = AITrackFollow.carriagewayDirection(under).getDirection();
            if (!direction.equals((Object)face)) {
                vd.resetUpdatesSinceTurn();
                direction = face;
                keepVel = false;
                data.setMotion(null);
            }
        } else if (keepVel && !data.hasMotion()) {
            keepVel = false;
        }
        if (brm.getDirection() == null && direction == null || brm.getType() == null) {
            this.findRoad(car, c, speed, car.getLocation().getBlock().getRelative(BlockFace.DOWN, 2), loc, brm.isJunction(), data);
            return;
        }
        if (!(brm.getDirection() == null || direction != null && direction.equals((Object)brm.getDirection()))) {
            vd.resetUpdatesSinceTurn();
            direction = brm.getDirection();
            keepVel = false;
            data.setDir(direction);
        }
        TrackingData nextTrack = AITrackFollow.nextBlock(under, vd, brm, car);
        if (direction != nextTrack.dir && !vd.isInProgressOfTurningAtJunction() && !brm.isJunction()) {
            direction = nextTrack.dir;
            keepVel = false;
            vd.resetUpdatesSinceTurn();
            data.setDir(direction);
            data.setMotion(null);
        }
        if (nextTrack.forJunction) {
            keepVel = false;
        }
        if (vd.isInProgressOfTurningAtJunction()) {
            keepVel = false;
            direction = nextTrack.dir;
            vd.resetUpdatesSinceTurn();
        }
        Block road = next = nextTrack.nextBlock;
        for (p = 0; !AIRouter.isTrackBlock(road.getType()) && p < 4; ++p, next = next.getRelative(BlockFace.DOWN), road = road.getRelative(BlockFace.DOWN)) {
        }
        if (!AIRouter.isTrackBlock(road.getType())) {
            road = road.getRelative(BlockFace.UP, 4);
            next = next.getRelative(BlockFace.UP, 4);
        }
        for (p = 0; !AIRouter.isTrackBlock(road.getType()) && p < 4; ++p, next = next.getRelative(BlockFace.DOWN), road = road.getRelative(BlockFace.DOWN)) {
        }
        while (AIRouter.isTrackBlock(road.getType())) {
            road = road.getRelative(BlockFace.UP);
        }
        vd.setTargetBlockLoc(road.getLocation().clone().add(0.0, -1.0, 0.0));
        Block toDrive = road.getRelative(BlockFace.UP);
        if (!toDrive.isEmpty()) {
            return;
        }
        String rName = road.getType().name().toLowerCase();
        String tName = toDrive.getType().name().toLowerCase();
        if (toDrive.getLocation().distanceSquared(loc) >= 3.25 || toDrive.getY() > loc.getBlockY() || tName.contains("step") || tName.contains("carpet")) {
            keepVel = false;
        }
        if (vd.getUpdatesSinceTurn() < 3) {
            keepVel = false;
        }
        if (keepVel) {
            vel = data.getMotion();
            car.setVelocity(vel);
            vd.incrementUpdatesSinceTurn();
        } else {
            double pz;
            double px;
            double tx = (double)toDrive.getX() + 0.5;
            double ty = (double)toDrive.getY() + 0.0;
            if (rName.contains("step") && !rName.contains("double") && road.getData() < 8) {
                ty -= 0.5;
            }
            if (rName.contains("carpet")) {
                ty -= 0.9;
            }
            double tz = (double)toDrive.getZ() + 0.5;
            double x = tx - cx;
            double y = ty - cy;
            double z = tz - cz;
            if (y < 0.2 && y > 0.0) {
                y = -0.3;
            }
            boolean ux = !((px = Math.abs(x)) > (pz = Math.abs(z)));
            double mult = speed * 0.15;
            if (y < 2.0) {
                if (ux) {
                    x = x / pz * mult;
                    z = z / pz * mult;
                } else {
                    x = x / px * mult;
                    z = z / px * mult;
                }
            }
            if (nextTrack.forJunction || brm.isJunction()) {
                x *= 0.5;
                z *= 0.5;
            }
            vel = new Vector(x, y, z);
            UEntityMeta.removeMetadata((Entity)car, (String)"relocatingRoad");
            data.setMotion(vel);
            car.setVelocity(vel);
        }
        Vector dirVec = vel.clone().setY(0).normalize();
        if (dirVec.lengthSquared() > 0.01) {
            float yaw;
            Location dirLoc = new Location(car.getWorld(), 0.0, 0.0, 0.0);
            dirLoc.setDirection(dirVec);
            for (yaw = dirLoc.getYaw() + 90.0f; yaw < 0.0f; yaw = 360.0f + yaw) {
            }
            while (yaw >= 360.0f) {
                yaw -= 360.0f;
            }
            CartOrientationUtil.setYaw((Entity)car, (float)yaw);
            Entity pass = car.getPassenger();
            if (pass != null && pass instanceof LivingEntity && UEntityMeta.hasMetadata((Entity)pass, (String)"trade.npcvillager")) {
                NoMobAI.clearAI(pass);
                main.plugin.aiSpawns.getCarPassengerProvider().setPassengerYaw((LivingEntity)pass, yaw - 90.0f);
                NoMobAI.clearAI(pass);
            }
        }
        data.setDir(direction);
    }

    public void findRoad(Entity car, DrivenCar c, double speed, Block under, Location currentLoc, boolean atJunction, VelocityData vd) {
        double pz;
        double px;
        vd.resetUpdatesSinceTurn();
        if (vd.getTargetBlockLoc() == null) {
            AIRouter.despawnNPCCar(car, c);
            return;
        }
        Location road = vd.getTargetBlockLoc().clone();
        Block rb = road.getBlock();
        Material rbt = rb.getType();
        String rName = rbt.name().toLowerCase();
        if (!AIRouter.isTrackBlock(rbt)) {
            AIRouter.despawnNPCCar(car, c);
            return;
        }
        Location toDriveLoc = road.add(0.0, 2.0, 0.0);
        Block toDrive = toDriveLoc.getBlock();
        if (!toDrive.isEmpty()) {
            toDrive = (toDriveLoc = toDriveLoc.add(0.0, 1.0, 0.0)).getBlock();
            if (!toDrive.isEmpty()) {
                AIRouter.despawnNPCCar(car, c);
            }
            return;
        }
        Location carLoc = car.getLocation();
        double cx = carLoc.getX();
        double cy = carLoc.getY();
        double cz = carLoc.getZ();
        double tx = (double)toDrive.getX() + 0.5;
        double ty = (double)toDrive.getY() + 0.0;
        if (rName.contains("step") && !rName.contains("double") && rb.getData() < 8) {
            ty -= 0.5;
        }
        if (rName.contains("carpet")) {
            ty -= 0.9;
        }
        double tz = (double)toDrive.getZ() + 0.5;
        double x = tx - cx;
        double y = ty - cy;
        double z = tz - cz;
        if (y < 0.2 && y > 0.0) {
            y = -0.3;
        }
        boolean ux = !((px = Math.abs(x)) > (pz = Math.abs(z)));
        double mult = speed * 0.15;
        if (y < 2.0) {
            if (ux) {
                x = x / pz * mult;
                z = z / pz * mult;
            } else {
                x = x / px * mult;
                z = z / px * mult;
            }
        }
        Vector vel = new Vector(x, y, z);
        vd.setMotion(vel);
        car.setVelocity(vel);
    }

    public void relocateRoad(Entity car, Block under, Location currentLoc, boolean atJunction, VelocityData vd) {
        vd.resetUpdatesSinceTurn();
        Location prev = null;
        if (UEntityMeta.hasMetadata((Entity)car, (String)"relocatingRoad")) {
            Object o = ((MetadataValue)UEntityMeta.getMetadata((Entity)car, (String)"relocatingRoad").get(0)).value();
            if (o != null && o instanceof Location) {
                prev = (Location)o;
                UEntityMeta.removeMetadata((Entity)car, (String)"relocatingRoad");
            } else {
                UEntityMeta.removeMetadata((Entity)car, (String)"relocatingRoad");
                return;
            }
        }
        Vector vel = vd.getMotion();
        double cx = currentLoc.getX();
        double cy = currentLoc.getY();
        double cz = currentLoc.getZ();
        Block toGo = null;
        BlockFace dir = null;
        BlockFace goDir = null;
        if (prev == null) {
            BlockFace bd;
            Block b;
            BlockFace currentDir = vd.getDir();
            for (BlockFace d : AITrackFollow.compassDirs()) {
                b = under.getRelative(d);
                if (!AIRouter.isTrackBlock(b.getType()) && b.getType() != junction) continue;
                if (toGo != null) {
                    bd = AITrackFollow.carriagewayDirection(b).getDirection();
                    if (bd != null && bd.equals((Object)currentDir) && (goDir == null || !goDir.equals((Object)currentDir))) {
                        toGo = b;
                        dir = d;
                        goDir = d;
                        continue;
                    }
                    if (currentDir == null || !d.equals((Object)currentDir) || dir != null && dir.equals((Object)currentDir)) continue;
                    toGo = b;
                    dir = d;
                    continue;
                }
                toGo = b;
                dir = d;
            }
            for (BlockFace d : AITrackFollow.diagonalDirs()) {
                b = under.getRelative(d);
                if (!AIRouter.isTrackBlock(b.getType()) && b.getType() != junction) continue;
                if (toGo != null) {
                    bd = AITrackFollow.carriagewayDirection(b).getDirection();
                    if (bd != null && bd.equals((Object)currentDir) && (goDir == null || !goDir.equals((Object)currentDir))) {
                        toGo = b;
                        dir = d;
                        goDir = d;
                        continue;
                    }
                    if (currentDir == null || !d.equals((Object)currentDir) || dir != null && dir.equals((Object)currentDir)) continue;
                    toGo = b;
                    dir = d;
                    continue;
                }
                toGo = b;
                dir = d;
            }
        } else {
            toGo = prev.getBlock();
        }
        if (toGo == null) {
            vd.setMotion(vel.multiply(-1));
            car.setVelocity(vel.multiply(-1));
            return;
        }
        UEntityMeta.setMetadata((Entity)car, (String)"relocatingRoad", (MetadataValue)new StatValue((Object)toGo.getLocation(), (Plugin)main.plugin));
        if (dir != null && toGo != null) {
            vd.setDir(dir);
        }
        if (!(toGo = toGo.getRelative(BlockFace.UP, 2)).isEmpty() && !(toGo = toGo.getRelative(BlockFace.UP)).isEmpty()) {
            return;
        }
        double tx = (double)toGo.getX() + 0.5;
        double ty = toGo.getY();
        double tz = (double)toGo.getZ() + 0.5;
        double x = tx - cx;
        double y = ty - cy;
        double z = tz - cz;
        if (y < 0.2 && y > 0.0) {
            y = -0.3;
        }
        vel = new Vector(x, y, z);
        car.setVelocity(vel);
        BlockFace direction = ClosestFace.getClosestFace((float)car.getLocation().getYaw());
        if (!atJunction) {
            if (goDir == null) {
                direction = AITrackFollow.carriagewayDirection(under).getDirection();
            }
            if (direction == null) {
                direction = dir;
            }
        }
        vd.setDir(direction);
        vd.setMotion(null);
    }

    public static void clearNPCMeta(Entity car) {
        car.removeMetadata("trade.npc", (Plugin)main.plugin);
        car.removeMetadata("relocatingRoad", (Plugin)main.plugin);
        car.removeMetadata("npc.turning", (Plugin)main.plugin);
        UEntityMeta.removeMetadata((Entity)car, (String)"trade.npc");
        UEntityMeta.removeMetadata((Entity)car, (String)"relocatingRoad");
        UEntityMeta.removeMetadata((Entity)car, (String)"npc.turning");
    }

    public static void despawnNPCCar(final Entity car, final DrivenCar c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Entity pass = car.getPassenger();
                if (pass != null) {
                    pass.remove();
                }
                AIRouter.clearNPCMeta(car);
                car.remove();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        main.plugin.aiSpawns.decrementSpawnedAICount();
                        main.plugin.carSaver.carNoLongerInUse(c.getId());
                    }
                });
            }
        };
        if (Bukkit.isPrimaryThread()) {
            run.run();
        } else {
            Bukkit.getScheduler().runTask((Plugin)main.plugin, run);
        }
    }

    public static void despawnNPCCarNow(Entity car, DrivenCar c) {
        Entity pass = car.getPassenger();
        AIRouter.clearNPCMeta(car);
        car.remove();
        if (pass != null) {
            pass.remove();
        }
        main.plugin.carSaver.carNoLongerInUseNow(c.getId());
        main.plugin.aiSpawns.decrementSpawnedAICount();
    }

    public boolean isCompassDir(BlockFace face) {
        switch (face) {
            case NORTH: {
                return true;
            }
            case EAST: {
                return true;
            }
            case SOUTH: {
                return true;
            }
            case WEST: {
                return true;
            }
        }
        return false;
    }

    static {
        trackBlocks = new HashMap<String, Material>();
        pattern = new String[0];
    }

    public static class PositionTracking {
        private Location current;
        private int stationaryCount = 0;

        public PositionTracking(Location current) {
            this.current = current;
        }

        public void updateLocation(Location loc) {
            if (loc.distanceSquared(this.current) < 2.0) {
                ++this.stationaryCount;
            } else {
                this.stationaryCount = 0;
                this.current = loc;
            }
        }

        public int getStationaryCount() {
            return this.stationaryCount;
        }
    }
}

