/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade;

import com.useful.uCarsAPI.CarCheck;
import com.useful.uCarsAPI.CarSpeedModifier;
import com.useful.uCarsAPI.uCarsAPI;
import com.useful.ucars.util.UEntityMeta;
import java.util.UUID;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucarstrade.cars.DrivenCar;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CarCalculations {
    private uCarsAPI api = null;

    public CarCalculations() {
        this.setup();
    }

    public void setup() {
        this.api = uCarsAPI.getAPI();
        if (!this.api.isPluginHooked((Plugin)main.plugin).booleanValue()) {
            this.api.hookPlugin((Plugin)main.plugin);
        }
        CarCheck isACar = new CarCheck(){

            public Boolean isACar(Entity car) {
                return CarCalculations.this.isAuCar(car);
            }
        };
        this.api.registerCarCheck((Plugin)main.plugin, isACar);
        CarSpeedModifier mod = new CarSpeedModifier(){

            public Vector getModifiedSpeed(Entity car, Vector travelVector, double currentMult) {
                Vector v = CarCalculations.this.getVelocity(car, travelVector, currentMult);
                return v;
            }
        };
        this.api.registerSpeedMod((Plugin)main.plugin, mod);
    }

    public Vector getVelocity(Entity cart, Vector current, double currentMult) {
        UUID id = cart.getUniqueId();
        DrivenCar car = main.plugin.carSaver.getCarInUse(cart);
        if (car == null) {
            return current;
        }
        current = current.multiply(car.getSpeed());
        if (car.isHandlingDamaged()) {
            double x = current.getX();
            double z = current.getZ();
            double degrees = main.random.nextInt(180) - 90;
            double[] output = CarCalculations.rotateVector2d(x, z, Math.toRadians(degrees));
            current.setX(output[0]);
            current.setZ(output[1]);
            current.multiply((double)main.random.nextInt(100) / 100.0);
        }
        return current;
    }

    public Boolean isAuCar(Entity car) {
        if (main.plugin.carSaver.isAUCar(car)) {
            return true;
        }
        if (car.hasMetadata("kart.racing") || UEntityMeta.hasMetadata((Entity)car, (String)"kart.racing")) {
            return true;
        }
        return false;
    }

    public static double[] rotateVector2d(double x, double y, double radians) {
        double[] result = new double[]{x * Math.cos(radians) - y * Math.sin(radians), x * Math.sin(radians) + y * Math.cos(radians)};
        return result;
    }
}

