/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.utils;

import com.useful.ucars.ucars;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucarstrade.cars.DrivenCar;

public class CarValueCalculator {
    public static double getCarValueForSale(DrivenCar car) {
        double average = main.config.getDouble("general.carTrading.averageCarValue");
        double rating = 20.0;
        boolean handlingDamaged = car.isHandlingDamaged();
        double speed = car.getSpeed();
        String name = car.getName();
        double defaultHealth = ucars.config.getDouble("general.cars.health.default");
        double maxHealth = ucars.config.getDouble("general.cars.health.max");
        double health = car.getHealth();
        double bonus = 0.0;
        rating += bonus;
        if (handlingDamaged) {
            rating -= 50.0;
        }
        rating = speed < 1.0 ? (rating -= 10.0 * speed) : (speed == 1.0 ? (rating += 1.0) : (speed > 3.0 ? (rating -= 3.0 - 5.0 * speed) : (rating += 20.0 * speed)));
        if (name.length() > 16) {
            rating -= 2.0;
        }
        if (health < defaultHealth) {
            rating -= defaultHealth - health;
        } else if (health == defaultHealth) {
            rating += 5.0;
        } else {
            double h = health / maxHealth * 100.0 - defaultHealth + 5.0;
            rating += h;
        }
        double handling = car.getTurnAmountPerTick();
        double accel = car.getAccelMod();
        rating *= accel;
        rating *= handling / 5.0;
        int percentExtra = 0;
        Boolean worse = (rating -= 50.0) < 0.0;
        if (rating < 0.0) {
            percentExtra += 10;
            if (rating < -5.0) {
                percentExtra += 5;
            }
            if (rating < -20.0) {
                percentExtra += 10;
            }
            if (rating < -25.0) {
                percentExtra = 50;
            }
        } else {
            percentExtra = rating < 5.0 ? 0 : ((int)rating - 3) / 2;
        }
        double cost = average;
        cost = worse.booleanValue() ? (cost -= (double)percentExtra * average / 100.0) : (cost += (double)percentExtra * average / 100.0);
        if (cost < 0.1) {
            cost = 0.1;
        }
        return Math.round(cost * 100.0) / 100L;
    }

    public static double getCarValueForPurchase(DrivenCar car) {
        double n = CarValueCalculator.getCarValueForSale(car);
        double cost = n + main.config.getDouble("general.carTrading.VATPercent") * n / 100.0;
        return Math.round(cost * 100.0) / 100L;
    }
}

