/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucarstrade;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.stormdev.ucars.trade.Colors;
import net.stormdev.ucarstrade.cars.DrivenCar;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemCarValidation {
    public static DrivenCar getCar(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemMeta im = item.getItemMeta();
        if (im == null || im.getLore() == null) {
            return null;
        }
        List lore = im.getLore();
        String name = im.getDisplayName();
        if (name == null || name.equalsIgnoreCase("null")) {
            name = "Car";
        }
        DrivenCar c = ItemCarValidation.getCarFromLore(im.getDisplayName(), lore);
        return c;
    }

    public static DrivenCar getCarFromLore(String name, List<String> lore) {
        double d2;
        if (lore.size() < 3) {
            return null;
        }
        int i = 0;
        if (!Colors.strip(lore.get(i)).toLowerCase().contains("[speed:]")) {
            String firstLine = Colors.strip(lore.get(i)).toLowerCase();
            if (firstLine.equalsIgnoreCase("plane") || firstLine.equalsIgnoreCase("helicopter") || !firstLine.equalsIgnoreCase("car")) {
                return null;
            }
            if (!firstLine.equalsIgnoreCase("car")) {
                try {
                    UUID.fromString(firstLine);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (!Colors.strip(lore.get(i = 1)).toLowerCase().contains("[speed:]")) {
                return null;
            }
        }
        double speed = 1.0;
        double health = 50.0;
        boolean isHandlingDamaged = false;
        double turnAmountPerTick = 5.0;
        double acceleration = 1.0;
        ArrayList<String> modifiers = new ArrayList<String>();
        String line = Colors.strip(lore.get(i)).toLowerCase();
        String speedRaw = line.replaceFirst(Pattern.quote("[speed:] "), "").replaceAll(Pattern.quote("x"), "");
        try {
            speed = Double.parseDouble(speedRaw);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        line = Colors.strip(lore.get(++i)).toLowerCase();
        String[] healthRaw = line.replaceFirst(Pattern.quote("[health:] "), "").split(Pattern.quote("/"));
        try {
            health = Double.parseDouble(healthRaw[0]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (++i >= lore.size()) {
            return null;
        }
        line = Colors.strip(lore.get(i)).toLowerCase();
        if (!line.contains("handling")) {
            return null;
        }
        String handlingRaw = line.replaceFirst(Pattern.quote("[handling:] "), "").trim();
        if (handlingRaw.equalsIgnoreCase("damaged")) {
            isHandlingDamaged = true;
        }
        try {
            d2 = Double.parseDouble(handlingRaw);
            turnAmountPerTick = d2 / 10.0;
        }
        catch (NumberFormatException d2) {
            // empty catch block
        }
        if (i + 1 >= lore.size()) {
            return new DrivenCar(name, speed, health, 1.0, 5.0, isHandlingDamaged, modifiers);
        }
        line = Colors.strip(lore.get(i + 1)).toLowerCase();
        if (line.contains("acceleration")) {
            ++i;
            String accelRaw = line.replaceFirst(Pattern.quote("[acceleration:] "), "").trim();
            try {
                d2 = Double.parseDouble(accelRaw);
                acceleration = d2 / 10.0;
            }
            catch (NumberFormatException e) {
                return null;
            }
            line = Colors.strip(lore.get(i + 1)).toLowerCase();
            if (line.contains("damage")) {
                ++i;
                String damageRaw = line.replaceFirst(Pattern.quote("[damage:] "), "").trim();
                if (damageRaw.equalsIgnoreCase("damaged")) {
                    isHandlingDamaged = true;
                }
            }
        }
        try {
            if (lore.size() > i) {
                int z = ++i;
                while (i < lore.size()) {
                    line = Colors.strip(lore.get(i));
                    modifiers.add(line.replaceFirst(Pattern.quote("-Modifier: "), "").trim());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return new DrivenCar(name, speed, health, acceleration, turnAmountPerTick, isHandlingDamaged, modifiers);
    }
}

