/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles;

import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.RoadEdge;
import net.stormdev.ucars.trade.AIVehicles.TrackBlock;
import net.stormdev.ucars.trade.AIVehicles.TrackingData;
import net.stormdev.ucars.trade.AIVehicles.VelocityData;
import net.stormdev.ucars.trade.AIVehicles.routing.BlockRouteData;
import net.stormdev.ucars.trade.AIVehicles.routing.RouteBlockType;
import net.stormdev.ucars.trade.AIVehicles.routing.RouteDecoder;
import net.stormdev.ucars.trade.main;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class AITrackFollow {
    private static Material roadEdge = null;

    private static Material getRoadEdgeType() {
        if (roadEdge != null) {
            return roadEdge;
        }
        roadEdge = Material.getMaterial((String)main.config.getString("general.ai.roadEdgeBlock"));
        return roadEdge;
    }

    public static RoadEdge findRoadEdge(Block roadSpawnBlock, BlockFace dir) {
        Block edge = null;
        int distance = 1;
        for (int z = 1; z < 20 && edge == null; ++z) {
            Block b = roadSpawnBlock.getRelative(dir, z);
            if (b.getType() != AITrackFollow.getRoadEdgeType()) continue;
            edge = b;
            distance = z;
        }
        if (edge != null) {
            return new RoadEdge(edge, distance);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlockRouteData carriagewayDirection(Block roadSpawnBlock) {
        if (AIRouter.isEncodedRouting()) {
            Block under;
            BlockRouteData brd = RouteDecoder.getDirection(roadSpawnBlock.getType(), roadSpawnBlock.getData());
            if (brd != null) {
                if (brd.getType() != null) return brd;
                if (brd.getDirection() != null) return brd;
            }
            if ((brd = RouteDecoder.getDirection((under = roadSpawnBlock.getRelative(BlockFace.DOWN)).getType(), under.getData())) != null) {
                if (brd.getType() != null) return brd;
                if (brd.getDirection() != null) return brd;
            }
            under = under.getRelative(BlockFace.DOWN);
            return RouteDecoder.getDirection(under.getType(), under.getData());
        }
        if (roadSpawnBlock.getType().equals((Object)AIRouter.junction)) {
            return new BlockRouteData(RouteBlockType.JUNCTION, null);
        }
        String currentType = AIRouter.getTrackBlockType(roadSpawnBlock.getType());
        if (currentType != null) {
            int currentPos = AIRouter.getTrackBlockIndexByType(currentType);
            int nextPos = currentPos + 1;
            if (nextPos >= AIRouter.pattern.length) {
                nextPos = 0;
            }
            if (currentPos >= 0) {
                int pos;
                String type;
                Block next;
                block19: {
                    BlockFace[] s;
                    String top;
                    Block underunder = roadSpawnBlock.getRelative(BlockFace.DOWN);
                    if (underunder.getState() instanceof Sign && (top = (s = (BlockFace[])underunder.getState()).getLine(0)) != null && top.length() > 0) {
                        try {
                            return new BlockRouteData(RouteBlockType.DIRECTIONAL, BlockFace.valueOf((String)top));
                        }
                        catch (Exception e) {
                            if (top.equalsIgnoreCase("NONE")) return new BlockRouteData(RouteBlockType.CONTINUE, null);
                            if (!top.equalsIgnoreCase("NULL")) break block19;
                            return new BlockRouteData(RouteBlockType.CONTINUE, null);
                        }
                    }
                }
                for (BlockFace pDir : AITrackFollow.compassDirs()) {
                    next = roadSpawnBlock.getRelative(pDir);
                    type = AIRouter.getTrackBlockType(next.getType());
                    if (type == null || type.equals(currentType) || (pos = AIRouter.getTrackBlockIndexByType(type)) != nextPos || pos == currentPos) continue;
                    return new BlockRouteData(RouteBlockType.DIRECTIONAL, pDir);
                }
                for (BlockFace pDir : AITrackFollow.diagonalDirs()) {
                    next = roadSpawnBlock.getRelative(pDir);
                    type = AIRouter.getTrackBlockType(next.getType());
                    if (type == null || type.equals(currentType) || (pos = AIRouter.getTrackBlockIndexByType(type)) != nextPos || pos == currentPos) continue;
                    return new BlockRouteData(RouteBlockType.DIRECTIONAL, pDir);
                }
            }
        }
        BlockFace dir = BlockFace.NORTH;
        RoadEdge north = AITrackFollow.findRoadEdge(roadSpawnBlock, BlockFace.NORTH);
        RoadEdge east = AITrackFollow.findRoadEdge(roadSpawnBlock, BlockFace.EAST);
        RoadEdge south = AITrackFollow.findRoadEdge(roadSpawnBlock, BlockFace.SOUTH);
        RoadEdge west = AITrackFollow.findRoadEdge(roadSpawnBlock, BlockFace.WEST);
        north = south == null ? null : north;
        south = north == null ? null : south;
        west = east == null ? null : west;
        RoadEdge roadEdge = east = west == null ? null : east;
        if (east != null && west != null && north != null && south != null) {
            RoadEdge NE = AITrackFollow.findRoadEdge(roadSpawnBlock, BlockFace.NORTH_EAST);
            RoadEdge SE = AITrackFollow.findRoadEdge(roadSpawnBlock, BlockFace.SOUTH_EAST);
            RoadEdge SW = AITrackFollow.findRoadEdge(roadSpawnBlock, BlockFace.SOUTH_WEST);
            RoadEdge NW = AITrackFollow.findRoadEdge(roadSpawnBlock, BlockFace.NORTH_WEST);
            NE = SW == null ? null : NE;
            SW = NE == null ? null : SW;
            SE = NW == null ? null : SE;
            RoadEdge roadEdge2 = NW = SE == null ? null : NW;
            if (NE != null && SW != null && SE != null && NW != null) {
                return new BlockRouteData(null, null);
            }
            if (NW != null) {
                dir = BlockFace.NORTH_EAST;
                if (NW.distance >= SE.distance) return new BlockRouteData(RouteBlockType.DIRECTIONAL, dir);
                dir = BlockFace.SOUTH_WEST;
                return new BlockRouteData(RouteBlockType.DIRECTIONAL, dir);
            } else {
                if (SW == null) return new BlockRouteData(null, null);
                dir = BlockFace.NORTH_WEST;
                if (SW.distance >= NE.distance) return new BlockRouteData(RouteBlockType.DIRECTIONAL, dir);
                dir = BlockFace.SOUTH_EAST;
            }
            return new BlockRouteData(RouteBlockType.DIRECTIONAL, dir);
        } else if (east != null) {
            if (west.distance >= east.distance) return new BlockRouteData(RouteBlockType.DIRECTIONAL, dir);
            dir = BlockFace.SOUTH;
            return new BlockRouteData(RouteBlockType.DIRECTIONAL, dir);
        } else {
            if (north == null) return new BlockRouteData(null, null);
            dir = BlockFace.EAST;
            if (north.distance >= south.distance) return new BlockRouteData(RouteBlockType.DIRECTIONAL, dir);
            dir = BlockFace.WEST;
        }
        return new BlockRouteData(RouteBlockType.DIRECTIONAL, dir);
    }

    public static TrackingData nextBlock(Block current, VelocityData vd, BlockRouteData routeData, Entity vehicle) {
        boolean chJ;
        Block check;
        BlockFace dir;
        BlockFace blockFace = dir = routeData.getDirection() != null ? routeData.getDirection() : vd.getDir();
        if (AIRouter.isEncodedRouting()) {
            if (!routeData.isJunction() || vd.isInProgressOfTurningAtJunction()) {
                Block cr = current.getRelative(dir);
                BlockRouteData brd = AITrackFollow.carriagewayDirection(cr);
                if (brd.getType() == null && (brd = AITrackFollow.carriagewayDirection(cr = cr.getRelative(BlockFace.UP))).getType() == null && (brd = AITrackFollow.carriagewayDirection(cr = cr.getRelative(BlockFace.DOWN, 2))).getType() == null) {
                    return new TrackingData(current, dir, routeData.isJunction());
                }
                if (!routeData.isJunction() && !brd.isJunction()) {
                    vd.setInProgressOfTurningAtJunction(false);
                }
                return new TrackingData(cr, dir, brd.isJunction());
            }
            if (main.random.nextBoolean()) {
                vd.setInProgressOfTurningAtJunction(true);
                return new TrackingData(current.getRelative(dir), dir, false);
            }
            if (dir == null) {
                dir = BlockFace.NORTH;
            }
            BlockFace leftCheck = AITrackFollow.nextLeftFace(dir);
            BlockFace rightCheck = AITrackFollow.nextRightFace(dir);
            BlockFace behind = dir.getOppositeFace();
            while (!leftCheck.equals((Object)behind) && !rightCheck.equals((Object)behind)) {
                try {
                    Block left = current.getRelative(leftCheck);
                    Block right = current.getRelative(rightCheck);
                    BlockRouteData brd = AITrackFollow.carriagewayDirection(right);
                    if (brd.getType() != null) {
                        vd.setInProgressOfTurningAtJunction(true);
                        return new TrackingData(right, rightCheck, true);
                    }
                    brd = AITrackFollow.carriagewayDirection(left);
                    if (brd.getType() != null) {
                        vd.setInProgressOfTurningAtJunction(true);
                        return new TrackingData(left, leftCheck, true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                leftCheck = AITrackFollow.nextLeftFace(leftCheck);
                rightCheck = AITrackFollow.nextRightFace(rightCheck);
            }
            vd.setInProgressOfTurningAtJunction(true);
            return new TrackingData(current.getRelative(dir), dir, false);
        }
        Block cr = current.getRelative(dir);
        TrackBlock ch = AITrackFollow.checkIfOreTracker(current, cr);
        boolean turn = false;
        if (ch != null && (check = ch.block) != null) {
            if (routeData.isJunction() && main.random.nextBoolean() && vehicle != null && !UEntityMeta.hasMetadata((Entity)vehicle, (String)"npc.turning")) {
                turn = true;
            } else {
                if (vehicle != null) {
                    UEntityMeta.removeMetadata((Entity)vehicle, (String)"npc.turning");
                }
                return new TrackingData(check, dir, ch.junction);
            }
        }
        boolean bl = chJ = ch != null ? ch.junction : false;
        if (dir == null) {
            dir = BlockFace.NORTH;
        }
        BlockFace leftCheck = AITrackFollow.nextLeftFace(dir);
        BlockFace rightCheck = AITrackFollow.nextRightFace(dir);
        BlockFace behind = dir.getOppositeFace();
        while (!leftCheck.equals((Object)behind) && !rightCheck.equals((Object)behind)) {
            Block lb = current.getRelative(leftCheck);
            Block rb = current.getRelative(rightCheck);
            TrackBlock clb = AITrackFollow.checkIfOreTracker(current, lb);
            TrackBlock crb = AITrackFollow.checkIfOreTracker(current, rb);
            if (crb != null) {
                if (vehicle != null) {
                    if (!crb.junction) {
                        UEntityMeta.removeMetadata((Entity)vehicle, (String)"npc.turning");
                    } else if (turn && !UEntityMeta.hasMetadata((Entity)vehicle, (String)"npc.turning")) {
                        UEntityMeta.setMetadata((Entity)vehicle, (String)"npc.turning", (MetadataValue)new StatValue(null, (Plugin)main.plugin));
                    }
                }
                return new TrackingData(crb.block, rightCheck, chJ);
            }
            if (clb != null) {
                if (vehicle != null) {
                    if (!clb.junction) {
                        UEntityMeta.removeMetadata((Entity)vehicle, (String)"npc.turning");
                    } else if (turn && !UEntityMeta.hasMetadata((Entity)vehicle, (String)"npc.turning")) {
                        UEntityMeta.setMetadata((Entity)vehicle, (String)"npc.turning", (MetadataValue)new StatValue(null, (Plugin)main.plugin));
                    }
                }
                TrackingData res = new TrackingData(clb.block, leftCheck, chJ);
                return res;
            }
            leftCheck = AITrackFollow.nextLeftFace(leftCheck);
            rightCheck = AITrackFollow.nextRightFace(rightCheck);
        }
        return new TrackingData(current, dir, chJ);
    }

    public static TrackBlock checkIfOreTracker(Block current, Block check) {
        Material junction = AIRouter.junction;
        if (AIRouter.isTrackBlock(check.getType())) {
            current = check;
            return new TrackBlock(current, false);
        }
        if (check.getType() == junction) {
            current = check;
            return new TrackBlock(current, true);
        }
        if (AIRouter.isTrackBlock(check.getRelative(BlockFace.UP).getType())) {
            current = check.getRelative(BlockFace.UP);
            return new TrackBlock(current, false);
        }
        if (check.getRelative(BlockFace.UP).getType() == junction) {
            current = check.getRelative(BlockFace.UP);
            return new TrackBlock(current, true);
        }
        if (AIRouter.isTrackBlock(check.getRelative(BlockFace.DOWN).getType())) {
            current = check.getRelative(BlockFace.DOWN);
            return new TrackBlock(current, false);
        }
        if (check.getRelative(BlockFace.DOWN).getType() == junction) {
            current = check.getRelative(BlockFace.DOWN);
            return new TrackBlock(current, true);
        }
        return null;
    }

    public static boolean isCompassDir(BlockFace dir) {
        if (dir == null) {
            return false;
        }
        return dir.equals((Object)BlockFace.NORTH) || dir.equals((Object)BlockFace.EAST) || dir.equals((Object)BlockFace.SOUTH) || dir.equals((Object)BlockFace.WEST);
    }

    public static boolean isDiagonalDir(BlockFace dir) {
        if (dir == null) {
            return false;
        }
        return dir.equals((Object)BlockFace.NORTH_EAST) || dir.equals((Object)BlockFace.SOUTH_EAST) || dir.equals((Object)BlockFace.SOUTH_WEST) || dir.equals((Object)BlockFace.NORTH_WEST);
    }

    public static BlockFace[] allDirs() {
        return new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    }

    public static BlockFace[] compassDirs() {
        return new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    }

    public static BlockFace[] diagonalDirs() {
        return new BlockFace[]{BlockFace.NORTH_EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST, BlockFace.NORTH_WEST};
    }

    public static BlockFace nextRightFace(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.NORTH_EAST;
            }
            case NORTH_EAST: {
                return BlockFace.EAST;
            }
            case EAST: {
                return BlockFace.SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH_WEST;
            }
            case NORTH_WEST: {
                return BlockFace.NORTH;
            }
        }
        return face;
    }

    public static BlockFace nextLeftFace(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.NORTH_WEST;
            }
            case NORTH_WEST: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH_WEST;
            }
            case SOUTH_WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.SOUTH_EAST;
            }
            case SOUTH_EAST: {
                return BlockFace.EAST;
            }
            case EAST: {
                return BlockFace.NORTH_EAST;
            }
            case NORTH_EAST: {
                return BlockFace.NORTH;
            }
        }
        return face;
    }

    public static BlockFace nextCompassPointRight(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.EAST;
            }
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
        }
        return face.getOppositeFace();
    }

    public static BlockFace nextCompassPointLeft(BlockFace face) {
        switch (face) {
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
            case EAST: {
                return BlockFace.NORTH;
            }
        }
        return face.getOppositeFace();
    }

    public static BlockFace randomCompassDir() {
        int rand = main.random.nextInt(4);
        switch (rand) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.EAST;
            }
            case 2: {
                return BlockFace.WEST;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
        }
        return BlockFace.SOUTH;
    }
}

