/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade;

import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucarstrade.cars.DrivenCar;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CarSaver {
    public static final String META = "car.drivenCarMeta";
    private volatile Map<UUID, DrivenCar> inUse = new ConcurrentHashMap<UUID, DrivenCar>(200, 0.75f, 2);
    File newSaveFile = null;

    public CarSaver(File newSaveFile) {
        this.newSaveFile = newSaveFile;
        Bukkit.getScheduler().runTaskTimer((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                final ArrayList entities = new ArrayList();
                for (World w : Bukkit.getWorlds()) {
                    entities.addAll(w.getEntities());
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        block0: for (UUID id : new ArrayList(CarSaver.this.inUse.keySet())) {
                            for (Entity e : entities) {
                                if (!e.getUniqueId().equals(id)) continue;
                                continue block0;
                            }
                            CarSaver.this.inUse.remove(id);
                        }
                    }
                });
            }
        }, 3600L, 3600L);
    }

    public boolean isAUCar(Entity v) {
        if (UEntityMeta.hasMetadata((Entity)v, (String)META)) {
            return true;
        }
        return this.inUse.containsKey(v.getUniqueId());
    }

    public boolean isAUCarWithEntityID(UUID carId) {
        return this.inUse.containsKey(carId);
    }

    public DrivenCar getCarInUse(Entity cart) {
        try {
            return (DrivenCar)((MetadataValue)UEntityMeta.getMetadata((Entity)cart, (String)META).get(0)).value();
        }
        catch (Exception e) {
            UEntityMeta.removeMetadata((Entity)cart, (String)META);
            return this.inUse.get(cart.getUniqueId());
        }
    }

    public DrivenCar getCarInUseWithEntityID(UUID carId) {
        return this.inUse.get(carId);
    }

    public void carNoLongerInUse(final DrivenCar car) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CarSaver carSaver = CarSaver.this;
                synchronized (carSaver) {
                    if (car == null || car.getId() == null) {
                        throw new RuntimeException("DrivenCar is null!");
                    }
                    CarSaver.this.inUse.remove(car.getId());
                    CarSaver.this.asyncSave();
                }
            }
        });
    }

    public void carNoLongerInUse(final UUID id) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CarSaver carSaver = CarSaver.this;
                synchronized (carSaver) {
                    CarSaver.this.inUse.remove(id);
                    CarSaver.this.asyncSave();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void carNoLongerInUseNow(UUID id) {
        CarSaver carSaver = this;
        synchronized (carSaver) {
            this.inUse.remove(id);
            this.save();
        }
    }

    public void carNowInUse(final Entity v, final DrivenCar car) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UEntityMeta.removeMetadata((Entity)v, (String)CarSaver.META);
                UEntityMeta.setMetadata((Entity)v, (String)CarSaver.META, (MetadataValue)new StatValue((Object)car, (Plugin)main.plugin));
                if (car == null || car.getId() == null) {
                    throw new RuntimeException("DrivenCar is null!");
                }
                CarSaver carSaver = CarSaver.this;
                synchronized (carSaver) {
                    CarSaver.this.inUse.put(car.getId(), car);
                    CarSaver.this.asyncSave();
                }
            }
        });
    }

    public void carNowInUseNoEntity(final DrivenCar car) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (car == null || car.getId() == null) {
                    throw new RuntimeException("DrivenCar is null!");
                }
                CarSaver carSaver = CarSaver.this;
                synchronized (carSaver) {
                    CarSaver.this.inUse.put(car.getId(), car);
                    CarSaver.this.asyncSave();
                }
            }
        });
    }

    public void asyncSave() {
        main.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)main.plugin, new BukkitRunnable(){

            public void run() {
                CarSaver.this.saveIt();
            }
        });
    }

    public void load() {
        this.newSaveFile.getParentFile().mkdirs();
        if (!this.newSaveFile.exists() || this.newSaveFile.length() < 1L) {
            try {
                this.newSaveFile.createNewFile();
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.inUse = CarSaver.loadHashMap(this.newSaveFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.inUse = null;
            }
        }
        if (this.inUse == null) {
            this.inUse = new ConcurrentHashMap<UUID, DrivenCar>();
        }
    }

    public void save() {
        this.asyncSave();
    }

    private void saveIt() {
        if (!this.newSaveFile.exists() || this.newSaveFile.length() < 1L) {
            try {
                this.newSaveFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        CarSaver.saveHashMap(this.inUse, this.newSaveFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveHashMap(Map<UUID, DrivenCar> map, String path) {
        CarSaver carSaver = main.plugin.carSaver;
        synchronized (carSaver) {
            HashMap<UUID, DrivenCar> hm = new HashMap<UUID, DrivenCar>(map);
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));
                oos.writeObject(hm);
                oos.flush();
                oos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<UUID, DrivenCar> loadHashMap(String path) {
        try {
            HashMap result;
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
            try {
                result = ois.readObject();
            }
            catch (NoClassDefFoundError e1) {
                try {
                    File f = new File(path);
                    f.delete();
                    f.createNewFile();
                }
                catch (Exception f) {
                    // empty catch block
                }
                ois.close();
                result = new HashMap();
            }
            ois.close();
            try {
                HashMap res = result;
                if (res instanceof ConcurrentHashMap) {
                    HashMap r = res;
                    res = new HashMap();
                    res.putAll(r);
                }
                return res;
            }
            catch (Exception e) {
                return new HashMap<UUID, DrivenCar>();
            }
        }
        catch (Exception e) {
            return null;
        }
    }
}

