/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.stormdev.uPlanes.api.RollTarget;
import net.stormdev.uPlanes.api.uPlanesVehicle;
import net.stormdev.uPlanes.api.uPlanesVehicleBase;
import net.stormdev.uPlanes.main.BoatState;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.presets.BoatPreset;
import net.stormdev.uPlanes.presets.PresetManager;
import net.stormdev.uPlanes.utils.Colors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public class Boat
extends uPlanesVehicleBase<BoatPreset>
implements Serializable {
    public static final double DEFAULT_TURN_AMOUNT = 4.0;
    private static final long serialVersionUID = 2L;
    private double turnAmount = 4.0;
    private double mass = 1000.0;
    private transient long lastSpacebarTime = 0L;
    private transient BoatState boatState;

    public void postBoatUpdateEvent(Vector vec) {
        this.lastUpdateEventTime = System.currentTimeMillis();
        this.setLastUpdateEventVec(vec);
    }

    public Boat() {
        this.setCurrentPitch(0.0f);
        this.setRoll(0.0);
        this.boatState = new BoatState(this);
    }

    public Boat(double speed, String name, double health, double accelMod, double turnAmountPerTick) {
        super(speed, name, health, accelMod);
        this.turnAmount = turnAmountPerTick;
        this.boatState = new BoatState(this);
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public BoatState getBoatState() {
        return this.boatState;
    }

    public void setBoatState(BoatState boatState) {
        this.boatState = boatState;
    }

    @Override
    public int getMaxPassengers() {
        if (this.maxPassengers < 0) {
            if (this.isFromPreset()) {
                return this.getPreset().getMaxPassengers();
            }
            return 1;
        }
        return this.maxPassengers;
    }

    @Override
    public void setMaxPassengers(int maxPassengers) {
        this.maxPassengers = maxPassengers;
    }

    @Override
    public double[] getBoatRotationOffsetDegrees() {
        if (this.maxPassengers < 0 && this.isFromPreset()) {
            return this.getPreset().getBoatRotationOffsetDeg();
        }
        return this.boatsRotationOffsetDegrees;
    }

    @Override
    public void setBoatRotationOffsetDegrees(double[] boatRotationOffsetDegrees) {
        this.boatsRotationOffsetDegrees = boatRotationOffsetDegrees;
    }

    @Override
    public boolean isFromPreset() {
        return this.getPreset() != null;
    }

    @Override
    public BoatPreset getPreset() {
        if (!PresetManager.usePresets) {
            return null;
        }
        List<BoatPreset> pps = main.plugin.presets.getBoatPresets();
        for (BoatPreset pp : new ArrayList<BoatPreset>(pps)) {
            if (!pp.getName().equals(this.getName())) continue;
            return pp;
        }
        return null;
    }

    @Override
    public ItemStack toItemStack() {
        ItemStack stack;
        MaterialData displayBlock = this.getCartDisplayBlock();
        if (this.getPreset() != null) {
            displayBlock = this.getPreset().getDisplayBlock();
        }
        if (main.config.getBoolean("general.planes.renderAsModelledBlockWhenExist") && displayBlock != null) {
            stack = new ItemStack(displayBlock.getItemType());
            stack.setData(displayBlock);
        } else {
            stack = new ItemStack(Material.MINECART);
        }
        ArrayList<String> lore = new ArrayList<String>();
        ItemMeta meta = stack.getItemMeta();
        lore.add(ChatColor.GRAY + "boat");
        lore.add(main.colors.getTitle() + "[Speed:] " + main.colors.getInfo() + this.mutliplier);
        lore.add(main.colors.getTitle() + "[Health:] " + main.colors.getInfo() + this.health);
        lore.add(main.colors.getTitle() + "[Acceleration:] " + main.colors.getInfo() + this.accelMod * 10.0);
        lore.add(main.colors.getTitle() + "[Handling:] " + main.colors.getInfo() + this.turnAmount * 10.0);
        if (this.getMaxPassengers() > 1) {
            lore.add(main.colors.getTitle() + "[Passengers:] " + main.colors.getInfo() + this.getMaxPassengers());
        }
        meta.setDisplayName(Colors.colorise(this.name));
        meta.setLore(lore);
        stack.setItemMeta(meta);
        return stack;
    }

    @Override
    public void setTurnAmountPerTick(double d) {
        this.turnAmount = d;
    }

    @Override
    public Boat setId(UUID id) {
        return (Boat)super.setId(id);
    }

    @Override
    public uPlanesVehicle.VehicleType getType() {
        return uPlanesVehicle.VehicleType.BOAT;
    }

    @Override
    public float getRollAmount(RollTarget rollTarget) {
        switch (rollTarget) {
            case LEFT: {
                return 25.0f;
            }
            case NONE: {
                return 0.0f;
            }
            case RIGHT: {
                return -25.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public String getTypeName() {
        return "boat";
    }

    @Override
    public double getTurnAmountPerTick() {
        if (this.turnAmount <= 0.0) {
            this.turnAmount = 4.0;
        }
        return this.turnAmount;
    }

    public long getLastSpacebarTime() {
        return this.lastSpacebarTime;
    }

    public void setLastSpacebarTime(long lastSpacebarTime) {
        this.lastSpacebarTime = lastSpacebarTime;
    }
}

