/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.stormdev.uPlanes.api.Boat;
import net.stormdev.uPlanes.api.Keypress;
import net.stormdev.uPlanes.api.Plane;
import net.stormdev.uPlanes.api.RollTarget;
import net.stormdev.uPlanes.api.uPlanesAPI;
import net.stormdev.uPlanes.api.uPlanesVehicle;
import net.stormdev.uPlanes.main.AccelerationManager;
import net.stormdev.uPlanes.main.BoatState;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.main.uPlanesListener;
import net.stormdev.uPlanes.utils.BoatUpdateEvent;
import net.stormdev.uPlanes.utils.CartOrientationUtil;
import net.stormdev.uPlanes.utils.PEntityMeta;
import net.stormdev.uPlanes.utils.PlaneUpdateEvent;
import net.stormdev.uPlanes.utils.StatValue;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MotionManager {
    private static Map<UUID, MovePacketInfo> playerPacketUpdates = new HashMap<UUID, MovePacketInfo>();

    public static Vector rotateXZVector3dDegrees(Vector original, double degrees) {
        double[] out = MotionManager.rotateVector2dRadians(original.getX(), original.getZ(), Math.toRadians(degrees));
        original.setX(out[0]);
        original.setZ(out[1]);
        return original;
    }

    public static double[] rotateVector2dDegrees(double x, double y, double degrees) {
        return MotionManager.rotateVector2dRadians(x, y, Math.toRadians(degrees));
    }

    public static double[] rotateVector2dRadians(double x, double y, double radians) {
        double[] result = new double[]{x * Math.cos(radians) - y * Math.sin(radians), x * Math.sin(radians) + y * Math.cos(radians)};
        return result;
    }

    public static void removePlayer(Player player) {
        playerPacketUpdates.remove(player.getUniqueId());
    }

    public static void onPacket(Player player, float f, float s, boolean jumping) {
        if (!player.isOnline()) {
            return;
        }
        playerPacketUpdates.put(player.getUniqueId(), new MovePacketInfo(f, s, jumping));
    }

    public static MovePacketInfo getMostRecentPacketInfo(Player player) {
        MovePacketInfo m = playerPacketUpdates.get(player.getUniqueId());
        if (m == null) {
            m = new MovePacketInfo(0.0f, 0.0f, false);
        }
        return m;
    }

    public static void moveBoat(Vehicle vehicle, Boat boat, boolean hasPassenger) {
        BoatState state = boat.getBoatState();
        if (state == null) {
            state = new BoatState(boat);
            boat.setBoatState(state);
        }
        if (!hasPassenger) {
            state.setThrottleAmt(0.0);
        }
        state.updateVelocitiesYawForThisGameTick(vehicle);
        CartOrientationUtil.setYaw(vehicle, (float)state.getCurYaw() + 90.0f);
        CartOrientationUtil.setPitch(vehicle, boat.getCurrentPitch());
        CartOrientationUtil.setRoll(vehicle, boat.getRoll());
        Vector vel = state.getVelBlocksPerSec().clone().multiply(0.05);
        vehicle.setVelocity(vel);
    }

    private static void moveBoat(Player player, Vehicle vehicle, Boat boat, List<Keypress> keysPressed) {
        double newThrottle;
        BoatState state = boat.getBoatState();
        if (keysPressed.contains((Object)Keypress.W)) {
            newThrottle = state.getThrottleAmt() + (state.getThrottleAmt() < 0.0 ? 0.125 : 0.025);
            if (newThrottle > 1.0) {
                newThrottle = 1.0;
            }
            state.setThrottleAmt(newThrottle);
        } else if (keysPressed.contains((Object)Keypress.S)) {
            newThrottle = state.getThrottleAmt() - (state.getThrottleAmt() > 0.0 ? 0.125 : 0.025);
            if (newThrottle < -0.5) {
                newThrottle = -0.5;
            }
            state.setThrottleAmt(newThrottle);
        } else {
            newThrottle = state.getThrottleAmt();
            newThrottle = newThrottle > 0.1 ? (newThrottle -= 0.1) : (newThrottle < -0.1 ? (newThrottle += 0.1) : 0.0);
            state.setThrottleAmt(newThrottle);
        }
        double newSteeringAngle = state.getThrustYawOffsetAngleDeg();
        double maxSteeringAngle = 10.0;
        double steerPerTick = uPlanesAPI.getBoatManager().getAlteredRotationAmountPerTick(player, vehicle, boat) / boat.getTurnAmountPerTick() * 20.0 / 20.0;
        if (keysPressed.contains((Object)Keypress.D)) {
            if ((newSteeringAngle += steerPerTick) > maxSteeringAngle) {
                newSteeringAngle = maxSteeringAngle;
            }
        } else if (keysPressed.contains((Object)Keypress.A)) {
            if ((newSteeringAngle -= steerPerTick) < -maxSteeringAngle) {
                newSteeringAngle = -maxSteeringAngle;
            }
        } else {
            newSteeringAngle = newSteeringAngle > steerPerTick ? (newSteeringAngle -= steerPerTick) : (newSteeringAngle < -steerPerTick ? (newSteeringAngle += steerPerTick) : 0.0);
        }
        state.setThrustYawOffsetAngleDeg(newSteeringAngle);
        if (keysPressed.contains((Object)Keypress.JUMP) && System.currentTimeMillis() - boat.getLastSpacebarTime() > 200L) {
            boat.setLastSpacebarTime(System.currentTimeMillis());
            double throttleLim = state.getThrottleLimit();
            if (throttleLim == 0.1) {
                throttleLim = 0.25;
            } else if (throttleLim < 1.0) {
                throttleLim += 0.25;
            } else if (throttleLim >= 1.0) {
                throttleLim = 0.1;
            }
            state.setThrottleLimit(throttleLim);
            player.sendMessage(ChatColor.GREEN + "" + ChatColor.BOLD + "Throttle Limit: " + ChatColor.YELLOW + "" + ChatColor.BOLD + throttleLim * 100.0 + "%");
        }
        MotionManager.moveBoat(vehicle, boat, true);
        final BoatUpdateEvent event = new BoatUpdateEvent(vehicle, boat.getBoatState().getVelBlocksPerSec().clone().multiply(0.05), player, keysPressed, boat);
        main.plugin.getServer().getScheduler().runTask((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                if (main.fireUpdateEvent) {
                    main.plugin.getServer().getPluginManager().callEvent((Event)event);
                } else {
                    main.plugin.listener.boatControl(event);
                }
            }
        });
    }

    public static void move(Player player, float f, float s, boolean jumping) {
        float hoverAmount;
        Vector vec = new Vector();
        Entity ent = player.getVehicle();
        if (ent == null) {
            return;
        }
        while (!(ent instanceof Vehicle) && ent.getVehicle() != null) {
            ent = ent.getVehicle();
        }
        if (!(ent instanceof Vehicle)) {
            return;
        }
        Vehicle plane = (Vehicle)ent;
        uPlanesVehicle<?> pluginVehicle = main.plugin.listener.getPluginVehicle(plane);
        Plane pln = main.plugin.listener.getPlane(plane);
        if (pluginVehicle == null) {
            return;
        }
        if (plane.hasMetadata("plane.frozen") || PEntityMeta.hasMetadata((Entity)plane, "plane.frozen")) {
            return;
        }
        ArrayList<Keypress> pressedKeys = new ArrayList<Keypress>();
        if (jumping) {
            pressedKeys.add(Keypress.JUMP);
        }
        Keypress speedModKey = Keypress.NONE;
        int side = 0;
        boolean turning = false;
        boolean decel = true;
        if (f > 0.0f) {
            speedModKey = Keypress.W;
            pressedKeys.add(speedModKey);
            decel = false;
        }
        if (s > 0.0f) {
            side = -1;
            turning = true;
        }
        if (s < 0.0f) {
            side = 1;
            turning = true;
        }
        double y = -0.0;
        boolean isRight = false;
        boolean isLeft = false;
        if (turning) {
            if (side < 0) {
                isLeft = true;
                pressedKeys.add(Keypress.A);
                PEntityMeta.setMetadata((Entity)plane, "plane.left", new StatValue(true, (Plugin)main.plugin));
            } else if (side > 0) {
                isRight = true;
                pressedKeys.add(Keypress.D);
                PEntityMeta.setMetadata((Entity)plane, "plane.right", new StatValue(true, (Plugin)main.plugin));
            }
        }
        if (!isRight) {
            PEntityMeta.removeMetadata((Entity)plane, "plane.right");
        }
        if (!isLeft) {
            PEntityMeta.removeMetadata((Entity)plane, "plane.left");
        }
        if (f < 0.0f && (pln == null || pln.isHover())) {
            speedModKey = Keypress.S;
            pressedKeys.add(Keypress.S);
        }
        if (pln == null) {
            if (pluginVehicle.getType().equals((Object)uPlanesVehicle.VehicleType.BOAT)) {
                MotionManager.moveBoat(player, plane, (Boat)pluginVehicle, pressedKeys);
            }
            return;
        }
        if (f != 0.0f || s == 0.0f) {
            // empty if block
        }
        Vector playD = player.getEyeLocation().getDirection();
        Vector planeDirection = null;
        if (PEntityMeta.hasMetadata((Entity)plane, "plane.destination")) {
            planeDirection = playD.clone().setY(0).normalize();
        } else if (!main.doTurningCircles) {
            if ((AccelerationManager.getCurrentMultiplier(plane) >= 0.2 || pln.isHover()) && !PEntityMeta.hasMetadata((Entity)plane, "plane.destination")) {
                planeDirection = playD.clone().setY(0).normalize();
                float vYaw = (float)Math.toDegrees(Math.atan2(planeDirection.getX(), -planeDirection.getZ()));
                CartOrientationUtil.setYaw(plane, vYaw - 90.0f);
            }
        } else {
            boolean roll;
            try {
                planeDirection = (Vector)PEntityMeta.getMetadata((Entity)plane, "plane.direction").get(0).value();
            }
            catch (Exception e) {
                planeDirection = playD.clone().setY(0).normalize();
            }
            double rotMod = uPlanesAPI.getPlaneManager().getAlteredRotationAmountPerTick(player, plane, pln);
            float pYaw = (float)Math.toDegrees(Math.atan2(playD.getX(), -playD.getZ()));
            float vYaw = (float)Math.toDegrees(Math.atan2(planeDirection.getX(), -planeDirection.getZ()));
            float yawDiff = pYaw - vYaw;
            if (yawDiff <= -180.0f) {
                yawDiff += 360.0f;
            } else if (yawDiff > 180.0f) {
                yawDiff -= 360.0f;
            }
            boolean bl = roll = Math.abs(yawDiff) > 30.0f;
            if (!roll) {
                pln.setRollTarget(RollTarget.NONE);
            }
            if ((double)yawDiff < -rotMod) {
                pln.setRollTarget(RollTarget.LEFT);
                yawDiff = (float)(-rotMod);
            } else if ((double)yawDiff > rotMod) {
                pln.setRollTarget(RollTarget.RIGHT);
                yawDiff = (float)rotMod;
            }
            double am = AccelerationManager.getCurrentMultiplier(plane);
            if ((am >= 0.2 || pln.isHover() && am > 0.0 || pln.canPlaneHoverMidair() && !pln.isHover() && !plane.isOnGround()) && !PEntityMeta.hasMetadata((Entity)plane, "plane.destination")) {
                pln.updateRoll();
                CartOrientationUtil.setRoll(plane, pln.getRoll());
                planeDirection = MotionManager.rotateXZVector3dDegrees(planeDirection, yawDiff);
                CartOrientationUtil.setYaw(plane, vYaw - 90.0f);
            }
            if (pln.isHover() && am == 0.0) {
                pln.setRollTarget(RollTarget.NONE);
                pln.updateRoll();
                CartOrientationUtil.setRoll(plane, pln.getRoll());
            }
            PEntityMeta.removeMetadata((Entity)plane, "plane.direction");
            PEntityMeta.setMetadata((Entity)plane, "plane.direction", new StatValue(planeDirection.clone().normalize(), (Plugin)main.plugin));
        }
        if (jumping && !pln.isHover()) {
            decel = false;
            if (!pln.isSpeedLocked()) {
                pln.setSpeedLocked(true);
                player.sendMessage(ChatColor.YELLOW + "Thrust locked at " + Math.round(AccelerationManager.getCurrentMultiplier(plane) * 100.0) + "%. Unlock it again with w.");
                pln.setSpeedLockTime(System.currentTimeMillis());
            }
        }
        if (f != 0.0f && pln.isSpeedLocked() && !pln.isHover() && !jumping && System.currentTimeMillis() - pln.getSpeedLockTime() > 500L) {
            pln.setSpeedLocked(false);
            player.sendMessage(ChatColor.YELLOW + "Thrust unlocked. Lock it again with spacebar.");
        }
        double d = 27.0;
        if (pln.isSpeedLocked()) {
            decel = false;
        }
        double accelMod = 1.0;
        if (!PEntityMeta.hasMetadata((Entity)plane, "plane.destination")) {
            double d2 = !decel ? AccelerationManager.getMultiplier(player, plane, pln, pln.isSpeedLocked()) : (accelMod = f == 0.0f ? AccelerationManager.decelerateAndGetMult(player, plane, pln) : AccelerationManager.decelerateAndGetMult(player, plane, pln));
            if (f < 0.0f) {
                accelMod = AccelerationManager.decelerateAndGetMult(player, plane, pln);
            }
        }
        if ((double)(hoverAmount = (float)(2.0E-4 * pln.getSpeed())) < 0.005) {
            hoverAmount = 0.005f;
        }
        if ((double)hoverAmount > 0.02) {
            hoverAmount = 0.02f;
        }
        if (turning) {
            if (side < 0) {
                if (pln.isHover()) {
                    y = hoverAmount;
                }
            } else if (side > 0 && pln.isHover()) {
                y = -hoverAmount;
            }
        }
        double x = planeDirection.getX() / d;
        double z = planeDirection.getZ() / d;
        double xOriginal = x;
        double zOriginal = z;
        x *= accelMod;
        z *= accelMod;
        double speedLength = pln.getSpeed() * accelMod;
        boolean hasFlightSpeed = speedLength > 10.0 || accelMod > 0.87;
        boolean planeFloats = false;
        if (pln.canPlaneHoverMidair()) {
            planeFloats = !hasFlightSpeed;
            hasFlightSpeed = true;
        }
        if (pln.isHover()) {
            double pitch = 20.0 * accelMod;
            if (pitch > 10.0) {
                pitch = 10.0;
            }
            pln.setCurrentPitch((float)pitch);
        } else {
            double aPitch;
            if (plane.isOnGround()) {
                if (!hasFlightSpeed) {
                    pln.setCurrentPitch(0.0f);
                }
                if (pln.getCurrentPitch() > 0.0f) {
                    pln.setCurrentPitch(0.0f);
                }
            }
            if (hasFlightSpeed || !plane.isOnGround()) {
                Keypress vertModKey = Keypress.NONE;
                if (pressedKeys.contains((Object)Keypress.A)) {
                    vertModKey = Keypress.A;
                } else if (pressedKeys.contains((Object)Keypress.D) && (!plane.isOnGround() || pln.getCurrentPitch() > 0.0f)) {
                    vertModKey = Keypress.D;
                }
                if (vertModKey != Keypress.NONE) {
                    float pitch = pln.getCurrentPitch();
                    float change = (float)(planeFloats ? 0.5 : 2.0);
                    if ((pitch += vertModKey.equals((Object)Keypress.D) ? change : -change) > 89.0f) {
                        pitch = 89.0f;
                    }
                    if (pitch < -89.0f) {
                        pitch = -89.0f;
                    }
                    pln.setCurrentPitch(pitch);
                }
            }
            double adjacentLength = new Vector(x, 0.0, z).length();
            y = -Math.tan(Math.toRadians(pln.getCurrentPitch())) * adjacentLength;
            double yMult = 1.0 - aPitch / ((aPitch = (double)(-pln.getCurrentPitch())) > 0.0 ? 70.0 : 300.0);
            if (yMult < 0.0) {
                yMult = 0.0;
            }
            y *= yMult;
            if (aPitch > 60.0 && y < 0.012) {
                accelMod = AccelerationManager.stall(player, plane, pln);
            }
            x *= yMult;
            z *= yMult;
            if (!hasFlightSpeed && y > 0.0) {
                y = 0.0;
            }
        }
        double resY = plane.getLocation().getY() + y;
        if (resY > (double)plane.getLocation().getWorld().getMaxHeight() || resY > uPlanesListener.heightLimit) {
            y = 0.0;
        }
        vec = new Vector(x, y, z);
        if (planeFloats && vec.clone().setY(0).lengthSquared() < 1.0) {
            double m = Math.sin((double)pln.getCurrentPitch() * (Math.PI / 180));
            double yAmt = m * m * 0.005;
            if (m > 0.0) {
                yAmt = -yAmt;
            }
            if (Math.abs(pln.getCurrentPitch()) < 45.0f) {
                yAmt = 0.0;
            }
            Vector floatVec = new Vector(xOriginal, 0.0, zOriginal);
            floatVec.multiply(m);
            floatVec.setY(yAmt);
            vec.add(floatVec);
        }
        final PlaneUpdateEvent event = new PlaneUpdateEvent(plane, vec, player, pressedKeys, accelMod, pln);
        main.plugin.getServer().getScheduler().runTask((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                if (main.fireUpdateEvent) {
                    main.plugin.getServer().getPluginManager().callEvent((Event)event);
                } else {
                    main.plugin.listener.planeFlightControl(event);
                }
            }
        });
    }

    public static class MovePacketInfo {
        public float f = 0.0f;
        public float s = 0.0f;
        public boolean jumping = false;

        public MovePacketInfo(float f, float s, boolean jumping) {
            this.f = f;
            this.s = s;
            this.jumping = jumping;
        }
    }
}

