/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.api;

import java.io.Serializable;
import java.util.UUID;
import net.stormdev.uPlanes.api.RollTarget;
import net.stormdev.uPlanes.api.uPlanesVehicle;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.presets.uPlanesVehiclePreset;
import org.bukkit.entity.Entity;
import org.bukkit.material.MaterialData;
import org.bukkit.util.Vector;

public abstract class uPlanesVehicleBase<P extends uPlanesVehiclePreset>
implements uPlanesVehicle<P>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected double mutliplier = 30.0;
    protected String name = "Plane";
    protected double health = 50.0;
    protected double accelMod = 1.0;
    protected UUID id = UUID.randomUUID();
    protected boolean writtenOff = false;
    protected float hitboxX = -1.0f;
    protected float hitboxZ = -1.0f;
    protected int maxPassengers = -1;
    protected double[] boatsRotationOffsetDegrees = new double[]{0.0};
    protected transient float currentPitch = 0.0f;
    protected transient float roll = 0.0f;
    protected transient RollTarget rollTarget = RollTarget.NONE;
    protected transient MaterialData displayBlock;
    protected transient double offset;
    protected transient long lastUpdateEventTime = System.currentTimeMillis();
    protected transient Vector lastUpdateEventVec = null;
    protected transient Entity lastDamager;

    @Override
    public long getTimeSinceLastUpdateEvent() {
        return System.currentTimeMillis() - this.lastUpdateEventTime;
    }

    @Override
    public void postUpdateEvent(Vector vec) {
        this.lastUpdateEventTime = System.currentTimeMillis();
        this.setLastUpdateEventVec(vec);
    }

    public uPlanesVehicleBase() {
        this.setCurrentPitch(0.0f);
        this.setRoll(0.0);
    }

    @Override
    public void setRoll(double i) {
        this.rollTarget = RollTarget.NONE;
        this.roll = (float)i;
    }

    @Override
    public RollTarget getRollTarget() {
        return this.rollTarget;
    }

    @Override
    public void updateRoll() {
        RollTarget t = this.rollTarget;
        if (t == null) {
            t = RollTarget.NONE;
        }
        if (this.roll == this.getRollAmount(t)) {
            return;
        }
        float diff = this.getRollAmount(t) - this.roll;
        if ((double)diff > this.getTurnAmountPerTick()) {
            diff = (float)this.getTurnAmountPerTick();
        }
        if ((double)diff < -this.getTurnAmountPerTick()) {
            diff = (float)(-this.getTurnAmountPerTick());
        }
        this.roll += diff;
    }

    @Override
    public void setRollTarget(RollTarget target) {
        this.rollTarget = target;
    }

    @Override
    public float getRoll() {
        return this.roll;
    }

    public uPlanesVehicleBase(double speed, String name, double health, double accelMod) {
        this.setCurrentPitch(0.0f);
        if (speed > main.maxSpeed) {
            speed = main.maxSpeed;
        }
        this.mutliplier = speed;
        this.name = name;
        this.health = health;
        this.accelMod = accelMod;
    }

    public uPlanesVehicleBase(double speed, double health, double accelMod) {
        this(speed, "vehicle name", health, accelMod);
    }

    @Override
    public int getMaxPassengers() {
        if (this.maxPassengers < 0) {
            if (this.isFromPreset()) {
                return this.getPreset().getMaxPassengers();
            }
            return 1;
        }
        return this.maxPassengers;
    }

    @Override
    public void setMaxPassengers(int maxPassengers) {
        this.maxPassengers = maxPassengers;
    }

    @Override
    public double[] getBoatRotationOffsetDegrees() {
        if (this.maxPassengers < 0 && this.isFromPreset()) {
            return this.getPreset().getBoatRotationOffsetDeg();
        }
        return this.boatsRotationOffsetDegrees;
    }

    @Override
    public void setBoatRotationOffsetDegrees(double[] boatRotationOffsetDegrees) {
        this.boatsRotationOffsetDegrees = boatRotationOffsetDegrees;
    }

    protected String getHandleString(boolean b) {
        if (b) {
            return "Yes";
        }
        return "No";
    }

    @Override
    public boolean isFromPreset() {
        return this.getPreset() != null;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public uPlanesVehicleBase<P> setId(UUID id) {
        this.id = id;
        return this;
    }

    @Override
    public double getSpeed() {
        if (this.mutliplier > main.maxSpeed) {
            this.mutliplier = main.maxSpeed;
        }
        return this.mutliplier;
    }

    @Override
    public void setSpeed(double speed) {
        if (speed > main.maxSpeed) {
            speed = main.maxSpeed;
        }
        this.mutliplier = speed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    @Override
    public void setHealth(double health) {
        this.health = health;
    }

    @Override
    public boolean isWrittenOff() {
        return this.writtenOff;
    }

    @Override
    public void setWrittenOff(boolean writtenOff) {
        this.writtenOff = writtenOff;
    }

    @Override
    public float getCurrentPitch() {
        return this.currentPitch;
    }

    @Override
    public void setCurrentPitch(float currentPitch) {
        this.currentPitch = currentPitch;
    }

    @Override
    public double getAccelMod() {
        return this.accelMod;
    }

    @Override
    public void setAccelMod(double accelMod) {
        this.accelMod = accelMod;
    }

    @Override
    public MaterialData getCartDisplayBlock() {
        return this.displayBlock;
    }

    @Override
    public void setCartDisplayBlock(MaterialData displayBlock) {
        this.displayBlock = displayBlock;
    }

    @Override
    public double getDisplayOffset() {
        return this.offset;
    }

    @Override
    public void setDisplayOffset(double offset) {
        this.offset = offset;
    }

    @Override
    public Vector getLastUpdateEventVec() {
        return this.lastUpdateEventVec;
    }

    @Override
    public void setLastUpdateEventVec(Vector lastUpdateEventVec) {
        this.lastUpdateEventVec = lastUpdateEventVec;
    }

    @Override
    public Entity getLastDamager() {
        return this.lastDamager;
    }

    @Override
    public void setLastDamager(Entity lastDamager) {
        this.lastDamager = lastDamager;
    }

    @Override
    public float getHitboxX() {
        Object pp = this.getPreset();
        if (this.hitboxX < 0.0f && pp != null) {
            return pp.getHitBoxX();
        }
        return this.hitboxX;
    }

    @Override
    public void setHitboxX(float hitboxX) {
        this.hitboxX = hitboxX;
    }

    @Override
    public float getHitboxZ() {
        Object pp = this.getPreset();
        if (this.hitboxZ < 0.0f && pp != null) {
            return pp.getHitBoxZ();
        }
        return this.hitboxZ;
    }

    @Override
    public void setHitboxZ(float hitboxZ) {
        this.hitboxZ = hitboxZ;
    }
}

