/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.server.v1_12_R1.EntityArmorStand;
import net.stormdev.uPlanes.hover.HoverCart;
import net.stormdev.uPlanes.hover.HoverCartEntity;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class CraftHoverCart
extends CraftArmorStand
implements HoverCart {
    public CraftHoverCart(CraftServer server, HoverCartEntity entity) {
        super(server, (EntityArmorStand)entity);
        this.setVisible(false);
        this.setGravity(true);
    }

    public HoverCartEntity getHandle() {
        return (HoverCartEntity)super.getHandle();
    }

    public Location getLocation() {
        return this.getHandle().getTrueLocation();
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        location.checkFinite();
        if (!this.entity.dead) {
            this.entity.stopRiding();
            if (!location.getWorld().equals(this.getWorld())) {
                if (this.entity.isVehicle()) {
                    return false;
                }
                this.entity.teleportTo(location, cause.equals((Object)PlayerTeleportEvent.TeleportCause.NETHER_PORTAL));
                return true;
            }
            this.entity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            this.entity.setHeadRotation(location.getYaw());
            this.entity.world.entityJoinedWorld(this.entity, false);
            return true;
        }
        return false;
    }

    @Override
    public void setDisplay(ItemStack stack, double offset) {
        this.setHelmet(stack.clone());
        this.getHandle().setHeightOffset(offset);
    }

    public Entity getPassenger() {
        List<Entity> pass = this.getPassengers();
        if (pass.size() < 1) {
            return null;
        }
        return pass.get(0);
    }

    @Override
    public List<Entity> getPassengers() {
        ArrayList<Entity> le = new ArrayList<Entity>(super.getPassengers());
        Collections.reverse(le);
        return le;
    }

    @Override
    public double getDisplayOffset() {
        return this.getHandle().getHeightOffset();
    }

    @Override
    public void setYaw(float yaw) {
        double y;
        for (y = (double)(yaw - 90.0f); y < 0.0; y = 360.0 + y) {
        }
        this.getHandle().setYaw((float)y);
    }

    public void setVelocity(Vector vel) {
        super.setVelocity(vel);
    }

    @Override
    public void setPitch(float pitch) {
        double y;
        for (y = (double)pitch; y < 0.0; y = 360.0 + y) {
        }
        this.setHeadPose(new EulerAngle(Math.toRadians(y), this.getHeadPose().getY(), this.getHeadPose().getZ()));
    }

    @Override
    public void setYawPitch(float yaw, float pitch) {
        this.setYaw(yaw);
        this.setPitch(pitch);
    }

    @Override
    public double getMaxPassengers() {
        return this.getHandle().getMaxPassengers();
    }

    @Override
    public double[] getBoatRotationOffsetDegrees() {
        return this.getHandle().getBoatOffsetDeg();
    }

    @Override
    public void setRoll(float roll) {
        double y = roll;
        this.setHeadPose(new EulerAngle(this.getHeadPose().getX(), this.getHeadPose().getY(), Math.toRadians(y)));
    }

    @Override
    public float getHitBoxX() {
        return this.getHandle().getHitBoxX();
    }

    @Override
    public float getHitBoxZ() {
        return this.getHandle().getHitBoxZ();
    }

    @Override
    public void setHitBoxX(float x) {
        this.getHandle().setHitBoxX(x);
    }

    @Override
    public void setHitBoxZ(float z) {
        this.getHandle().setHitBoxZ(z);
    }
}

