/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.guis;

import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class InputMenu
implements Listener,
InventoryHolder {
    private String name;
    private int size;
    private OptionClickEventHandler handler;
    private Plugin plugin;
    private String[] optionNames;
    private ItemStack[] optionIcons;
    private ArrayList<Integer> cancelSlots = new ArrayList();
    private Inventory inventory;
    private boolean destroyOnClose;

    public InputMenu(String name, int size, OptionClickEventHandler handler, Plugin plugin, boolean destroyOnClose) {
        this.name = name;
        this.size = size;
        this.handler = handler;
        this.plugin = plugin;
        this.optionNames = new String[size];
        this.optionIcons = new ItemStack[size];
        this.destroyOnClose = destroyOnClose;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public InputMenu setOption(int position, ItemStack icon, String name, String ... info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = this.setItemNameAndLore(icon, name, info);
        this.cancelSlots.add(position);
        return this;
    }

    public InputMenu setItem(int position, ItemStack icon, String name, String ... info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = this.setItemNameAndLore(icon, name, info);
        return this;
    }

    public void create(InventoryHolder holder) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.size, (String)this.name);
        for (int i = 0; i < this.optionIcons.length; ++i) {
            if (this.optionIcons[i] == null) continue;
            this.inventory.setItem(i, this.optionIcons[i]);
        }
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
    }

    public void destroy() {
        HandlerList.unregisterAll((Listener)this);
        this.handler = null;
        this.plugin = null;
        this.optionNames = null;
        this.optionIcons = null;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void close(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        if (event.getView().getTopInventory().getHolder() != null && event.getView().getTopInventory().getHolder().equals(this)) {
            try {
                if (this.inventory != null && this.handler != null) {
                    this.handler.onClose((Player)event.getPlayer(), this.inventory);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.destroyOnClose) {
                this.destroy();
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onInventoryClick(InventoryClickEvent event) {
        if (event.isShiftClick()) {
            event.setCancelled(true);
            return;
        }
        if (event.getView().getTopInventory().equals(this.inventory) && event.getView().getTopInventory().getHolder() != null && event.getView().getTopInventory().getHolder().equals(this)) {
            int slot = event.getRawSlot();
            if (this.cancelSlots.contains(slot)) {
                event.setCancelled(true);
            }
            if (slot >= 0 && slot < this.size) {
                Plugin plugin = this.plugin;
                OptionClickEvent e = new OptionClickEvent((Player)event.getWhoClicked(), slot, this.optionNames[slot], event.getInventory(), this, event);
                this.handler.onOptionClick(e);
                if (e.willClose()) {
                    final Player p = (Player)event.getWhoClicked();
                    Bukkit.getScheduler().runTaskLater(plugin, new Runnable(){

                        @Override
                        public void run() {
                            p.closeInventory();
                        }
                    }, 1L);
                }
                if (e.willCancelClick()) {
                    event.setCancelled(true);
                }
                if (e.willDestroy()) {
                    this.destroy();
                }
            }
        }
    }

    public ItemStack setItemNameAndLore(ItemStack item, String name, String ... lore) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        im.setLore(Arrays.asList(lore));
        item.setItemMeta(im);
        return item;
    }

    public Inventory getInventory() {
        return null;
    }

    public class OptionClickEvent {
        private Player player;
        private int position;
        private String name;
        private boolean close;
        private boolean destroy;
        private boolean cancelClick = false;
        private Inventory i = null;
        private InputMenu im = null;
        private InventoryClickEvent parent;

        public OptionClickEvent(Player player, int position, String name, Inventory i, InputMenu im, InventoryClickEvent parent) {
            this.player = player;
            this.position = position;
            this.name = name;
            this.close = false;
            this.destroy = false;
            this.i = i;
            this.im = im;
            this.parent = parent;
        }

        public InventoryClickEvent getParentEvent() {
            return this.parent;
        }

        public InputMenu getMenu() {
            return this.im;
        }

        public Inventory getInventory() {
            return this.i;
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public boolean willClose() {
            return this.close;
        }

        public boolean willDestroy() {
            return this.destroy;
        }

        public boolean willCancelClick() {
            return this.cancelClick;
        }

        public void setCancelClick(boolean click) {
            this.cancelClick = click;
        }

        public void setWillClose(boolean close) {
            this.close = close;
        }

        public void setWillDestroy(boolean destroy) {
            this.destroy = destroy;
        }
    }

    public static interface OptionClickEventHandler {
        public void onOptionClick(OptionClickEvent var1);

        public void onClose(Player var1, Inventory var2);
    }
}

