/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.items;

import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.stormdev.uPlanes.api.Boat;
import net.stormdev.uPlanes.utils.Colors;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBoatValidation {
    public static Boat getBoat(ItemStack item) {
        Boat c;
        if (item == null) {
            return null;
        }
        ItemMeta im = item.getItemMeta();
        if (im == null || im.getLore() == null) {
            return null;
        }
        List lore = im.getLore();
        String name = im.getDisplayName();
        if (name == null || name.equalsIgnoreCase("null")) {
            name = "Boat";
        }
        if ((c = ItemBoatValidation.getBoatFromLore(im.getDisplayName(), lore)) == null) {
            return null;
        }
        return c;
    }

    public static Boat getBoatFromLore(String name, List<String> lore) {
        if (lore.size() < 3) {
            return null;
        }
        int i = 0;
        if (!Colors.strip(lore.get(i)).toLowerCase().contains("[speed:]")) {
            String firstLine = Colors.strip(lore.get(i)).toLowerCase();
            if (!firstLine.equalsIgnoreCase("boat")) {
                return null;
            }
            if (!firstLine.equalsIgnoreCase("boat")) {
                try {
                    UUID.fromString(firstLine);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (!Colors.strip(lore.get(i = 1)).toLowerCase().contains("[speed:]")) {
                return null;
            }
        }
        double speed = 1.0;
        double health = 50.0;
        boolean hover = false;
        String line = Colors.strip(lore.get(i)).toLowerCase();
        String speedRaw = line.replaceFirst(Pattern.quote("[speed:] "), "").trim();
        try {
            speed = Double.parseDouble(speedRaw);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        line = Colors.strip(lore.get(++i)).toLowerCase();
        String healthRaw = line.replaceFirst(Pattern.quote("[health:] "), "").trim();
        try {
            health = Double.parseDouble(healthRaw);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (++i >= lore.size()) {
            return new Boat(speed, name, health, 1.0, 4.0);
        }
        line = Colors.strip(lore.get(i)).toLowerCase();
        if (!line.contains("acceleration")) {
            return null;
        }
        try {
            String accelRaw = line.replaceFirst(Pattern.quote("[acceleration:] "), "").trim();
            double accelMod = Double.parseDouble(accelRaw) / 10.0;
            line = Colors.strip(lore.get(++i)).toLowerCase();
            if (!line.contains("handling")) {
                return null;
            }
            String hRaw = line.replaceAll(Pattern.quote("[handling:] "), "").trim();
            double turnAmount = Double.parseDouble(hRaw) / 10.0;
            return new Boat(speed, name, health, accelMod, turnAmount);
        }
        catch (Exception e) {
            return null;
        }
    }
}

