/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.hover;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_12_R1.DamageSource;
import net.minecraft.server.v1_12_R1.EntityArmorStand;
import net.minecraft.server.v1_12_R1.EntityArrow;
import net.minecraft.server.v1_12_R1.EntityBoat;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityMinecartAbstract;
import net.minecraft.server.v1_12_R1.EnumHand;
import net.minecraft.server.v1_12_R1.EnumInteractionResult;
import net.minecraft.server.v1_12_R1.ItemStack;
import net.minecraft.server.v1_12_R1.Vec3D;
import net.stormdev.uPlanes.hover.CraftHoverCart;
import net.stormdev.uPlanes.hover.HoverCart;
import net.stormdev.uPlanes.utils.CustomEntityHandler;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public class HoverCartEntity
extends EntityArmorStand {
    public static final double OFFSET_AMOUNT = 0.0;
    private CraftHoverCart ce;
    private Location loc;
    private double heightOffset = 0.0;
    private float hitBoxX = -1.0f;
    private float hitBoxZ = -1.0f;
    private double[] boatOffsetDeg = new double[]{0.0};
    private int maxPassengers = 1;
    private EntityBoat fakeBoat;
    private EntityBoat fakeBoat2;
    private EntityBoat fakeBoat3;
    private EntityArrow fakeArrow;
    private EntityArrow fakeArrow2;
    private EntityArrow fakeArrow3;
    private EntityArrow fakeArrow4;
    private List<String> playersKnowAboutFakeEntities = new ArrayList<String>();
    private DamageSource damagesource = null;

    public float getHitBoxX() {
        return this.hitBoxX;
    }

    public void setHitBoxX(float hitBoxX) {
        this.hitBoxX = hitBoxX;
        this.setSize();
    }

    public float getHitBoxZ() {
        return this.hitBoxZ;
    }

    public void setHitBoxZ(float hitBoxZ) {
        this.hitBoxZ = hitBoxZ;
        this.setSize();
    }

    public double[] getBoatOffsetDeg() {
        return this.boatOffsetDeg;
    }

    public void setBoatOffsetDeg(double[] boatOffsetDeg) {
        this.boatOffsetDeg = boatOffsetDeg;
    }

    public int getMaxPassengers() {
        return this.maxPassengers;
    }

    public void setMaxPassengers(int maxPassengers) {
        this.maxPassengers = maxPassengers;
    }

    public static HoverCart getCart(Entity e) {
        if (((CraftEntity)e).getHandle() instanceof HoverCartEntity) {
            HoverCartEntity hce = (HoverCartEntity)((CraftEntity)e).getHandle();
            return hce.getHoverCartEntity();
        }
        return null;
    }

    public static boolean isCart(Entity e) {
        return HoverCartEntity.getCart(e) != null;
    }

    public HoverCartEntity(net.minecraft.server.v1_12_R1.World world) {
        super(world);
        this.loc = new Location((World)world.getWorld(), this.locX, this.locY, this.locZ);
        this.setSize();
    }

    public HoverCartEntity(Location loc) {
        this((net.minecraft.server.v1_12_R1.World)((CraftWorld)loc.getWorld()).getHandle());
        this.loc = loc;
        this.updatePosition(loc);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
    }

    public float getBukkitYaw() {
        return this.yaw;
    }

    private void setSize() {
        this.setSize(this.hitBoxX < 0.0f ? 0.98f : this.hitBoxX, this.hitBoxZ < 0.0f ? 0.7f : this.hitBoxZ);
    }

    public Location getTrueLocation() {
        this.loc.setX(this.locX);
        this.loc.setY(this.locY - 0.0);
        this.loc.setZ(this.locZ);
        this.loc.setYaw(this.yaw);
        this.loc.setPitch(this.pitch);
        this.loc.setWorld((World)this.world.getWorld());
        return this.loc.clone();
    }

    public void updatePosition(Location loc) {
        this.loc = loc;
        this.setPositionRotation(loc.getX(), loc.getY() + 0.0, loc.getZ(), loc.getYaw(), loc.getPitch());
    }

    public HoverCart spawn() {
        if (this.ce != null) {
            return this.ce;
        }
        CraftWorld w = (CraftWorld)this.loc.getWorld();
        w.getHandle().addEntity((net.minecraft.server.v1_12_R1.Entity)this, CreatureSpawnEvent.SpawnReason.DEFAULT);
        this.world.getServer().getPluginManager().callEvent((Event)new VehicleCreateEvent((Vehicle)this.ce));
        this.bukkitEntity = this.getHoverCartEntity();
        this.updatePosition(this.loc);
        CraftHoverCart hc = this.getHoverCartEntity();
        if (hc.getMaxPassengers() > 1.0) {
            this.fakeBoat = new EntityBoat((net.minecraft.server.v1_12_R1.World)w.getHandle());
            this.fakeArrow = new EntityArrow((net.minecraft.server.v1_12_R1.World)w.getHandle()){

                protected ItemStack j() {
                    return null;
                }
            };
            this.fakeArrow2 = new EntityArrow((net.minecraft.server.v1_12_R1.World)w.getHandle()){

                protected ItemStack j() {
                    return null;
                }
            };
            if (hc.getMaxPassengers() > 2.0) {
                this.fakeBoat2 = new EntityBoat((net.minecraft.server.v1_12_R1.World)w.getHandle());
                this.fakeBoat3 = new EntityBoat((net.minecraft.server.v1_12_R1.World)w.getHandle());
                this.fakeArrow3 = new EntityArrow((net.minecraft.server.v1_12_R1.World)w.getHandle()){

                    protected ItemStack j() {
                        return null;
                    }
                };
                this.fakeArrow4 = new EntityArrow((net.minecraft.server.v1_12_R1.World)w.getHandle()){

                    protected ItemStack j() {
                        return null;
                    }
                };
            }
        }
        return hc;
    }

    public double getFakeBoatRotationOffsetDeg(int i) {
        if (i == 0) {
            return this.getFirstFakeBoatRotationOffsetDeg();
        }
        if (i == 1) {
            return this.getSecondFakeBoatRotationOffsetDeg();
        }
        return this.getThirdFakeBoatRotationOffsetDeg();
    }

    public double getFirstFakeBoatRotationOffsetDeg() {
        if (this.boatOffsetDeg.length < 1) {
            return 0.0;
        }
        return this.boatOffsetDeg[0];
    }

    public double getSecondFakeBoatRotationOffsetDeg() {
        if (this.boatOffsetDeg.length > 1) {
            return this.boatOffsetDeg[1];
        }
        return this.getFirstFakeBoatRotationOffsetDeg();
    }

    public double getThirdFakeBoatRotationOffsetDeg() {
        if (this.boatOffsetDeg.length > 2) {
            return this.boatOffsetDeg[2];
        }
        return this.getSecondFakeBoatRotationOffsetDeg();
    }

    public double getNumFakeBoats() {
        if (!this.hasFakeBoat()) {
            return 0.0;
        }
        if (!this.hasExtraFakeBoats()) {
            return 1.0;
        }
        return 3.0;
    }

    public boolean hasExtraFakeBoats() {
        return this.fakeBoat2 != null;
    }

    public boolean hasFakeBoat() {
        return this.fakeBoat != null;
    }

    public EntityBoat getFakeBoat(int i) {
        if (i == 0) {
            return this.getFakeBoat();
        }
        if (i == 1) {
            return this.getFakeBoat2();
        }
        return this.getFakeBoat3();
    }

    public EntityBoat getFakeBoat() {
        return this.fakeBoat;
    }

    public EntityBoat getFakeBoat2() {
        return this.fakeBoat2;
    }

    public EntityBoat getFakeBoat3() {
        return this.fakeBoat3;
    }

    public EntityArrow getFakeArrow() {
        return this.fakeArrow;
    }

    public EntityArrow getFakeArrow2() {
        return this.fakeArrow2;
    }

    public EntityArrow getFakeArrow3() {
        return this.fakeArrow3;
    }

    public EntityArrow getFakeArrow4() {
        return this.fakeArrow4;
    }

    public boolean doesKnowAboutFakeEntities(Player p) {
        return this.playersKnowAboutFakeEntities.contains(p.getName());
    }

    public void setKnowAboutFakeEntities(Player p, boolean b) {
        if (b) {
            this.playersKnowAboutFakeEntities.add(p.getName());
        } else {
            this.playersKnowAboutFakeEntities.remove(p.getName());
        }
    }

    public EnumInteractionResult a(EntityHuman entityhuman, Vec3D vec3d, EnumHand hand) {
        if ((double)this.ce.getPassengers().size() < this.ce.getMaxPassengers()) {
            this.ce.addPassenger((Entity)entityhuman.getBukkitEntity());
        }
        return EnumInteractionResult.FAIL;
    }

    public void collide(net.minecraft.server.v1_12_R1.Entity entity) {
        if (this.passengers.size() > 0 && entity.equals(this.passengers.get(0))) {
            return;
        }
        CraftHoverCart vehicle = this.getHoverCartEntity();
        CraftEntity hitEntity = entity == null ? null : entity.getBukkitEntity();
        VehicleEntityCollisionEvent collisionEvent = new VehicleEntityCollisionEvent((Vehicle)vehicle, (Entity)hitEntity);
        this.world.getServer().getPluginManager().callEvent((Event)collisionEvent);
        if (collisionEvent.isCancelled()) {
            return;
        }
        super.collide(entity);
    }

    public void Y() {
        double prevX = this.locX;
        double prevY = this.locY;
        double prevZ = this.locZ;
        float prevYaw = this.yaw;
        float prevPitch = this.pitch;
        super.Y();
        CraftWorld bworld = this.world.getWorld();
        Location from = new Location((World)bworld, prevX, prevY, prevZ, prevYaw, prevPitch);
        Location to = new Location((World)bworld, this.locX, this.locY, this.locZ, this.yaw, this.pitch);
        CraftHoverCart vehicle = this.getHoverCartEntity();
        this.world.getServer().getPluginManager().callEvent((Event)new VehicleUpdateEvent((Vehicle)vehicle));
        if (!from.equals((Object)to)) {
            this.world.getServer().getPluginManager().callEvent((Event)new VehicleMoveEvent((Vehicle)vehicle, from, to));
        }
        this.setSize();
    }

    public void die() {
        CraftHoverCart vehicle = this.getHoverCartEntity();
        CraftEntity passenger = this.damagesource == null || this.damagesource.getEntity() == null ? null : this.damagesource.getEntity().getBukkitEntity();
        VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent((Vehicle)vehicle, (Entity)passenger);
        this.world.getServer().getPluginManager().callEvent((Event)destroyEvent);
        super.die();
    }

    public boolean damageEntity(DamageSource damagesource, float f) {
        this.damagesource = damagesource;
        CraftHoverCart vehicle = this.getHoverCartEntity();
        CraftEntity passenger = damagesource.getEntity() == null ? null : damagesource.getEntity().getBukkitEntity();
        VehicleDamageEvent event = new VehicleDamageEvent((Vehicle)vehicle, (Entity)passenger, (double)f);
        this.world.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        return super.damageEntity(damagesource, f);
    }

    public CraftHoverCart getBukkitEntity() {
        return this.getHoverCartEntity();
    }

    public void setYaw(float yaw) {
        this.setYawPitch(yaw, this.pitch);
    }

    public void setPitch(float pitch) {
        this.setYawPitch(this.yaw, pitch);
    }

    public void setYawPitch(float yaw, float pitch) {
        super.setYawPitch(yaw, pitch);
    }

    public CraftHoverCart getHoverCartEntity() {
        if (this.ce == null) {
            this.ce = new CraftHoverCart(this.world.getServer(), this);
        }
        return this.ce;
    }

    public static void register() {
        CustomEntityHandler.registerEntity("ArmorStand", 30, EntityArmorStand.class, HoverCartEntity.class);
    }

    protected void cB() {
        List list = this.world.getEntities((net.minecraft.server.v1_12_R1.Entity)this, this.getBoundingBox());
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                net.minecraft.server.v1_12_R1.Entity entity = (net.minecraft.server.v1_12_R1.Entity)list.get(i);
                if (!(entity instanceof EntityMinecartAbstract) && (!(entity instanceof HoverCartEntity) || !(this.h(entity) <= 0.2))) continue;
                entity.collide((net.minecraft.server.v1_12_R1.Entity)this);
            }
        }
    }

    public double getHeightOffset() {
        return this.heightOffset;
    }

    public void setHeightOffset(double heightOffset) {
        this.heightOffset = heightOffset;
    }
}

