/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.presets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.stormdev.uPlanes.main.ItemStackFromId;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.presets.BoatPreset;
import net.stormdev.uPlanes.presets.PlanePreset;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.material.MaterialData;

public class PresetManager {
    public static boolean usePresets = false;
    public static boolean disableItemRenaming = false;
    private List<PlanePreset> presets = new ArrayList<PlanePreset>();
    private List<BoatPreset> boatPresets = new ArrayList<BoatPreset>();
    private Random random = new Random();

    public PresetManager() {
        this.init();
    }

    public List<BoatPreset> getBoatPresets() {
        return new ArrayList<BoatPreset>(this.boatPresets);
    }

    public BoatPreset getRandomBoatPreset() {
        return this.boatPresets.get(this.random.nextInt(this.boatPresets.size()));
    }

    public List<PlanePreset> getPresets() {
        return new ArrayList<PlanePreset>(this.presets);
    }

    public PlanePreset getRandomPreset() {
        return this.presets.get(this.random.nextInt(this.presets.size()));
    }

    private void init() {
        double turnAmountPerTick;
        double accelMod;
        double health;
        double speed;
        String name;
        ConfigurationSection sect;
        if (!main.config.contains("general.planes.presets.enable")) {
            main.config.set("general.planes.presets.enable", (Object)true);
        }
        if (!main.config.contains("general.planes.presets.disableItemRename")) {
            main.config.set("general.planes.presets.disableItemRename", (Object)true);
        }
        usePresets = main.config.getBoolean("general.planes.presets.enable");
        disableItemRenaming = main.config.getBoolean("general.planes.presets.disableItemRename");
        ConfigurationSection presets = main.config.getConfigurationSection("general.planes.presets.types");
        ConfigurationSection boatPresets = main.config.getConfigurationSection("general.planes.presets.boatTypes");
        if (presets == null) {
            presets = main.config.createSection("general.planes.presets.types");
            presets.set("superjet.name", (Object)"Fast Jet");
            presets.set("superjet.speed", (Object)50);
            presets.set("superjet.health", (Object)75);
            presets.set("superjet.acceleration", (Object)20);
            presets.set("superjet.handling", (Object)15);
            presets.set("superjet.cost", (Object)200);
            presets.set("jet.name", (Object)"Jet");
            presets.set("jet.speed", (Object)40);
            presets.set("jet.health", (Object)75);
            presets.set("jet.acceleration", (Object)15);
            presets.set("jet.handling", (Object)10);
            presets.set("jet.cost", (Object)150);
            presets.set("lightaircraft.name", (Object)"Piper");
            presets.set("lightaircraft.speed", (Object)25);
            presets.set("lightaircraft.health", (Object)40);
            presets.set("lightaircraft.acceleration", (Object)7);
            presets.set("lightaircraft.handling", (Object)5);
            presets.set("lightaircraft.cost", (Object)60);
            presets.set("attackchopper.name", (Object)"Attack Chopper");
            presets.set("attackchopper.speed", (Object)35);
            presets.set("attackchopper.health", (Object)100);
            presets.set("attackchopper.acceleration", (Object)10);
            presets.set("attackchopper.handling", (Object)10);
            presets.set("attackchopper.hover", (Object)true);
            presets.set("attackchopper.cost", (Object)150);
        }
        if (boatPresets == null) {
            boatPresets = main.config.createSection("general.planes.presets.boatTypes");
            boatPresets.set("boat1.name", (Object)"Boat");
            boatPresets.set("boat1.speed", (Object)50);
            boatPresets.set("boat1.health", (Object)75);
            boatPresets.set("boat1.acceleration", (Object)20);
            boatPresets.set("boat1.handling", (Object)15);
            boatPresets.set("boat1.cost", (Object)200);
        }
        this.presets.clear();
        this.boatPresets.clear();
        Set presetIDs = presets.getKeys(false);
        for (String id : presetIDs) {
            try {
                boolean hoverMidair;
                sect = presets.getConfigurationSection(id);
                name = sect.getString("name");
                speed = sect.getDouble("speed");
                health = sect.getDouble("health");
                accelMod = sect.getDouble("acceleration") / 10.0;
                turnAmountPerTick = sect.getDouble("handling") / 10.0;
                boolean hover = sect.contains("hover") ? sect.getBoolean("hover") : false;
                boolean bl = hoverMidair = sect.contains("planeHover") ? sect.getBoolean("planeHover") : false;
                if (sect.contains("helicopter")) {
                    hoverMidair = hover;
                    hover = sect.getBoolean("helicopter");
                }
                double cost = sect.getDouble("cost");
                if (name == null || speed <= 0.0 || health <= 0.0 || accelMod <= 0.0 || turnAmountPerTick <= 0.0) {
                    throw new Exception("INVALID plane preset " + id);
                }
                MaterialData displayBlock = null;
                double displayOffset2 = 0.0;
                if (sect.contains("display")) {
                    try {
                        displayBlock = ItemStackFromId.get(sect.getString("display")).getData();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sect.contains("displayOffset")) {
                    displayOffset2 = sect.getDouble("displayOffset");
                }
                float hitBoxX = -1.0f;
                float hitBoxZ = -1.0f;
                if (sect.contains("hitbox.x")) {
                    hitBoxX = (float)sect.getDouble("hitbox.x");
                }
                if (sect.contains("hitbox.z")) {
                    hitBoxZ = (float)sect.getDouble("hitbox.z");
                }
                if (!sect.contains("passengers.max")) {
                    sect.set("passengers.max", (Object)1);
                }
                if (!sect.contains("passengers.boatRotationOffsetDeg")) {
                    sect.set("passengers.boatRotationOffsetDeg", Arrays.asList(new double[][]{{0.0}}));
                }
                PlanePreset pp = new PlanePreset(id, speed, name, health, accelMod, turnAmountPerTick, hover, cost, displayBlock, displayOffset2, hitBoxX, hitBoxZ, hoverMidair);
                pp.setMaxPassengers(sect.getInt("passengers.max"));
                pp.setBoatRotationOffsetDeg(ArrayUtils.toPrimitive((Double[])sect.getDoubleList("passengers.boatRotationOffsetDeg").toArray(new Double[0])));
                this.presets.add(pp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String id : boatPresets.getKeys(false)) {
            try {
                sect = boatPresets.getConfigurationSection(id);
                name = sect.getString("name");
                speed = sect.getDouble("speed");
                health = sect.getDouble("health");
                accelMod = sect.getDouble("acceleration") / 10.0;
                turnAmountPerTick = sect.getDouble("handling") / 3.0;
                double cost = sect.getDouble("cost");
                if (name == null || speed <= 0.0 || health <= 0.0 || accelMod <= 0.0 || turnAmountPerTick <= 0.0) {
                    throw new Exception("INVALID boat preset " + id);
                }
                MaterialData displayBlock = null;
                double displayOffset = 0.0;
                if (sect.contains("display")) {
                    try {
                        displayBlock = ItemStackFromId.get(sect.getString("display")).getData();
                    }
                    catch (Exception displayOffset2) {
                        // empty catch block
                    }
                }
                if (sect.contains("displayOffset")) {
                    displayOffset = sect.getDouble("displayOffset");
                }
                float hitBoxX = -1.0f;
                float hitBoxZ = -1.0f;
                if (sect.contains("hitbox.x")) {
                    hitBoxX = (float)sect.getDouble("hitbox.x");
                }
                if (sect.contains("hitbox.z")) {
                    hitBoxZ = (float)sect.getDouble("hitbox.z");
                }
                if (!sect.contains("passengers.max")) {
                    sect.set("passengers.max", (Object)1);
                }
                if (!sect.contains("passengers.boatRotationOffsetDeg")) {
                    sect.set("passengers.boatRotationOffsetDeg", Arrays.asList(new double[][]{{0.0}}));
                }
                if (!sect.contains("mass")) {
                    sect.set("mass", (Object)1000.0);
                }
                BoatPreset pp = new BoatPreset(id, speed, name, health, accelMod, turnAmountPerTick, cost, displayBlock, displayOffset, hitBoxX, hitBoxZ);
                pp.setMass(sect.getDouble("mass"));
                pp.setMaxPassengers(sect.getInt("passengers.max"));
                pp.setBoatRotationOffsetDeg(ArrayUtils.toPrimitive((Double[])sect.getDoubleList("passengers.boatRotationOffsetDeg").toArray(new Double[0])));
                this.boatPresets.add(pp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (usePresets && this.presets.size() < 1 && this.boatPresets.size() < 1) {
            usePresets = false;
        }
    }
}

