/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.items;

import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.stormdev.uPlanes.api.Plane;
import net.stormdev.uPlanes.presets.PlanePreset;
import net.stormdev.uPlanes.utils.Colors;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemPlaneValidation {
    public static Plane getPlane(ItemStack item) {
        Plane c;
        if (item == null) {
            return null;
        }
        ItemMeta im = item.getItemMeta();
        if (im == null || im.getLore() == null) {
            return null;
        }
        List lore = im.getLore();
        String name = im.getDisplayName();
        if (name == null || name.equalsIgnoreCase("null")) {
            name = "Plane";
        }
        if ((c = ItemPlaneValidation.getPlaneFromLore(im.getDisplayName(), lore)) == null) {
            return null;
        }
        PlanePreset preset = c.getPreset();
        if (preset != null && preset.canPlaneHoverMidair()) {
            c.setCanPlaneHover(true);
        }
        return c;
    }

    public static Plane getPlaneFromLore(String name, List<String> lore) {
        if (lore.size() < 3) {
            return null;
        }
        int i = 0;
        boolean isHeli = false;
        if (!Colors.strip(lore.get(i)).toLowerCase().contains("[speed:]")) {
            String firstLine = Colors.strip(lore.get(i)).toLowerCase();
            if (firstLine.equalsIgnoreCase("helicopter")) {
                isHeli = true;
            }
            if (!firstLine.equalsIgnoreCase("plane") && !firstLine.equalsIgnoreCase("helicopter")) {
                return null;
            }
            if (!firstLine.equalsIgnoreCase("plane") && !firstLine.equalsIgnoreCase("helicopter")) {
                try {
                    UUID.fromString(firstLine);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (!Colors.strip(lore.get(i = 1)).toLowerCase().contains("[speed:]")) {
                return null;
            }
        }
        double speed = 1.0;
        double health = 50.0;
        boolean hover = false;
        String line = Colors.strip(lore.get(i)).toLowerCase();
        String speedRaw = line.replaceFirst(Pattern.quote("[speed:] "), "").trim();
        try {
            speed = Double.parseDouble(speedRaw);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        line = Colors.strip(lore.get(++i)).toLowerCase();
        String healthRaw = line.replaceFirst(Pattern.quote("[health:] "), "").trim();
        try {
            health = Double.parseDouble(healthRaw);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (++i >= lore.size()) {
            return new Plane(speed, name, health, 1.0, 2.0, isHeli, isHeli ? true : hover);
        }
        line = Colors.strip(lore.get(i)).toLowerCase();
        if (!line.contains("hover")) {
            if (!line.contains("acceleration")) {
                return null;
            }
            try {
                String accelRaw = line.replaceFirst(Pattern.quote("[acceleration:] "), "").trim();
                double accelMod = Double.parseDouble(accelRaw) / 10.0;
                line = Colors.strip(lore.get(++i)).toLowerCase();
                if (!line.contains("handling")) {
                    return null;
                }
                String hRaw = line.replaceAll(Pattern.quote("[handling:] "), "").trim();
                double turnAmount = Double.parseDouble(hRaw) / 10.0;
                if (++i >= lore.size()) {
                    return new Plane(speed, name, health, accelMod, turnAmount, isHeli, false);
                }
                line = Colors.strip(lore.get(i)).toLowerCase();
                String hoverRaw = line.replaceFirst(Pattern.quote("[hover:] "), "").trim();
                if (hoverRaw.equalsIgnoreCase("Yes")) {
                    hover = true;
                }
                return new Plane(speed, name, health, accelMod, turnAmount, isHeli, hover);
            }
            catch (Exception e) {
                return null;
            }
        }
        String handlingRaw = line.replaceFirst(Pattern.quote("[hover:] "), "").trim();
        if (handlingRaw.equalsIgnoreCase("Yes")) {
            hover = true;
        }
        return new Plane(speed, name, health, 1.0, 2.0, isHeli, hover);
    }
}

