/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.commands;

import java.util.List;
import java.util.UUID;
import net.stormdev.uPlanes.api.Plane;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.utils.Colors;
import net.stormdev.uPlanes.utils.Lang;
import net.stormdev.uPlanes.utils.PEntityMeta;
import net.stormdev.uPlanes.utils.StatValue;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.plugin.Plugin;

public class AutoPilotCommandExecutor
implements CommandExecutor {
    private Boolean autoPilotEnabled = main.config.getBoolean("general.planes.autopilot");

    public boolean onCommand(CommandSender sender, Command cmd, String alias, String[] args) {
        if (!this.autoPilotEnabled.booleanValue()) {
            sender.sendMessage(main.colors.getError() + Lang.get("general.disabled.msg"));
            return true;
        }
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (cmd.getName().equalsIgnoreCase("destination")) {
            if (player == null) {
                sender.sendMessage(main.colors.getError() + Lang.get("general.playersOnly"));
                return true;
            }
            if (args.length < 1) {
                return false;
            }
            String name = args[0];
            for (int i = 1; i < args.length; ++i) {
                name = name + " " + args[i];
            }
            Entity vehicle = player.getVehicle();
            UUID id = vehicle != null ? vehicle.getUniqueId() : UUID.randomUUID();
            Plane plane = main.plugin.planeManager.getPlane(id);
            if (vehicle == null || !(vehicle instanceof Vehicle) || plane == null) {
                sender.sendMessage(main.colors.getError() + Lang.get("general.cmd.destinations.notInPlane"));
                return true;
            }
            if (!plane.isHover()) {
                sender.sendMessage(main.colors.getError() + "Autopilot requires being in a helicopter!");
                return true;
            }
            Location destination = main.plugin.destinationManager.getLocation(name, main.plugin.getServer());
            if (destination == null) {
                sender.sendMessage(main.colors.getError() + Lang.get("general.cmd.destinations.invalid"));
                return true;
            }
            if (destination.getWorld() != player.getWorld()) {
                sender.sendMessage(main.colors.getError() + Lang.get("general.cmd.destinations.wrongWorld"));
                return true;
            }
            PEntityMeta.removeMetadata(vehicle, "plane.destination");
            PEntityMeta.setMetadata(vehicle, "plane.destination", new StatValue(destination, (Plugin)main.plugin));
            sender.sendMessage(main.colors.getSuccess() + Lang.get("general.cmd.destinations.go"));
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("destinations")) {
            List<String> dests = main.plugin.destinationManager.getDestinationsList();
            String title = main.colors.getTitle() + "Available Destinations:";
            String msg = "";
            for (String s : dests) {
                if (msg.length() < 1) {
                    msg = Colors.colorise(s);
                    continue;
                }
                msg = msg + ", " + main.colors.getInfo() + Colors.colorise(s);
            }
            sender.sendMessage(title);
            sender.sendMessage(main.colors.getInfo() + msg);
            return true;
        }
        return false;
    }
}

