/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.main;

import net.stormdev.uPlanes.api.Plane;
import net.stormdev.uPlanes.api.uPlanesAPI;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.utils.PEntityMeta;
import net.stormdev.uPlanes.utils.StatValue;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.plugin.Plugin;

public class AccelerationManager {
    public static final String ACCEL_META = "uPlanes.accel";

    public static void lastAccelTimeNow(Vehicle cart) {
        AccelerationManager.getMeta(cart).setTime(System.currentTimeMillis());
    }

    private static AccelMeta getMeta(Vehicle cart) {
        if (!PEntityMeta.hasMetadata((Entity)cart, ACCEL_META)) {
            AccelMeta am = new AccelMeta(0.0);
            PEntityMeta.setMetadata((Entity)cart, ACCEL_META, new StatValue(am, (Plugin)main.plugin));
            return am;
        }
        try {
            return (AccelMeta)PEntityMeta.getMetadata((Entity)cart, ACCEL_META).get(0).value();
        }
        catch (Exception e) {
            PEntityMeta.removeMetadata((Entity)cart, ACCEL_META);
            AccelMeta am = new AccelMeta(0.0);
            PEntityMeta.setMetadata((Entity)cart, ACCEL_META, new StatValue(am, (Plugin)main.plugin));
            return am;
        }
    }

    private static double getCurrentAccel(Vehicle cart) {
        AccelMeta am = AccelerationManager.getMeta(cart);
        return am.getCurrent();
    }

    public static void setCurrentAccel(Vehicle cart, double accel) {
        AccelerationManager.getMeta(cart).setCurrent(accel);
    }

    private static float getA(Player player, Vehicle cart, Plane plane) {
        float d = 1.0f;
        if (PEntityMeta.hasMetadata((Entity)cart, "plane.destination")) {
            d = 1.2f;
        }
        if (player == null) {
            return d * 0.02f;
        }
        return (float)((double)d * 0.02 * uPlanesAPI.getPlaneManager().getAlteredAccelerationMod(player, cart, plane));
    }

    private static float getDA(Player player, Vehicle cart, Plane plane) {
        if (player == null) {
            return 0.03f;
        }
        return (float)(0.03 * uPlanesAPI.getPlaneManager().getAlteredDecelerationMod(player, cart, plane));
    }

    private static float getGA(Player player, Vehicle cart, Plane plane) {
        if (player == null) {
            return 0.02f;
        }
        return (float)(0.02 * uPlanesAPI.getPlaneManager().getAlteredDecelerationMod(player, cart, plane));
    }

    public static long getTimeSinceLastKeypress(Vehicle cart) {
        return System.currentTimeMillis() - AccelerationManager.getMeta(cart).getTime();
    }

    public static double stall(Player player, Vehicle cart, Plane plane) {
        if (!main.doAcceleration) {
            return 1.0;
        }
        double accel = AccelerationManager.getCurrentAccel(cart);
        AccelerationManager.setCurrentAccel(cart, accel *= 0.25);
        return accel;
    }

    public static double decelerateAndGetMult(Player player, Vehicle cart, Plane plane) {
        if (!main.doAcceleration) {
            return 1.0;
        }
        double current = AccelerationManager.getCurrentAccel(cart);
        float diff = 0.2f;
        if ((current -= plane.getAccelMod() * (double)AccelerationManager.getDA(player, cart, plane) * (double)diff) <= 0.05) {
            current = 0.0;
        }
        AccelerationManager.setCurrentAccel(cart, current);
        return current;
    }

    public static double glideAndGetMult(Player player, Vehicle cart, Plane plane) {
        if (!main.doAcceleration) {
            return 1.0;
        }
        double current = AccelerationManager.getCurrentAccel(cart);
        float diff = (float)(1.0 - current);
        if ((double)diff > 0.99) {
            diff = 0.99f;
        }
        if ((current -= (double)(AccelerationManager.getGA(player, cart, plane) * diff)) <= 0.05) {
            current = 0.0;
        }
        AccelerationManager.setCurrentAccel(cart, current);
        return current;
    }

    public static double getCurrentMultiplier(Vehicle cart) {
        if (!main.doAcceleration) {
            return 1.0;
        }
        return AccelerationManager.getCurrentAccel(cart);
    }

    public static double getMultiplier(Player player, Vehicle cart, Plane plane, boolean speedLocked) {
        if (!main.doAcceleration) {
            return 1.0;
        }
        double current = AccelerationManager.getCurrentAccel(cart);
        if (current >= 0.97 && current != 1.0) {
            current = 1.0;
            AccelerationManager.setCurrentAccel(cart, 1.0);
            return current;
        }
        if (speedLocked || current == 1.0) {
            return current;
        }
        float diff = 0.2f;
        AccelerationManager.setCurrentAccel(cart, current += plane.getAccelMod() * (double)AccelerationManager.getA(player, cart, plane) * (double)diff);
        return current;
    }

    public static class AccelMeta {
        private double current = 0.0;
        private long time = 0L;

        public AccelMeta(double accel) {
            this.setCurrent(accel);
            this.setTime(System.currentTimeMillis());
        }

        public double getCurrent() {
            this.time = System.currentTimeMillis();
            return this.current;
        }

        public void setCurrent(double current) {
            this.time = System.currentTimeMillis();
            this.current = current;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

