/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.presets;

import java.io.Serializable;
import java.util.ArrayList;
import net.stormdev.uPlanes.api.Boat;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.presets.uPlanesVehiclePresetBase;
import net.stormdev.uPlanes.utils.Colors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class BoatPreset
extends uPlanesVehiclePresetBase<Boat>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double mass = 1000.0;

    public BoatPreset(String presetID, double speed, String name, double health, double accelMod, double turnAmountPerTick, double cost, MaterialData displayBlock, double offset, float hitBoxX, float hitBoxZ) {
        super(presetID, speed, name, health, accelMod, turnAmountPerTick, cost, displayBlock, offset, hitBoxX, hitBoxZ);
    }

    public Boat toBoat() {
        Boat p = new Boat(this.getSpeed(), this.getName(), this.getHealth(), this.getAccelMod(), this.getTurnAmountPerTick());
        p.setMass(this.mass);
        p.setCartDisplayBlock(this.getDisplayBlock());
        p.setDisplayOffset(this.getDisplayOffset());
        return p;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    @Override
    public Boat toVehicle() {
        return this.toBoat();
    }

    @Override
    public ItemStack toItemStack() {
        ItemStack stack;
        if (main.config.getBoolean("general.planes.renderAsModelledBlockWhenExist") && this.getDisplayBlock() != null) {
            MaterialData md = this.getDisplayBlock();
            stack = new ItemStack(md.getItemType());
            stack.setData(md);
        } else {
            stack = new ItemStack(Material.MINECART);
        }
        ArrayList<String> lore = new ArrayList<String>();
        ItemMeta meta = stack.getItemMeta();
        lore.add(ChatColor.GRAY + "boat");
        lore.add(main.colors.getTitle() + "[Speed:] " + main.colors.getInfo() + this.mutliplier);
        lore.add(main.colors.getTitle() + "[Health:] " + main.colors.getInfo() + this.health);
        lore.add(main.colors.getTitle() + "[Acceleration:] " + main.colors.getInfo() + this.accelMod * 10.0);
        lore.add(main.colors.getTitle() + "[Handling:] " + main.colors.getInfo() + this.turnAmount * 10.0);
        meta.setDisplayName(Colors.colorise(this.name));
        meta.setLore(lore);
        stack.setItemMeta(meta);
        return stack;
    }

    @Override
    public String[] getSellLore() {
        String currency = main.config.getString("general.currencySign");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(main.colors.getTitle() + "[Price:] " + main.colors.getInfo() + currency + this.cost);
        lore.add(main.colors.getTitle() + "[Speed:] " + main.colors.getInfo() + this.mutliplier);
        lore.add(main.colors.getTitle() + "[Health:] " + main.colors.getInfo() + this.health);
        lore.add(main.colors.getTitle() + "[Acceleration:] " + main.colors.getInfo() + this.accelMod * 10.0);
        lore.add(main.colors.getTitle() + "[Handling:] " + main.colors.getInfo() + this.turnAmount * 10.0);
        return lore.toArray(new String[0]);
    }
}

