/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.utils.Colors;
import net.stormdev.uPlanes.utils.SerializableLocation;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DestinationManager {
    private ConcurrentHashMap<String, SerializableLocation> destinations = new ConcurrentHashMap();
    private File saveFile;

    public DestinationManager(File saveFile) {
        this.saveFile = saveFile;
        this.load();
    }

    public Location getLocation(String destination, Server server) {
        SerializableLocation sl = this.destinations.get(this.getCorrectName(destination));
        if (sl == null) {
            return null;
        }
        Location l = sl.getLocation(server);
        return l;
    }

    public Boolean locationExists(String destination) {
        return this.destinations.containsKey(this.getCorrectName(destination));
    }

    public List<String> getDestinationsList() {
        return new ArrayList<String>(this.destinations.keySet());
    }

    public ConcurrentHashMap<String, SerializableLocation> getDestinations() {
        return this.destinations;
    }

    public String getCorrectName(String name) {
        if (!this.destinations.containsKey(name)) {
            for (String dest : this.getDestinationsList()) {
                if (!ChatColor.stripColor((String)Colors.colorise(dest)).equalsIgnoreCase(name)) continue;
                name = dest;
            }
        }
        return name;
    }

    public synchronized void setDestination(String name, Location loc) {
        this.destinations.put(name, new SerializableLocation(loc));
        this.asyncSave();
    }

    public synchronized void delDestination(String name) {
        if (!this.destinations.containsKey(name)) {
            for (String dest : this.getDestinationsList()) {
                if (!ChatColor.stripColor((String)Colors.colorise(dest)).equalsIgnoreCase(name)) continue;
                name = dest;
            }
        }
        this.destinations.remove(name);
        this.asyncSave();
    }

    public void asyncSave() {
        main.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)main.plugin, new BukkitRunnable(){

            public void run() {
                DestinationManager.this.save();
            }
        });
    }

    public void load() {
        this.saveFile.getParentFile().mkdirs();
        if (!this.saveFile.exists() || this.saveFile.length() < 1L) {
            try {
                this.saveFile.createNewFile();
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.destinations = DestinationManager.loadHashMap(this.saveFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.destinations = null;
            }
        }
        if (this.destinations == null) {
            this.destinations = new ConcurrentHashMap();
        }
    }

    private void save() {
        this.saveFile.getParentFile().mkdirs();
        if (!this.saveFile.exists() || this.saveFile.length() < 1L) {
            try {
                this.saveFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DestinationManager.saveHashMap(this.destinations, this.saveFile.getAbsolutePath());
    }

    public static void saveHashMap(ConcurrentHashMap<String, SerializableLocation> map, String path) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));
            oos.writeObject(map);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ConcurrentHashMap<String, SerializableLocation> loadHashMap(String path) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
            Object result = ois.readObject();
            ois.close();
            try {
                return (ConcurrentHashMap)result;
            }
            catch (Exception e) {
                return new ConcurrentHashMap<String, SerializableLocation>();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

