/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.utils;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.utils.PMeta;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PEntityMeta {
    private static volatile Map<UUID, Object> entityMetaObjs = new ConcurrentHashMap<UUID, Object>(100, 0.75f, 2);
    private static volatile Map<UUID, WeakReference<Entity>> entityObjs = new ConcurrentHashMap<UUID, WeakReference<Entity>>(100, 0.75f, 2);
    public static boolean USING_UCARS = false;

    public static void cleanEntityObjs() {
        try {
            Class<?> uEntityMetaClass = Class.forName("com.useful.ucars.util.UEntityMeta");
            USING_UCARS = true;
            Method method = uEntityMetaClass.getDeclaredMethod("cleanEntityObjs", new Class[0]);
            method.invoke(null, new Object[0]);
            return;
        }
        catch (Exception e) {
            if (Bukkit.getServer().getPluginManager().getPlugin("uCars") != null) {
                e.printStackTrace();
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

                @Override
                public void run() {
                    for (UUID entID : new ArrayList(entityObjs.keySet())) {
                        WeakReference val = (WeakReference)entityObjs.get(entID);
                        if (val == null || val.get() != null) continue;
                        entityObjs.remove(entID);
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setEntityObj(Entity e) {
        Map<UUID, WeakReference<Entity>> map = entityObjs;
        synchronized (map) {
            entityObjs.put(e.getUniqueId(), new WeakReference<Entity>(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delEntityObj(Entity e) {
        Map<UUID, WeakReference<Entity>> map = entityObjs;
        synchronized (map) {
            entityObjs.remove(e.getUniqueId());
        }
    }

    public static void removeAllMeta(Entity e) {
        try {
            Class<?> uEntityMetaClass = Class.forName("com.useful.ucars.util.UEntityMeta");
            USING_UCARS = true;
            Method method = uEntityMetaClass.getDeclaredMethod("removeAllMeta", Entity.class);
            method.invoke(null, e);
            return;
        }
        catch (Exception e1) {
            if (Bukkit.getServer().getPluginManager().getPlugin("uCars") != null) {
                e1.printStackTrace();
            }
            Object o = entityMetaObjs.get(e.getUniqueId());
            entityMetaObjs.remove(e.getUniqueId());
            PEntityMeta.delEntityObj(e);
            if (o != null) {
                PMeta.removeAllMeta(o);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getMetaObj(Entity e) {
        if (e == null) {
            return null;
        }
        try {
            Class<?> uEntityMetaClass = Class.forName("com.useful.ucars.util.UEntityMeta");
            USING_UCARS = true;
            Method method = uEntityMetaClass.getDeclaredMethod("getMetaObj", Entity.class);
            return method.invoke(null, e);
        }
        catch (Exception e1) {
            if (Bukkit.getServer().getPluginManager().getPlugin("uCars") != null) {
                e1.printStackTrace();
            }
            Map<UUID, Object> map = entityMetaObjs;
            synchronized (map) {
                Object obj = entityMetaObjs.get(e.getUniqueId());
                if (obj == null) {
                    obj = new Object();
                    entityMetaObjs.put(e.getUniqueId(), obj);
                    PEntityMeta.setEntityObj(e);
                }
                return obj;
            }
        }
    }

    public static void setMetadata(Entity entity, String metaKey, MetadataValue value) {
        try {
            Class<?> uEntityMetaClass = Class.forName("com.useful.ucars.util.UEntityMeta");
            USING_UCARS = true;
            Method method = uEntityMetaClass.getDeclaredMethod("setMetadata", Entity.class, String.class, MetadataValue.class);
            method.invoke(null, entity, metaKey, value);
            return;
        }
        catch (Exception e) {
            if (Bukkit.getServer().getPluginManager().getPlugin("uCars") != null) {
                e.printStackTrace();
            }
            PEntityMeta.setEntityObj(entity);
            PMeta.getMeta(PEntityMeta.getMetaObj(entity), metaKey).add(value);
            return;
        }
    }

    public static List<MetadataValue> getMetadata(Entity entity, String metaKey) {
        try {
            Class<?> uEntityMetaClass = Class.forName("com.useful.ucars.util.UEntityMeta");
            USING_UCARS = true;
            Method method = uEntityMetaClass.getDeclaredMethod("getMetadata", Entity.class, String.class);
            return (List)method.invoke(null, entity, metaKey);
        }
        catch (Exception e) {
            if (Bukkit.getServer().getPluginManager().getPlugin("uCars") != null) {
                e.printStackTrace();
            }
            return PMeta.getAllMeta(PEntityMeta.getMetaObj(entity)).get(metaKey);
        }
    }

    public static boolean hasMetadata(Entity entity, String metaKey) {
        try {
            Class<?> uEntityMetaClass = Class.forName("com.useful.ucars.util.UEntityMeta");
            USING_UCARS = true;
            Method method = uEntityMetaClass.getDeclaredMethod("hasMetadata", Entity.class, String.class);
            return (Boolean)method.invoke(null, entity, metaKey);
        }
        catch (Exception e) {
            if (Bukkit.getServer().getPluginManager().getPlugin("uCars") != null) {
                e.printStackTrace();
            }
            return PMeta.getAllMeta(PEntityMeta.getMetaObj(entity)).containsKey(metaKey);
        }
    }

    public static void removeMetadata(Entity entity, String metaKey) {
        try {
            Class<?> uEntityMetaClass = Class.forName("com.useful.ucars.util.UEntityMeta");
            USING_UCARS = true;
            Method method = uEntityMetaClass.getDeclaredMethod("removeMetadata", Entity.class, String.class);
            method.invoke(null, entity, metaKey);
            return;
        }
        catch (Exception e) {
            if (Bukkit.getServer().getPluginManager().getPlugin("uCars") != null) {
                e.printStackTrace();
            }
            PMeta.removeMeta(PEntityMeta.getMetaObj(entity), metaKey);
            return;
        }
    }
}

