/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.guis;

import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class IconMenu
implements Listener,
InventoryHolder {
    private String name;
    private int size;
    private OptionClickEventHandler handler;
    private Plugin plugin;
    private String[] optionNames;
    private ItemStack[] optionIcons;
    private Boolean enabled = true;
    private String metaData;
    private boolean destroyOnClose = false;
    private UUID selfID = UUID.randomUUID();

    public IconMenu(String name, int size, OptionClickEventHandler handler, Plugin plugin) {
        this.name = name;
        this.size = size;
        this.handler = handler;
        this.plugin = plugin;
        this.optionNames = new String[size];
        this.optionIcons = new ItemStack[size];
        this.metaData = "menu." + UUID.randomUUID().toString();
        if (this.plugin == null) {
            System.out.println("UH OH Plugin null in iconmenu = memory leak");
        }
    }

    public IconMenu(String name, int size, OptionClickEventHandler handler, Plugin plugin, boolean destroyOnClose) {
        this(name, size, handler, plugin);
        this.destroyOnClose = destroyOnClose;
    }

    public IconMenu setOption(int position, ItemStack icon, String name, String ... info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = this.setItemNameAndLore(icon, name, info);
        return this;
    }

    public IconMenu appendOption(ItemStack icon, String name, List<String> info) {
        int position;
        int i = position = 0;
        while (position < this.optionIcons.length) {
            try {
                if (this.optionIcons[i] == null) {
                }
            }
            catch (Exception e) {}
            break;
            ++position;
            ++i;
        }
        this.optionNames[position] = name;
        this.optionIcons[position] = this.setItemNameAndLore(icon, name, info);
        return this;
    }

    public IconMenu setOption(int position, ItemStack icon, String name, List<String> info) {
        this.optionNames[position] = name;
        this.optionIcons[position] = this.setItemNameAndLore(icon, name, info);
        return this;
    }

    public void open(Player player) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.size, (String)this.name);
        this.enabled = true;
        this.name = inventory.getTitle();
        for (int i = 0; i < this.optionIcons.length; ++i) {
            if (this.optionIcons[i] == null) continue;
            inventory.setItem(i, this.optionIcons[i]);
        }
        player.openInventory(inventory);
        UEntityMeta.setMetadata((Entity)player, (String)this.metaData, (MetadataValue)new StatValue(null, this.plugin));
    }

    public void destroy() {
        this.handler = null;
        this.optionNames = null;
        this.optionIcons = null;
        this.enabled = false;
    }

    void invClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() != null && event.getInventory().getHolder().equals(this)) {
            if (this.plugin == null) {
                Bukkit.broadcastMessage((String)"PLUGIN NULL HALP HALP");
            }
            if (!event.getInventory().getName().equals(this.name)) {
                return;
            }
            UEntityMeta.removeMetadata((Entity)event.getPlayer(), (String)this.metaData);
            if (this.destroyOnClose) {
                this.destroy();
            }
        }
    }

    void onInventoryClick(InventoryClickEvent event) {
        boolean sameHolder;
        InventoryHolder ih = event.getInventory().getHolder();
        boolean bl = sameHolder = ih != null && ih instanceof IconMenu && ((IconMenu)ih).selfID.equals(this.selfID);
        if (sameHolder) {
            event.setCancelled(true);
            if (!this.enabled.booleanValue()) {
                return;
            }
            int slot = event.getRawSlot();
            if (slot >= 0 && slot < this.size && this.optionNames[slot] != null) {
                Plugin plugin = this.plugin;
                OptionClickEvent e = new OptionClickEvent(event.getInventory(), this, (Player)event.getWhoClicked(), slot, this.optionNames[slot], event);
                this.handler.onOptionClick(e);
                if (e.willClose()) {
                    final Player p = (Player)event.getWhoClicked();
                    Bukkit.getScheduler().runTaskLater(plugin, new Runnable(){

                        @Override
                        public void run() {
                            p.closeInventory();
                            UEntityMeta.removeMetadata((Entity)p, (String)IconMenu.this.metaData);
                        }
                    }, 1L);
                }
                if (e.willDestroy()) {
                    this.destroy();
                }
            }
        }
    }

    public ItemStack[] getOptions() {
        return this.optionIcons;
    }

    public void setOptions(ItemStack[] opts) {
        this.optionIcons = opts;
    }

    public ItemStack setItemNameAndLore(ItemStack item, String name, String ... lore) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        im.setLore(Arrays.asList(lore));
        item.setItemMeta(im);
        return item;
    }

    public ItemStack setItemNameAndLore(ItemStack item, String name, List<String> lore) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        im.setLore(lore);
        item.setItemMeta(im);
        return item;
    }

    public Inventory getInventory() {
        return null;
    }

    public class OptionClickEvent {
        private Player player;
        private int position;
        private String name;
        private boolean close;
        private boolean destroy;
        private Inventory inv;
        private IconMenu menu;
        private InventoryClickEvent parentEvent;

        public OptionClickEvent(Inventory inv, IconMenu menu, Player player, int position, String name, InventoryClickEvent parentEvent) {
            this.player = player;
            this.position = position;
            this.name = name;
            this.close = true;
            this.destroy = false;
            this.inv = inv;
            this.menu = menu;
            this.parentEvent = parentEvent;
        }

        public InventoryClickEvent getParentEvent() {
            return this.parentEvent;
        }

        public Inventory getInventory() {
            return this.inv;
        }

        public IconMenu getMenu() {
            return this.menu;
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public boolean willClose() {
            return this.close;
        }

        public boolean willDestroy() {
            return this.destroy;
        }

        public void setWillClose(boolean close) {
            this.close = close;
        }

        public void setWillDestroy(boolean destroy) {
            this.destroy = destroy;
        }
    }

    public static interface OptionClickEventHandler {
        public void onOptionClick(OptionClickEvent var1);
    }
}

