/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles;

import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class VelocityData {
    private volatile BlockFace dir;
    private volatile Vector motion;
    private volatile int updatesSinceTurn = 0;
    private volatile boolean stoppedForOtherCar = false;
    private volatile boolean inProgressOfTurningAtJunction = false;
    private volatile Location current;
    private volatile Location targetBlockLoc = null;
    private volatile int stationaryCount = 0;

    public VelocityData(BlockFace dir, Vector motion, Location current) {
        this.setDir(dir);
        this.setMotion(motion);
        this.current = current;
    }

    public void updateLocation(Location loc) {
        if (loc.distanceSquared(this.current) < 2.0) {
            ++this.stationaryCount;
        } else {
            this.stationaryCount = 0;
            this.current = loc;
        }
    }

    public void notStationary() {
        this.stationaryCount = 0;
    }

    public int getStationaryCount() {
        return this.stationaryCount;
    }

    public BlockFace getDir() {
        return this.dir;
    }

    public void setDir(BlockFace dir) {
        this.dir = dir;
    }

    public Vector getMotion() {
        return this.motion.clone();
    }

    public boolean hasMotion() {
        return this.motion != null;
    }

    public void setMotion(Vector motion) {
        this.motion = motion;
    }

    public boolean isStoppedForOtherCar() {
        return this.stoppedForOtherCar;
    }

    public void setStoppedForOtherCar(boolean stoppedForOtherCar) {
        this.stoppedForOtherCar = stoppedForOtherCar;
    }

    public boolean isInProgressOfTurningAtJunction() {
        return this.inProgressOfTurningAtJunction;
    }

    public void setInProgressOfTurningAtJunction(boolean inProgressOfTurningAtJunction) {
        this.inProgressOfTurningAtJunction = inProgressOfTurningAtJunction;
    }

    public void resetUpdatesSinceTurn() {
        this.updatesSinceTurn = 0;
    }

    public void incrementUpdatesSinceTurn() {
        ++this.updatesSinceTurn;
    }

    public int getUpdatesSinceTurn() {
        return this.updatesSinceTurn;
    }

    public void setUpdatesSinceTurn(int updatesSinceTurn) {
        this.updatesSinceTurn = updatesSinceTurn;
    }

    public Location getTargetBlockLoc() {
        return this.targetBlockLoc;
    }

    public void setTargetBlockLoc(Location targetBlockLoc) {
        this.targetBlockLoc = targetBlockLoc;
    }
}

