/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.protocolMagic;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_12_R1.EntityBoat;
import net.stormdev.uPlanes.hover.CraftHoverCart;
import net.stormdev.uPlanes.hover.HoverCart;
import net.stormdev.uPlanes.hover.HoverCartEntity;
import net.stormdev.uPlanes.main.main;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.plugin.Plugin;

public class ProtocolManipulator
implements Listener {
    private ProtocolManager protocolManager;
    public static double OFFSET_FIX = -0.9;

    public ProtocolManipulator(ProtocolManager manager) {
        this.protocolManager = manager;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main.plugin);
    }

    @EventHandler
    void logout(PlayerQuitEvent event) {
        for (World w : Bukkit.getServer().getWorlds()) {
            for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                HoverCart hc = HoverCartEntity.getCart((Entity)e.getBukkitEntity());
                if (hc == null) continue;
                ((HoverCartEntity)e).setKnowAboutFakeEntities(event.getPlayer(), false);
            }
        }
    }

    @EventHandler
    void entityDestroy(VehicleDestroyEvent event) {
        if (event.getVehicle() instanceof HoverCart) {
            HoverCartEntity hce = ((CraftHoverCart)event.getVehicle()).getHandle();
            this.sendFakeBoatAndArrowDie(hce);
        }
    }

    public void updateBoatRotationAngle(HoverCart entity) {
        for (Player pl : Bukkit.getOnlinePlayers()) {
            if (!((CraftHoverCart)entity).getHandle().doesKnowAboutFakeEntities(pl)) continue;
            this.updateBoatRotationAngle(pl, entity);
        }
    }

    public void updateBoatRotationAngle(Player player, HoverCart entity) {
        HoverCartEntity hce = ((CraftHoverCart)entity).getHandle();
        int i = 0;
        while ((double)i < hce.getNumFakeBoats()) {
            int entityID = ((CraftHoverCart)entity).getHandle().getFakeBoat(i).getId();
            PacketContainer rotatePacket = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
            rotatePacket.getIntegers().write(0, (Object)entityID);
            double yawDegrees = (double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(i);
            double pitchRad = entity.getHeadPose().getX();
            int yaw = this.getCompressedAngle(yawDegrees * (Math.PI / 180));
            int pitch = this.getCompressedAngle(pitchRad);
            rotatePacket.getBytes().write(0, (Object)((byte)yaw));
            rotatePacket.getBytes().write(1, (Object)((byte)pitch));
            try {
                this.protocolManager.sendServerPacket(player, rotatePacket);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected int getCompressedAngle(double angleRad) {
        double compAngle;
        for (compAngle = angleRad * 40.74366543152521; compAngle < 0.0; compAngle = 256.0 + compAngle) {
        }
        while (compAngle > 256.0) {
            compAngle -= 256.0;
        }
        return (int)compAngle;
    }

    protected void sendFakeBoatAndArrowDie(HoverCartEntity hce) {
        if (!hce.hasFakeBoat()) {
            return;
        }
        for (Player pl : Bukkit.getOnlinePlayers()) {
            if (!hce.doesKnowAboutFakeEntities(pl)) continue;
            this.sendFakeBoatAndArrowDie(hce, pl);
        }
    }

    protected void sendFakeBoatAndArrowDie(HoverCartEntity hce, Player pl) {
        this.sendFakeEntityRemove(pl, hce.getFakeBoat().getId());
        this.sendFakeEntityRemove(pl, hce.getFakeArrow().getId());
        this.sendFakeEntityRemove(pl, hce.getFakeArrow2().getId());
        if (hce.hasExtraFakeBoats()) {
            this.sendFakeEntityRemove(pl, hce.getFakeBoat2().getId());
            this.sendFakeEntityRemove(pl, hce.getFakeBoat3().getId());
            this.sendFakeEntityRemove(pl, hce.getFakeArrow3().getId());
            this.sendFakeEntityRemove(pl, hce.getFakeArrow4().getId());
        }
    }

    protected void sendFakeEntityRemove(Player pl, int ... entityid) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        packet.getIntegerArrays().write(0, (Object)entityid);
        try {
            this.protocolManager.sendServerPacket(pl, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void sendSpawns(HoverCartEntity hce, HoverCart hc) {
        for (Player pl : Bukkit.getOnlinePlayers()) {
            this.sendFakeBoatAndArrowSpawns(hce, hc, pl);
        }
    }

    protected void sendFakeBoatAndArrowSpawns(HoverCartEntity hce, HoverCart hc, Player player) {
        if (!hce.hasFakeBoat()) {
            return;
        }
        EntityBoat toSend = hce.getFakeBoat();
        boolean entityType = true;
        double yawRad = ((double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(0)) * (Math.PI / 180);
        double pitchRad = hc.getHeadPose().getX();
        if (!hce.doesKnowAboutFakeEntities(player)) {
            this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat(), hc.getLocation(), yawRad, pitchRad, 1);
            this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow(), hc.getLocation(), yawRad, pitchRad, 60);
            this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow2(), hc.getLocation(), yawRad, pitchRad, 60);
            this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce, hce.getFakeBoat().getId());
            if (hce.hasExtraFakeBoats()) {
                double yawRad2 = ((double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(1)) * (Math.PI / 180);
                double yawRad3 = ((double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(2)) * (Math.PI / 180);
                this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat2(), hc.getLocation(), yawRad2, pitchRad, 1);
                this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat3(), hc.getLocation(), yawRad3, pitchRad, 1);
                this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow3(), hc.getLocation(), yawRad2, pitchRad, 60);
                this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow4(), hc.getLocation(), yawRad3, pitchRad, 60);
                this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat(), hce.getFakeBoat2().getId(), hce.getFakeBoat3().getId());
                this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat2(), hce.getFakeArrow().getId(), hce.getFakeArrow3().getId());
                this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat3(), hce.getFakeArrow2().getId(), hce.getFakeArrow4().getId());
            } else {
                this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat(), hce.getFakeArrow().getId(), hce.getFakeArrow2().getId());
            }
            hce.setKnowAboutFakeEntities(player, true);
        }
    }

    protected void sendFakeEntityPassengers(Player player, net.minecraft.server.v1_12_R1.Entity vehicle, int ... passengers) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.MOUNT);
        packet.getIntegers().write(0, (Object)vehicle.getId());
        packet.getIntegerArrays().write(0, (Object)passengers);
        try {
            this.protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void sendFakeEntitySpawn(Player player, net.minecraft.server.v1_12_R1.Entity toSend, Location l, double yawRad, double pitchRad, int entityType) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        packet.getIntegers().write(0, (Object)toSend.getId());
        packet.getUUIDs().write(0, (Object)toSend.getUniqueID());
        packet.getIntegers().write(1, (Object)0);
        packet.getIntegers().write(2, (Object)0);
        packet.getIntegers().write(3, (Object)0);
        packet.getDoubles().write(0, (Object)l.getX());
        packet.getDoubles().write(1, (Object)l.getY());
        packet.getDoubles().write(2, (Object)l.getZ());
        packet.getIntegers().write(4, (Object)this.getCompressedAngle(pitchRad));
        packet.getIntegers().write(5, (Object)this.getCompressedAngle(yawRad));
        packet.getIntegers().write(6, (Object)entityType);
        packet.getIntegers().write(7, (Object)0);
        try {
            this.protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void registerManipulations() {
        try {
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Server.ENTITY_TELEPORT}){

                public void onPacketSending(PacketEvent event) {
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    HoverCart hce = null;
                    HoverCartEntity nmsEntity = null;
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : ((CraftWorld)w).getHandle().entityList) {
                            if (entityId != e.getId()) continue;
                            HoverCart hc = HoverCartEntity.getCart((Entity)e.getBukkitEntity());
                            if (hc == null) {
                                return;
                            }
                            nmsEntity = (HoverCartEntity)e;
                            hce = hc;
                        }
                    }
                    if (hce == null) {
                        return;
                    }
                    double y = hce.getLocation().getY();
                    event.getPacket().getDoubles().write(1, (Object)(y += hce.getDisplayOffset() + OFFSET_FIX));
                    ProtocolManipulator.this.sendFakeBoatAndArrowSpawns(nmsEntity, hce, event.getPlayer());
                }
            });
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Client.USE_ENTITY}){

                public void onPacketReceiving(PacketEvent event) {
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                            if (!(e instanceof HoverCartEntity) || !((HoverCartEntity)e).hasFakeBoat() || entityId != ((HoverCartEntity)e).getFakeBoat().getId() && entityId != ((HoverCartEntity)e).getFakeArrow().getId() && entityId != ((HoverCartEntity)e).getFakeArrow2().getId() && (!((HoverCartEntity)e).hasExtraFakeBoats() || entityId != ((HoverCartEntity)e).getFakeArrow3().getId() && entityId != ((HoverCartEntity)e).getFakeArrow4().getId() && entityId != ((HoverCartEntity)e).getFakeBoat2().getId() && entityId != ((HoverCartEntity)e).getFakeBoat3().getId())) continue;
                            event.getPacket().getIntegers().write(0, (Object)e.getId());
                            return;
                        }
                    }
                }
            });
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Server.MOUNT}){

                public void onPacketSending(final PacketEvent event) {
                    int[] passenger3;
                    int[] nArray;
                    int[] passenger2;
                    int[] passenger1;
                    int[] nArray2;
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    HoverCart hce = null;
                    HoverCartEntity nmsEntity = null;
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                            if (entityId != e.getId()) continue;
                            HoverCart hc = HoverCartEntity.getCart((Entity)e.getBukkitEntity());
                            if (hc == null) {
                                return;
                            }
                            nmsEntity = (HoverCartEntity)e;
                            hce = hc;
                        }
                    }
                    if (hce == null) {
                        return;
                    }
                    if (!nmsEntity.hasFakeBoat()) {
                        return;
                    }
                    int[] passengers = (int[])event.getPacket().getIntegerArrays().read(0);
                    int[] fixedPassengers = new int[]{nmsEntity.getFakeBoat().getId()};
                    event.getPacket().getIntegerArrays().write(0, (Object)fixedPassengers);
                    List<Entity> correctPassengers = hce.getPassengers();
                    passengers = new int[correctPassengers.size()];
                    for (int i = 0; i < correctPassengers.size(); ++i) {
                        passengers[i] = ((CraftEntity)correctPassengers.get(i)).getHandle().getId();
                    }
                    if (passengers.length > 0) {
                        int[] nArray3 = new int[1];
                        nArray2 = nArray3;
                        nArray3[0] = passengers[0];
                    } else {
                        nArray2 = passenger1 = new int[]{};
                    }
                    if (!nmsEntity.hasExtraFakeBoats()) {
                        passenger2 = passengers.length > 1 ? ArrayUtils.subarray((int[])passengers, (int)1, (int)passengers.length) : new int[]{};
                    } else if (passengers.length > 1) {
                        int[] nArray4 = new int[1];
                        nArray = nArray4;
                        nArray4[0] = passengers[1];
                    } else {
                        nArray = passenger2 = new int[]{};
                    }
                    if (nmsEntity.hasExtraFakeBoats()) {
                        if (hce.getMaxPassengers() == 3.0) {
                            passenger3 = passengers.length > 1 ? ArrayUtils.subarray((int[])passengers, (int)1, (int)passengers.length) : new int[]{};
                        } else {
                            int[] nArray5;
                            if (passengers.length > 2) {
                                int[] nArray6 = new int[1];
                                nArray5 = nArray6;
                                nArray6[0] = passengers[2];
                            } else {
                                nArray5 = new int[]{};
                            }
                            passenger3 = nArray5;
                        }
                    } else {
                        passenger3 = new int[]{};
                    }
                    int[] passenger4 = nmsEntity.hasExtraFakeBoats() && hce.getMaxPassengers() > 3.0 ? (passengers.length > 3 ? ArrayUtils.subarray((int[])passengers, (int)3, (int)passengers.length) : new int[]{}) : new int[]{};
                    final HoverCartEntity nm = nmsEntity;
                    if (nmsEntity.hasExtraFakeBoats()) {
                        ProtocolManipulator.this.sendFakeEntityPassengers(event.getPlayer(), (net.minecraft.server.v1_12_R1.Entity)nm.getFakeArrow3(), passenger3);
                        ProtocolManipulator.this.sendFakeEntityPassengers(event.getPlayer(), (net.minecraft.server.v1_12_R1.Entity)nm.getFakeArrow4(), passenger4);
                    }
                    ProtocolManipulator.this.sendFakeEntityPassengers(event.getPlayer(), (net.minecraft.server.v1_12_R1.Entity)nm.getFakeArrow2(), passenger2);
                    Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                        @Override
                        public void run() {
                            if (!nm.isAlive()) {
                                return;
                            }
                            ProtocolManipulator.this.sendFakeEntityPassengers(event.getPlayer(), (net.minecraft.server.v1_12_R1.Entity)nm.getFakeArrow(), passenger1);
                        }
                    }, 1L);
                }
            });
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Server.SPAWN_ENTITY}){

                public void onPacketSending(PacketEvent event) {
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    HoverCart hce = null;
                    HoverCartEntity nmsEntity = null;
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                            if (entityId != e.getId()) continue;
                            HoverCart hc = HoverCartEntity.getCart((Entity)e.getBukkitEntity());
                            if (hc == null) {
                                return;
                            }
                            nmsEntity = (HoverCartEntity)e;
                            hce = hc;
                        }
                    }
                    if (hce == null) {
                        return;
                    }
                    double y = hce.getLocation().getY();
                    Block b = hce.getLocation().getBlock();
                    event.getPacket().getDoubles().write(1, (Object)(y += hce.getDisplayOffset() + OFFSET_FIX));
                    ProtocolManipulator.this.sendFakeBoatAndArrowSpawns(nmsEntity, hce, event.getPlayer());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

