/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucarstrade.protocolMagic;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.server.v1_12_R1.EntityBoat;
import net.stormdev.ucars.entity.Car;
import net.stormdev.ucars.entity.CarMinecraftEntity;
import net.stormdev.ucars.entity.CraftCar;
import net.stormdev.ucars.trade.main;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.plugin.Plugin;

public class ProtocolManipulator
implements Listener {
    private ProtocolManager protocolManager;
    public static double OFFSET_FIX = -1.05;

    public ProtocolManipulator(ProtocolManager manager) {
        this.protocolManager = manager;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main.plugin);
    }

    @EventHandler
    void logout(PlayerQuitEvent event) {
        for (World w : Bukkit.getServer().getWorlds()) {
            for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                Car hc = CarMinecraftEntity.getCart((Entity)e.getBukkitEntity());
                if (hc == null) continue;
                ((CarMinecraftEntity)e).setKnowAboutFakeEntities(event.getPlayer(), false);
            }
        }
    }

    @EventHandler
    void entityDestroy(VehicleDestroyEvent event) {
        if (event.getVehicle() instanceof Car) {
            CarMinecraftEntity hce = ((CraftCar)event.getVehicle()).getHandle();
            this.sendFakeBoatAndArrowDie(hce);
        }
    }

    public void updateBoatRotationAngle(Car entity) {
        for (Player pl : Bukkit.getOnlinePlayers()) {
            if (!((CraftCar)entity).getHandle().doesKnowAboutFakeEntities(pl)) continue;
            this.updateBoatRotationAngle(pl, entity);
        }
    }

    public void updateBoatRotationAngle(Player player, Car entity) {
        CarMinecraftEntity hce = ((CraftCar)entity).getHandle();
        int i = 0;
        while ((double)i < hce.getNumFakeBoats()) {
            int entityID = ((CraftCar)entity).getHandle().getFakeBoat(i).getId();
            PacketContainer rotatePacket = new PacketContainer(PacketType.Play.Server.ENTITY_LOOK);
            rotatePacket.getIntegers().write(0, (Object)entityID);
            double yawDegrees = (double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(i);
            double pitchRad = entity.getHeadPose().getX();
            int yaw = this.getCompressedAngle(yawDegrees * (Math.PI / 180));
            int pitch = this.getCompressedAngle(pitchRad);
            rotatePacket.getBytes().write(0, (Object)((byte)yaw));
            rotatePacket.getBytes().write(1, (Object)((byte)pitch));
            try {
                this.protocolManager.sendServerPacket(player, rotatePacket);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected int getCompressedAngle(double angleRad) {
        double compAngle;
        for (compAngle = angleRad * 40.74366543152521; compAngle < 0.0; compAngle = 256.0 + compAngle) {
        }
        while (compAngle > 256.0) {
            compAngle -= 256.0;
        }
        return (int)compAngle;
    }

    protected void sendFakeBoatAndArrowDie(CarMinecraftEntity hce) {
        if (!hce.hasFakeBoat()) {
            return;
        }
        for (Player pl : Bukkit.getOnlinePlayers()) {
            if (!hce.doesKnowAboutFakeEntities(pl)) continue;
            this.sendFakeBoatAndArrowDie(hce, pl);
        }
    }

    protected void sendFakeBoatAndArrowDie(CarMinecraftEntity hce, Player pl) {
        this.sendFakeEntityRemove(pl, hce.getFakeBoat().getId());
        this.sendFakeEntityRemove(pl, hce.getFakeArrow().getId());
        this.sendFakeEntityRemove(pl, hce.getFakeArrow2().getId());
        if (hce.hasExtraFakeBoats()) {
            this.sendFakeEntityRemove(pl, hce.getFakeBoat2().getId());
            this.sendFakeEntityRemove(pl, hce.getFakeBoat3().getId());
            this.sendFakeEntityRemove(pl, hce.getFakeArrow3().getId());
            this.sendFakeEntityRemove(pl, hce.getFakeArrow4().getId());
            if (hce.hasExtraExtraFakeBoats()) {
                this.sendFakeEntityRemove(pl, hce.getFakeBoat4().getId());
                this.sendFakeEntityRemove(pl, hce.getFakeBoat5().getId());
                this.sendFakeEntityRemove(pl, hce.getFakeArrow4().getId());
                this.sendFakeEntityRemove(pl, hce.getFakeArrow5().getId());
            }
        }
    }

    protected void sendFakeEntityRemove(Player pl, int ... entityid) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        packet.getIntegerArrays().write(0, (Object)entityid);
        try {
            this.protocolManager.sendServerPacket(pl, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void sendFakeBoatAndArrowSpawns(CarMinecraftEntity hce, Car hc, Player player, boolean sendFirstBoat) {
        if (!hce.hasFakeBoat()) {
            return;
        }
        EntityBoat toSend = hce.getFakeBoat();
        boolean entityType = true;
        double yawRad = ((double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(0)) * (Math.PI / 180);
        double pitchRad = hc.getHeadPose().getX();
        if (!hce.doesKnowAboutFakeEntities(player)) {
            this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat(), hc.getLocation(), yawRad, pitchRad, 1);
            this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow(), hc.getLocation(), yawRad, pitchRad, 60);
            this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow2(), hc.getLocation(), yawRad, pitchRad, 60);
            this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce, hce.getFakeBoat().getId());
            if (hce.hasExtraFakeBoats()) {
                double yawRad2 = ((double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(1)) * (Math.PI / 180);
                double yawRad3 = ((double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(2)) * (Math.PI / 180);
                this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat2(), hc.getLocation(), yawRad2, pitchRad, 1);
                this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat3(), hc.getLocation(), yawRad3, pitchRad, 1);
                this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow3(), hc.getLocation(), yawRad2, pitchRad, 60);
                this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow4(), hc.getLocation(), yawRad3, pitchRad, 60);
                if (hce.hasExtraExtraFakeBoats()) {
                    double yawRad4 = ((double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(3)) * (Math.PI / 180);
                    double yawRad5 = ((double)hce.getBukkitYaw() + hce.getFakeBoatRotationOffsetDeg(4)) * (Math.PI / 180);
                    this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat4(), hc.getLocation(), yawRad4, pitchRad, 1);
                    this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat5(), hc.getLocation(), yawRad5, pitchRad, 1);
                    this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow5(), hc.getLocation(), yawRad4, pitchRad, 60);
                    this.sendFakeEntitySpawn(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeArrow6(), hc.getLocation(), yawRad5, pitchRad, 60);
                }
            }
            hce.setKnowAboutFakeEntities(player, true);
            if (sendFirstBoat) {
                this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce, hce.getFakeBoat().getId());
            }
            if (hce.hasExtraFakeBoats()) {
                this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat(), hce.getFakeBoat2().getId(), hce.getFakeBoat3().getId());
                if (!hce.hasExtraExtraFakeBoats()) {
                    this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat2(), hce.getFakeArrow().getId(), hce.getFakeArrow3().getId());
                    this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat3(), hce.getFakeArrow2().getId(), hce.getFakeArrow4().getId());
                } else {
                    this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat2(), hce.getFakeArrow().getId(), hce.getFakeBoat4().getId());
                    this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat3(), hce.getFakeArrow2().getId(), hce.getFakeBoat5().getId());
                    this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat4(), hce.getFakeArrow5().getId(), hce.getFakeArrow3().getId());
                    this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat5(), hce.getFakeArrow6().getId(), hce.getFakeArrow4().getId());
                }
            } else {
                this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)hce.getFakeBoat(), hce.getFakeArrow().getId(), hce.getFakeArrow2().getId());
            }
        }
    }

    protected void sendFakeEntityPassengers(Player player, net.minecraft.server.v1_12_R1.Entity vehicle, int ... passengers) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.MOUNT);
        packet.getIntegers().write(0, (Object)vehicle.getId());
        packet.getIntegerArrays().write(0, (Object)passengers);
        try {
            this.protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    protected void sendFakeEntitySpawn(Player player, net.minecraft.server.v1_12_R1.Entity toSend, Location l, double yawRad, double pitchRad, int entityType) {
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY);
        packet.getIntegers().write(0, (Object)toSend.getId());
        packet.getUUIDs().write(0, (Object)toSend.getUniqueID());
        packet.getIntegers().write(1, (Object)0);
        packet.getIntegers().write(2, (Object)0);
        packet.getIntegers().write(3, (Object)0);
        packet.getDoubles().write(0, (Object)l.getX());
        packet.getDoubles().write(1, (Object)l.getY());
        packet.getDoubles().write(2, (Object)l.getZ());
        packet.getIntegers().write(4, (Object)this.getCompressedAngle(pitchRad));
        packet.getIntegers().write(5, (Object)this.getCompressedAngle(yawRad));
        packet.getIntegers().write(6, (Object)entityType);
        packet.getIntegers().write(7, (Object)0);
        try {
            this.protocolManager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void ensurePassengersAttached(Car car) {
        if (!(car instanceof CraftCar)) {
            return;
        }
        CraftCar craftCar = (CraftCar)car;
        CarMinecraftEntity nmsEntity = craftCar.getHandle();
        for (String pName : nmsEntity.getPlayersKnowAboutFakeEntities()) {
            Player pl = Bukkit.getServer().getPlayerExact(pName);
            if (pl == null) continue;
            this.sendPassengersToPlayer(pl, car, nmsEntity);
        }
    }

    public void sendPassengersToPlayer(final Player player, Car hce, CarMinecraftEntity nmsEntity) {
        int[] passenger3;
        int[] nArray;
        int[] passenger2;
        int[] passenger1;
        int[] nArray2;
        if (hce == null) {
            return;
        }
        if (!nmsEntity.hasFakeBoat()) {
            return;
        }
        List<Entity> correctPassengers = hce.getPassengers();
        int[] passengers = new int[correctPassengers.size()];
        for (int i = 0; i < correctPassengers.size(); ++i) {
            passengers[i] = ((CraftEntity)correctPassengers.get(i)).getHandle().getId();
        }
        if (passengers.length > 0) {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = passengers[0];
        } else {
            nArray2 = passenger1 = new int[]{};
        }
        if (!nmsEntity.hasExtraFakeBoats()) {
            passenger2 = passengers.length > 1 ? ArrayUtils.subarray((int[])passengers, (int)1, (int)passengers.length) : new int[]{};
        } else if (passengers.length > 1) {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = passengers[1];
        } else {
            nArray = passenger2 = new int[]{};
        }
        if (nmsEntity.hasExtraFakeBoats()) {
            if (hce.getMaxPassengers() == 3.0) {
                passenger3 = passengers.length > 1 ? ArrayUtils.subarray((int[])passengers, (int)1, (int)passengers.length) : new int[]{};
            } else {
                int[] nArray5;
                if (passengers.length > 2) {
                    int[] nArray6 = new int[1];
                    nArray5 = nArray6;
                    nArray6[0] = passengers[2];
                } else {
                    nArray5 = new int[]{};
                }
                passenger3 = nArray5;
            }
        } else {
            passenger3 = new int[]{};
        }
        int[] passenger4 = nmsEntity.hasExtraFakeBoats() && hce.getMaxPassengers() > 3.0 ? (passengers.length > 3 ? ArrayUtils.subarray((int[])passengers, (int)3, (int)passengers.length) : new int[]{}) : new int[]{};
        final CarMinecraftEntity nm = nmsEntity;
        if (nmsEntity.hasExtraFakeBoats()) {
            this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)nm.getFakeArrow3(), passenger3);
            this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)nm.getFakeArrow4(), passenger4);
        }
        this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)nm.getFakeArrow2(), passenger2);
        Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                if (!nm.isAlive()) {
                    return;
                }
                ProtocolManipulator.this.sendFakeEntityPassengers(player, (net.minecraft.server.v1_12_R1.Entity)nm.getFakeArrow(), passenger1);
            }
        }, 2L);
    }

    public void registerManipulations() {
        try {
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Server.ENTITY_TELEPORT}){

                public void onPacketSending(PacketEvent event) {
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    Car hce = null;
                    CarMinecraftEntity nmsEntity = null;
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : ((CraftWorld)w).getHandle().entityList) {
                            if (entityId != e.getId()) continue;
                            Car hc = CarMinecraftEntity.getCart((Entity)e.getBukkitEntity());
                            if (hc == null) {
                                return;
                            }
                            nmsEntity = (CarMinecraftEntity)e;
                            hce = hc;
                        }
                    }
                    if (hce == null) {
                        return;
                    }
                    double y = hce.getLocation().getY();
                    event.getPacket().getDoubles().write(1, (Object)(y += hce.getDisplayOffset() + OFFSET_FIX));
                    ProtocolManipulator.this.sendFakeBoatAndArrowSpawns(nmsEntity, hce, event.getPlayer(), true);
                }
            });
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Client.USE_ENTITY}){

                public void onPacketReceiving(PacketEvent event) {
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                            if (!(e instanceof CarMinecraftEntity) || !((CarMinecraftEntity)e).hasFakeBoat() || entityId != ((CarMinecraftEntity)e).getFakeBoat().getId() && entityId != ((CarMinecraftEntity)e).getFakeArrow().getId() && entityId != ((CarMinecraftEntity)e).getFakeArrow2().getId() && (!((CarMinecraftEntity)e).hasExtraFakeBoats() || entityId != ((CarMinecraftEntity)e).getFakeArrow3().getId() && entityId != ((CarMinecraftEntity)e).getFakeArrow4().getId() && entityId != ((CarMinecraftEntity)e).getFakeBoat2().getId() && entityId != ((CarMinecraftEntity)e).getFakeBoat3().getId()) && (!((CarMinecraftEntity)e).hasExtraExtraFakeBoats() || entityId != ((CarMinecraftEntity)e).getFakeBoat4().getId() && entityId != ((CarMinecraftEntity)e).getFakeBoat5().getId())) continue;
                            event.getPacket().getIntegers().write(0, (Object)e.getId());
                            return;
                        }
                    }
                }
            });
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Server.MOUNT}){

                public void onPacketSending(final PacketEvent event) {
                    CarMinecraftEntity cme;
                    Car c;
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    Car hce = null;
                    CarMinecraftEntity nmsEntity = null;
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                            if (entityId != e.getId()) continue;
                            Car hc = CarMinecraftEntity.getCart((Entity)e.getBukkitEntity());
                            if (hc == null) {
                                return;
                            }
                            nmsEntity = (CarMinecraftEntity)e;
                            hce = hc;
                        }
                    }
                    if (hce == null) {
                        return;
                    }
                    if (!nmsEntity.hasFakeBoat()) {
                        return;
                    }
                    int[] passengers = (int[])event.getPacket().getIntegerArrays().read(0);
                    int[] fixedPassengers = new int[]{nmsEntity.getFakeBoat().getId()};
                    event.getPacket().getIntegerArrays().write(0, (Object)fixedPassengers);
                    if (!Arrays.equals(passengers, fixedPassengers)) {
                        if (!nmsEntity.doesKnowAboutFakeEntities(event.getPlayer())) {
                            ProtocolManipulator.this.sendFakeBoatAndArrowSpawns(nmsEntity, hce, event.getPlayer(), false);
                        }
                        c = hce;
                        cme = nmsEntity;
                        Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                            @Override
                            public void run() {
                                ProtocolManipulator.this.sendPassengersToPlayer(event.getPlayer(), c, cme);
                            }
                        }, 2L);
                    } else {
                        c = hce;
                        cme = nmsEntity;
                        Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                            @Override
                            public void run() {
                                ProtocolManipulator.this.sendPassengersToPlayer(event.getPlayer(), c, cme);
                            }
                        }, 2L);
                    }
                }
            });
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Server.SPAWN_ENTITY}){

                public void onPacketSending(PacketEvent event) {
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    Car hce = null;
                    CarMinecraftEntity nmsEntity = null;
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                            if (entityId != e.getId()) continue;
                            Car hc = CarMinecraftEntity.getCart((Entity)e.getBukkitEntity());
                            if (hc == null) {
                                return;
                            }
                            nmsEntity = (CarMinecraftEntity)e;
                            hce = hc;
                        }
                    }
                    if (hce == null) {
                        return;
                    }
                    double y = hce.getLocation().getY();
                    Block b = hce.getLocation().getBlock();
                    event.getPacket().getDoubles().write(1, (Object)(y += hce.getDisplayOffset() + OFFSET_FIX));
                    ProtocolManipulator.this.sendFakeBoatAndArrowSpawns(nmsEntity, hce, event.getPlayer(), true);
                }
            });
            this.protocolManager.addPacketListener((PacketListener)new PacketAdapter((Plugin)main.plugin, new PacketType[]{PacketType.Play.Server.NAMED_ENTITY_SPAWN}){

                public void onPacketSending(PacketEvent event) {
                    int entityId = (Integer)event.getPacket().getIntegers().read(0);
                    Car hce = null;
                    CarMinecraftEntity nmsEntity = null;
                    for (World w : Bukkit.getServer().getWorlds()) {
                        for (net.minecraft.server.v1_12_R1.Entity e : new ArrayList(((CraftWorld)w).getHandle().entityList)) {
                            if (entityId != e.getId()) continue;
                            Car hc = CarMinecraftEntity.getCart((Entity)e.getBukkitEntity());
                            if (hc == null) {
                                return;
                            }
                            nmsEntity = (CarMinecraftEntity)e;
                            hce = hc;
                        }
                    }
                    if (hce == null) {
                        return;
                    }
                    double y = hce.getLocation().getY();
                    Block b = hce.getLocation().getBlock();
                    event.getPacket().getDoubles().write(1, (Object)(y += hce.getDisplayOffset() + OFFSET_FIX));
                    ProtocolManipulator.this.sendFakeBoatAndArrowSpawns(nmsEntity, hce, event.getPlayer(), true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

