/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles.spawning;

import com.useful.ucars.ClosestFace;
import java.util.ArrayList;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.SpawnData;
import net.stormdev.ucars.trade.AIVehicles.spawning.AbstractAISpawnManager;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.ReturnTask;
import net.stormdev.ucars.utils.Scheduler;
import net.stormdev.ucars.utils.SyncReturnTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class AIWorldProbingSpawnManager
extends AbstractAISpawnManager {
    private BukkitTask task = null;
    private static long spawnRate = 20L;

    public AIWorldProbingSpawnManager(main plugin, boolean enabled) {
        super(plugin, enabled);
    }

    @Override
    public void shutdown() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    @Override
    public void initSpawnTask() {
        this.task = main.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!AIWorldProbingSpawnManager.this.enabled) {
                    return;
                }
                if (AbstractAISpawnManager.spawnedCount >= AbstractAISpawnManager.liveCap || AbstractAISpawnManager.spawnedCount >= AbstractAISpawnManager.cap) {
                    return;
                }
                boolean longSpawns = main.random.nextInt(10) < 8;
                boolean doubleSpawns = longSpawns && main.random.nextInt(10) < 8;
                for (Player player : new ArrayList(Bukkit.getOnlinePlayers())) {
                    try {
                        AIWorldProbingSpawnManager.this.doSpawns(player);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (longSpawns) {
                        AIWorldProbingSpawnManager.this.doLongSpawns(player);
                    }
                    if (!doubleSpawns) continue;
                    try {
                        AIWorldProbingSpawnManager.this.doSpawns(player);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }, spawnRate, spawnRate);
    }

    public void doLongSpawns(final Player player) {
        if (!this.enabled) {
            return;
        }
        if (main.random.nextInt(10) < 2) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        try {
            Block tracked = null;
            boolean stopSearch = false;
            SyncReturnTask<SpawnData> spawnData = new SyncReturnTask<SpawnData>(new ReturnTask<SpawnData>(){

                public SpawnData[] execute() {
                    Block b = player.getLocation().getBlock().getRelative(BlockFace.UP);
                    Block br = b.getRelative(AIWorldProbingSpawnManager.this.randomFace(), AIWorldProbingSpawnManager.this.randomDir3Amount());
                    World w = b.getWorld();
                    int y = br.getY();
                    int x = br.getX();
                    int z = br.getZ();
                    return new SpawnData[]{new SpawnData(b, br, w, x, y, z)};
                }
            }).executeOnce();
            SpawnData data = spawnData.getResults()[0];
            Block b = data.getB();
            Block br = data.getBr();
            final World w = data.getWorld();
            int y = data.getY();
            final int x = data.getX();
            final int z = data.getZ();
            int minY = y - 10;
            tracked = AIRouter.isTrackBlock(b.getType()) ? b : null;
            Object object = tracked = AIRouter.isTrackBlock(br.getType()) ? br : null;
            while (tracked == null && !stopSearch && y > minY) {
                final int yy = y--;
                Scheduler.runBlockingSyncTask(new Runnable(){

                    @Override
                    public void run() {
                        Location check = new Location(w, (double)x, (double)yy, (double)z);
                        if (AIRouter.isTrackBlock(check.getBlock().getType())) {
                            AIWorldProbingSpawnManager.this.followRoadAndSpawnCarFromTrackerBlock(check, ClosestFace.getClosestFace((float)player.getLocation().getYaw()));
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doLongSpawns() {
        Player[] online;
        if (!this.enabled) {
            return;
        }
        for (final Player player : online = new ArrayList(this.plugin.getServer().getOnlinePlayers()).toArray(new Player[0])) {
            if (main.random.nextBoolean() || player == null || !player.isOnline()) continue;
            try {
                Block tracked = null;
                boolean stopSearch = false;
                SyncReturnTask<SpawnData> spawnData = new SyncReturnTask<SpawnData>(new ReturnTask<SpawnData>(){

                    public SpawnData[] execute() {
                        Block b = player.getLocation().getBlock().getRelative(BlockFace.UP);
                        Block br = b.getRelative(AIWorldProbingSpawnManager.this.randomFace(), AIWorldProbingSpawnManager.this.randomDir3Amount());
                        World w = b.getWorld();
                        int y = br.getY();
                        int x = br.getX();
                        int z = br.getZ();
                        return new SpawnData[]{new SpawnData(b, br, w, x, y, z)};
                    }
                }).executeOnce();
                SpawnData data = spawnData.getResults()[0];
                Block b = data.getB();
                Block br = data.getBr();
                final World w = data.getWorld();
                int y = data.getY();
                final int x = data.getX();
                final int z = data.getZ();
                int minY = y - 10;
                tracked = AIRouter.isTrackBlock(b.getType()) ? b : null;
                Object object = tracked = AIRouter.isTrackBlock(br.getType()) ? br : null;
                while (tracked == null && !stopSearch && y > minY) {
                    final int yy = y--;
                    Scheduler.runBlockingSyncTask(new Runnable(){

                        @Override
                        public void run() {
                            Location check = new Location(w, (double)x, (double)yy, (double)z);
                            if (AIRouter.isTrackBlock(check.getBlock().getType())) {
                                AIWorldProbingSpawnManager.this.followRoadAndSpawnCarFromTrackerBlock(check, ClosestFace.getClosestFace((float)player.getLocation().getYaw()));
                            }
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void doSpawns() throws Exception {
        Player[] online;
        if (!this.enabled) {
            return;
        }
        for (final Player player : online = new ArrayList(this.plugin.getServer().getOnlinePlayers()).toArray(new Player[0])) {
            int y;
            if (main.random.nextInt(10) < 2 || player == null || !player.isOnline()) continue;
            Block tracked = null;
            boolean stopSearch = false;
            SyncReturnTask<SpawnData> spawnData = new SyncReturnTask<SpawnData>(new ReturnTask<SpawnData>(){

                public SpawnData[] execute() {
                    Block b = player.getLocation().getBlock().getRelative(BlockFace.UP);
                    Block br = null;
                    br = main.random.nextBoolean() ? b.getRelative(AIWorldProbingSpawnManager.this.randomFace(), AIWorldProbingSpawnManager.this.randomDir3Amount()) : b.getRelative(AIWorldProbingSpawnManager.this.randomFace(), AIWorldProbingSpawnManager.this.randomDir2Amount());
                    World w = b.getWorld();
                    int y = br.getY();
                    int x = br.getX();
                    int z = br.getZ();
                    return new SpawnData[]{new SpawnData(b, br, w, x, y, z)};
                }
            }).executeOnce();
            SpawnData data = spawnData.getResults()[0];
            Block b = data.getB();
            Block br = data.getBr();
            World w = data.getWorld();
            int x = data.getX();
            int z = data.getZ();
            int minY = y - 10;
            tracked = AIRouter.isTrackBlock(b.getType()) ? b : null;
            Object object = tracked = AIRouter.isTrackBlock(br.getType()) ? br : null;
            for (y = data.getY(); tracked == null && !stopSearch && y > minY; --y) {
                Location check = new Location(w, (double)x, (double)y, (double)z);
                if (!AIRouter.isTrackBlock(check.getBlock().getType())) continue;
                this.followRoadAndSpawnCarFromTrackerBlock(check, ClosestFace.getClosestFace((float)player.getLocation().getYaw()));
            }
        }
    }

    public void doSpawns(final Player player) throws Exception {
        int y;
        SpawnData data;
        if (!this.enabled) {
            return;
        }
        if (main.random.nextInt(10) < 2) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        Block tracked = null;
        boolean stopSearch = false;
        SyncReturnTask<SpawnData> spawnData = new SyncReturnTask<SpawnData>(new ReturnTask<SpawnData>(){

            public SpawnData[] execute() {
                Block b = player.getLocation().getBlock().getRelative(BlockFace.UP);
                Block br = null;
                br = main.random.nextBoolean() ? b.getRelative(AIWorldProbingSpawnManager.this.randomFace(), AIWorldProbingSpawnManager.this.randomDirAmount()) : b.getRelative(AIWorldProbingSpawnManager.this.randomFace(), AIWorldProbingSpawnManager.this.randomDir2Amount());
                World w = b.getWorld();
                int y = br.getY();
                int x = br.getX();
                int z = br.getZ();
                return new SpawnData[]{new SpawnData(b, br, w, x, y, z)};
            }
        }).executeOnce();
        try {
            data = spawnData.getResults()[0];
        }
        catch (Exception e) {
            return;
        }
        Block b = data.getB();
        Block br = data.getBr();
        World w = data.getWorld();
        int x = data.getX();
        int z = data.getZ();
        int minY = y - 10;
        tracked = AIRouter.isTrackBlock(b.getType()) ? b : null;
        Object object = tracked = AIRouter.isTrackBlock(br.getType()) ? br : null;
        for (y = data.getY(); tracked == null && !stopSearch && y > minY; --y) {
            final Location check = new Location(w, (double)x, (double)y, (double)z);
            Scheduler.runBlockingSyncTask(new Runnable(){

                @Override
                public void run() {
                    if (AIRouter.isTrackBlock(check.getBlock().getType())) {
                        AIWorldProbingSpawnManager.this.followRoadAndSpawnCarFromTrackerBlock(check, ClosestFace.getClosestFace((float)player.getLocation().getYaw()));
                    }
                }
            }, 60);
        }
    }
}

