/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.main;

import java.util.List;
import java.util.UUID;
import net.stormdev.uPlanes.api.AutopilotDestination;
import net.stormdev.uPlanes.api.Boat;
import net.stormdev.uPlanes.api.Keypress;
import net.stormdev.uPlanes.api.Plane;
import net.stormdev.uPlanes.api.uPlanesAPI;
import net.stormdev.uPlanes.api.uPlanesVehicle;
import net.stormdev.uPlanes.hover.HoverCart;
import net.stormdev.uPlanes.main.FlightControl;
import net.stormdev.uPlanes.main.MotionManager;
import net.stormdev.uPlanes.main.PlaneGenerator;
import net.stormdev.uPlanes.main.PlaneItemMethods;
import net.stormdev.uPlanes.main.UpgradeManager;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.presets.BoatPreset;
import net.stormdev.uPlanes.presets.PlanePreset;
import net.stormdev.uPlanes.presets.PresetManager;
import net.stormdev.uPlanes.utils.BoatUpdateEvent;
import net.stormdev.uPlanes.utils.CartOrientationUtil;
import net.stormdev.uPlanes.utils.Lang;
import net.stormdev.uPlanes.utils.PEntityMeta;
import net.stormdev.uPlanes.utils.PlaneUpdateEvent;
import net.stormdev.uPlanes.utils.PreBoatCrashEvent;
import net.stormdev.uPlanes.utils.PrePlaneCrashEvent;
import net.stormdev.uPlanes.utils.PrePlaneRoughLandingEvent;
import net.stormdev.uPlanes.utils.StatValue;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class uPlanesListener
implements Listener {
    private main plugin;
    private double punchDamage;
    public static double heightLimit;
    private boolean perms;
    private String perm;
    private boolean safeExit;
    private boolean fuel;
    private boolean crashing = false;
    private String fuelBypassPerm;

    public uPlanesListener(main instance) {
        this.plugin = instance;
        this.fuel = main.config.getBoolean("general.planes.fuel.enable");
        this.fuelBypassPerm = main.config.getString("general.planes.fuel.bypassPerm");
        this.punchDamage = main.config.getDouble("general.planes.punchDamage");
        heightLimit = main.config.getDouble("general.planes.heightLimit");
        this.perms = main.config.getBoolean("general.planes.perms");
        this.perm = main.config.getString("general.planes.flyPerm");
        this.safeExit = main.config.getBoolean("general.planes.safeExit");
        this.crashing = main.config.getBoolean("general.planes.enableCrashing");
    }

    @EventHandler
    void entityCrash(VehicleEntityCollisionEvent event) {
        if (!this.crashing) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Vehicle m = event.getVehicle();
        if (m == null) {
            return;
        }
        uPlanesVehicle<?> plane = this.getPluginVehicle(m);
        if (plane == null) {
            return;
        }
        Entity collided = event.getEntity();
        if (PEntityMeta.hasMetadata(collided, "IGNORE_COLLISIONS")) {
            event.setCancelled(true);
            event.setCollisionCancelled(true);
            return;
        }
        if (collided == null || collided instanceof Item || collided instanceof ItemFrame) {
            return;
        }
        if (m.getPassenger() == null || m.getPassenger() != null && collided.equals(m.getPassenger())) {
            return;
        }
        double speedSq = m.getVelocity().lengthSquared();
        if (speedSq < 0.2) {
            return;
        }
        double damage = 20.0 * speedSq;
        if ((damage = (double)Math.round(damage * 10.0) / 10.0) < 1.0) {
            damage = 1.0;
        }
        if (damage > 15.0) {
            damage = 15.0;
        }
        if (collided instanceof Damageable) {
            if (collided instanceof Player) {
                ((Player)collided).sendMessage(ChatColor.RED + "You collided with a " + plane.getTypeName() + "!");
            }
            if (!(plane instanceof Plane) || !((Plane)plane).isHover()) {
                collided.setVelocity(m.getVelocity().clone().setY(0.5));
            }
            ((Damageable)collided).damage(damage, (Entity)m);
        }
        if (plane instanceof Plane) {
            uPlanesAPI.getPlaneManager().damagePlane(m, (Plane)plane, damage, "Crash");
        } else if (plane instanceof Boat) {
            uPlanesAPI.getBoatManager().damageBoat(m, (Boat)plane, damage, "Crash");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void despawn(EntityDeathEvent event) {
        if (!this.plugin.planeManager.isPlaneInUse(event.getEntity().getUniqueId()).booleanValue()) {
            return;
        }
        this.plugin.planeManager.noLongerPlaced(event.getEntity().getUniqueId());
        if (!PEntityMeta.USING_UCARS && !(event.getEntity() instanceof Player)) {
            PEntityMeta.removeAllMeta((Entity)event.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void despawnBoats(EntityDeathEvent event) {
        if (!this.plugin.boatsManager.isBoatInUse(event.getEntity().getUniqueId()).booleanValue()) {
            return;
        }
        this.plugin.boatsManager.noLongerPlaced(event.getEntity().getUniqueId());
        if (!PEntityMeta.USING_UCARS && !(event.getEntity() instanceof Player)) {
            PEntityMeta.removeAllMeta((Entity)event.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    void projectileDamage(EntityDamageByEntityEvent event) {
        Player player;
        Projectile proj;
        ProjectileSource source;
        if (event.isCancelled()) {
            return;
        }
        Entity dmged = event.getEntity();
        Entity dmger = event.getDamager();
        if (dmger instanceof Player) {
            Player player2 = (Player)dmger;
            if (player2.getVehicle() != null && player2.getVehicle().equals(dmged)) {
                event.setDamage(-0.5);
                event.setCancelled(true);
            }
            return;
        }
        if (dmger instanceof Projectile && (source = (proj = (Projectile)dmger).getShooter()) instanceof Player && (player = (Player)source).getVehicle() != null && player.getVehicle().equals(dmged)) {
            event.setDamage(-0.5);
            event.setCancelled(true);
        }
    }

    @EventHandler
    void protectInPlane(EntityDamageEvent event) {
        Entity e = event.getEntity();
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Entity v = e.getVehicle();
        if (v == null || !(v instanceof Vehicle)) {
            return;
        }
        if (this.isPluginEntity((Vehicle)v)) {
            event.setDamage(-2.5);
            event.setCancelled(true);
        }
    }

    @EventHandler
    void signWrite(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[Shop]") && lines.length > 1) {
            lines[0] = ChatColor.GREEN + "[Shop]".trim();
            lines[1] = ChatColor.RED + ChatColor.stripColor((String)lines[1].trim());
            lines[2] = "Place chest";
            lines[3] = "above";
        }
    }

    @EventHandler
    public void shopOpen(InventoryOpenEvent event) {
        Boolean installed;
        if (!this.plugin.shopsEnabled) {
            return;
        }
        if (main.economy == null && !(installed = Boolean.valueOf(this.plugin.setupEconomy())).booleanValue()) {
            main.logger.info(main.colors.getError() + "[Important] Unable to find an economy plugin: shop was unable to open.");
            return;
        }
        Inventory inv = event.getInventory();
        if (!(inv.getHolder() instanceof Chest) && !(inv.getHolder() instanceof DoubleChest)) {
            return;
        }
        Block block = null;
        block = inv.getHolder() instanceof Chest ? ((Chest)inv.getHolder()).getBlock() : ((DoubleChest)inv.getHolder()).getLocation().getBlock();
        Block underBlock = block.getRelative(BlockFace.DOWN);
        Block underunderBlock = underBlock.getRelative(BlockFace.DOWN);
        Sign sign = null;
        if (underBlock.getState() instanceof Sign) {
            sign = (Sign)underBlock.getState();
        } else if (underunderBlock.getState() instanceof Sign) {
            sign = (Sign)underunderBlock.getState();
        } else {
            return;
        }
        if (!ChatColor.stripColor((String)sign.getLines()[0].trim()).equalsIgnoreCase("[Shop]") || !ChatColor.stripColor((String)sign.getLines()[1].trim()).equalsIgnoreCase("planes")) {
            return;
        }
        Player player = (Player)event.getPlayer();
        event.getView().close();
        event.setCancelled(true);
        this.plugin.planeShop.open(player);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onQuit(PlayerQuitEvent event) {
        MotionManager.removePlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void onQuit(PlayerKickEvent event) {
        MotionManager.removePlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void vehicleExit(VehicleExitEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Vehicle veh = event.getVehicle();
        LivingEntity exited = event.getExited();
        if (!(exited instanceof Player) || !(veh instanceof Vehicle)) {
            return;
        }
        if (!this.isPluginEntity(veh)) {
            return;
        }
        if (PEntityMeta.hasMetadata((Entity)veh, "plane.destination")) {
            AutopilotDestination aData = null;
            if (PEntityMeta.hasMetadata((Entity)veh, "plane.autopilotData")) {
                try {
                    aData = (AutopilotDestination)PEntityMeta.getMetadata((Entity)veh, "plane.autopilotData").get(0).value();
                }
                catch (Exception e) {
                    aData = null;
                }
            }
            if (aData != null && !aData.isAutopilotOverridenByControlInput()) {
                event.setCancelled(true);
                exited.teleport(veh.getLocation());
                return;
            }
        }
        PEntityMeta.removeMetadata((Entity)veh, "uPlanes.accel");
        if (!this.safeExit) {
            return;
        }
        Location loc = veh.getLocation();
        Block b = loc.getBlock();
        Player player = (Player)exited;
        if (exited.isDead() || player.getHealth() < 1.0) {
            return;
        }
        loc.setYaw(player.getLocation().getYaw());
        loc.setPitch(player.getLocation().getPitch());
        Vector vel = veh.getVelocity();
        main.plugin.getServer().getScheduler().runTaskLater((Plugin)main.plugin, new Runnable((Entity)exited, loc, vel){
            final /* synthetic */ Entity val$exited;
            final /* synthetic */ Location val$loc;
            final /* synthetic */ Vector val$vel;
            {
                this.val$exited = entity;
                this.val$loc = location;
                this.val$vel = vector;
            }

            @Override
            public void run() {
                this.val$exited.teleport(this.val$loc.add(0.0, 0.5, 0.0));
                this.val$exited.setVelocity(this.val$vel);
                if (this.val$exited instanceof Player) {
                    MotionManager.removePlayer((Player)this.val$exited);
                }
            }
        }, 2L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    void onVehTick(VehicleUpdateEvent event) {
        if (event instanceof PlaneUpdateEvent || event instanceof BoatUpdateEvent) {
            return;
        }
        Vehicle v = event.getVehicle();
        if (this.isPluginEntity(v)) {
            Entity pass = v.getPassenger();
            if (pass instanceof Player) {
                Player pl = (Player)pass;
                MotionManager.MovePacketInfo mpi = MotionManager.getMostRecentPacketInfo(pl);
                MotionManager.move(pl, mpi.f, mpi.s, mpi.jumping);
            } else if (this.isABoat(v)) {
                MotionManager.moveBoat(v, this.getBoat(v), false);
            }
        }
    }

    @EventHandler
    void vehicleUpdate(VehicleUpdateEvent event) {
        Entity passenger;
        Vehicle car = event.getVehicle();
        Location loc = car.getLocation();
        if (car.hasMetadata("plane.frozen") || PEntityMeta.hasMetadata((Entity)car, "plane.frozen")) {
            if (car instanceof ArmorStand) {
                ((ArmorStand)car).setGravity(false);
            } else {
                car.setVelocity(new Vector(0.0, 0.04, 0.0));
            }
            return;
        }
        if (car instanceof ArmorStand && !((ArmorStand)car).hasGravity()) {
            ((ArmorStand)car).setGravity(true);
        }
        if ((passenger = car.getPassenger()) == null) {
            return;
        }
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
        }
        uPlanesVehicle<?> pln = this.getPluginVehicle(car);
        if (PEntityMeta.hasMetadata((Entity)car, "plane.destination") && pln instanceof Plane) {
            List<MetadataValue> metas = PEntityMeta.getMetadata((Entity)car, "plane.destination");
            Location dest = (Location)metas.get(0).value();
            FlightControl.route(dest, loc, car, (Plane)pln);
            return;
        }
        if (pln == null) {
            return;
        }
        CartOrientationUtil.setPitch(car, pln.getCurrentPitch());
        if (!(pln instanceof Plane) || !((Plane)pln).isHover()) {
            if (pln.getTimeSinceLastUpdateEvent() >= 150L && pln.getLastUpdateEventVec() != null) {
                car.setVelocity(pln.getLastUpdateEventVec());
            }
            return;
        }
        if (!PEntityMeta.hasMetadata((Entity)car, "plane.left") && !PEntityMeta.hasMetadata((Entity)car, "plane.right")) {
            car.setVelocity(car.getVelocity().clone().setY(0));
            return;
        }
    }

    @EventHandler
    void boatControl(BoatUpdateEvent event) {
        Vehicle cart = event.getVehicle();
        Player player = event.getPlayer();
        if (!(cart instanceof Vehicle)) {
            return;
        }
        if (main.perms && !player.hasPermission("uplanes.fly")) {
            player.sendMessage(main.colors.getError() + "You don't have the permission 'uplanes.fly' required to fly a plane!");
            return;
        }
        Boat boat = event.getBoat();
        if (boat == null) {
            return;
        }
        if (this.fuel && !player.hasPermission(this.fuelBypassPerm)) {
            double fuel = 0.0;
            if (main.fuel.containsKey(player.getName())) {
                fuel = main.fuel.get(player.getName());
            }
            if (fuel < 0.1) {
                player.sendMessage(main.colors.getError() + Lang.get("lang.fuel.empty"));
                return;
            }
            int amount = 0 + (int)(Math.random() * 250.0);
            if (amount == 10) {
                fuel -= 0.1;
                fuel = (double)Math.round(fuel * 10.0) / 10.0;
                main.fuel.put(player.getName(), fuel);
            }
        }
        if (this.perms && !player.hasPermission(this.perm)) {
            return;
        }
        if (cart.hasMetadata("plane.frozen") || PEntityMeta.hasMetadata((Entity)cart, "plane.frozen")) {
            if (cart instanceof ArmorStand) {
                ((ArmorStand)cart).setGravity(false);
            } else {
                cart.setVelocity(new Vector(0.0, 0.04, 0.0));
            }
            return;
        }
        if (cart instanceof ArmorStand && !((ArmorStand)cart).hasGravity()) {
            ((ArmorStand)cart).setGravity(true);
        }
        if (cart instanceof Minecart) {
            ((Minecart)cart).setMaxSpeed(5.0);
        }
        Location loc = cart.getLocation();
        Vector travel = event.getTravelVector();
        if (loc.getY() >= heightLimit) {
            travel.setY(-1);
            float pitch = 1.0f;
            boat.setCurrentPitch(pitch);
            player.sendMessage(main.colors.getError() + Lang.get("general.heightLimit"));
        }
        if (this.crashing) {
            Location nextHorizontal;
            Block b = null;
            double x = travel.getX();
            double z = travel.getZ();
            double vx = cart.getVelocity().getX();
            double vz = cart.getVelocity().getZ();
            if (Math.abs(vx) > Math.abs(x)) {
                x = vx;
            }
            if (Math.abs(vz) > Math.abs(z)) {
                z = vz;
            }
            double ax = x;
            double az = z;
            BoatPreset pp = boat.getPreset();
            if (pp != null && pp.getHitBoxX() > 0.0f) {
                double length = new Vector(ax, 0.0, az).length();
                double goodLength = length + (double)pp.getHitBoxX() / 2.0;
                if (length != 0.0 && goodLength != 0.0) {
                    double mult = goodLength / length;
                    ax *= mult;
                    az *= mult;
                }
            }
            if (!((b = (nextHorizontal = cart.getLocation().clone().add(new Vector(ax, 0.0, az))).getBlock()).isEmpty() || b.isLiquid() || !b.getType().isSolid() || b.getType().equals((Object)Material.CARPET) || b.getType().equals((Object)Material.BARRIER))) {
                String name;
                boolean inside = true;
                double relY = nextHorizontal.getY() - (double)b.getY();
                if (relY < 0.0) {
                    relY = 0.0;
                }
                if ((name = b.getType().name().toLowerCase()).contains("step") && relY >= 0.4) {
                    inside = false;
                }
                if (name.contains("carpet") && relY > 0.0) {
                    inside = false;
                }
                if (inside) {
                    double speedSq = new Vector(x, 0.0, z).lengthSquared();
                    double damage = 150.0 * (speedSq *= 1.5);
                    if ((damage = (double)Math.round(damage * 10.0) / 10.0) < 1.0) {
                        damage = 1.0;
                    }
                    if (damage > 100.0) {
                        damage = 100.0;
                    }
                    PreBoatCrashEvent evt = new PreBoatCrashEvent(cart, player, travel.length(), boat, damage);
                    Bukkit.getPluginManager().callEvent((Event)evt);
                    if (!evt.isCancelled() && evt.getDamage() > 0.0) {
                        uPlanesAPI.getBoatManager().damageBoat(cart, boat, evt.getDamage(), "Crash");
                    }
                }
            }
        }
        Vector behind = travel.clone().multiply(-1);
        Location exhaust = loc.add(behind);
        exhaust.getWorld().playEffect(exhaust, Effect.SMOKE, 1);
        cart.setVelocity(travel);
        boat.postBoatUpdateEvent(travel);
    }

    @EventHandler
    void planeFlightControl(PlaneUpdateEvent event) {
        Vector travel;
        Location loc;
        Plane plane;
        Vehicle cart;
        block61: {
            Location nextVertical;
            Block b;
            Player player;
            block59: {
                block60: {
                    cart = event.getVehicle();
                    player = event.getPlayer();
                    if (!(cart instanceof Vehicle)) {
                        return;
                    }
                    if (main.perms && !player.hasPermission("uplanes.fly")) {
                        player.sendMessage(main.colors.getError() + "You don't have the permission 'uplanes.fly' required to fly a plane!");
                        return;
                    }
                    plane = event.getPlane();
                    if (plane == null) {
                        return;
                    }
                    if (plane.isHover()) {
                        PEntityMeta.setMetadata((Entity)cart, "plane.hover", new StatValue(true, (Plugin)main.plugin));
                        if (main.perms && !player.hasPermission("uplanes.hoverplane")) {
                            player.sendMessage(main.colors.getError() + "You don't have the permission 'uplanes.hoverplane' required to fly a plane!");
                            return;
                        }
                    }
                    if (this.fuel && !player.hasPermission(this.fuelBypassPerm)) {
                        double fuel = 0.0;
                        if (main.fuel.containsKey(player.getName())) {
                            fuel = main.fuel.get(player.getName());
                        }
                        if (fuel < 0.1) {
                            player.sendMessage(main.colors.getError() + Lang.get("lang.fuel.empty"));
                            return;
                        }
                        int amount = 0 + (int)(Math.random() * 250.0);
                        if (amount == 10) {
                            fuel -= 0.1;
                            fuel = (double)Math.round(fuel * 10.0) / 10.0;
                            main.fuel.put(player.getName(), fuel);
                        }
                    }
                    if (PEntityMeta.hasMetadata((Entity)cart, "plane.destination")) {
                        AutopilotDestination aData = null;
                        if (PEntityMeta.hasMetadata((Entity)cart, "plane.autopilotData")) {
                            aData = (AutopilotDestination)PEntityMeta.getMetadata((Entity)cart, "plane.autopilotData").get(0).value();
                        }
                        boolean cont = false;
                        if (aData != null && !aData.isAutopilotOverridenByControlInput()) {
                            cont = true;
                        }
                        if (!cont && !event.wasKeypressed(Keypress.NONE)) {
                            if (aData != null && !event.wasKeypressed(Keypress.NONE)) {
                                aData.autoPilotCancelled();
                            } else if (!event.wasKeypressed(Keypress.NONE)) {
                                player.sendMessage(main.colors.getInfo() + Lang.get("general.cmd.destinations.cancel"));
                            }
                            PEntityMeta.removeMetadata((Entity)cart, "plane.destination");
                            PEntityMeta.removeMetadata((Entity)cart, "plane.autopilotData");
                        }
                    }
                    if (this.perms && !player.hasPermission(this.perm)) {
                        return;
                    }
                    if (cart.hasMetadata("plane.frozen") || PEntityMeta.hasMetadata((Entity)cart, "plane.frozen")) {
                        if (cart instanceof ArmorStand) {
                            ((ArmorStand)cart).setGravity(false);
                        } else {
                            cart.setVelocity(new Vector(0.0, 0.04, 0.0));
                        }
                        return;
                    }
                    if (cart instanceof ArmorStand && !((ArmorStand)cart).hasGravity()) {
                        ((ArmorStand)cart).setGravity(true);
                    }
                    if (cart instanceof Minecart) {
                        ((Minecart)cart).setMaxSpeed(5.0);
                    }
                    loc = cart.getLocation();
                    travel = event.getTravelVector();
                    double multiplier = plane.getSpeed();
                    if (multiplier > 15.0) {
                        multiplier = 15.0 + (multiplier - 15.0) * 0.5;
                    }
                    travel.multiply(multiplier);
                    if (loc.getY() >= heightLimit) {
                        travel.setY(-1);
                        float pitch = 1.0f;
                        plane.setCurrentPitch(pitch);
                        player.sendMessage(main.colors.getError() + Lang.get("general.heightLimit"));
                    }
                    Vector vector = new Vector(travel.getX(), 0.0, travel.getZ());
                    if (vector.lengthSquared() < 0.75 && event.getAcceleration() < 0.75 && !plane.canFloat() && travel.getY() < 0.1) {
                        travel.setY(-Math.abs(cart.getVelocity().getY()) * 1.015);
                    }
                    if (this.crashing) {
                        Block b2 = null;
                        if (!PEntityMeta.hasMetadata((Entity)cart, "plane.destination") && !PEntityMeta.hasMetadata((Entity)cart, "arrivedAtDest")) {
                            Location nextHorizontal;
                            double x = travel.getX();
                            double z = travel.getZ();
                            double vx = cart.getVelocity().getX();
                            double vz = cart.getVelocity().getZ();
                            if (Math.abs(vx) > Math.abs(x)) {
                                x = vx;
                            }
                            if (Math.abs(vz) > Math.abs(z)) {
                                z = vz;
                            }
                            double ax = x;
                            double az = z;
                            PlanePreset pp = plane.getPreset();
                            if (pp != null && pp.getHitBoxX() > 0.0f) {
                                double length = new Vector(ax, 0.0, az).length();
                                double goodLength = length + (double)pp.getHitBoxX() / 2.0 + (plane.isHover() ? 0.5 : 0.0);
                                if (length != 0.0 && goodLength != 0.0) {
                                    double mult = goodLength / length;
                                    ax *= mult;
                                    az *= mult;
                                }
                            }
                            if (!((b2 = (nextHorizontal = cart.getLocation().clone().add(new Vector(ax, 0.0, az))).getBlock()).isEmpty() || b2.isLiquid() || !b2.getType().isSolid() || b2.getType().equals((Object)Material.CARPET) || b2.getType().equals((Object)Material.BARRIER))) {
                                String name;
                                boolean inside = true;
                                double relY = nextHorizontal.getY() - (double)b2.getY();
                                if (relY < 0.0) {
                                    relY = 0.0;
                                }
                                if ((name = b2.getType().name().toLowerCase()).contains("step") && relY >= 0.4) {
                                    inside = false;
                                }
                                if (name.contains("carpet") && relY > 0.0) {
                                    inside = false;
                                }
                                if (inside) {
                                    double speedSq = new Vector(x, 0.0, z).lengthSquared();
                                    double damage = 150.0 * (speedSq *= 1.5);
                                    if (plane.isHover()) {
                                        damage *= 1.5;
                                    }
                                    if ((damage = (double)Math.round(damage * 10.0) / 10.0) < 1.0) {
                                        damage = 1.0;
                                    }
                                    if (damage > 100.0) {
                                        damage = 100.0;
                                    }
                                    PrePlaneCrashEvent evt = new PrePlaneCrashEvent(cart, player, event.getAcceleration(), plane, damage);
                                    Bukkit.getPluginManager().callEvent((Event)evt);
                                    if (!evt.isCancelled() && evt.getDamage() > 0.0) {
                                        uPlanesAPI.getPlaneManager().damagePlane(cart, plane, evt.getDamage(), "Crash");
                                    }
                                }
                            }
                        }
                    }
                    if (!this.crashing || plane.isHover() || PEntityMeta.hasMetadata((Entity)cart, "plane.destination") || PEntityMeta.hasMetadata((Entity)cart, "arrivedAtDest")) break block59;
                    if (travel.getY() < -0.2 && plane.getCurrentPitch() > 22.0f) break block60;
                    if (!(travel.getY() < -0.7)) break block61;
                    Vector vector2 = new Vector(travel.getX(), 0.0, travel.getZ());
                    if (!(vector2.lengthSquared() < 0.8) || !(event.getAcceleration() < 0.8)) break block61;
                }
                double y = Math.min(travel.getY(), cart.getVelocity().getY());
                Location nextVertical2 = cart.getLocation().add(0.0, y, 0.0);
                Block b3 = nextVertical2.getBlock();
                if (!b3.isEmpty() && !b3.isLiquid() && b3.getType().isSolid()) {
                    String name;
                    boolean inside = true;
                    double relY = nextVertical2.getY() - (double)b3.getY();
                    if (relY < 0.0) {
                        relY = 0.0;
                    }
                    if ((name = b3.getType().name().toLowerCase()).contains("step") && relY >= 0.4) {
                        inside = false;
                    }
                    if (name.contains("carpet") && relY > 0.0) {
                        inside = false;
                    }
                    if (inside) {
                        double damage = 130.0 * Math.abs(y);
                        if ((damage = (double)Math.round(damage * 10.0) / 10.0) < 1.0) {
                            damage = 1.0;
                        }
                        if (damage > 200.0) {
                            damage = 200.0;
                        }
                        PrePlaneRoughLandingEvent evt = new PrePlaneRoughLandingEvent(cart, player, event.getAcceleration(), plane, damage);
                        Bukkit.getPluginManager().callEvent((Event)evt);
                        if (!evt.isCancelled() && evt.getDamage() > 0.0) {
                            uPlanesAPI.getPlaneManager().damagePlane(cart, plane, evt.getDamage(), "Rough Landing");
                            player.damage(20.0 * (damage / 200.0));
                        }
                    }
                }
                break block61;
            }
            if (this.crashing && plane.isHover() && !PEntityMeta.hasMetadata((Entity)cart, "plane.destination") && !PEntityMeta.hasMetadata((Entity)cart, "arrivedAtDest") && travel.getY() < 0.0 && (Math.abs(travel.getX()) > 0.1 || Math.abs(travel.getZ()) > 0.1) && !(b = (nextVertical = cart.getLocation().add(0.0, cart.getVelocity().getY(), 0.0)).getBlock()).isEmpty() && !b.isLiquid() && b.getType().isSolid()) {
                String name;
                boolean inside = true;
                double relY = nextVertical.getY() - (double)b.getY();
                if (relY < 0.0) {
                    relY = 0.0;
                }
                if ((name = b.getType().name().toLowerCase()).contains("step") && relY >= 0.4) {
                    inside = false;
                }
                if (name.contains("carpet") && relY > 0.0) {
                    inside = false;
                }
                if (inside) {
                    double damage = 110.0 * new Vector(travel.getX(), 0.0, travel.getZ()).lengthSquared();
                    if ((damage = (double)Math.round(damage * 10.0) / 10.0) < 1.0) {
                        damage = 1.0;
                    }
                    if (damage > 200.0) {
                        damage = 200.0;
                    }
                    PrePlaneRoughLandingEvent evt = new PrePlaneRoughLandingEvent(cart, player, event.getAcceleration(), plane, damage);
                    Bukkit.getPluginManager().callEvent((Event)evt);
                    if (!evt.isCancelled() && evt.getDamage() > 0.0) {
                        uPlanesAPI.getPlaneManager().damagePlane(cart, plane, evt.getDamage(), "Rough Landing");
                        player.damage(20.0 * (damage / 200.0));
                    }
                }
            }
        }
        Vector behind = travel.clone().multiply(-1);
        Location exhaust = loc.add(behind);
        exhaust.getWorld().playEffect(exhaust, Effect.SMOKE, 1);
        if (!PEntityMeta.hasMetadata((Entity)cart, "plane.destination")) {
            cart.setVelocity(travel);
            plane.postPlaneUpdateEvent(travel);
        }
    }

    public uPlanesVehicle getPluginVehicle(ItemStack stack) {
        Plane pl = main.plugin.planeManager.getPlane(stack);
        return pl == null ? main.plugin.boatsManager.getBoat(stack) : pl;
    }

    @EventHandler
    void placePlane(PlayerInteractEvent event) {
        Location toSpawn;
        Action a = event.getAction();
        if (a != Action.RIGHT_CLICK_BLOCK && a != Action.RIGHT_CLICK_AIR) {
            return;
        }
        final Player player = event.getPlayer();
        ItemStack inHand = player.getItemInHand();
        final uPlanesVehicle plane = this.getPluginVehicle(inHand);
        if (plane == null) {
            return;
        }
        if (main.perms && !player.hasPermission("uplanes.place")) {
            player.sendMessage(main.colors.getError() + "You don't have the permission 'uplanes.place' required to place a " + plane.getTypeName() + "!");
            return;
        }
        Block b = event.getClickedBlock();
        if (a != Action.RIGHT_CLICK_BLOCK) {
            if (!plane.getType().equals((Object)uPlanesVehicle.VehicleType.BOAT)) {
                return;
            }
            b = null;
            Vector eyeDir = player.getEyeLocation().getDirection();
            BlockIterator bi = new BlockIterator(player.getWorld(), player.getLocation().toVector(), eyeDir, player.getEyeHeight(), 7);
            while (bi.hasNext()) {
                Block nextB = bi.next();
                if (!nextB.isLiquid()) continue;
                b = nextB;
                break;
            }
            if (b == null) {
                return;
            }
        }
        if ((toSpawn = b.getLocation().clone().add(0.0, 1.5, 0.0)).getY() >= (double)toSpawn.getWorld().getMaxHeight()) {
            event.setCancelled(true);
            player.sendMessage(ChatColor.RED + "You may not place this here!");
            return;
        }
        Block in = toSpawn.getBlock();
        if (!in.isEmpty() && !in.isLiquid()) {
            return;
        }
        Vector v = toSpawn.toVector().clone().setY(event.getPlayer().getLocation().getY()).subtract(event.getPlayer().getLocation().toVector());
        v = v.normalize();
        boolean loop = this.safeExit;
        Location current = event.getPlayer().getLocation().clone();
        double prevDist = Double.MAX_VALUE;
        while (loop) {
            double dist = current.distanceSquared(toSpawn);
            if (dist > prevDist || dist < 1.5) {
                loop = false;
            }
            prevDist = dist;
            Block b1 = current.getBlock();
            if (!b1.isEmpty() && !b1.isLiquid()) {
                event.getPlayer().sendMessage(ChatColor.RED + "You need a clear path between you and the vehicle to be placed!");
                event.setCancelled(true);
                return;
            }
            current = current.add(v);
        }
        event.setUseItemInHand(Event.Result.DENY);
        event.setCancelled(true);
        Bukkit.getScheduler().runTask((Plugin)main.plugin, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<uPlanesListener> clazz = uPlanesListener.class;
                synchronized (uPlanesListener.class) {
                    ItemStack inHand = player.getItemInHand();
                    if (inHand == null || inHand.getAmount() < 1) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    uPlanesVehicle pln = uPlanesListener.this.getPluginVehicle(inHand);
                    if (pln == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    float yaw = player.getLocation().getYaw() + 90.0f;
                    if (yaw < 0.0f) {
                        yaw = 360.0f + yaw;
                    } else if (yaw >= 360.0f) {
                        yaw -= 360.0f;
                    }
                    toSpawn.setYaw(player.getLocation().getYaw());
                    Vehicle ent = null;
                    if (pln instanceof Plane) {
                        ent = uPlanesAPI.getPlaneManager().placePlane((Plane)plane, toSpawn);
                    } else if (pln instanceof Boat) {
                        ent = uPlanesAPI.getBoatManager().placeBoat((Boat)plane, toSpawn);
                    }
                    CartOrientationUtil.setYaw(ent, yaw);
                    Block in = ent.getLocation().getBlock();
                    Block n = in.getRelative(BlockFace.NORTH);
                    Block w = in.getRelative(BlockFace.WEST);
                    Block nw = in.getRelative(BlockFace.NORTH_WEST);
                    Block ne = in.getRelative(BlockFace.NORTH_EAST);
                    Block sw = in.getRelative(BlockFace.SOUTH_WEST);
                    if (!in.isEmpty() && !in.isLiquid() || !n.isEmpty() && !n.isLiquid() || !w.isEmpty() && !w.isLiquid() || !ne.isEmpty() && !ne.isLiquid() || !nw.isEmpty() && !nw.isLiquid() || !sw.isEmpty() && !sw.isLiquid()) {
                        ent.remove();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    inHand.setAmount(inHand.getAmount() - 1);
                    if (inHand.getAmount() < 1) {
                        player.setItemInHand(new ItemStack(Material.AIR));
                    }
                    ent.teleport(ent.getLocation());
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    @EventHandler
    void vehicleDestroy(VehicleDestroyEvent event) {
        Vehicle v = event.getVehicle();
        if (!this.isPluginEntity(v)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void allowArmorStandInteractDespiteProtection(PlayerArmorStandManipulateEvent event) {
        if (event.getRightClicked() instanceof HoverCart) {
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void armorStandHurt(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof HoverCart) {
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void armorStandHurt(EntityDamageEvent event) {
        if (event.getEntity() instanceof HoverCart) {
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void interact(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked() instanceof HoverCart) {
            event.setCancelled(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void vehicleDamage(VehicleDamageEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        Vehicle m = event.getVehicle();
        uPlanesVehicle<?> plane = this.getPluginVehicle(m);
        if (plane == null) {
            return;
        }
        Entity dmger = event.getAttacker();
        if (dmger instanceof Projectile) {
            Player player2;
            Projectile proj = (Projectile)dmger;
            ProjectileSource source = proj.getShooter();
            if (source instanceof Player && (player2 = (Player)source).getVehicle() != null && player2.getVehicle().equals(m)) {
                event.setCancelled(true);
                return;
            }
        } else if (dmger instanceof Player && (player = (Player)dmger).getVehicle() != null && player.getVehicle().equals(m)) {
            event.setCancelled(true);
            return;
        }
        if (plane instanceof Plane && ((Plane)plane).canFloat() && m.getVelocity().getY() < 0.001 && dmger == null) {
            return;
        }
        plane.setLastDamager(dmger);
        if (event.getDamage() <= 0.0) {
            return;
        }
        if (dmger != null && dmger instanceof Player) {
            if (plane instanceof Plane) {
                uPlanesAPI.getPlaneManager().damagePlane(m, (Plane)plane, this.punchDamage, (Player)dmger);
            } else if (plane instanceof Boat) {
                uPlanesAPI.getBoatManager().damageBoat(m, (Boat)plane, this.punchDamage, (Player)dmger);
            }
        } else if (dmger != null || event.getDamage() >= 24.0) {
            if (plane instanceof Plane) {
                uPlanesAPI.getPlaneManager().damagePlane(m, (Plane)plane, event.getDamage(), "Damage");
            } else if (plane instanceof Boat) {
                uPlanesAPI.getBoatManager().damageBoat(m, (Boat)plane, event.getDamage(), "Damage");
            }
        }
        event.setDamage(-5.5);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void itemCraft(CraftItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemStack recipe = event.getCurrentItem();
        if (recipe.getType() != Material.MINECART) {
            return;
        }
        HumanEntity e = event.getWhoClicked();
        Player player = null;
        if (e instanceof Player) {
            player = (Player)e;
        }
        Boolean hover = false;
        String name = ChatColor.stripColor((String)recipe.getItemMeta().getDisplayName());
        if (!name.equalsIgnoreCase("plane")) {
            if (name.equalsIgnoreCase("hover plane")) {
                hover = true;
            } else {
                return;
            }
        }
        Plane plane = PlaneGenerator.gen();
        if (hover.booleanValue()) {
            plane.setName("Hover Plane");
            plane.setHover(true);
        }
        if (player != null && main.perms && !player.hasPermission("uplanes.craft")) {
            player.sendMessage(main.colors.getError() + "You don't have the permission 'uplanes.craft' required to craft a plane!");
            event.setCurrentItem(new ItemStack(Material.AIR));
            return;
        }
        event.setCurrentItem(PlaneItemMethods.getItem(plane));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void planeUpgradeAnvil(final InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.CLONE_STACK) {
            ItemStack cloned = event.getCursor();
            if (cloned.getType() == Material.MINECART || cloned.getItemMeta() == null || cloned.getItemMeta().getLore() == null || cloned.getItemMeta().getLore().size() < 2) {
                event.setCancelled(true);
                return;
            }
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        InventoryView view = event.getView();
        if (event.isShiftClick() && (view.getBottomInventory() instanceof AnvilInventory || view.getTopInventory() instanceof AnvilInventory)) {
            event.setCancelled(true);
            return;
        }
        final Inventory i = event.getInventory();
        if (!(i instanceof AnvilInventory)) {
            return;
        }
        int slotNumber = event.getRawSlot();
        if (slotNumber != view.convertSlot(slotNumber)) {
            return;
        }
        Boolean update = true;
        Boolean save = false;
        Boolean pickup = false;
        if (event.getAction() == InventoryAction.PICKUP_ALL || event.getAction() == InventoryAction.PICKUP_HALF || event.getAction() == InventoryAction.PICKUP_ONE || event.getAction() == InventoryAction.PICKUP_SOME) {
            update = false;
            pickup = true;
            if (slotNumber == 2) {
                save = true;
            }
        }
        ItemStack item = null;
        try {
            item = i.getItem(0);
        }
        catch (Exception e) {
            return;
        }
        if (item == null) {
            if (!pickup.booleanValue() && i.getItem(1) != null) {
                ItemStack held = event.getCursor();
                uPlanesVehicle plane = this.getPluginVehicle(held);
                if (plane == null) {
                    return;
                }
                Bukkit.getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (i.getItem(0) != null) {
                            uPlanesListener.this.planeUpgradeAnvil(event);
                        }
                    }
                }, 1L);
            }
            return;
        }
        if (item.getItemMeta().getLore().size() < 2) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        uPlanesVehicle plane = this.getPluginVehicle(item);
        if (plane == null) {
            return;
        }
        List lore = meta.getLore();
        if (save.booleanValue() && slotNumber == 2) {
            if (!PresetManager.usePresets || !PresetManager.disableItemRenaming) {
                ItemStack result = event.getCurrentItem();
                String name = ChatColor.stripColor((String)result.getItemMeta().getDisplayName());
                plane.setName(name);
                player.sendMessage(main.colors.getSuccess() + "+" + main.colors.getInfo() + " Renamed " + plane.getTypeName() + " to: '" + name + "'");
                return;
            }
            event.getCurrentItem().getItemMeta().setDisplayName(plane.getName());
            event.setCancelled(true);
            return;
        }
        InventoryAction a = event.getAction();
        ItemStack upgrade = null;
        Boolean set = false;
        final ItemStack up = upgrade;
        final Boolean updat = update;
        final Boolean sav = save;
        final uPlanesVehicle ca = plane;
        if (slotNumber == 1 && (a == InventoryAction.PLACE_ALL || a == InventoryAction.PLACE_ONE || a == InventoryAction.PLACE_SOME) && event.getCursor().getType() != Material.AIR) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ItemStack upgrade = up;
                    try {
                        upgrade = i.getItem(1);
                    }
                    catch (Exception e) {
                        return;
                    }
                    if (upgrade == null) {
                        return;
                    }
                    UpgradeManager.applyUpgrades(upgrade, ca, updat, sav, player, i, ca.getId());
                }
            }, 1L);
            set = true;
            return;
        }
        if (!set.booleanValue()) {
            try {
                upgrade = i.getItem(1);
            }
            catch (Exception e) {
                return;
            }
        }
        if (upgrade == null) {
            return;
        }
        if (pickup.booleanValue() && slotNumber == 1) {
            return;
        }
        UpgradeManager.applyUpgrades(upgrade, plane, update, save, player, i, plane.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killPlane(Vehicle vehicle, Plane plane) {
        UUID id = vehicle.getUniqueId();
        if (!PEntityMeta.USING_UCARS) {
            PEntityMeta.removeAllMeta((Entity)vehicle);
        }
        this.plugin.planeManager.noLongerPlaced(id);
        final Location loc = vehicle.getLocation();
        Entity top = vehicle.getPassenger();
        if (top instanceof Player) {
            top.eject();
            top.setVelocity(vehicle.getVelocity());
            if (this.safeExit) {
                final Player pl = (Player)top;
                final Vector vel = vehicle.getVelocity();
                main.plugin.getServer().getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        pl.teleport(loc.clone().add(0.0, 0.5, 0.0));
                        pl.setVelocity(vel);
                    }
                }, 2L);
            }
        }
        Class<uPlanesListener> clazz = uPlanesListener.class;
        synchronized (uPlanesListener.class) {
            if (vehicle.isDead() || !vehicle.isValid() || vehicle.getCustomName() != null && vehicle.getCustomName().equals("broken")) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            vehicle.setCustomName("broken");
            List near = vehicle.getNearbyEntities(5.0, 5.0, 5.0);
            for (Entity e : near) {
                if (e.getEntityId() != vehicle.getEntityId() && e instanceof Vehicle) continue;
            }
            vehicle.eject();
            vehicle.remove();
            if (!plane.isWrittenOff()) {
                loc.getWorld().dropItem(loc, new ItemStack(PlaneItemMethods.getItem(plane)));
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killBoat(Vehicle vehicle, Boat plane) {
        UUID id = vehicle.getUniqueId();
        if (!PEntityMeta.USING_UCARS) {
            PEntityMeta.removeAllMeta((Entity)vehicle);
        }
        this.plugin.boatsManager.noLongerPlaced(id);
        final Location loc = vehicle.getLocation();
        Entity top = vehicle.getPassenger();
        if (top instanceof Player) {
            top.eject();
            top.setVelocity(vehicle.getVelocity());
            if (this.safeExit) {
                final Player pl = (Player)top;
                final Vector vel = vehicle.getVelocity();
                main.plugin.getServer().getScheduler().runTaskLater((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        pl.teleport(loc.clone().add(0.0, 0.5, 0.0));
                        pl.setVelocity(vel);
                    }
                }, 2L);
            }
        }
        Class<uPlanesListener> clazz = uPlanesListener.class;
        synchronized (uPlanesListener.class) {
            if (vehicle.isDead() || !vehicle.isValid() || vehicle.getCustomName() != null && vehicle.getCustomName().equals("broken")) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
            vehicle.setCustomName("broken");
            List near = vehicle.getNearbyEntities(5.0, 5.0, 5.0);
            for (Entity e : near) {
                if (e.getEntityId() != vehicle.getEntityId() && e instanceof Vehicle) continue;
            }
            vehicle.eject();
            vehicle.remove();
            if (!plane.isWrittenOff()) {
                loc.getWorld().dropItem(loc, new ItemStack(plane.toItemStack()));
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public uPlanesVehicle<?> getPluginVehicle(Vehicle m) {
        Plane pl = this.getPlane(m);
        return pl == null ? this.getBoat(m) : pl;
    }

    public Boat getBoat(Vehicle m) {
        return this.plugin.boatsManager.getBoat(m.getUniqueId());
    }

    public Plane getPlane(Vehicle m) {
        return this.plugin.planeManager.getPlane(m.getUniqueId());
    }

    public boolean isPluginEntity(Vehicle m) {
        return uPlanesAPI.isPluginControlledEntity((Entity)m);
    }

    public boolean isABoat(Vehicle m) {
        return this.plugin.boatsManager.isBoatInUse(m.getUniqueId());
    }

    public Boolean isAPlane(Vehicle m) {
        return this.plugin.planeManager.isPlaneInUse(m.getUniqueId());
    }
}

