/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars.controls;

import com.useful.ucars.controls.ControlScheme;
import com.useful.ucars.ucars;
import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ControlSchemeManager {
    public static final String CONTROL_TYPE_META = "ucarsControlScheme";
    public static final String CONTROL_LOCK_META = "ucarsControlsLocked";

    public static ControlScheme getScheme(Player player) {
        if (!UEntityMeta.hasMetadata((Entity)player, CONTROL_TYPE_META)) {
            return ControlScheme.getDefault();
        }
        try {
            return (ControlScheme)((Object)UEntityMeta.getMetadata((Entity)player, CONTROL_TYPE_META).get(0).value());
        }
        catch (Exception e) {
            UEntityMeta.removeMetadata((Entity)player, CONTROL_TYPE_META);
            return ControlScheme.getDefault();
        }
    }

    public static void setControlScheme(Player player, ControlScheme scheme) {
        UEntityMeta.removeMetadata((Entity)player, CONTROL_TYPE_META);
        UEntityMeta.setMetadata((Entity)player, CONTROL_TYPE_META, new StatValue((Object)scheme, (Plugin)ucars.plugin));
    }

    public static ControlScheme toggleControlScheme(Player player) {
        ControlScheme newScheme = ControlSchemeManager.getScheme(player).getNext();
        ControlSchemeManager.setControlScheme(player, newScheme);
        newScheme.showInfo(player);
        return newScheme;
    }

    public static boolean isControlsLocked(Player player) {
        return UEntityMeta.hasMetadata((Entity)player, CONTROL_LOCK_META);
    }

    public static void setControlsLocked(Player player, boolean locked) {
        UEntityMeta.removeMetadata((Entity)player, CONTROL_LOCK_META);
        if (locked) {
            UEntityMeta.setMetadata((Entity)player, CONTROL_LOCK_META, new StatValue(null, (Plugin)ucars.plugin));
        }
    }
}

