/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars;

import com.useful.uCarsAPI.uCarsAPI;
import com.useful.ucars.CarDirection;
import com.useful.ucars.ControlInput;
import com.useful.ucars.controls.ControlScheme;
import com.useful.ucars.controls.ControlSchemeManager;
import com.useful.ucars.ucarUpdateEvent;
import com.useful.ucars.ucars;
import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MotionManager {
    public static Vector rotateXZVector3dDegrees(Vector original, double degrees) {
        double[] out = MotionManager.rotateVector2dRadians(original.getX(), original.getZ(), Math.toRadians(degrees));
        original.setX(out[0]);
        original.setZ(out[1]);
        return original;
    }

    public static double[] rotateVector2dDegrees(double x, double y, double degrees) {
        return MotionManager.rotateVector2dRadians(x, y, Math.toRadians(degrees));
    }

    public static double[] rotateVector2dRadians(double x, double y, double radians) {
        double[] result = new double[]{x * Math.cos(radians) - y * Math.sin(radians), x * Math.sin(radians) + y * Math.cos(radians)};
        return result;
    }

    public static void move(Player player, float f, float s, boolean jumping) {
        long timeSinceOnGround;
        double y;
        Vector vec = new Vector();
        Entity ent = player.getVehicle();
        if (ent == null) {
            return;
        }
        while (!(ent instanceof Vehicle) && ent.getVehicle() != null) {
            ent = ent.getVehicle();
        }
        if (!ucars.listener.inACar(player)) {
            // empty if block
        }
        if (!ucars.listener.inACar(player) || !(ent instanceof Vehicle)) {
            return;
        }
        final Vehicle car = (Vehicle)ent;
        if (!player.equals(car.getPassenger())) {
            return;
        }
        Vector plaD = player.getEyeLocation().getDirection();
        if (jumping) {
            if (!UEntityMeta.hasMetadata((Entity)player, "ucarsToggleControls")) {
                UEntityMeta.setMetadata((Entity)player, "ucarsToggleControls", new StatValue(true, (Plugin)ucars.plugin));
                if (ControlSchemeManager.isControlsLocked(player)) {
                    player.sendMessage(ucars.colors.getError() + "Cannot toggle control scheme right now! (It's been locked by another plugin)");
                } else {
                    ControlSchemeManager.toggleControlScheme(player);
                    if (!ucars.turningCircles && ControlSchemeManager.getScheme(player).equals((Object)ControlScheme.KEYBOARD)) {
                        UEntityMeta.removeMetadata((Entity)car, "ucarsSteeringDir");
                        UEntityMeta.setMetadata((Entity)car, "ucarsSteeringDir", new StatValue(plaD.clone().setY(0).normalize(), (Plugin)ucars.plugin));
                    }
                }
            }
        } else if (UEntityMeta.hasMetadata((Entity)player, "ucarsToggleControls")) {
            UEntityMeta.removeMetadata((Entity)player, "ucarsToggleControls");
        }
        ControlScheme controls = ControlSchemeManager.getScheme(player);
        boolean keyboardSteering = controls.equals((Object)ControlScheme.KEYBOARD);
        Vector carDirection = null;
        try {
            if (UEntityMeta.hasMetadata((Entity)car, "ucarsSteeringDir")) {
                carDirection = (Vector)UEntityMeta.getMetadata((Entity)car, "ucarsSteeringDir").get(0).value();
            }
        }
        catch (Exception e) {
            carDirection = null;
        }
        if (carDirection == null) {
            carDirection = car.getLocation().getDirection();
        }
        if (keyboardSteering || ucars.turningCircles) {
            try {
                if (UEntityMeta.hasMetadata((Entity)car, "ucarsSteeringDir")) {
                    carDirection = (Vector)UEntityMeta.getMetadata((Entity)car, "ucarsSteeringDir").get(0).value();
                }
            }
            catch (Exception e) {
                carDirection = null;
            }
            if (carDirection == null) {
                carDirection = car.getLocation().getDirection();
            }
        }
        CarDirection dir = CarDirection.NONE;
        if (f == 0.0f && !ucars.smoothDrive) {
            return;
        }
        Location carLoc = car.getLocation().clone();
        boolean inAir = false;
        if (carLoc.getBlock().isEmpty() && carLoc.subtract(0.0, 1.0, 0.0).getBlock().isEmpty()) {
            inAir = true;
        }
        double len = car.getWidth() / 2.0;
        if (!(car.getLocation().clone().add(len, -1.0, 0.0).getBlock().isEmpty() && car.getLocation().clone().add(-len, -1.0, 0.0).getBlock().isEmpty() && car.getLocation().clone().add(0.0, -1.0, len).getBlock().isEmpty() && car.getLocation().clone().add(0.0, -1.0, -len).getBlock().isEmpty() && car.getLocation().clone().add(len, -1.0, len).getBlock().isEmpty() && car.getLocation().clone().add(len, -1.0, -len).getBlock().isEmpty() && car.getLocation().clone().add(-len, -1.0, len).getBlock().isEmpty() && car.getLocation().clone().add(-len, -1.0, -len).getBlock().isEmpty())) {
            inAir = false;
        }
        if (ucars.smoothDrive && inAir) {
            f = 0.0f;
            s = 0.0f;
        } else if (ucars.smoothDrive) {
            ControlInput.setFirstAirTime(player, System.currentTimeMillis());
        }
        Boolean forwards = true;
        int side = 0;
        Boolean turning = false;
        if (f < 0.0f) {
            dir = CarDirection.BACKWARDS;
            forwards = false;
        } else if (f > 0.0f) {
            dir = CarDirection.FORWARDS;
            forwards = true;
        }
        if (s > 0.0f) {
            side = -1;
            turning = true;
        }
        if (s < 0.0f) {
            side = 1;
            turning = true;
        }
        if ((y = -0.1 + -0.003 * (double)(timeSinceOnGround = System.currentTimeMillis() - ControlInput.getFirstAirTime(player))) < -1.0) {
            y = -1.0;
        }
        double d = 27.0;
        Boolean doDivider = false;
        Boolean doAction = false;
        double divider = 0.5;
        double rotMod = uCarsAPI.getAPI().getMaxCarTurnAmountDegrees((Entity)car, 5.0);
        if (turning.booleanValue()) {
            if (side < 0) {
                if (!keyboardSteering) {
                    doAction = true;
                    UEntityMeta.setMetadata((Entity)car, "car.action", new StatValue(true, (Plugin)ucars.plugin));
                } else {
                    carDirection = MotionManager.rotateXZVector3dDegrees(carDirection, ControlInput.getCurrentDriveDir(player).equals((Object)CarDirection.BACKWARDS) ? rotMod : -rotMod);
                }
            } else if (side > 0) {
                if (!keyboardSteering) {
                    doDivider = true;
                    UEntityMeta.setMetadata((Entity)car, "car.action", new StatValue(true, (Plugin)ucars.plugin));
                } else {
                    carDirection = MotionManager.rotateXZVector3dDegrees(carDirection, ControlInput.getCurrentDriveDir(player).equals((Object)CarDirection.BACKWARDS) ? -rotMod : rotMod);
                }
            }
        }
        if (!(keyboardSteering || !ucars.turningCircles || ucars.smoothDrive && inAir)) {
            float cYaw;
            float pYaw = (float)Math.toDegrees(Math.atan2(plaD.getX(), -plaD.getZ()));
            float yawDiff = pYaw - (cYaw = (float)Math.toDegrees(Math.atan2(carDirection.getX(), -carDirection.getZ())));
            if (yawDiff <= -180.0f) {
                yawDiff += 360.0f;
            } else if (yawDiff > 180.0f) {
                yawDiff -= 360.0f;
            }
            if ((double)yawDiff < -rotMod) {
                yawDiff = (float)(-rotMod);
            } else if ((double)yawDiff > rotMod) {
                yawDiff = (float)rotMod;
            }
            carDirection = MotionManager.rotateXZVector3dDegrees(carDirection, yawDiff);
        }
        if (keyboardSteering || ucars.turningCircles) {
            UEntityMeta.removeMetadata((Entity)car, "ucarsSteeringDir");
            UEntityMeta.setMetadata((Entity)car, "ucarsSteeringDir", new StatValue(carDirection.normalize(), (Plugin)ucars.plugin));
            plaD = carDirection.clone();
        }
        if (forwards.booleanValue()) {
            double x = plaD.getX() / d;
            double z = plaD.getZ() / d;
            if (!doDivider.booleanValue() && UEntityMeta.hasMetadata((Entity)car, "car.braking")) {
                UEntityMeta.removeMetadata((Entity)car, "car.braking");
            }
            if (!doAction.booleanValue() && UEntityMeta.hasMetadata((Entity)car, "car.action")) {
                UEntityMeta.removeMetadata((Entity)car, "car.action");
            }
            vec = new Vector(x, y, z);
            final ucarUpdateEvent event = new ucarUpdateEvent(car, vec, player, dir);
            event.setDoDivider(doDivider);
            event.setDivider(divider);
            final Vector v = vec;
            ucars.plugin.getServer().getScheduler().runTask((Plugin)ucars.plugin, new Runnable(){

                @Override
                public void run() {
                    ControlInput.input((Entity)car, v, event);
                }
            });
            return;
        }
        if (!forwards.booleanValue()) {
            double x = plaD.getX() / d;
            double z = plaD.getZ() / d;
            if (!doDivider.booleanValue() && UEntityMeta.hasMetadata((Entity)car, "car.braking")) {
                UEntityMeta.removeMetadata((Entity)car, "car.braking");
            }
            x = 0.0 - x;
            z = 0.0 - z;
            final Vector v = vec = new Vector(x, y, z);
            final ucarUpdateEvent event = new ucarUpdateEvent(car, vec, player, dir);
            event.setDoDivider(doDivider);
            event.setDivider(divider);
            Bukkit.getScheduler().runTask((Plugin)ucars.plugin, new Runnable(){

                @Override
                public void run() {
                    ControlInput.input((Entity)car, v, event);
                }
            });
            return;
        }
    }
}

