/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade.AIVehicles.spawning.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.md_5.bungee.api.ChatColor;
import net.stormdev.ucars.trade.AIVehicles.AIRouter;
import net.stormdev.ucars.trade.AIVehicles.AITrackFollow;
import net.stormdev.ucars.trade.AIVehicles.DynamicLagReducer;
import net.stormdev.ucars.trade.AIVehicles.spawning.SpawnMethod;
import net.stormdev.ucars.trade.AIVehicles.spawning.nodes.AINodesSpawnManager;
import net.stormdev.ucars.trade.AIVehicles.spawning.nodes.Node;
import net.stormdev.ucars.trade.main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class NetworkScan {
    private static int SCAN_BRANCH_LIMIT = 1000;
    private Logger logger = null;
    private Location origin = null;
    private Stage stage = Stage.SCAN_ROAD_NETWORK_BLOCKS;
    private AINodesSpawnManager spawnManager = null;
    private volatile List<Vector> roadNetworkBlocks = new ArrayList<Vector>();
    private volatile long REST_TIME = 50L;
    private volatile BukkitTask restTimeChecker = null;
    private volatile int roughNodes = 0;
    private volatile List<Block> queuedBranches = new ArrayList<Block>();
    private volatile long lastStartTime = 0L;
    private volatile int scansRunning = 1;
    private volatile int roughSize = 0;

    public NetworkScan(Player player) {
        if (Bukkit.isPrimaryThread()) {
            throw new RuntimeException("Don't use in main thread");
        }
        this.logger = new Logger(player);
        this.logger.log("Detecting road network...");
        final Location playerLoc = player.getLocation();
        Location startTrackerBlock = null;
        Future trackerBlockFind = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<Location>(){

            @Override
            public Location call() throws Exception {
                for (int i = 0; i < 5; ++i) {
                    Block under = playerLoc.getBlock().getRelative(BlockFace.DOWN, i);
                    if (!AIRouter.isTrackBlock(under.getType())) continue;
                    return under.getLocation();
                }
                return null;
            }
        });
        try {
            startTrackerBlock = (Location)trackerBlockFind.get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (startTrackerBlock == null) {
            this.logger.log("Unable to detect road network! Scan cancelled! Please make sure you're standing on it!");
            return;
        }
        this.origin = startTrackerBlock;
        this.logger.log("Successfully found road network's entry point!");
        if (!(main.plugin.aiSpawns instanceof AINodesSpawnManager)) {
            this.logger.log("Switching to node based spawn system... (No cars will spawn until nodes are setup though)");
            main.plugin.aiSpawns.shutdown();
            main.plugin.initNodeAISpawnManager();
        }
        this.spawnManager = (AINodesSpawnManager)main.plugin.aiSpawns;
        this.restTimeChecker = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                double tps = DynamicLagReducer.getTPS();
                if (tps > 18.0) {
                    if (NetworkScan.this.REST_TIME > 10L) {
                        NetworkScan.this.REST_TIME -= 10L;
                    }
                    if (NetworkScan.this.REST_TIME < 0L) {
                        NetworkScan.this.REST_TIME = 0L;
                    }
                } else if (tps > 14.0) {
                    if (NetworkScan.this.REST_TIME > 10L) {
                        NetworkScan.this.REST_TIME -= 5L;
                    }
                    if (NetworkScan.this.REST_TIME < 2L) {
                        NetworkScan.this.REST_TIME = 2L;
                    }
                } else {
                    NetworkScan.this.REST_TIME += 20L;
                    if (NetworkScan.this.REST_TIME > 200L) {
                        NetworkScan.this.REST_TIME = 200L;
                    }
                }
            }
        }, 20L, 20L);
        this.startStage();
    }

    private void nextStage() {
        this.stage = this.stage.getNext();
        if (this.stage == null) {
            this.finish();
        } else {
            this.startStage();
        }
    }

    public void finish() {
        NetworkScan networkScan = this;
        networkScan.spawnManager.getNodesStore().asyncSave();
        this.origin = null;
        this.spawnManager = null;
        this.roadNetworkBlocks.clear();
        this.roadNetworkBlocks = null;
        this.restTimeChecker.cancel();
        this.logger.log("Network scanning terminated!");
        this.logger = null;
        System.gc();
    }

    private void startStage() {
        switch (this.stage) {
            case PLACE_NODES: {
                this.nodePlacing();
                this.nextStage();
                break;
            }
            case SAVE_AND_ACTIVATE: {
                this.saveNodes();
                this.nextStage();
                break;
            }
            case SCAN_ROAD_NETWORK_BLOCKS: {
                this.scanRoadNetwork();
                this.nextStage();
                break;
            }
        }
    }

    public void saveNodes() {
        NetworkScan networkScan = this;
        networkScan.spawnManager.getNodesStore().asyncSave();
        main.config.set("general.ai.spawnMethod", (Object)SpawnMethod.NODES.name());
        main.plugin.saveConfig();
        this.logger.log("Successfully saved the nodes! Villager cars should now start spawning!");
    }

    public void nodePlacing() {
        this.logger.log("Starting placing of nodes throughout the network, this could also take a long time...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

            @Override
            public void run() {
                while (NetworkScan.this.stage.equals((Object)Stage.PLACE_NODES)) {
                    NetworkScan.this.logger.log("Gone through " + NetworkScan.this.roughNodes + " out of " + NetworkScan.this.roughSize + " road blocks...");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        for (final Vector blockLoc : new ArrayList<Vector>(this.roadNetworkBlocks)) {
            Block block;
            if (blockLoc == null) continue;
            ++this.roughNodes;
            boolean overlappingNode = false;
            Future getBlock = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<Block>(){

                @Override
                public Block call() throws Exception {
                    Block block = new Location(NetworkScan.this.origin.getWorld(), blockLoc.getX(), blockLoc.getY(), blockLoc.getZ()).getBlock();
                    return block;
                }
            });
            try {
                block = (Block)getBlock.get();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                continue;
            }
            if (block == null) continue;
            Future getDir = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<BlockFace>(){

                @Override
                public BlockFace call() throws Exception {
                    return AITrackFollow.carriagewayDirection(block).getDirection();
                }
            });
            BlockFace dir = null;
            try {
                dir = (BlockFace)getDir.get();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (dir == null) continue;
            NetworkScan networkScan = this;
            ArrayList<Node> toScan = new ArrayList<Node>(networkScan.spawnManager.getNodesStore().getActiveNodes(block.getLocation()));
            for (final Node node : toScan) {
                Vector nodeLoc;
                Vector diff;
                if (node.getLocation() == null || !((diff = (nodeLoc = new Vector(node.getLocation().getX(), node.getLocation().getY(), node.getLocation().getZ())).subtract(blockLoc)).lengthSquared() < 49.0)) continue;
                Future existingNodeDir = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<BlockFace>(){

                    @Override
                    public BlockFace call() throws Exception {
                        return node.getCarriagewayDirection();
                    }
                });
                try {
                    BlockFace existingNodeCarriageway = (BlockFace)existingNodeDir.get();
                    if (existingNodeCarriageway.getOppositeFace().equals((Object)dir)) continue;
                    double absModX = Math.abs(diff.getX());
                    double absModZ = Math.abs(diff.getZ());
                    if (!(absModX < 2.0) && !(absModZ < 2.0)) continue;
                    overlappingNode = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (overlappingNode) continue;
            Node n = new Node(block.getLocation(), dir);
            NetworkScan networkScan2 = this;
            networkScan2.spawnManager.getNodesStore().setNodeIntoCorrectActiveChunks(n);
            this.sleep();
        }
        this.logger.log("Nodes distributed throughout the network successfully! There are now roughly " + this.roughNodes + " new nodes placed!");
    }

    private void sleep() {
        Thread.yield();
        if (this.REST_TIME > 0L) {
            try {
                Thread.sleep(this.REST_TIME);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void rescanNodes() {
        this.logger.log("Starting revalidating of existing nodes, this may take a short while...");
        NetworkScan networkScan = this;
        networkScan.spawnManager.getNodesStore().revalidateNodesNow();
        this.logger.log("Existing nodes successfully revalidated!");
    }

    public void scanRoadNetwork() {
        if (this.roadNetworkBlocks == null) {
            this.roadNetworkBlocks = new ArrayList<Vector>();
        }
        this.roadNetworkBlocks.clear();
        this.logger.log("Starting indexing of the road network... (This could take a long time)");
        this.blockScan(this.origin.getBlock());
        this.roadScanOutput();
        this.logger.log("Road network indexed!");
    }

    private void roadScanOutput() {
        while (this.countScanBranches() > 0 && System.currentTimeMillis() - this.lastStartTime < 120000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.logger.log("Currently active scan branches: " + this.scansRunning + " Queued extra branches: " + this.queuedBranches.size() + " Current network size: " + this.roughSize);
        }
        int count = 0;
        while ((this.countScanBranches() <= 0 || System.currentTimeMillis() - this.lastStartTime > 120000L) && count < 5) {
            ++count;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (count < 5) {
            this.roadScanOutput();
            return;
        }
        this.roughSize = this.roadNetworkBlocks.size();
    }

    private int countScanBranches() {
        if (this.queuedBranches.size() > 0 && this.scansRunning < SCAN_BRANCH_LIMIT) {
            int toStart = SCAN_BRANCH_LIMIT - this.scansRunning;
            if (toStart > this.queuedBranches.size()) {
                toStart = this.queuedBranches.size();
            }
            for (int i = 0; i < toStart && this.scansRunning < SCAN_BRANCH_LIMIT; ++i) {
                final Block b = this.queuedBranches.get(0);
                this.queuedBranches.remove(0);
                this.incrementScansRunning();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)main.plugin, new Runnable(){

                    @Override
                    public void run() {
                        NetworkScan.this.blockScan(b);
                    }
                });
                Thread.yield();
                try {
                    Thread.sleep(this.REST_TIME);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.queuedBranches.size() > 0 && this.scansRunning < 1) {
            return 1;
        }
        return this.scansRunning;
    }

    private synchronized void incrementScansRunning() {
        ++this.scansRunning;
    }

    private synchronized void decrementScansRunning() {
        --this.scansRunning;
    }

    private boolean isOppositeDirection(int modX, int modZ, BlockFace dir) {
        return dir.getModX() == -modX && dir.getModZ() == -modZ;
    }

    private boolean isSameDirection(int modX, int modZ, BlockFace dir) {
        return dir.getModX() == modX && dir.getModZ() == modZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockScan(final Block block) {
        this.lastStartTime = System.currentTimeMillis();
        if (block == null) {
            this.decrementScansRunning();
            return;
        }
        List<Vector> list = this.roadNetworkBlocks;
        synchronized (list) {
            if (this.roadNetworkBlocks.contains(block.getLocation().toVector())) {
                this.decrementScansRunning();
                return;
            }
            if (this.scansRunning > SCAN_BRANCH_LIMIT) {
                this.queuedBranches.add(block);
                this.decrementScansRunning();
                return;
            }
            ++this.roughSize;
            this.roadNetworkBlocks.add(block.getLocation().toVector());
        }
        try {
            this.sleep();
            Future moreStarted = Bukkit.getScheduler().callSyncMethod((Plugin)main.plugin, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    boolean startedMore = false;
                    for (int modY = -1; modY <= 1; ++modY) {
                        for (int modX = -1; modX <= 1; ++modX) {
                            for (int modZ = -1; modZ <= 1; ++modZ) {
                                try {
                                    final Block newBlock = new Location(block.getWorld(), (double)(block.getX() + modX), (double)(block.getY() + modY), (double)(block.getZ() + modZ)).getBlock();
                                    if (!AIRouter.isTrackBlock(newBlock.getType())) continue;
                                    final boolean originalScan = !startedMore;
                                    startedMore = true;
                                    Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)main.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!originalScan) {
                                                NetworkScan.this.incrementScansRunning();
                                            }
                                            NetworkScan.this.blockScan(newBlock);
                                        }
                                    }, 1L);
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    return startedMore;
                }
            });
            if (!((Boolean)moreStarted.get()).booleanValue()) {
                this.decrementScansRunning();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Stage {
        SCAN_ROAD_NETWORK_BLOCKS(1),
        PLACE_NODES(2),
        SAVE_AND_ACTIVATE(3);

        private int pos;

        private Stage(int pos) {
            this.pos = pos;
        }

        public Stage getNext() {
            int nextPos = this.pos + 1;
            return Stage.getStage(nextPos);
        }

        private static Stage getStage(int pos) {
            for (Stage s : Stage.values()) {
                if (s.pos != pos) continue;
                return s;
            }
            return null;
        }
    }

    public static class Logger {
        private UUID startPlayerUUID;

        public Logger(Player starter) {
            this.startPlayerUUID = starter.getUniqueId();
        }

        public void log(String message) {
            main.plugin.getLogger().info(message);
            Player player = Bukkit.getPlayer((UUID)this.startPlayerUUID);
            if (player != null) {
                player.sendMessage(ChatColor.RED + "[RoadNetworkScan]:" + ChatColor.RESET + message);
            }
        }
    }
}

