/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.UUID;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucars.utils.CarForSale;
import net.stormdev.ucars.utils.UpgradeForSale;

public class SalesManager {
    public File carSaveFile = null;
    public File upgradeSaveFile = null;
    public HashMap<UUID, CarForSale> carsForSale = new HashMap();
    public HashMap<UUID, UpgradeForSale> upgradeForSale = new HashMap();

    public SalesManager(File carSaveFile, File upgradeSaveFile) {
        this.carSaveFile = carSaveFile;
        this.upgradeSaveFile = upgradeSaveFile;
        this.load();
    }

    public synchronized void load() {
        if (this.carSaveFile.length() < 1L || !this.carSaveFile.exists()) {
            try {
                this.carSaveFile.createNewFile();
            }
            catch (IOException e) {
                main.logger.info(main.colors.getError() + "Error creating save file for cars market!");
            }
        } else {
            this.carsForSale = SalesManager.loadHashMapCars(this.carSaveFile.getAbsolutePath());
        }
        if (this.upgradeSaveFile.length() < 1L || !this.upgradeSaveFile.exists()) {
            try {
                this.upgradeSaveFile.createNewFile();
            }
            catch (IOException e) {
                main.logger.info(main.colors.getError() + "Error creating save file for upgrade market!");
            }
        } else {
            this.upgradeForSale = SalesManager.loadHashMapUpgrades(this.upgradeSaveFile.getAbsolutePath());
        }
        if (this.carsForSale == null) {
            this.carsForSale = new HashMap();
        }
    }

    public void saveAll() {
        this.saveCars();
        this.saveUpgrades();
    }

    public synchronized void saveCars() {
        if (!this.carSaveFile.exists() || this.carSaveFile.length() < 1L) {
            try {
                this.carSaveFile.createNewFile();
            }
            catch (IOException e) {
                main.logger.info(main.colors.getError() + "Error creating save file for cars market!");
                return;
            }
        }
        SalesManager.saveHashMapCars(this.carsForSale, this.carSaveFile.getAbsolutePath());
    }

    public synchronized void saveUpgrades() {
        if (!this.upgradeSaveFile.exists() || this.upgradeSaveFile.length() < 1L) {
            try {
                this.upgradeSaveFile.createNewFile();
            }
            catch (IOException e) {
                main.logger.info(main.colors.getError() + "Error creating save file for upgrades market!");
                return;
            }
        }
        SalesManager.saveHashMapUpgrades(this.upgradeForSale, this.upgradeSaveFile.getAbsolutePath());
    }

    public static void saveHashMapCars(HashMap<UUID, CarForSale> map, String path) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));
            oos.writeObject(map);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<UUID, CarForSale> loadHashMapCars(String path) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
            Object result = ois.readObject();
            ois.close();
            return (HashMap)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveHashMapUpgrades(HashMap<UUID, UpgradeForSale> map, String path) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path));
            oos.writeObject(map);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<UUID, UpgradeForSale> loadHashMapUpgrades(String path) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
            Object result = ois.readObject();
            ois.close();
            return (HashMap)result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

