/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucarstrade.cars;

import com.useful.ucars.ItemStackFromId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.stormdev.ucars.trade.main;
import net.stormdev.ucarstrade.cars.DrivenCar;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class CarPresets {
    public static boolean isCarPresetsUsed = false;
    public static boolean isCarAllowedRename = true;
    private static List<CarPreset> carPresets = new ArrayList<CarPreset>();

    public static List<CarPreset> getPresets() {
        return new ArrayList<CarPreset>(carPresets);
    }

    public static void addCarPreset(CarPreset preset) {
        carPresets.add(preset);
    }

    public static void setCarPresetsUsed(boolean b) {
        isCarPresetsUsed = b;
    }

    public static boolean isCarPresetsUsed() {
        return isCarPresetsUsed;
    }

    public static void init(FileConfiguration config) {
        if (!config.contains("general.cars.presets.enabled")) {
            config.set("general.cars.presets.enabled", (Object)false);
            config.set("general.cars.presets.ferarriF50.name", (Object)"Ferrari F50");
            config.set("general.cars.presets.ferarriF50.speed", (Object)1.5);
            config.set("general.cars.presets.ferarriF50.health", (Object)100.0);
            config.set("general.cars.presets.lotusesprit.name", (Object)"Lotus Esprit");
            config.set("general.cars.presets.lotusesprit.speed", (Object)1.2);
            config.set("general.cars.presets.lotusesprit.health", (Object)110.0);
            config.set("general.cars.presets.bugattiveyron.name", (Object)"Bugatti Veyron");
            config.set("general.cars.presets.bugattiveyron.speed", (Object)2.0);
            config.set("general.cars.presets.bugattiveyron.health", (Object)75.0);
            config.set("general.cars.presets.geewhizz.name", (Object)"G-Whizz");
            config.set("general.cars.presets.geewhizz.speed", (Object)0.25);
            config.set("general.cars.presets.geewhizz.health", (Object)50.0);
            config.set("general.cars.presets.mini.name", (Object)"Mini Cooper");
            config.set("general.cars.presets.mini.speed", (Object)1.0);
            config.set("general.cars.presets.mini.health", (Object)50.0);
            config.set("general.cars.presets.terrafugiatransition.name", (Object)"Terrafugia Transition");
            config.set("general.cars.presets.terrafugiatransition.speed", (Object)1.0);
            config.set("general.cars.presets.terrafugiatransition.health", (Object)100.0);
            config.set("general.cars.presets.terrafugiatransition.modifiers", (Object)new String[]{"Hover Upgrade"});
        }
        if (!config.contains("general.cars.presets.allowRename")) {
            config.set("general.cars.presets.allowRename", (Object)false);
        }
        isCarAllowedRename = config.getBoolean("general.cars.presets.allowRename");
        CarPresets.setCarPresetsUsed(config.getBoolean("general.cars.presets.enabled"));
        if (!CarPresets.isCarPresetsUsed()) {
            main.logger.info("Car presets are NOT enabled! Cars will be randomly generated!");
            return;
        }
        ConfigurationSection cars = config.getConfigurationSection("general.cars.presets");
        for (String key : cars.getKeys(false)) {
            ConfigurationSection carSect = cars.getConfigurationSection(key);
            if (carSect == null) {
                if (key == null || key.equals("enabled")) continue;
                main.logger.info("ERROR: No information for car preset: " + key);
                continue;
            }
            if (!(carSect.contains("name") && carSect.contains("speed") && carSect.contains("health"))) {
                main.logger.info("ERROR: Car preset " + key + " doesn't have all necessary fields! (name, speed, health and optionally hover)");
                continue;
            }
            String name = carSect.getString("name");
            double speed = carSect.getDouble("speed");
            double health = carSect.getDouble("health");
            ArrayList<String> modifiers = new ArrayList();
            if (carSect.contains("modifiers")) {
                modifiers = carSect.getStringList("modifiers");
            }
            double accelMod = carSect.contains("acceleration") ? carSect.getDouble("acceleration") / 10.0 : 1.0;
            double turnAmountPerTick = carSect.contains("handling") ? carSect.getDouble("handling") / 10.0 : 5.0;
            MaterialData displayBlock = null;
            double offset = 0.0;
            if (carSect.contains("display")) {
                ItemStack is = ItemStackFromId.get((String)carSect.getString("display"));
                displayBlock = is.getData();
            }
            if (carSect.contains("displayOffset")) {
                offset = carSect.getDouble("displayOffset");
            }
            if (!carSect.contains("passengers.max")) {
                carSect.set("passengers.max", (Object)1);
            }
            if (!carSect.contains("passengers.boatOrientationOffsetDeg")) {
                carSect.set("passengers.boatOrientationOffsetDeg", Arrays.asList(new double[][]{{0.0}}));
            }
            if (!carSect.contains("hitbox.x")) {
                carSect.set("hitbox.x", (Object)-1.0);
            }
            if (!carSect.contains("hitbox.z")) {
                carSect.set("hitbox.z", (Object)-1.0);
            }
            CarPreset cp = new CarPreset(name, speed, health, accelMod, turnAmountPerTick, modifiers, displayBlock, offset);
            cp.setMaxPassengers(carSect.getInt("passengers.max"));
            cp.setBoatOrientationOffsetDeg(ArrayUtils.toPrimitive((Double[])carSect.getDoubleList("passengers.boatOrientationOffsetDeg").toArray(new Double[0])));
            cp.setHitboxX((float)carSect.getDouble("hitbox.x"));
            cp.setHitboxZ((float)carSect.getDouble("hitbox.z"));
            CarPresets.addCarPreset(cp);
        }
        main.logger.info("Loaded " + CarPresets.getPresets().size() + " car presets!");
    }

    public static class CarPreset {
        private String name;
        private double speed;
        private double health;
        private double acceleration;
        private double turnAmountPerTick;
        private MaterialData displayBlock;
        private double displayBlockOffset = 0.0;
        private List<String> modifiers = new ArrayList<String>();
        private int maxPassengers = 1;
        private double[] boatsOrientationOffsetDeg = new double[0];
        private float hitboxX = -1.0f;
        private float hitboxZ = -1.0f;

        public CarPreset(String name, double speed, double health, double accelMod, double turnAmountPerTick, List<String> modifiers, MaterialData displayBlock, double displayBlockOffset) {
            this.name = name;
            this.speed = speed;
            this.health = health;
            this.modifiers = modifiers;
            this.setAcceleration(accelMod);
            this.setTurnAmountPerTick(turnAmountPerTick);
            this.setDisplayBlock(displayBlock);
            this.setDisplayBlockOffset(displayBlockOffset);
        }

        public int getMaxPassengers() {
            return this.maxPassengers;
        }

        public void setMaxPassengers(int maxPassengers) {
            this.maxPassengers = maxPassengers;
        }

        public double[] getBoatOrientationOffsetDeg() {
            return this.boatsOrientationOffsetDeg;
        }

        public void setBoatOrientationOffsetDeg(double[] boatOrientationOffsetDeg) {
            this.boatsOrientationOffsetDeg = boatOrientationOffsetDeg;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getSpeed() {
            return this.speed;
        }

        public void setSpeed(double speed) {
            this.speed = speed;
        }

        public double getHealth() {
            return this.health;
        }

        public void setHealth(double health) {
            this.health = health;
        }

        public List<String> getModifications() {
            return this.modifiers;
        }

        public void setModifications(List<String> modifiers) {
            this.modifiers = modifiers;
        }

        public double getAcceleration() {
            return this.acceleration;
        }

        public void setAcceleration(double acceleration) {
            this.acceleration = acceleration;
        }

        public double getTurnAmountPerTick() {
            return this.turnAmountPerTick;
        }

        public void setTurnAmountPerTick(double turnAmountPerTick) {
            this.turnAmountPerTick = turnAmountPerTick;
        }

        public MaterialData getDisplayBlock() {
            return this.displayBlock;
        }

        public void setDisplayBlock(MaterialData displayBlock) {
            this.displayBlock = displayBlock;
        }

        public boolean hasDisplayBlock() {
            return this.displayBlock != null;
        }

        public double getDisplayBlockOffset() {
            return this.displayBlockOffset;
        }

        public void setDisplayBlockOffset(double displayBlockOffset) {
            this.displayBlockOffset = displayBlockOffset;
        }

        public ItemStack toItemStack() {
            return new DrivenCar(this).toItemStack();
        }

        public float getHitboxX() {
            return this.hitboxX;
        }

        public void setHitboxX(float hitboxX) {
            this.hitboxX = hitboxX;
        }

        public void setHitboxZ(float hitboxZ) {
            this.hitboxZ = hitboxZ;
        }

        public float getHitboxZ() {
            return this.hitboxZ;
        }
    }
}

