/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.ucars.trade;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.stormdev.ucars.trade.main;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;

public class CustomLogger {
    public Boolean coloured = true;
    ConsoleCommandSender console = null;
    Logger logger = null;

    public CustomLogger(ConsoleCommandSender console, Logger logger) {
        try {
            this.coloured = main.config.getBoolean("general.logger.colour");
        }
        catch (Exception e) {
            this.coloured = false;
        }
        this.console = console;
        this.logger = logger;
    }

    public void setColoured(Boolean coloured) {
        this.coloured = coloured;
    }

    public String getMsg(String raw) {
        String colour = main.colorise(raw);
        if (!this.coloured.booleanValue()) {
            return ChatColor.stripColor((String)colour);
        }
        return colour;
    }

    public void log(String message, Level level) {
        this.print(message);
        this.log(level);
    }

    public void defaultLog(String msg, Level level) {
        this.logger.log(level, msg);
    }

    public void log(Level level) {
        this.logger.log(level, "");
    }

    public void error(Exception e) {
        this.print(main.colors.getError() + e.getLocalizedMessage());
        e.printStackTrace();
    }

    public void error(String msg, Exception e) {
        this.print(main.colors.getError() + msg);
        e.printStackTrace();
    }

    public void info(String message) {
        this.print(main.colors.getInfo() + message);
    }

    public void print(String message) {
        if (this.coloured.booleanValue()) {
            this.console.sendMessage(ChatColor.RED + "[uCarsTrade] " + ChatColor.RESET + this.getMsg(message));
        } else {
            this.logger.info(this.getMsg(message));
        }
    }
}

