/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.api;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.stormdev.uPlanes.api.AccelerationModifier;
import net.stormdev.uPlanes.api.Boat;
import net.stormdev.uPlanes.api.BoatDamageEvent;
import net.stormdev.uPlanes.api.BoatDeathEvent;
import net.stormdev.uPlanes.api.BoatTurningModifier;
import net.stormdev.uPlanes.hover.HoverCart;
import net.stormdev.uPlanes.hover.HoverCartEntity;
import net.stormdev.uPlanes.items.ItemBoatValidation;
import net.stormdev.uPlanes.main.BoatGenerator;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.presets.BoatPreset;
import net.stormdev.uPlanes.utils.CartOrientationUtil;
import net.stormdev.uPlanes.utils.Lang;
import net.stormdev.uPlanes.utils.PEntityMeta;
import net.stormdev.uPlanes.utils.StatValue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class uPlanesBoatManager {
    private volatile List<AccelerationModifier> accelMods = new ArrayList<AccelerationModifier>();
    private volatile List<AccelerationModifier> decelMods = new ArrayList<AccelerationModifier>();
    private volatile List<BoatTurningModifier> rotMods = new ArrayList<BoatTurningModifier>();

    protected uPlanesBoatManager() {
    }

    public void addTurningModifier(BoatTurningModifier mod) {
        this.rotMods.add(mod);
    }

    public void removeTurningModifier(BoatTurningModifier mod) {
        this.rotMods.remove(mod);
    }

    public double getAlteredRotationAmountPerTick(Player player, Vehicle cart, Boat plane) {
        double current = plane.getTurnAmountPerTick();
        for (BoatTurningModifier am : new ArrayList<BoatTurningModifier>(this.rotMods)) {
            current *= am.getTurnAmountPerTick(cart, current);
        }
        return current;
    }

    public void addAccelerationModifier(AccelerationModifier mod) {
        this.accelMods.add(mod);
    }

    public void removeAccelerationModifier(AccelerationModifier mod) {
        this.accelMods.remove(mod);
    }

    public void addDecelerationModifier(AccelerationModifier mod) {
        this.decelMods.add(mod);
    }

    public void removeDecelerationModifier(AccelerationModifier mod) {
        this.decelMods.remove(mod);
    }

    public double getAlteredDecelerationMod(Player player, Vehicle cart, Boat plane) {
        double current = 1.0;
        for (AccelerationModifier am : new ArrayList<AccelerationModifier>(this.decelMods)) {
            current *= am.getAccelerationMultiplier(player, cart, plane);
        }
        return current;
    }

    public double getAlteredAccelerationMod(Player player, Vehicle cart, Boat plane) {
        double current = 1.0;
        for (AccelerationModifier am : new ArrayList<AccelerationModifier>(this.accelMods)) {
            try {
                current *= am.getAccelerationMultiplier(player, cart, plane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return current;
    }

    public Boat generateRandomPlane() {
        Boat plane = BoatGenerator.gen();
        return plane;
    }

    public Boat generatePlane(double health, double speed, String name, boolean hover) {
        Boat boat = BoatGenerator.gen();
        boat.setId(UUID.randomUUID());
        boat.setHealth(health);
        boat.setSpeed(speed);
        boat.setName(name);
        return boat;
    }

    public void removeBoat(Boat plane) {
        main.plugin.boatsManager.noLongerPlaced(plane.getId());
    }

    public void removeBoat(UUID planeId) {
        main.plugin.boatsManager.noLongerPlaced(planeId);
    }

    public Boat getBoatById(UUID planeId) {
        return main.plugin.boatsManager.getBoat(planeId);
    }

    public ItemStack getBoatItem(Boat plane) {
        return plane.toItemStack();
    }

    public Boat getBoatFromItem(ItemStack stack) {
        Boat item = ItemBoatValidation.getBoat(stack);
        return item;
    }

    public boolean isABoat(UUID entityId) {
        return main.plugin.boatsManager.isBoatInUse(entityId);
    }

    public boolean isABoat(Entity entity) {
        return this.isABoat(entity.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vehicle placeBoat(Boat plane, Location loc, Vector directionToFace) {
        Class<uPlanesBoatManager> clazz = uPlanesBoatManager.class;
        synchronized (uPlanesBoatManager.class) {
            Vehicle ent;
            BoatPreset pp = plane.getPreset();
            MaterialData display = null;
            double offset = 0.0;
            if (plane.getCartDisplayBlock() != null) {
                display = plane.getCartDisplayBlock();
                offset = plane.getDisplayOffset();
            } else if (pp != null && pp.hasDisplayBlock()) {
                display = pp.getDisplayBlock();
                offset = pp.getDisplayOffset();
            }
            float vYaw = (float)Math.toDegrees(Math.atan2(directionToFace.getX(), -directionToFace.getZ()));
            plane.getBoatState().setCurYaw(vYaw -= 90.0f);
            if (display == null) {
                ent = (Vehicle)loc.getWorld().spawnEntity(loc, EntityType.MINECART);
            } else {
                HoverCartEntity hce = new HoverCartEntity(loc.clone().add(0.0, 0.3, 0.0));
                hce.setHitBoxX(plane.getHitboxX());
                hce.setHitBoxZ(plane.getHitboxZ());
                hce.setMaxPassengers(plane.getMaxPassengers());
                hce.setBoatOffsetDeg(plane.getBoatRotationOffsetDegrees());
                HoverCart hc = hce.spawn();
                ent = hc;
                hc.setDisplay(new ItemStack(display.getItemType(), 1, (short)display.getData()), offset);
                main.plugin.protocolManipulator.sendSpawns(hce, hc);
            }
            PEntityMeta.setMetadata((Entity)ent, "ucars.ignore", new StatValue(true, (Plugin)main.plugin));
            PEntityMeta.setMetadata((Entity)ent, "plane.health", new StatValue(plane.getHealth(), (Plugin)main.plugin));
            PEntityMeta.setMetadata((Entity)ent, "plane.direction", new StatValue(directionToFace.clone(), (Plugin)main.plugin));
            plane.setId(ent.getUniqueId());
            plane.setRoll(0.0);
            CartOrientationUtil.setYaw(ent, vYaw);
            main.plugin.boatsManager.nowPlaced(plane);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ent;
        }
    }

    public Vehicle placeBoat(Boat plane, Location loc) {
        return this.placeBoat(plane, loc, loc.getDirection());
    }

    public Vehicle placeBoat(Boat plane, Location loc, ItemStack planeStack) {
        planeStack.setAmount(planeStack.getAmount() - 1);
        if (planeStack.getAmount() <= 0) {
            planeStack.setType(Material.AIR);
        }
        return this.placeBoat(plane, loc);
    }

    private BoatDamageEvent boatDamageEvent(Vehicle v, Boat p, double dmg, String cause) {
        BoatDamageEvent pde = new BoatDamageEvent(v, p, dmg, cause);
        Bukkit.getPluginManager().callEvent((Event)pde);
        return pde;
    }

    public ItemStack destroyBoat(Vehicle vehicle, Boat plane) {
        UUID id = vehicle.getUniqueId();
        main.plugin.planeManager.noLongerPlaced(id);
        Entity top = vehicle.getPassenger();
        if (top instanceof Player) {
            top.eject();
            top.setVelocity(vehicle.getVelocity());
        }
        vehicle.eject();
        vehicle.remove();
        ItemStack i = plane.toItemStack();
        return i;
    }

    public void damageBoat(Vehicle m, Boat plane, double damage, Player damager, boolean breakIt) {
        if (m.hasMetadata("invincible") || PEntityMeta.hasMetadata((Entity)m, "invincible")) {
            return;
        }
        double health = plane.getHealth();
        if (PEntityMeta.hasMetadata((Entity)m, "plane.health")) {
            List<MetadataValue> ms = PEntityMeta.getMetadata((Entity)m, "plane.health");
            health = (Double)ms.get(0).value();
        }
        String msg = Lang.get("general.damage.msg");
        msg = msg.replaceAll(Pattern.quote("%damage%"), damage + "HP");
        if ((health -= damage) <= 0.0) {
            health = 0.0;
        }
        health = (double)Math.round(health * 10.0) / 10.0;
        msg = msg.replaceAll(Pattern.quote("%remainder%"), health + "HP");
        msg = msg.replaceAll(Pattern.quote("%cause%"), "Fist");
        damager.sendMessage(main.colors.getInfo() + msg);
        this.damageBoat(m, plane, damage, breakIt);
    }

    public void damageBoat(Vehicle m, Boat plane, double damage, Player damager, String cause, boolean breakIt) {
        if (m.hasMetadata("invincible") || PEntityMeta.hasMetadata((Entity)m, "invincible")) {
            return;
        }
        double health = plane.getHealth();
        if (PEntityMeta.hasMetadata((Entity)m, "plane.health")) {
            List<MetadataValue> ms = PEntityMeta.getMetadata((Entity)m, "plane.health");
            health = (Double)ms.get(0).value();
        }
        String msg = Lang.get("general.damage.msg");
        msg = msg.replaceAll(Pattern.quote("%damage%"), damage + "HP");
        if ((health -= damage) <= 0.0) {
            health = 0.0;
        }
        health = (double)Math.round(health * 10.0) / 10.0;
        msg = msg.replaceAll(Pattern.quote("%remainder%"), health + "HP");
        msg = msg.replaceAll(Pattern.quote("%cause%"), cause);
        damager.sendMessage(main.colors.getInfo() + msg);
        this.damageBoat(m, plane, damage, breakIt);
    }

    public void damageBoat(Vehicle m, Boat plane, double damage, Player damager, String cause) {
        this.damageBoat(m, plane, damage, damager, cause, true);
    }

    public void damageBoat(Vehicle m, Boat plane, double damage, Player damager) {
        this.damageBoat(m, plane, damage, damager, true);
    }

    public void damageBoat(Vehicle m, Boat plane, double damage) {
        this.damageBoat(m, plane, damage, true);
    }

    public void damageBoat(Vehicle m, Boat plane, double damage, String cause) {
        this.damageBoat(m, plane, damage, cause, true);
    }

    public void damageBoat(Vehicle m, Boat plane, double damage, String cause, boolean breakIt) {
        if (m.hasMetadata("invincible") || PEntityMeta.hasMetadata((Entity)m, "invincible")) {
            return;
        }
        BoatDamageEvent evt1 = this.boatDamageEvent(m, plane, damage, cause);
        if (evt1.isCancelled()) {
            return;
        }
        double health = plane.getHealth();
        if (PEntityMeta.hasMetadata((Entity)m, "plane.health")) {
            List<MetadataValue> ms = PEntityMeta.getMetadata((Entity)m, "plane.health");
            health = (Double)ms.get(0).value();
        }
        String msg = Lang.get("general.damage.msg");
        Boolean die = false;
        msg = msg.replaceAll(Pattern.quote("%damage%"), damage + "HP");
        if ((health -= damage) <= 0.0) {
            die = true;
            health = 0.0;
        }
        health = (double)Math.round(health * 10.0) / 10.0;
        msg = msg.replaceAll(Pattern.quote("%remainder%"), health + "HP");
        msg = msg.replaceAll(Pattern.quote("%cause%"), cause);
        if (m.getPassenger() != null && m.getPassenger() instanceof Player) {
            ((Player)m.getPassenger()).sendMessage(main.colors.getInfo() + msg);
        }
        PEntityMeta.removeMetadata((Entity)m, "plane.health");
        PEntityMeta.setMetadata((Entity)m, "plane.health", new StatValue(health, (Plugin)main.plugin));
        if (die.booleanValue() || health < 0.1 && breakIt) {
            BoatDeathEvent evt = new BoatDeathEvent(m, plane);
            main.plugin.getServer().getPluginManager().callEvent((Event)evt);
            if (!evt.isCancelled()) {
                main.plugin.listener.killBoat(m, plane);
            }
        }
    }

    public void healBoat(Vehicle m, Boat plane) {
        double health = plane.getHealth();
        PEntityMeta.removeMetadata((Entity)m, "plane.health");
        PEntityMeta.setMetadata((Entity)m, "plane.health", new StatValue(health, (Plugin)main.plugin));
    }

    public void damageBoat(Vehicle m, Boat plane, double damage, boolean breakIt) {
        this.damageBoat(m, plane, damage, "Damage", breakIt);
    }
}

