/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.main;

import net.stormdev.uPlanes.api.Boat;
import net.stormdev.uPlanes.api.uPlanesAPI;
import net.stormdev.uPlanes.main.main;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.util.Vector;

public class BoatState {
    public static final double MAX_STEERING_ANGLE = 10.0;
    private Boat boat;
    private Vector vel = new Vector(0, 0, 0);
    private double throttleAmt = 0.0;
    private double dragConstant = 250.0;
    private double thrustYawOffsetAngleDeg = 0.0;
    private double yawRateDeg = 0.0;
    private double planingSpeed = 1.0;
    private double curYaw = 0.0;
    private double errorY = 0.0;
    private double throttleLimit = 1.0;

    public BoatState(Boat b) {
        this.boat = b;
        this.dragConstant *= b.getAccelMod();
    }

    public double getThrottleLimit() {
        return this.throttleLimit;
    }

    public void setThrottleLimit(double throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    public void clearThrottleLimit() {
        this.setThrottleLimit(1.0);
    }

    public void updateVelocitiesYawForThisGameTick(Vehicle vehicle) {
        double maxTurnRatePerTick = this.boat.getTurnAmountPerTick();
        Player pl = null;
        if (vehicle.getPassenger() != null && vehicle.getPassenger() instanceof Player) {
            pl = (Player)vehicle.getPassenger();
            this.dragConstant = 250.0 * uPlanesAPI.getBoatManager().getAlteredAccelerationMod(pl, vehicle, this.boat);
            maxTurnRatePerTick = uPlanesAPI.getBoatManager().getAlteredRotationAmountPerTick(pl, vehicle, this.boat);
        } else {
            this.dragConstant = 250.0 * this.boat.getAccelMod();
        }
        boolean floating = false;
        double yCoord = vehicle.getLocation().getY();
        Block under = vehicle.getLocation().getBlock().getRelative(BlockFace.DOWN);
        double targetY = -1.0;
        if (under.isLiquid()) {
            floating = true;
            targetY = (double)under.getY() + 1.05;
            if (vehicle.getLocation().getBlock().isLiquid()) {
                targetY += 1.0;
            }
        } else if (!under.isEmpty()) {
            targetY = (double)under.getY() + 1.05;
        }
        Vector directionVector = new Vector(-Math.sin(Math.toRadians(this.curYaw)), 0.0, Math.cos(Math.toRadians(this.curYaw)));
        Vector travelDir = directionVector.clone();
        Vector thrustForce = travelDir.clone().multiply(this.getThrustForce() * (double)(floating ? 1 : 0));
        Vector toTheRightOfDir = travelDir.crossProduct(new Vector(0, 1, 0));
        double forwardVel = this.vel.clone().setY(0).dot(directionVector);
        double sideSlipVel = toTheRightOfDir.dot(this.vel.clone().setY(0));
        double totalMoment = this.getDragYawingMoment(maxTurnRatePerTick) + this.getThrustYawingMoment() + this.getRudderYawingMoment(forwardVel);
        double wdot = totalMoment / this.yawMomentOfInertia();
        double d = this.yawRateDeg = !floating ? 0.0 : this.yawRateDeg + Math.toDegrees(wdot);
        if (this.yawRateDeg > 80.0) {
            this.yawRateDeg = 80.0;
        }
        if (this.yawRateDeg < -80.0) {
            this.yawRateDeg = -80.0;
        }
        this.curYaw += this.yawRateDeg * 0.05;
        while (this.curYaw > 180.0) {
            this.curYaw -= 360.0;
        }
        while (this.curYaw < -180.0) {
            this.curYaw += 360.0;
        }
        Vector sideslipDragForce = toTheRightOfDir.clone().multiply(-0.45 * sideSlipVel * this.boat.getMass());
        double mass = this.boat.getMass();
        if (mass < 1.0) {
            mass = 1000.0;
        }
        mass *= 3.5;
        Vector forwardDragForce = this.vel.clone().multiply(-Math.abs(this.getDragForce(forwardVel, this.boat.getCurrentPitch())));
        if (Math.abs(forwardVel) < 0.1) {
            forwardDragForce = this.vel.clone().setY(0).multiply(-mass);
        }
        double errorY = yCoord - targetY;
        Vector verticalPerturbForce = new Vector(0.0, -0.5 + main.plugin.random.nextDouble() * mass * 4.0 + (-0.5 + main.plugin.random.nextDouble() * mass * 40.0) * forwardVel, 0.0);
        if (!floating || Math.abs(errorY) > 0.1) {
            verticalPerturbForce = verticalPerturbForce.multiply(0);
        }
        Vector totalForce = thrustForce.clone().add(forwardDragForce).add(sideslipDragForce).add(verticalPerturbForce);
        Vector accel = totalForce.multiply(1.0 / mass);
        this.vel = this.vel.add(accel.multiply(0.05));
        if (this.vel.lengthSquared() > 1000000.0) {
            Bukkit.broadcastMessage((String)"Error in vel magnitude");
            this.vel = this.vel.normalize().multiply(3);
        }
        if (targetY < 0.0) {
            double fallYVel = this.vel.getY() - 4.905;
            if (fallYVel < -3.0) {
                fallYVel = -3.0;
            }
            this.vel.setY(fallYVel);
        } else {
            double yV;
            double errorDy = this.vel.getY();
            if (errorDy > 2.0) {
                errorDy = 2.0;
            }
            if (errorDy < -2.0) {
                errorDy = -2.0;
            }
            double kP = 0.7;
            double kD = 0.3;
            double kI = 0.7;
            double errorYI = this.errorY;
            this.errorY += errorY * 0.05;
            if (this.errorY > 1.0) {
                this.errorY = 1.0;
            }
            if (this.errorY < -1.0) {
                this.errorY = -1.0;
            }
            if ((yV = this.vel.getY() - kP * errorY) > 0.2) {
                yV = 0.2;
            }
            if (yV < -0.2) {
                yV = -0.2;
            }
            this.vel.setY(yV);
        }
        float targetPitch = (float)((double)((float)this.getNominalPitch(forwardVel)) + (-0.5 + main.plugin.random.nextDouble()) * forwardVel);
        float curPitch = this.boat.getCurrentPitch();
        this.boat.setCurrentPitch((float)((double)curPitch - 0.2 * (double)(curPitch - targetPitch)));
        double targetRoll = this.getNominalRoll(forwardVel, this.yawRateDeg, maxTurnRatePerTick) + (-0.5 + main.plugin.random.nextDouble()) * 2.0;
        double currentRoll = this.boat.getRoll();
        double errorRoll = currentRoll - targetRoll;
        this.boat.setRoll((float)(currentRoll - 0.095 * errorRoll));
    }

    public double getDragYawingMoment(double maxTurnRatePerTick) {
        double sign = 1.0;
        if (this.yawRateDeg > 0.0) {
            sign = -1.0;
        }
        double maxYawRate = maxTurnRatePerTick * 20.0;
        double equilibriumVal = this.getMaxThrustYawingMoment() + this.getMaxRudderYawingMoment();
        double k = equilibriumVal / (Math.abs(Math.pow(maxYawRate, 2.0)) * Math.cos(Math.toRadians(this.getNominalPitch(Math.pow(this.getBoatMaxRealSpeed(), 2.0)))));
        double dragMoment = sign * k * Math.abs(Math.pow(this.yawRateDeg, 2.0)) * Math.cos(Math.toRadians(this.boat.getCurrentPitch()));
        if (Math.abs(dragMoment) > Math.abs(this.yawMomentOfInertia() * this.yawRateDeg)) {
            dragMoment = sign * this.yawMomentOfInertia() * Math.abs(this.yawRateDeg);
        }
        return dragMoment;
    }

    public double getCurYaw() {
        return this.curYaw;
    }

    public void setCurYaw(double curYaw) {
        this.curYaw = curYaw - 90.0;
        this.errorY = 0.0;
    }

    public double getYawRateDeg() {
        return this.yawRateDeg;
    }

    public void setYawRateDeg(double yawRate) {
        this.yawRateDeg = yawRate;
    }

    public double getThrustYawOffsetAngleDeg() {
        return this.thrustYawOffsetAngleDeg;
    }

    public void setThrustYawOffsetAngleDeg(double thrustYawOffsetAngleDeg) {
        this.thrustYawOffsetAngleDeg = thrustYawOffsetAngleDeg;
    }

    public double getRudderYawingMoment(double forwardVel) {
        double speedMultiplier = Math.abs(forwardVel) / this.getBoatMaxRealSpeed();
        if (speedMultiplier < 0.3 && (speedMultiplier = Math.abs(forwardVel) / 0.5) > 0.3) {
            speedMultiplier = 0.3;
        }
        double sign = 1.0;
        if (forwardVel < 0.0) {
            sign = -1.0;
        }
        return sign * speedMultiplier * 0.1 * (double)this.boat.getHitboxX() * Math.sin(Math.toRadians(this.thrustYawOffsetAngleDeg)) * this.getMaxThrustForce();
    }

    public double getMaxRudderYawingMoment() {
        return 0.1 * (double)this.boat.getHitboxX() * Math.sin(Math.toRadians(10.0)) * this.getMaxThrustForce() * Math.cos(Math.toRadians(10.0));
    }

    public double getThrustYawingMoment() {
        return 0.9 * (double)this.boat.getHitboxX() * Math.sin(Math.toRadians(this.thrustYawOffsetAngleDeg)) * this.getMaxThrustForce() * this.getThrustMultiplier();
    }

    public double getMaxThrustYawingMoment() {
        return 0.9 * (double)this.boat.getHitboxX() * Math.sin(Math.toRadians(10.0)) * this.getMaxThrustForce();
    }

    public double yawMomentOfInertia() {
        double l = 2.0f * this.boat.getHitboxX();
        return 0.8333333333333333 * this.boat.getMass() * Math.pow(l, 2.0);
    }

    public double getThrustMultiplier() {
        return this.getThrottleLimit() * (Math.exp(this.throttleAmt) - 1.0) / (Math.exp(1.0) - 1.0);
    }

    public double getThrustForce() {
        return this.getMaxThrustForce() * this.getThrustMultiplier() * Math.cos(Math.toRadians(this.thrustYawOffsetAngleDeg));
    }

    public double getBoatMaxRealSpeed() {
        return this.boat.getSpeed();
    }

    public double getMaxThrustForce() {
        return Math.abs(this.getDragForce(this.getBoatMaxRealSpeed(), this.getNominalPitch(this.getBoatMaxRealSpeed())));
    }

    public double getNominalRoll(double speed, double yawRateDeg, double maxTurnRatePerTick) {
        if (speed < this.planingSpeed) {
            return 0.0;
        }
        double maxRoll = 45.0;
        return -maxRoll * yawRateDeg / (maxTurnRatePerTick * 20.0);
    }

    public double getNominalPitch(double speed) {
        double pitch = speed * (20.0 / Math.pow(this.getBoatMaxRealSpeed() * 0.7, 1.0));
        if (pitch > 20.0) {
            pitch = 20.0;
        }
        if (pitch < -5.0) {
            pitch = -5.0;
        }
        return -pitch;
    }

    public double getDragForce() {
        return this.getDragForce(this.vel.clone().setY(0).length(), this.boat.getCurrentPitch());
    }

    public double getDragForce(double vel, double pitchDeg) {
        double sign = 1.0;
        if (vel > 0.0) {
            sign = -1.0;
        }
        double dragMultiplier = 1.0;
        double velRatio = vel / 1.2;
        if (velRatio > 1.0) {
            dragMultiplier *= 1.0 / velRatio;
        }
        if (velRatio < 0.75) {
            dragMultiplier *= 1.0 / (velRatio + 0.25);
        }
        if (dragMultiplier < 0.2) {
            dragMultiplier = 0.2;
        }
        return sign * Math.abs(Math.cos(Math.toRadians(pitchDeg))) * dragMultiplier * this.dragConstant * Math.pow(vel, 2.0);
    }

    public float getBukkitVelVectorYaw() {
        return this.getVelVectorYaw() - 90.0f;
    }

    public float getVelVectorYaw() {
        return (float)Math.toDegrees(Math.atan2(this.vel.getX(), -this.vel.getZ()));
    }

    public Vector getVelBlocksPerSec() {
        return this.vel;
    }

    public void setVelBlocksPerSec(Vector vel) {
        this.vel = vel;
    }

    public double getThrottleAmt() {
        return this.throttleAmt;
    }

    public void setThrottleAmt(double throttleAmt) {
        this.throttleAmt = throttleAmt;
    }
}

