/*
 * Decompiled with CFR 0.152.
 */
package net.stormdev.uPlanes.utils;

import com.useful.uCarsAPI.CarCheck;
import com.useful.uCarsAPI.ItemCarCheck;
import com.useful.uCarsAPI.uCarsAPI;
import java.util.List;
import java.util.UUID;
import net.stormdev.uPlanes.main.main;
import net.stormdev.uPlanes.utils.PEntityMeta;
import net.stormdev.uPlanes.utils.StatValue;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class uCarsCompatibility {
    public static void run() {
        main.logger.info("Sorting uCars compatibility...");
        uCarsAPI api = uCarsAPI.getAPI();
        api.hookPlugin((Plugin)main.plugin);
        api.registerCarCheck((Plugin)main.plugin, new CarCheck(){

            public Boolean isACar(Entity car) {
                if (main.plugin.planeManager.isPlaneInUse(car.getUniqueId()).booleanValue() || main.plugin.boatsManager.isBoatInUse(car.getUniqueId()).booleanValue()) {
                    PEntityMeta.setMetadata(car, "ucars.ignore", new StatValue(true, (Plugin)main.plugin));
                    return false;
                }
                return true;
            }
        });
        api.registerItemCarCheck((Plugin)main.plugin, new ItemCarCheck(){

            public Boolean isACar(ItemStack carStack) {
                UUID uuid;
                ItemMeta im = carStack.getItemMeta();
                if (im == null) {
                    return true;
                }
                List lore = im.getLore();
                if (im == null || lore == null || lore.size() < 1) {
                    return true;
                }
                String id = (String)lore.get(0);
                try {
                    uuid = UUID.fromString(id);
                }
                catch (Exception e) {
                    return true;
                }
                if (main.plugin.planeManager.isAPlane(carStack).booleanValue()) {
                    return false;
                }
                if (main.plugin.planeManager.isPlaneInUse(uuid).booleanValue()) {
                    return false;
                }
                if (main.plugin.boatsManager.isABoat(carStack).booleanValue()) {
                    return false;
                }
                if (main.plugin.boatsManager.isBoatInUse(uuid).booleanValue()) {
                    return false;
                }
                return true;
            }
        });
        main.logger.info("Allowed for car compatibility!");
    }
}

