/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars;

import com.useful.ucars.ucarDeathEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CarHealthData
implements MetadataValue {
    double health = 5.0;
    Plugin plugin = null;

    public CarHealthData(double health, Plugin plugin) {
        this.health = health;
        this.plugin = plugin;
    }

    public boolean asBoolean() {
        return false;
    }

    public byte asByte() {
        return 0;
    }

    public double asDouble() {
        return this.health;
    }

    public float asFloat() {
        return (float)this.health;
    }

    public int asInt() {
        return (int)Math.floor(this.health + 0.5);
    }

    public long asLong() {
        return Math.round(this.health);
    }

    public short asShort() {
        return Short.parseShort("" + this.health);
    }

    public String asString() {
        return "" + this.health;
    }

    public Plugin getOwningPlugin() {
        return this.plugin;
    }

    public void invalidate() {
        this.health = 0.0;
    }

    public Object value() {
        return this.health;
    }

    public void damage(double amount, Entity carEntity) {
        this.health = (double)((int)this.health) - amount;
        if (this.health <= 0.0) {
            this.die(carEntity);
        }
    }

    public void damage(double amount, Entity carEntity, Player whoHurt) {
        this.health = (double)((int)this.health) - amount;
        if (this.health <= 0.0) {
            this.die(carEntity, whoHurt);
        }
    }

    public void setHealth(double amount) {
        this.health = (int)amount;
    }

    public double getHealth() {
        return this.health;
    }

    public void die(Entity m, Player whoHurt) {
        if (m == null || !m.isValid() || m.isDead()) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new ucarDeathEvent(m, whoHurt));
    }

    public void die(Entity carEntity) {
        if (carEntity == null || !carEntity.isValid() || carEntity.isDead()) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new ucarDeathEvent(carEntity));
    }
}

