/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars;

import com.useful.ucars.CarDirection;

public class SmoothMeta {
    private volatile long lastTime;
    private volatile float speedFactor = 0.0f;
    private volatile float accFac = 1.0f;
    private volatile float decFac = 1.0f;
    private volatile CarDirection dir = CarDirection.FORWARDS;
    private volatile long firstAirTime = System.currentTimeMillis();

    public SmoothMeta(float accFac, float decFac) {
        this.lastTime = System.currentTimeMillis();
        this.accFac = accFac;
        this.decFac = decFac;
        this.firstAirTime = System.currentTimeMillis();
    }

    public void setFirstAirTime(long sf) {
        this.firstAirTime = sf;
    }

    public long getFirstAirTime() {
        return this.firstAirTime;
    }

    public void setCurrentSpeedFactor(float sf) {
        this.speedFactor = sf;
    }

    public float getCurrentSpeedFactor() {
        return this.speedFactor;
    }

    public CarDirection getDirection() {
        return this.dir;
    }

    public float getFactor(CarDirection dir) {
        this.updateTime();
        return this.incrementAndGetFactor(dir);
    }

    public void updateAccelerationFactor(float accFac) {
        this.accFac = accFac;
    }

    public void updateDecelerationFactor(float decFac) {
        this.decFac = decFac;
    }

    private float getA() {
        return (float)(0.025 * (double)this.accFac);
    }

    private float getDA(boolean reversing) {
        if (!reversing) {
            return (float)(0.025 * (double)this.decFac);
        }
        return (float)(0.035 * (double)this.decFac);
    }

    private float incrementAndGetFactor(CarDirection dir) {
        if (dir.equals((Object)CarDirection.NONE)) {
            this.decrementFactor(false);
            if (this.dir.equals((Object)CarDirection.BACKWARDS)) {
                return -this.speedFactor;
            }
            return this.speedFactor;
        }
        if (!this.dir.equals((Object)dir) && this.speedFactor > 0.0f) {
            this.decrementFactor(true);
            return -this.speedFactor;
        }
        this.dir = dir;
        this.incrementFactor();
        return this.speedFactor;
    }

    private void incrementFactor(CarDirection dir) {
        if (dir.equals((Object)CarDirection.NONE)) {
            this.decrementFactor(false);
            return;
        }
        if (!this.dir.equals((Object)dir) && this.speedFactor > 0.0f) {
            this.decrementFactor(true);
        }
        this.dir = dir;
        this.incrementFactor();
    }

    private void decrementFactor(boolean reversing) {
        float diff = this.speedFactor;
        this.speedFactor -= this.getDA(reversing) * diff;
        if ((double)this.speedFactor <= 0.05) {
            this.speedFactor = 0.0f;
            return;
        }
    }

    private void incrementFactor() {
        if ((double)this.speedFactor >= 0.97) {
            this.speedFactor = 1.0f;
            return;
        }
        float diff = 1.0f - this.speedFactor;
        this.speedFactor += this.getA() * diff;
    }

    public void resetAcel() {
        this.speedFactor = 0.0f;
    }

    private void updateTime() {
        long now;
        this.lastTime = now = System.currentTimeMillis();
    }
}

