/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars;

import com.useful.ucars.ucars;
import com.useful.ucarsCommon.IdMaterialConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigVersionConverter {
    public static FileConfiguration convert(FileConfiguration config, double target) {
        ucars.plugin.getLogger().info("Converting config to new format...");
        double td = target * 10.0;
        int t = (int)td;
        switch (t) {
            case 11: {
                ConfigVersionConverter.fromV16ToV17(config);
                config.set("misc.configVersion", (Object)1.1);
            }
        }
        return config;
    }

    public static FileConfiguration fromV16ToV17(FileConfiguration config) {
        ConfigVersionConverter.convertItemFormat(config, "general.cars.lowBoost");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.medBoost");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.highBoost");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.blockBoost");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.HighblockBoost");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.ResetblockBoost");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.jumpBlock");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.teleportBlock");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.trafficLights.waitingBlock");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.roadBlocks.ids");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.fuel.check");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.fuel.items.ids");
        ConfigVersionConverter.convertItemFormat(config, "general.cars.barriers");
        ConfigVersionConverter.convertSpeedModsFormat(config, "general.cars.speedMods");
        ucars.plugin.getLogger().info("Config successfully converted!");
        return config;
    }

    public static FileConfiguration convertItemFormat(FileConfiguration config, String configKey) {
        String[] rawIds = config.getString(configKey).split(",");
        List<String> newIds = ConfigVersionConverter.convertItemsToNewFormat(rawIds);
        config.set(configKey, null);
        config.set(configKey, newIds);
        return config;
    }

    public static FileConfiguration convertSpeedModsFormat(FileConfiguration config, String configKey) {
        String[] rawIds = config.getString(configKey).split(",");
        List<String> newIds = ConfigVersionConverter.convertSpeedModsToNewFormat(rawIds);
        config.set(configKey, null);
        config.set(configKey, newIds);
        return config;
    }

    public static List<String> convertItemsToNewFormat(String[] rawIds) {
        ArrayList<String> newIds = new ArrayList<String>();
        for (String raw : rawIds) {
            try {
                String[] parts = raw.split(":");
                if (parts.length >= 1) {
                    Material mat;
                    int id;
                    if (parts.length < 2) {
                        id = Integer.parseInt(parts[0]);
                        mat = IdMaterialConverter.getMaterialById(id);
                        newIds.add(mat.name().toUpperCase());
                        continue;
                    }
                    id = Integer.parseInt(parts[0]);
                    mat = IdMaterialConverter.getMaterialById(id);
                    int data = Integer.parseInt(parts[1]);
                    String newFormat = mat.name().toUpperCase() + ":" + data;
                    newIds.add(newFormat);
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ucars.plugin.getLogger().info("Invalid config value: " + raw + ", skipping...");
        }
        return newIds;
    }

    public static List<String> convertSpeedModsToNewFormat(String[] rawIds) {
        ArrayList<String> newIds = new ArrayList<String>();
        for (String raw : rawIds) {
            try {
                String[] segments = raw.split(Pattern.quote("-"));
                String[] parts = segments[0].split(":");
                String mod = segments[1];
                if (parts.length >= 1) {
                    Material mat;
                    int id;
                    if (parts.length < 2) {
                        id = Integer.parseInt(parts[0]);
                        mat = IdMaterialConverter.getMaterialById(id);
                        newIds.add(mat.name().toUpperCase() + "-" + mod);
                        continue;
                    }
                    id = Integer.parseInt(parts[0]);
                    mat = IdMaterialConverter.getMaterialById(id);
                    int data = Integer.parseInt(parts[1]);
                    String newFormat = mat.name().toUpperCase() + ":" + data;
                    newIds.add(newFormat + "-" + mod);
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ucars.plugin.getLogger().info("Invalid config speedmod: " + raw + ", skipping...");
        }
        return newIds;
    }
}

