/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars;

import com.useful.uCarsAPI.CarRespawnReason;
import com.useful.uCarsAPI.uCarCrashEvent;
import com.useful.uCarsAPI.uCarRespawnEvent;
import com.useful.uCarsAPI.uCarsAPI;
import com.useful.ucars.CarDirection;
import com.useful.ucars.CarHealthData;
import com.useful.ucars.CartOrientationUtil;
import com.useful.ucars.ClosestFace;
import com.useful.ucars.ControlInput;
import com.useful.ucars.ItemStackFromId;
import com.useful.ucars.Lang;
import com.useful.ucars.PlaceManager;
import com.useful.ucars.Reflect;
import com.useful.ucars.controls.ControlSchemeManager;
import com.useful.ucars.ucarDeathEvent;
import com.useful.ucars.ucarUpdateEvent;
import com.useful.ucars.ucars;
import com.useful.ucars.util.UEntityMeta;
import com.useful.ucarsCommon.StatValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class uCarsListener
implements Listener {
    private ucars plugin;
    private List<String> ignoreJump = null;
    private Boolean carsEnabled = true;
    private Boolean licenseEnabled = false;
    private Boolean roadBlocksEnabled = false;
    private Boolean trafficLightsEnabled = true;
    private Boolean effectBlocksEnabled = true;
    private Boolean usePerms = false;
    private Boolean fuelEnabled = false;
    private Boolean fuelUseItems = false;
    private double defaultSpeed = 30.0;
    private static double defaultHealth = 10.0;
    private double damage_water = 0.0;
    private double damage_lava = 10.0;
    private double damage_cactus = 5.0;
    private double uCar_jump_amount = 5.0;
    private double crash_damage = 0.0;
    private double hitby_crash_damage = 0.0;
    private String fuelBypassPerm = "ufuel.bypass";
    private List<String> roadBlocks = new ArrayList<String>();
    private List<String> trafficLightRawIds = new ArrayList<String>();
    private List<String> blockBoost = new ArrayList<String>();
    private List<String> highBlockBoost = new ArrayList<String>();
    private List<String> resetBlockBoost = new ArrayList<String>();
    private List<String> jumpBlock = new ArrayList<String>();
    private List<String> teleportBlock = new ArrayList<String>();
    private List<String> barriers = new ArrayList<String>();
    private ConcurrentHashMap<String, Double> speedMods = new ConcurrentHashMap();

    public uCarsListener(ucars plugin) {
        this.plugin = ucars.plugin;
        this.ignoreJump = new ArrayList<String>();
        this.ignoreJump.add("AIR");
        this.ignoreJump.add("LAVA");
        this.ignoreJump.add("STATIONARY_LAVA");
        this.ignoreJump.add("WATER");
        this.ignoreJump.add("STATIONARY_WATER");
        this.ignoreJump.add("COBBLE_WALL");
        this.ignoreJump.add("FENCE");
        this.ignoreJump.add("NETHER_FENCE");
        this.ignoreJump.add("STONE_PLATE");
        this.ignoreJump.add("WOOD_PLATE");
        this.ignoreJump.add("TRIPWIRE");
        this.ignoreJump.add("TRIPWIRE_HOOK");
        this.ignoreJump.add("TORCH");
        this.ignoreJump.add("REDSTONE_TORCH_ON");
        this.ignoreJump.add("REDSTONE_TORCH_OFF");
        this.ignoreJump.add("DIODE_BLOCK_OFF");
        this.ignoreJump.add("DIODE_BLOCK_ON");
        this.ignoreJump.add("REDSTONE_COMPARATOR_OFF");
        this.ignoreJump.add("REDSTONE_COMPARATOR_ON");
        this.ignoreJump.add("VINE");
        this.ignoreJump.add("LONG_GRASS");
        this.ignoreJump.add("STONE_BUTTON");
        this.ignoreJump.add("WOOD_BUTTON");
        this.ignoreJump.add("FENCE_GATE");
        this.ignoreJump.add("LEVER");
        this.ignoreJump.add("SNOW");
        this.ignoreJump.add("DAYLIGHT_DETECTOR");
        this.ignoreJump.add("SIGN_POST");
        this.ignoreJump.add("WALL_SIGN");
        this.ignoreJump.add(Material.ACACIA_FENCE.name());
        this.ignoreJump.add(Material.ACACIA_FENCE_GATE.name());
        this.ignoreJump.add(Material.BIRCH_FENCE.name());
        this.ignoreJump.add(Material.BIRCH_FENCE_GATE.name());
        this.ignoreJump.add(Material.JUNGLE_FENCE.name());
        this.ignoreJump.add(Material.JUNGLE_FENCE_GATE.name());
        this.usePerms = ucars.config.getBoolean("general.permissions.enable");
        this.carsEnabled = ucars.config.getBoolean("general.cars.enable");
        defaultHealth = ucars.config.getDouble("general.cars.health.default");
        this.damage_water = ucars.config.getDouble("general.cars.health.underwaterDamage");
        this.damage_lava = ucars.config.getDouble("general.cars.health.lavaDamage");
        this.damage_cactus = ucars.config.getDouble("general.cars.health.cactusDamage");
        this.defaultSpeed = ucars.config.getDouble("general.cars.defSpeed");
        this.fuelBypassPerm = ucars.config.getString("general.cars.fuel.bypassPerm");
        this.uCar_jump_amount = ucars.config.getDouble("general.cars.jumpAmount");
        this.crash_damage = ucars.config.getDouble("general.cars.health.crashDamage");
        this.hitby_crash_damage = ucars.config.getDouble("general.cars.hitBy.damage");
        this.licenseEnabled = ucars.config.getBoolean("general.cars.licenses.enable");
        this.roadBlocksEnabled = ucars.config.getBoolean("general.cars.roadBlocks.enable");
        this.trafficLightsEnabled = ucars.config.getBoolean("general.cars.trafficLights.enable");
        this.effectBlocksEnabled = ucars.config.getBoolean("general.cars.effectBlocks.enable");
        this.fuelEnabled = ucars.config.getBoolean("general.cars.fuel.enable");
        this.fuelUseItems = ucars.config.getBoolean("general.cars.fuel.items.enable");
        if (this.roadBlocksEnabled.booleanValue()) {
            List ids = ucars.config.getStringList("general.cars.roadBlocks.ids");
            ids.addAll(ucars.config.getStringList("general.cars.blockBoost"));
            ids.addAll(ucars.config.getStringList("general.cars.HighblockBoost"));
            ids.addAll(ucars.config.getStringList("general.cars.ResetblockBoost"));
            ids.addAll(ucars.config.getStringList("general.cars.jumpBlock"));
            ids.add("AIR");
            ids.add("LAVA");
            ids.add("STATIONARY_LAVA");
            ids.add("WATER");
            ids.add("STATIONARY_WATER");
            this.roadBlocks = ids;
        }
        if (this.trafficLightsEnabled.booleanValue()) {
            this.trafficLightRawIds = ucars.config.getStringList("general.cars.trafficLights.waitingBlock");
        }
        if (this.effectBlocksEnabled.booleanValue()) {
            this.blockBoost = ucars.config.getStringList("general.cars.blockBoost");
            this.highBlockBoost = ucars.config.getStringList("general.cars.HighblockBoost");
            this.resetBlockBoost = ucars.config.getStringList("general.cars.ResetblockBoost");
            this.jumpBlock = ucars.config.getStringList("general.cars.jumpBlock");
            this.teleportBlock = ucars.config.getStringList("general.cars.teleportBlock");
        }
        this.barriers = ucars.config.getStringList("general.cars.barriers");
        List units = ucars.config.getStringList("general.cars.speedMods");
        for (String unit : units) {
            String[] sections = unit.split("-");
            try {
                String rawMat = sections[0];
                double mult = Double.parseDouble(sections[1]);
                this.speedMods.put(rawMat, mult);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Vector calculateCarStats(Entity car, Player player, Vector velocity, double currentMult) {
        if (UEntityMeta.hasMetadata(car, "car.frozen")) {
            velocity = new Vector(0, 0, 0);
            return velocity;
        }
        velocity = this.plugin.getAPI().getTravelVector(car, velocity, currentMult);
        return velocity;
    }

    public boolean trafficlightSignOn(Block block) {
        Sign sign;
        return block.getRelative(BlockFace.NORTH).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.NORTH).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : (block.getRelative(BlockFace.EAST).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.EAST).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : (block.getRelative(BlockFace.SOUTH).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.SOUTH).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : (block.getRelative(BlockFace.WEST).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.WEST).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : (block.getRelative(BlockFace.DOWN).getState() instanceof Sign ? ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.DOWN).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]")) : block.getRelative(BlockFace.UP).getState() instanceof Sign && ChatColor.stripColor((String)(sign = (Sign)block.getRelative(BlockFace.UP).getState()).getLine(1)).equalsIgnoreCase(ChatColor.stripColor((String)"[TrafficLight]"))))));
    }

    public boolean inACar(String playername) {
        try {
            Player p = this.plugin.getServer().getPlayer(playername);
            return this.inACar(p);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isACar(Entity cart) {
        if (cart.hasMetadata("ucars.ignore") || UEntityMeta.hasMetadata(cart, "ucars.ignore")) {
            return false;
        }
        Location loc = cart.getLocation();
        Block b = loc.getBlock();
        String mat = b.getType().name().toUpperCase();
        String underMat = b.getRelative(BlockFace.DOWN).getType().name().toUpperCase();
        String underUnderMat = b.getRelative(BlockFace.DOWN, 2).getType().name().toUpperCase();
        ArrayList<String> checks = new ArrayList<String>();
        if (ucars.ignoreRails) {
            checks.add("POWERED_RAIL");
            checks.add("RAILS");
            checks.add("DETECTOR_RAIL");
            checks.add("ACTIVATOR_RAIL");
        }
        if (checks.contains(mat) || checks.contains(underMat) || checks.contains(underUnderMat)) {
            return false;
        }
        return this.plugin.getAPI().runCarChecks(cart) != false;
    }

    public void ResetCarBoost(String playername, Vehicle car, double defaultSpeed) {
        String p = playername;
        World w = this.plugin.getServer().getPlayer(p).getLocation().getWorld();
        w.playSound(this.plugin.getServer().getPlayer(p).getLocation(), Sound.ENTITY_BAT_TAKEOFF, 1.5f, -2.0f);
        if (ucars.carBoosts.containsKey(p)) {
            ucars.carBoosts.remove(p);
        }
    }

    public boolean carBoost(String playerName, final double power, final long lengthMillis, double defaultSpeed) {
        double defMult;
        final String p = playerName;
        double Cur = defMult = defaultSpeed;
        if (ucars.carBoosts.containsKey(p)) {
            Cur = ucars.carBoosts.get(p);
        }
        if (Cur > defMult) {
            return false;
        }
        final double current = Cur;
        if (this.plugin == null) {
            this.plugin.getLogger().log(Level.SEVERE, Lang.get("lang.error.pluginNull"));
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                World w = uCarsListener.this.plugin.getServer().getPlayer(p).getLocation().getWorld();
                w.playSound(uCarsListener.this.plugin.getServer().getPlayer(p).getLocation(), Sound.BLOCK_LAVA_EXTINGUISH, 1.5f, -2.0f);
                double speed = current + power;
                ucars.carBoosts.put(p, speed);
                try {
                    Thread.sleep(lengthMillis);
                }
                catch (InterruptedException e) {
                    ucars.carBoosts.remove(p);
                    return;
                }
                ucars.carBoosts.remove(p);
            }
        });
        return true;
    }

    public boolean inACar(Player p) {
        try {
            if (p == null) {
                return false;
            }
            if (p.getVehicle() == null) {
                return false;
            }
            Entity ent = p.getVehicle();
            if (!(ent instanceof Vehicle)) {
                while (!(ent instanceof Vehicle) && ent.getVehicle() != null) {
                    ent = ent.getVehicle();
                }
                if (!(ent instanceof Vehicle)) {
                    return false;
                }
            }
            Vehicle cart = (Vehicle)ent;
            return this.isACar((Entity)cart);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Entity getDrivingPassengerOfCar(Vehicle vehicle) {
        Entity passenger = vehicle.getPassenger();
        if (passenger == null || !(vehicle instanceof Entity)) {
            return null;
        }
        if (!(passenger instanceof Player)) {
            while (!(passenger instanceof Player) && passenger.getPassenger() != null) {
                passenger = passenger.getPassenger();
            }
        }
        return passenger;
    }

    @EventHandler
    void carExit(VehicleExitEvent event) {
        UEntityMeta.removeMetadata((Entity)event.getVehicle(), "car.vec");
        UEntityMeta.removeMetadata((Entity)event.getExited(), "ucars.smooth");
        event.getVehicle().removeMetadata("car.vec", (Plugin)ucars.plugin);
        event.getExited().removeMetadata("ucars.smooth", (Plugin)ucars.plugin);
        if (event.getVehicle().hasMetadata("safeExit.ignore") || UEntityMeta.hasMetadata((Entity)event.getVehicle(), "safeExit.ignore")) {
            return;
        }
        if (!(event.getVehicle() instanceof Vehicle) || !this.isACar((Entity)event.getVehicle())) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void carRemove(VehicleDestroyEvent event) {
        if (event.isCancelled()) {
            return;
        }
        UEntityMeta.removeMetadata((Entity)event.getVehicle(), "car.vec");
        event.getVehicle().removeMetadata("car.vec", (Plugin)ucars.plugin);
        final Vehicle v = event.getVehicle();
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)ucars.plugin, new Runnable(){

            @Override
            public void run() {
                UEntityMeta.removeAllMeta((Entity)v);
            }
        }, 100L);
    }

    @EventHandler
    void entityDeath(EntityDeathEvent event) {
        LivingEntity e = event.getEntity();
        if (e instanceof Player) {
            return;
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)ucars.plugin, new Runnable((Entity)e){
            final /* synthetic */ Entity val$e;
            {
                this.val$e = entity;
            }

            @Override
            public void run() {
                UEntityMeta.removeAllMeta(this.val$e);
            }
        }, 100L);
    }

    @EventHandler
    public void signWriter(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (ChatColor.stripColor((String)lines[1]).equalsIgnoreCase("[TrafficLight]")) {
            lines[1] = "[TrafficLight]";
        }
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[uFuel]")) {
            lines[0] = "[uFuel]";
        }
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[Teleport]")) {
            lines[0] = "[Teleport]";
        }
        if (ChatColor.stripColor((String)lines[0]).equalsIgnoreCase("[wir]") && !event.getPlayer().hasPermission("wirelessredstone")) {
            event.getPlayer().sendMessage(ChatColor.RED + "Sorry you need the permisson 'wirelessredstone' to do this!");
            lines[0] = "";
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerJoinControlsUnlock(PlayerJoinEvent event) {
        ControlSchemeManager.setControlsLocked(event.getPlayer(), false);
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().isOp() && !this.plugin.protocolLib.booleanValue()) {
            event.getPlayer().sendMessage(ucars.colors.getError() + Lang.get("lang.messages.noProtocolLib"));
        }
    }

    @EventHandler
    public void tickCalcsAndLegacy(VehicleUpdateEvent event) {
        Vector dirVec;
        ChatColor color;
        double left;
        double max;
        double damage;
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Vehicle)) {
            return;
        }
        Entity passenger = this.getDrivingPassengerOfCar(vehicle);
        Boolean driven = passenger != null && passenger instanceof Player;
        if (!driven.booleanValue()) {
            return;
        }
        Vector travel = vehicle.getVelocity();
        if (event instanceof ucarUpdateEvent) {
            travel = ((ucarUpdateEvent)event).getTravelVector().clone();
        }
        if (!(event instanceof ucarUpdateEvent) && UEntityMeta.hasMetadata((Entity)vehicle, "car.vec")) {
            ucarUpdateEvent evt = (ucarUpdateEvent)((Object)UEntityMeta.getMetadata((Entity)vehicle, "car.vec").get(0).value());
            evt.player = (Player)passenger;
            evt.incrementRead();
            UEntityMeta.removeMetadata((Entity)vehicle, "car.vec");
            ucarUpdateEvent et = new ucarUpdateEvent(vehicle, evt.getTravelVector().clone(), null, evt.getDir());
            et.setRead(evt.getReadCount());
            UEntityMeta.setMetadata((Entity)vehicle, "car.vec", new StatValue((Object)et, (Plugin)ucars.plugin));
            if (!ucars.fireUpdateEvent) {
                this.onUcarUpdate(evt);
            } else {
                ucars.plugin.getServer().getPluginManager().callEvent((Event)evt);
            }
        }
        Block normalblock = vehicle.getLocation().getBlock();
        Player player = null;
        if (driven.booleanValue()) {
            player = (Player)passenger;
        }
        if (!this.carsEnabled.booleanValue()) {
            return;
        }
        Vehicle car = vehicle;
        if (!this.isACar((Entity)car)) {
            return;
        }
        Vector vel = car.getVelocity();
        if (car.getVelocity().getY() > 0.1 && !UEntityMeta.hasMetadata((Entity)car, "car.falling") && !UEntityMeta.hasMetadata((Entity)car, "car.ascending")) {
            if (UEntityMeta.hasMetadata((Entity)car, "car.jumping")) {
                UEntityMeta.removeMetadata((Entity)car, "car.jumping");
            } else if (UEntityMeta.hasMetadata((Entity)car, "car.jumpFull")) {
                if (car.getVelocity().getY() > 10.0) {
                    vel.setY(5);
                }
                UEntityMeta.removeMetadata((Entity)car, "car.jumpFull");
            } else {
                vel.setY(0);
            }
            car.setVelocity(vel);
        }
        if (UEntityMeta.hasMetadata((Entity)car, "car.jumpUp")) {
            double amt = (Double)UEntityMeta.getMetadata((Entity)car, "car.jumpUp").get(0).value();
            UEntityMeta.removeMetadata((Entity)car, "car.jumpUp");
            if (amt >= 1.5) {
                double y = amt * 0.1;
                UEntityMeta.setMetadata((Entity)car, "car.jumpUp", new StatValue(amt - y, (Plugin)this.plugin));
                vel.setY(y);
                car.setVelocity(vel);
                return;
            }
            UEntityMeta.setMetadata((Entity)car, "car.falling", new StatValue(0.01, (Plugin)this.plugin));
        }
        if (UEntityMeta.hasMetadata((Entity)car, "car.falling")) {
            double gravity = (Double)UEntityMeta.getMetadata((Entity)car, "car.falling").get(0).value();
            double newGravity = gravity + gravity * 0.6;
            UEntityMeta.removeMetadata((Entity)car, "car.falling");
            if (gravity <= 0.6) {
                UEntityMeta.setMetadata((Entity)car, "car.falling", new StatValue(newGravity, (Plugin)ucars.plugin));
                vel.setY(-(gravity * 1.333 + 0.2));
                car.setVelocity(vel);
            }
        }
        CarHealthData health = this.getCarHealthHandler((Entity)car);
        Boolean recalculateHealth = false;
        if ((normalblock.getType().equals((Object)Material.WATER) || normalblock.getType().equals((Object)Material.STATIONARY_WATER)) && (damage = this.damage_water) > 0.0) {
            if (driven.booleanValue()) {
                max = defaultHealth;
                left = health.getHealth() - damage;
                color = ChatColor.YELLOW;
                if (left > max * 0.66) {
                    color = ChatColor.GREEN;
                }
                if (left < max * 0.33) {
                    color = ChatColor.RED;
                }
                player.sendMessage(ChatColor.RED + "-" + damage + "[" + Material.WATER.name().toLowerCase() + "]" + color + " (" + left + ")");
            }
            health.damage(damage, (Entity)car);
            recalculateHealth = true;
        }
        if ((normalblock.getType().equals((Object)Material.LAVA) || normalblock.getType().equals((Object)Material.STATIONARY_LAVA)) && (damage = this.damage_lava) > 0.0) {
            if (driven.booleanValue()) {
                max = defaultHealth;
                left = health.getHealth() - damage;
                color = ChatColor.YELLOW;
                if (left > max * 0.66) {
                    color = ChatColor.GREEN;
                }
                if (left < max * 0.33) {
                    color = ChatColor.RED;
                }
                player.sendMessage(ChatColor.RED + "-" + damage + "[" + Material.LAVA.name().toLowerCase() + "]" + color + " (" + left + ")");
            }
            health.damage(damage, (Entity)car);
            recalculateHealth = true;
        }
        if (recalculateHealth.booleanValue()) {
            this.updateCarHealthHandler((Entity)car, health);
        }
        float a = 1.0f;
        if (event instanceof ucarUpdateEvent && ucars.smoothDrive) {
            a = ControlInput.getAccel(((ucarUpdateEvent)event).getPlayer(), ((ucarUpdateEvent)event).getDir());
            CarDirection driveDir = ControlInput.getCurrentDriveDir(player);
            if (driveDir.equals((Object)CarDirection.BACKWARDS)) {
                a = (float)((double)a * 0.2);
            }
            travel.setX(travel.getX() * (double)a);
            travel.setZ(travel.getZ() * (double)a);
        }
        if ((dirVec = travel.clone().setY(0).normalize()).lengthSquared() > 0.01) {
            CarDirection driveDir;
            Location dirLoc = new Location(car.getWorld(), 0.0, 0.0, 0.0);
            if (event instanceof ucarUpdateEvent && ((ucarUpdateEvent)event).getDir().equals((Object)CarDirection.BACKWARDS)) {
                dirVec = dirVec.multiply(-1);
            }
            if ((driveDir = ControlInput.getCurrentDriveDir(player)).equals((Object)CarDirection.BACKWARDS)) {
                dirVec = dirVec.multiply(-1);
            }
            dirLoc.setDirection(dirVec);
            float yaw = dirLoc.getYaw() + 90.0f;
            if (a < 0.0f) {
                yaw -= 180.0f;
            }
            while (yaw < 0.0f) {
                yaw = 360.0f + yaw;
            }
            while (yaw >= 360.0f) {
                yaw -= 360.0f;
            }
            CartOrientationUtil.setYaw((Entity)car, yaw);
        }
        if (this.plugin.protocolLib.booleanValue()) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onUcarUpdate(ucarUpdateEvent event) {
        double fuel;
        double damage;
        Vector unitVec;
        double fz;
        if (event.isCancelled()) {
            return;
        }
        Boolean modY = true;
        Vehicle vehicle = event.getVehicle();
        if (event.getReadCount() > 2) {
            UEntityMeta.removeMetadata((Entity)vehicle, "car.vec");
            vehicle.removeMetadata("car.vec", (Plugin)ucars.plugin);
        }
        Location under = vehicle.getLocation();
        under.setY(vehicle.getLocation().getY() - 1.0);
        Block underblock = under.getBlock();
        Block underunderblock = underblock.getRelative(BlockFace.DOWN);
        Block normalblock = vehicle.getLocation().getBlock();
        final Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!(vehicle instanceof Vehicle)) {
            return;
        }
        if (!this.carsEnabled.booleanValue()) {
            return;
        }
        try {
            if (this.licenseEnabled.booleanValue() && !this.plugin.licensedPlayers.contains(player.getName()).booleanValue()) {
                player.sendMessage(ucars.colors.getError() + Lang.get("lang.licenses.noLicense"));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vehicle car = vehicle;
        if (!this.isACar((Entity)car)) {
            return;
        }
        if (!player.isInsideVehicle()) {
            return;
        }
        CarHealthData health = this.getCarHealthHandler((Entity)car);
        Boolean recalculateHealth = false;
        if (car.getVelocity().getY() > 0.01 && !UEntityMeta.hasMetadata((Entity)car, "car.falling") && !UEntityMeta.hasMetadata((Entity)car, "car.ascending")) {
            modY = false;
        }
        if (UEntityMeta.hasMetadata((Entity)car, "car.jumping")) {
            if (!UEntityMeta.hasMetadata((Entity)car, "car.ascending")) {
                modY = false;
            }
            UEntityMeta.removeMetadata((Entity)car, "car.jumping");
        }
        if (car instanceof Minecart) {
            ((Minecart)car).setMaxSpeed(5.0);
        }
        if (this.roadBlocksEnabled.booleanValue() && !this.plugin.isBlockEqualToConfigIds(this.roadBlocks, underblock).booleanValue()) {
            return;
        }
        Location loc = car.getLocation();
        if (!ucars.playersIgnoreTrafficLights && this.atTrafficLight((Entity)car, underblock, underunderblock, loc).booleanValue()) {
            return;
        }
        if (this.effectBlocksEnabled.booleanValue()) {
            if (this.plugin.isBlockEqualToConfigIds(this.blockBoost, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.blockBoost, underunderblock).booleanValue()) {
                this.carBoost(player.getName(), 20.0, 6000L, this.defaultSpeed);
            }
            if (this.plugin.isBlockEqualToConfigIds(this.highBlockBoost, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.highBlockBoost, underunderblock).booleanValue()) {
                this.carBoost(player.getName(), 50.0, 8000L, this.defaultSpeed);
            }
            if (this.plugin.isBlockEqualToConfigIds(this.resetBlockBoost, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.resetBlockBoost, underunderblock).booleanValue()) {
                this.ResetCarBoost(player.getName(), car, this.defaultSpeed);
            }
        }
        Vector travel = event.getTravelVector();
        float a = 1.0f;
        if (ucars.smoothDrive) {
            a = ControlInput.getAccel(event.getPlayer(), event.getDir());
            CarDirection driveDir = ControlInput.getCurrentDriveDir(event.getPlayer());
            if (driveDir.equals((Object)CarDirection.BACKWARDS)) {
                a = (float)((double)a * 0.2);
            }
            travel.setX(travel.getX() * (double)a);
            travel.setZ(travel.getZ() * (double)a);
        }
        Vector dirVec = travel.clone().setY(0).normalize();
        double multiplier = this.defaultSpeed;
        try {
            if (ucars.carBoosts.containsKey(player.getName())) {
                multiplier = ucars.carBoosts.get(player.getName());
            }
        }
        catch (Exception e1) {
            return;
        }
        String underMat = under.getBlock().getType().name().toUpperCase();
        byte underdata = under.getBlock().getData();
        String key = underMat + ":" + underdata;
        if (this.speedMods.containsKey(key)) {
            multiplier = !ucars.carBoosts.containsKey(player.getName()) ? this.speedMods.get(key) : (this.speedMods.get(key) + multiplier) * 0.5;
        }
        if (event.getDoDivider().booleanValue()) {
            multiplier *= event.getDivider();
        }
        travel = travel.setX(travel.getX() * multiplier);
        travel = travel.setZ(travel.getZ() * multiplier);
        if (this.usePerms.booleanValue() && !player.hasPermission("ucars.cars")) {
            player.sendMessage(ucars.colors.getInfo() + Lang.get("lang.messages.noDrivePerm"));
            return;
        }
        Location before = car.getLocation();
        float dir = car.getLocation().clone().setDirection(travel).getYaw();
        BlockFace faceDir = ClosestFace.getClosestFace(dir);
        double length = 0.0;
        Object carNMSHandle = Reflect.getHandle((Entity)car);
        Field lenField = Reflect.getField(Reflect.getNMSClass("Entity"), "width");
        if (!lenField.isAccessible()) {
            lenField.setAccessible(true);
        }
        try {
            length = lenField.getDouble(carNMSHandle);
        }
        catch (Exception e) {
            e.printStackTrace();
            length = 0.0;
        }
        double fx = travel.getX() * 1.0;
        if (Math.abs(fx) > 1.0) {
            fx = faceDir.getModX();
        }
        if (Math.abs(fz = travel.getZ() * 1.0) > 1.0) {
            fz = faceDir.getModZ();
        }
        if ((unitVec = new Vector(faceDir.getModX(), 0, faceDir.getModZ())).lengthSquared() > 1.0) {
            unitVec.multiply(1.0 / Math.sqrt(2.0));
        }
        Vector faceDirVec = new Vector(fx, (double)faceDir.getModY(), fz);
        before = before.add(faceDirVec);
        Vector toRightOfFaceDir = unitVec.clone().crossProduct(new Vector(0, 1, 0));
        before = before.add(unitVec.clone().multiply(length * 0.5));
        Location frontRight = before.clone().add(unitVec.clone().multiply(length * 0.5));
        Location frontLeft = before.clone().add(unitVec.clone().multiply(length * -0.5));
        Block block = before.getBlock();
        Block frontRightInFront = frontRight.getBlock();
        Block frontLeftInFront = frontLeft.getBlock();
        if (this.ignoreJump.contains(block.getType().name())) {
            if (!this.ignoreJump.contains(frontRightInFront.getType().name())) {
                block = frontRightInFront;
            } else if (!this.ignoreJump.contains(frontLeftInFront.getType().name())) {
                block = frontLeftInFront;
            }
        }
        Block above = block.getRelative(BlockFace.UP);
        if (block.getType().equals((Object)Material.CACTUS) && (damage = this.damage_cactus) > 0.0) {
            double max = defaultHealth;
            double left = health.getHealth() - damage;
            ChatColor color = ChatColor.YELLOW;
            if (left > max * 0.66) {
                color = ChatColor.GREEN;
            }
            if (left < max * 0.33) {
                color = ChatColor.RED;
            }
            player.sendMessage(ChatColor.RED + "-" + damage + "[" + Material.CACTUS.name().toLowerCase() + "]" + color + " (" + left + ")");
            health.damage(damage, (Entity)car);
            recalculateHealth = true;
        }
        if (this.fuelEnabled.booleanValue() && !this.fuelUseItems.booleanValue() && !player.hasPermission(this.fuelBypassPerm)) {
            fuel = 0.0;
            if (ucars.fuel.containsKey(player.getName())) {
                fuel = ucars.fuel.get(player.getName());
            }
            if (fuel < 0.1) {
                player.sendMessage(ucars.colors.getError() + Lang.get("lang.fuel.empty"));
                return;
            }
            int amount = 0 + (int)(Math.random() * 250.0);
            if (amount == 10) {
                fuel -= 0.1;
                fuel = (double)Math.round(fuel * 10.0) / 10.0;
                ucars.fuel.put(player.getName(), fuel);
            }
        } else if (this.fuelEnabled.booleanValue() && this.fuelUseItems.booleanValue() && !player.hasPermission(this.fuelBypassPerm)) {
            fuel = 0.0;
            ArrayList<ItemStack> items = this.plugin.ufuelitems;
            PlayerInventory inv = player.getInventory();
            for (ItemStack item : items) {
                if (!inv.contains(item.getType(), 1)) continue;
                fuel += 0.1;
            }
            if (fuel < 0.1) {
                player.sendMessage(ucars.colors.getError() + Lang.get("lang.fuel.empty"));
                return;
            }
            int amount = 0 + (int)(Math.random() * 150.0);
            if (amount == 10) {
                Boolean taken = false;
                Boolean last = false;
                int toUse = 0;
                for (int i = 0; i < inv.getContents().length; ++i) {
                    ItemStack item = inv.getItem(i);
                    Boolean ignore = false;
                    try {
                        item.getType();
                    }
                    catch (Exception e) {
                        ignore = true;
                    }
                    if (ignore.booleanValue() || taken.booleanValue() || !this.plugin.isItemOnList(items, item).booleanValue()) continue;
                    taken = true;
                    if (item.getAmount() < 2) {
                        last = true;
                        toUse = i;
                    }
                    item.setAmount(item.getAmount() - 1);
                }
                if (last.booleanValue()) {
                    inv.setItem(toUse, new ItemStack(Material.AIR));
                }
            }
        }
        Material bType = block.getType();
        byte bData = block.getData();
        Boolean fly = false;
        if (normalblock.getRelative(faceDir).getType() == Material.STEP) {
            fly = true;
        }
        if (this.effectBlocksEnabled.booleanValue()) {
            if (this.plugin.isBlockEqualToConfigIds(this.jumpBlock, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.jumpBlock, underunderblock).booleanValue()) {
                double y = this.uCar_jump_amount;
                UEntityMeta.setMetadata((Entity)car, "car.jumpUp", new StatValue(this.uCar_jump_amount, (Plugin)this.plugin));
                travel.setY(y);
                car.setVelocity(travel);
            }
            if (this.plugin.isBlockEqualToConfigIds(this.teleportBlock, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.teleportBlock, underunderblock).booleanValue()) {
                String[] lines;
                Sign s = null;
                if (underunderblock.getState() instanceof Sign) {
                    s = (Sign)underunderblock.getState();
                }
                if (underunderblock.getRelative(BlockFace.DOWN).getState() instanceof Sign) {
                    s = (Sign)underunderblock.getRelative(BlockFace.DOWN).getState();
                }
                if (s != null && (lines = s.getLines())[0].equalsIgnoreCase("[Teleport]")) {
                    Boolean raceCar = false;
                    if (car.hasMetadata("kart.racing") || UEntityMeta.hasMetadata((Entity)car, "kart.racing")) {
                        raceCar = true;
                    }
                    UEntityMeta.setMetadata((Entity)car, "safeExit.ignore", new StatValue(null, (Plugin)this.plugin));
                    car.eject();
                    UUID carId = car.getUniqueId();
                    car.remove();
                    final Vehicle ca = car;
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            if (ca != null) {
                                ca.remove();
                            }
                        }
                    }, 2L);
                    String xs = lines[1];
                    String ys = lines[2];
                    String zs = lines[3];
                    Boolean valid = true;
                    double x = 0.0;
                    double y = 0.0;
                    double z = 0.0;
                    try {
                        x = Double.parseDouble(xs);
                        y = Double.parseDouble(ys);
                        y += 0.5;
                        z = Double.parseDouble(zs);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                    }
                    if (valid.booleanValue()) {
                        Location toTele;
                        Chunk ch;
                        List metas = null;
                        if (player.hasMetadata("car.stayIn") || UEntityMeta.hasMetadata((Entity)player, "car.stayIn")) {
                            metas = player.getMetadata("car.stayIn");
                            List<MetadataValue> others = UEntityMeta.getMetadata((Entity)player, "car.stayIn");
                            if (others != null) {
                                metas.addAll(others);
                            }
                            for (MetadataValue val : metas) {
                                player.removeMetadata("car.stayIn", val.getOwningPlugin());
                                UEntityMeta.removeMetadata((Entity)player, "car.stayIn");
                            }
                        }
                        if ((ch = (toTele = new Location(s.getWorld(), x, y, z)).getChunk()).isLoaded()) {
                            ch.load(true);
                        }
                        Vehicle v = car = (Vehicle)s.getWorld().spawnEntity(toTele, EntityType.MINECART);
                        UEntityMeta.setMetadata((Entity)car, "carhealth", health);
                        if (raceCar.booleanValue()) {
                            UEntityMeta.setMetadata((Entity)car, "kart.racing", new StatValue(null, (Plugin)this.plugin));
                        }
                        uCarRespawnEvent evnt = new uCarRespawnEvent((Entity)car, carId, car.getUniqueId(), CarRespawnReason.TELEPORT);
                        this.plugin.getServer().getPluginManager().callEvent((Event)evnt);
                        if (evnt.isCancelled()) {
                            car.remove();
                        } else {
                            player.sendMessage(ucars.colors.getTp() + "Teleporting...");
                            car.setPassenger((Entity)player);
                            final Vehicle ucar = car;
                            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                                @Override
                                public void run() {
                                    ucar.setPassenger((Entity)player);
                                }
                            }, 2L);
                            car.setVelocity(travel);
                            if (metas != null) {
                                for (MetadataValue val : metas) {
                                    UEntityMeta.setMetadata((Entity)player, "car.stayIn", val);
                                    player.setMetadata("car.stayIn", val);
                                }
                            }
                            this.plugin.getAPI().updateUcarMeta(carId, car.getUniqueId());
                        }
                    }
                }
            }
        }
        Location theNewLoc = block.getLocation();
        Location bidUpLoc = block.getLocation().add(0.0, 1.0, 0.0);
        Material bidU = bidUpLoc.getBlock().getType();
        Boolean cont = true;
        cont = this.plugin.isBlockEqualToConfigIds(this.barriers, block) == false && this.plugin.isBlockEqualToConfigIds(this.barriers, frontLeftInFront) == false && this.plugin.isBlockEqualToConfigIds(this.barriers, frontRightInFront) == false;
        Boolean inStairs = false;
        Material carBlock = car.getLocation().getBlock().getType();
        if (carBlock.name().toLowerCase().contains("stairs")) {
            inStairs = true;
        }
        if (UEntityMeta.hasMetadata((Entity)car, "car.ascending")) {
            UEntityMeta.removeMetadata((Entity)car, "car.ascending");
        }
        if (inStairs.booleanValue() || !this.ignoreJump.contains(bType.name().toUpperCase()) && cont.booleanValue() && modY.booleanValue()) {
            if (bidU == Material.AIR || bidU == Material.LAVA || bidU == Material.STATIONARY_LAVA || bidU == Material.WATER || bidU == Material.STATIONARY_WATER || bidU == Material.CARPET || inStairs.booleanValue()) {
                theNewLoc.add(0.0, 1.5, 0.0);
                Boolean calculated = false;
                double y = 1.1;
                if (block.getType().name().toLowerCase().contains("step")) {
                    calculated = true;
                    y = 1.2;
                }
                if (carBlock.name().toLowerCase().contains("step")) {
                    calculated = true;
                    y = 0.6;
                }
                if (carBlock.name().toLowerCase().contains(Pattern.quote("stairs")) || block.getType().name().toLowerCase().contains(Pattern.quote("stairs")) || inStairs.booleanValue()) {
                    calculated = true;
                    y = 0.6;
                }
                Boolean ignore = false;
                if (car.getVelocity().getY() > 4.0) {
                    ignore = true;
                }
                if (!ignore.booleanValue()) {
                    travel.setY((double)block.getY() + y - car.getLocation().getY());
                    if (calculated.booleanValue()) {
                        UEntityMeta.setMetadata((Entity)car, "car.jumping", new StatValue(null, (Plugin)this.plugin));
                    } else {
                        UEntityMeta.setMetadata((Entity)car, "car.jumpFull", new StatValue(null, (Plugin)this.plugin));
                    }
                }
            }
            if (fly.booleanValue() && cont.booleanValue()) {
                travel.setY(0.1);
                UEntityMeta.setMetadata((Entity)car, "car.ascending", new StatValue(null, (Plugin)this.plugin));
            }
            car.setVelocity(this.calculateCarStats((Entity)car, player, travel, multiplier));
        } else {
            if (fly.booleanValue()) {
                travel.setY(0.1);
                UEntityMeta.setMetadata((Entity)car, "car.ascending", new StatValue(null, (Plugin)this.plugin));
            }
            car.setVelocity(this.calculateCarStats((Entity)car, player, travel, multiplier));
        }
        if (recalculateHealth.booleanValue()) {
            this.updateCarHealthHandler((Entity)car, health);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    void safeFly(EntityDamageEvent event) {
        Vector vel;
        if (!(event.getEntity() instanceof Player) || event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        Player p = (Player)event.getEntity();
        if (!(!this.inACar(p.getName()) || (vel = p.getVehicle().getVelocity()).getY() > -0.1 && vel.getY() < 0.1)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    void hitByCar(VehicleEntityCollisionEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Vehicle veh = event.getVehicle();
        if (!(veh instanceof Vehicle)) {
            return;
        }
        Vehicle cart = veh;
        if (!this.isACar((Entity)cart)) {
            return;
        }
        Entity ent = event.getEntity();
        if (cart.hasMetadata("trade.npc") && ent.hasMetadata("trade.npcvillager") || UEntityMeta.hasMetadata((Entity)cart, "trade.npc") && UEntityMeta.hasMetadata(ent, "trade.npcvillager") || cart.hasMetadata("trade.npc") && ent.getVehicle() != null && ent.getVehicle().hasMetadata("trade.npc") && UEntityMeta.hasMetadata((Entity)cart, "trade.npc") && ent.getVehicle() != null && UEntityMeta.hasMetadata(ent.getVehicle(), "trade.npc")) {
            event.setCancelled(true);
            event.setCollisionCancelled(false);
            return;
        }
        if (UEntityMeta.hasMetadata(ent, "IGNORE_COLLISIONS")) {
            event.setCancelled(true);
            event.setCollisionCancelled(false);
            return;
        }
        if (cart.getPassenger() == null) {
            return;
        }
        Entity passenger = cart.getPassenger();
        while (passenger.getPassenger() != null) {
            passenger = passenger.getPassenger();
        }
        if (passenger.equals(ent) || cart.getPassengers().contains(ent)) {
            return;
        }
        if ((ent.hasMetadata("copCar") || UEntityMeta.hasMetadata(ent, "copCar") || ent.getVehicle() != null && (ent.getVehicle().hasMetadata("copCar") || UEntityMeta.hasMetadata(ent.getVehicle(), "copCar"))) && !(passenger instanceof Player)) {
            event.setCancelled(true);
            event.setCollisionCancelled(false);
            return;
        }
        if (UEntityMeta.hasMetadata(ent, "hitByLast")) {
            try {
                long l = (Long)UEntityMeta.getMetadata(ent, "hitByLast").get(0).value();
                long pastTime = System.currentTimeMillis() - l;
                if (pastTime < 500L) {
                    return;
                }
                UEntityMeta.removeMetadata(ent, "hitByLast");
            }
            catch (Exception e) {
                UEntityMeta.removeMetadata(ent, "hitByLast");
            }
        }
        UEntityMeta.removeMetadata(ent, "hitByLast");
        UEntityMeta.setMetadata(ent, "hitByLast", new StatValue(System.currentTimeMillis(), (Plugin)ucars.plugin));
        Vector vel = cart.getVelocity();
        double speed = vel.length() * 1.6;
        double damage = this.hitby_crash_damage;
        double pDmg = damage * speed * 2.0;
        if (pDmg < 1.0) {
            pDmg = 1.0;
        }
        if (pDmg > this.hitby_crash_damage * 1.5) {
            pDmg = this.hitby_crash_damage * 1.5;
        }
        if (pDmg > 8.0) {
            pDmg = 8.0;
        }
        Entity driver = this.getDrivingPassengerOfCar(veh);
        if (speed > 0.0) {
            CarHealthData health = this.getCarHealthHandler((Entity)cart);
            double dmg = this.crash_damage;
            if (dmg > 0.0) {
                if (cart.getPassenger() instanceof Player) {
                    double max = defaultHealth;
                    double left = health.getHealth() - dmg;
                    ChatColor color = ChatColor.YELLOW;
                    if (left > max * 0.66) {
                        color = ChatColor.GREEN;
                    }
                    if (left < max * 0.33) {
                        color = ChatColor.RED;
                    }
                    ((Player)cart.getPassenger()).sendMessage(ChatColor.RED + "-" + (int)dmg + "[crash]" + color + " (" + (int)left + ")");
                }
                health.damage(dmg, (Entity)cart);
            }
            this.updateCarHealthHandler((Entity)cart, health);
        }
        if (speed <= 0.0) {
            return;
        }
        if (!ucars.config.getBoolean("general.cars.hitBy.enable")) {
            return;
        }
        if (ucars.config.getBoolean("general.cars.hitBy.enableMonsterDamage") && (ent instanceof Monster || ucars.config.getBoolean("general.cars.hitBy.enableAllMonsterDamage") && ent instanceof Damageable)) {
            if (ent instanceof Villager && ent.getVehicle() != null && passenger instanceof Villager) {
                return;
            }
            uCarCrashEvent evt = new uCarCrashEvent((Entity)cart, ent, pDmg);
            if (evt.isCancelled()) {
                return;
            }
            pDmg = evt.getDamageToBeDoneToTheEntity();
            double mult = ucars.config.getDouble("general.cars.hitBy.power") / 7.0;
            ent.setVelocity(cart.getVelocity().clone().setY(0.5).multiply(mult));
            if (driver == null || !driver.equals(ent)) {
                if (driver != null) {
                    ((Damageable)ent).damage(pDmg, driver);
                } else {
                    ((Damageable)ent).damage(pDmg);
                }
            }
        }
        boolean player = ent instanceof Player;
        Player p = null;
        if (player) {
            p = (Player)ent;
        }
        if (!player) {
            return;
        }
        if (p != null && this.inACar(p)) {
            return;
        }
        uCarCrashEvent evt = new uCarCrashEvent((Entity)cart, ent, pDmg);
        Bukkit.getPluginManager().callEvent((Event)evt);
        if (evt.isCancelled()) {
            return;
        }
        pDmg = evt.getDamageToBeDoneToTheEntity();
        double mult = ucars.config.getDouble("general.cars.hitBy.power") / 5.0;
        ent.setVelocity(cart.getVelocity().clone().setY(0.5).multiply(mult));
        if (p != null) {
            p.sendMessage(ucars.colors.getInfo() + Lang.get("lang.messages.hitByCar"));
        }
        if (ent instanceof LivingEntity) {
            ((LivingEntity)ent).damage(pDmg, driver);
        }
    }

    @EventHandler
    void interact(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getHand() == null) {
            return;
        }
        if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (uCarsAPI.getAPI().isuCarsHandlingPlacingCars() && (this.plugin.API.hasItemCarCheckCriteria() || event.getPlayer().getItemInHand().getType() == Material.MINECART)) {
            Material iar = block.getType();
            if (ucars.ignoreRails && (iar == Material.RAILS || iar == Material.ACTIVATOR_RAIL || iar == Material.POWERED_RAIL || iar == Material.DETECTOR_RAIL)) {
                return;
            }
            if (!PlaceManager.placeableOn(iar.name().toUpperCase(), block.getData()).booleanValue()) {
                return;
            }
            if (!ucars.config.getBoolean("general.cars.enable")) {
                return;
            }
            if (ucars.config.getBoolean("general.cars.placePerm.enable")) {
                String perm = ucars.config.getString("general.cars.placePerm.perm");
                if (!event.getPlayer().hasPermission(perm)) {
                    String noPerm = Lang.get("lang.messages.noPlacePerm");
                    noPerm = noPerm.replaceAll("%perm%", perm);
                    event.getPlayer().sendMessage(ucars.colors.getError() + noPerm);
                    return;
                }
            }
            if (event.isCancelled()) {
                event.getPlayer().sendMessage(ucars.colors.getError() + Lang.get("lang.messages.noPlaceHere"));
                return;
            }
            if (!this.plugin.API.runCarChecks(event.getPlayer().getItemInHand()).booleanValue()) {
                return;
            }
            Location loc = block.getLocation().add(0.0, 1.5, 0.0);
            loc.setYaw(event.getPlayer().getLocation().getYaw() + 270.0f);
            Minecart car = (Minecart)event.getPlayer().getWorld().spawnEntity(loc, EntityType.MINECART);
            float yaw = event.getPlayer().getLocation().getYaw() + 90.0f;
            if (yaw < 0.0f) {
                yaw = 360.0f + yaw;
            } else if (yaw >= 360.0f) {
                yaw -= 360.0f;
            }
            CartOrientationUtil.setYaw((Entity)car, yaw);
            this.updateCarHealthHandler((Entity)car, this.getCarHealthHandler((Entity)car));
            event.getPlayer().sendMessage(ucars.colors.getInfo() + Lang.get("lang.messages.place"));
            event.getPlayer().sendMessage(ucars.colors.getInfo() + "You can also use 'jump' to change driving mode!");
            if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                ItemStack placed = event.getPlayer().getItemInHand();
                placed.setAmount(placed.getAmount() - 1);
                event.getPlayer().getInventory().setItemInHand(placed);
            }
        }
        if (this.inACar(event.getPlayer()) && ucars.config.getBoolean("general.cars.fuel.enable") && this.plugin.isItemEqualToConfigIds(ucars.config.getStringList("general.cars.fuel.check"), event.getPlayer().getItemInHand()).booleanValue()) {
            event.getPlayer().performCommand("ufuel view");
        }
        if (ucars.config.getBoolean("general.cars.boostsEnable")) {
            return;
        }
        List LowBoostRaw = ucars.config.getStringList("general.cars.lowBoost");
        List MedBoostRaw = ucars.config.getStringList("general.cars.medBoost");
        List HighBoostRaw = ucars.config.getStringList("general.cars.highBoost");
        ItemStack inHand = event.getPlayer().getItemInHand();
        String bid = inHand.getType().name().toUpperCase();
        short bdata = inHand.getDurability();
        ItemStack remove = inHand.clone();
        remove.setAmount(1);
        if (ItemStackFromId.equals(LowBoostRaw, bid, (int)bdata).booleanValue() && this.inACar(event.getPlayer())) {
            boolean boosting = this.carBoost(event.getPlayer().getName(), 10.0, 3000L, ucars.config.getDouble("general.cars.defSpeed"));
            if (boosting) {
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    event.getPlayer().getInventory().removeItem(new ItemStack[]{remove});
                }
                event.getPlayer().sendMessage(ucars.colors.getSuccess() + Lang.get("lang.boosts.low"));
                return;
            }
            event.getPlayer().sendMessage(ucars.colors.getError() + Lang.get("lang.boosts.already"));
            return;
        }
        if (ItemStackFromId.equals(MedBoostRaw, bid, (int)bdata).booleanValue() && this.inACar(event.getPlayer())) {
            boolean boosting = this.carBoost(event.getPlayer().getName(), 20.0, 6000L, ucars.config.getDouble("general.cars.defSpeed"));
            if (boosting) {
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    event.getPlayer().getInventory().removeItem(new ItemStack[]{remove});
                }
                event.getPlayer().sendMessage(ucars.colors.getSuccess() + Lang.get("lang.boosts.med"));
                return;
            }
            event.getPlayer().sendMessage(ucars.colors.getError() + Lang.get("lang.boosts.already"));
            return;
        }
        if (ItemStackFromId.equals(HighBoostRaw, bid, (int)bdata).booleanValue() && this.inACar(event.getPlayer())) {
            boolean boosting = this.carBoost(event.getPlayer().getName(), 50.0, 10000L, ucars.config.getDouble("general.cars.defSpeed"));
            if (boosting) {
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    event.getPlayer().getInventory().removeItem(new ItemStack[]{remove});
                }
                event.getPlayer().sendMessage(ucars.colors.getSuccess() + Lang.get("lang.boosts.high"));
                return;
            }
            event.getPlayer().sendMessage(ucars.colors.getError() + Lang.get("lang.boosts.already"));
            return;
        }
    }

    @EventHandler
    void signInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)block.getState();
        String[] lines = sign.getLines();
        if (!lines[0].equalsIgnoreCase("[uFuel]")) {
            return;
        }
        event.setCancelled(true);
        String action = lines[1];
        String quantity = lines[2];
        double amount = 0.0;
        try {
            amount = Double.parseDouble(quantity);
        }
        catch (NumberFormatException e) {
            return;
        }
        if (action.equalsIgnoreCase("buy")) {
            String[] args = new String[]{"buy", "" + amount};
            this.plugin.cmdExecutor.ufuel((CommandSender)event.getPlayer(), args);
        } else if (action.equalsIgnoreCase("sell")) {
            String[] args = new String[]{"sell", "" + amount};
            this.plugin.cmdExecutor.ufuel((CommandSender)event.getPlayer(), args);
        } else {
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    void minecartBreak(VehicleDamageEvent event) {
        if (!(event.getVehicle() instanceof Vehicle) || !(event.getAttacker() instanceof Player)) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Vehicle car = event.getVehicle();
        Player player = (Player)event.getAttacker();
        if (!this.isACar((Entity)car)) {
            return;
        }
        if (!ucars.config.getBoolean("general.cars.health.overrideDefault")) {
            return;
        }
        CarHealthData health = this.getCarHealthHandler((Entity)car);
        double damage = ucars.config.getDouble("general.cars.health.punchDamage");
        if (event.getDamage() > 0.0 && damage > 0.0) {
            double max = ucars.config.getDouble("general.cars.health.default");
            double left = health.getHealth() - damage;
            ChatColor color = ChatColor.YELLOW;
            if (left > max * 0.66) {
                color = ChatColor.GREEN;
            }
            if (left < max * 0.33) {
                color = ChatColor.RED;
            }
            if (left < 0.0) {
                left = 0.0;
            }
            player.sendMessage(ChatColor.RED + "-" + damage + ChatColor.YELLOW + "[" + player.getName() + "]" + color + " (" + left + ")");
            health.damage(damage, (Entity)car, player);
            this.updateCarHealthHandler((Entity)car, health);
            event.setCancelled(true);
            event.setDamage(0.0);
        } else {
            event.setCancelled(true);
            event.setDamage(0.0);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    void carDeath(ucarDeathEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Entity cart = event.getCar();
        if (cart.hasMetadata("car.destroyed") || UEntityMeta.hasMetadata(cart, "car.destroyed")) {
            return;
        }
        UEntityMeta.setMetadata(cart, "car.destroyed", new StatValue(true, (Plugin)ucars.plugin));
        cart.removeMetadata("car.vec", (Plugin)ucars.plugin);
        UEntityMeta.removeMetadata(cart, "car.vec");
        cart.eject();
        Location loc = cart.getLocation();
        cart.remove();
        loc.getWorld().dropItemNaturally(loc, new ItemStack(Material.MINECART));
    }

    @EventHandler
    void wirelessRedstone(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        if (!block.getType().equals((Object)Material.REDSTONE_LAMP_ON) && !block.getType().equals((Object)Material.REDSTONE_LAMP_OFF)) {
            return;
        }
        boolean on = block.isBlockPowered();
        Sign sign = null;
        for (BlockFace dir : BlockFace.values()) {
            Block bd = block.getRelative(dir);
            if (!(bd.getState() instanceof Sign)) continue;
            sign = (Sign)bd.getState();
        }
        if (sign == null) {
            return;
        }
        if (sign.getLine(0) == null || !sign.getLine(0).equalsIgnoreCase("[wir]")) {
            return;
        }
        String otherLoc = sign.getLine(1);
        if (otherLoc == null) {
            return;
        }
        String[] parts = otherLoc.split(",");
        if (parts.length < 3) {
            return;
        }
        try {
            if (!otherLoc.matches("-*\\d+,-*\\d+,-*\\d+")) {
                return;
            }
            int x = Integer.parseInt(parts[0]);
            int y = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            Block otherBlock = block.getWorld().getBlockAt(x, y, z);
            otherBlock.getLocation().getChunk();
            if (on) {
                otherBlock.setType(Material.REDSTONE_BLOCK);
            } else {
                otherBlock.setType(Material.AIR);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private int getCoord(String in, int current) throws Exception {
        if (in.matches("-*\\d+")) {
            try {
                return Integer.parseInt(in);
            }
            catch (Exception e) {
                throw new Exception();
            }
        }
        if (in.matches("~-*\\d+") && in.length() > 1) {
            try {
                return Integer.parseInt(in.substring(1)) + current;
            }
            catch (Exception e) {
                throw new Exception();
            }
        }
        throw new Exception();
    }

    @EventHandler
    void quit(PlayerQuitEvent event) {
        final Player pl = event.getPlayer();
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)ucars.plugin, new Runnable(){

            @Override
            public void run() {
                if (!pl.isOnline()) {
                    UEntityMeta.removeAllMeta((Entity)pl);
                }
            }
        }, 100L);
    }

    @EventHandler
    void quit(PlayerKickEvent event) {
        final Player pl = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)ucars.plugin, new Runnable(){

            @Override
            public void run() {
                UEntityMeta.removeAllMeta((Entity)pl);
            }
        }, 100L);
    }

    @EventHandler
    void trafficIndicators(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        if (!block.getType().equals((Object)Material.REDSTONE_LAMP_ON) && !block.getType().equals((Object)Material.REDSTONE_LAMP_OFF)) {
            return;
        }
        boolean on = block.isBlockPowered();
        Sign sign = null;
        for (BlockFace dir : uCarsListener.dirs()) {
            Block bd = block.getRelative(dir);
            if (!(bd.getState() instanceof Sign)) continue;
            sign = (Sign)bd.getState();
        }
        if (sign == null) {
            return;
        }
        if (sign.getLine(1) == null || !sign.getLine(1).equalsIgnoreCase("[trafficlight]")) {
            return;
        }
        String otherLoc = sign.getLine(2);
        if (otherLoc == null) {
            return;
        }
        String[] parts = otherLoc.split(",");
        if (parts.length < 3) {
            return;
        }
        try {
            int z;
            int y;
            int x;
            if (otherLoc.matches(".+,.+,.+")) {
                try {
                    x = this.getCoord(parts[0], sign.getX());
                    y = this.getCoord(parts[1], sign.getY());
                    z = this.getCoord(parts[2], sign.getZ());
                }
                catch (Exception e1) {
                    return;
                }
            } else {
                return;
            }
            Block otherBlock = block.getWorld().getBlockAt(x, y, z);
            for (Entity e : otherBlock.getLocation().getChunk().getEntities()) {
                if (!(e.getLocation().distanceSquared(otherBlock.getLocation()) < 4.0) || !(e instanceof ItemFrame)) continue;
                ItemFrame ifr = (ItemFrame)e;
                if (on) {
                    ifr.setItem(new ItemStack(Material.EMERALD_BLOCK));
                    continue;
                }
                ifr.setItem(new ItemStack(Material.REDSTONE_BLOCK));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public Boolean atTrafficLight(Entity car, Block underblock, Block underunderblock, Location loc) {
        if (this.trafficLightsEnabled.booleanValue() && (this.plugin.isBlockEqualToConfigIds(this.trafficLightRawIds, underblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.trafficLightRawIds, underunderblock).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.trafficLightRawIds, underunderblock.getRelative(BlockFace.DOWN)).booleanValue() || this.plugin.isBlockEqualToConfigIds(this.trafficLightRawIds, underunderblock.getRelative(BlockFace.DOWN, 2)).booleanValue())) {
            Boolean found = false;
            Boolean on = false;
            int radius = 3;
            int radiusSquared = radius * radius;
            for (int x = -radius; x <= radius && !found.booleanValue(); ++x) {
                for (int z = -radius; z <= radius && !found.booleanValue(); ++z) {
                    if (x * x + z * z > radiusSquared) continue;
                    double locX = loc.getX() + (double)x;
                    double locZ = loc.getZ() + (double)z;
                    int y = (int)Math.round(loc.getY() - 4.0);
                    while ((double)y < loc.getY() + 4.0 && !found.booleanValue()) {
                        Location light = new Location(loc.getWorld(), locX, (double)y, locZ);
                        if (light.getBlock().getType() == Material.REDSTONE_LAMP_OFF) {
                            if (this.trafficlightSignOn(light.getBlock())) {
                                found = true;
                                on = false;
                            }
                        } else if (light.getBlock().getType() == Material.REDSTONE_TORCH_ON && this.trafficlightSignOn(light.getBlock())) {
                            found = true;
                            on = true;
                        }
                        ++y;
                    }
                }
            }
            if (found.booleanValue() && !on.booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private static BlockFace[] dirs() {
        return new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH_WEST, BlockFace.NORTH_EAST, BlockFace.SOUTH_EAST, BlockFace.NORTH_WEST};
    }

    public void updateCarHealthHandler(Entity car, CarHealthData handler) {
        UEntityMeta.removeMetadata(car, "carhealth");
        UEntityMeta.setMetadata(car, "carhealth", new StatValue(handler, (Plugin)ucars.plugin));
    }

    public CarHealthData getCarHealthHandler(Entity car) {
        CarHealthData health = null;
        if (UEntityMeta.hasMetadata(car, "carhealth")) {
            try {
                List<MetadataValue> vals = UEntityMeta.getMetadata(car, "carhealth");
                for (MetadataValue val : vals) {
                    if (val.value() == null || !(val.value() instanceof CarHealthData)) continue;
                    health = (CarHealthData)val.value();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                UEntityMeta.removeMetadata(car, "carhealth");
                health = null;
            }
        }
        if (health == null) {
            health = new CarHealthData(defaultHealth, (Plugin)this.plugin);
        }
        return health;
    }

    public static void showCarDamageMessage(Player player, double damage, String cause, double remainingHealth) {
        double max = defaultHealth;
        ChatColor color = ChatColor.YELLOW;
        if (remainingHealth > max * 0.66) {
            color = ChatColor.GREEN;
        }
        if (remainingHealth < max * 0.33) {
            color = ChatColor.RED;
        }
        player.sendMessage(ChatColor.RED + "-" + damage + "[" + cause + "]" + color + " (" + (int)remainingHealth + ")");
    }

    public static void showCarDamageMessage(Player player, double damage, double remainingHealth) {
        double max = defaultHealth;
        ChatColor color = ChatColor.YELLOW;
        if (remainingHealth > max * 0.66) {
            color = ChatColor.GREEN;
        }
        if (remainingHealth < max * 0.33) {
            color = ChatColor.RED;
        }
        player.sendMessage(ChatColor.RED + "-" + damage + "[Car Health]" + color + " (" + (int)remainingHealth + ")");
    }
}

