/*
 * Decompiled with CFR 0.152.
 */
package com.useful.ucars;

import com.useful.ucars.Reflect;
import com.useful.ucars.ucars;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;

public class CartOrientationUtil {
    private static CartOrientationUtilOverride cartOrientationUtilOverride = null;

    public static void setCartOrientationUtilOverride(CartOrientationUtilOverride override) {
        cartOrientationUtilOverride = override;
    }

    public static void setRoll(Entity cart, float roll) {
        if (cartOrientationUtilOverride != null) {
            cartOrientationUtilOverride.setRoll(cart, roll);
            return;
        }
    }

    public static void setPitch(Entity cart, float pitch) {
        if (cartOrientationUtilOverride != null) {
            cartOrientationUtilOverride.setPitch(cart, pitch);
            return;
        }
        if (!(cart instanceof Minecart)) {
            throw new RuntimeException("Non Minecart cars not supported yet!");
        }
        try {
            Class<?> cmr = cart.getClass();
            Method getHandle = cmr.getMethod("getHandle", new Class[0]);
            Object nmsCart = getHandle.invoke(cmr.cast(cart), new Object[0]);
            Field p = null;
            Class<?> ema = Reflect.getNMSClass("world.entity.", "Entity");
            if (ucars.MCVersion.get(0) == 1) {
                if (ucars.MCVersion.get(1) >= 18) {
                    p = ema.getDeclaredField("aB");
                } else if (ucars.MCVersion.get(1) == 17) {
                    p = ema.getDeclaredField("az");
                } else {
                    ema = Reflect.getNMSClass("world.entity.vehicle.", "EntityMinecartAbstract");
                    p = ema.getField("pitch");
                }
                p.setAccessible(true);
                p.set(ema.cast(nmsCart), Float.valueOf(-pitch));
                p.setAccessible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setYaw(Entity cart, float yaw) {
        if (cartOrientationUtilOverride != null) {
            cartOrientationUtilOverride.setYaw(cart, yaw);
            return;
        }
        if (!(cart instanceof Minecart)) {
            throw new RuntimeException("Non Minecart cars not supported yet!");
        }
        try {
            Class<?> cmr = cart.getClass();
            Method getHandle = cmr.getMethod("getHandle", new Class[0]);
            Class<?> ema = Reflect.getNMSClass("world.entity.", "Entity");
            Object nmsCart = getHandle.invoke(cmr.cast(cart), new Object[0]);
            Field p = null;
            if (ucars.MCVersion.get(0) == 1) {
                if (ucars.MCVersion.get(1) >= 18) {
                    p = ema.getDeclaredField("aA");
                } else if (ucars.MCVersion.get(1) == 17) {
                    p = ema.getDeclaredField("ay");
                } else {
                    ema = Reflect.getNMSClass("world.entity.vehicle.", "EntityMinecartAbstract");
                    p = ema.getField("yaw");
                }
            }
            p.setAccessible(true);
            p.set(ema.cast(nmsCart), Float.valueOf(yaw));
            p.setAccessible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface CartOrientationUtilOverride {
        public void setPitch(Entity var1, float var2);

        public void setYaw(Entity var1, float var2);

        public void setRoll(Entity var1, float var2);
    }
}

